/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage.migration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.storage.backend.IPlayerProgressBackend;
import org.texboobcat.questory.storage.backend.ITeamStorageBackend;
import org.texboobcat.questory.team.QuestTeam;

public class DataExporter {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static boolean exportPlayerProgress(IPlayerProgressBackend backend, Path exportDir) {
        try {
            Path progressDir = exportDir.resolve("player_progress");
            Files.createDirectories(progressDir, new FileAttribute[0]);
            List<UUID> playerIds = backend.getAllPlayerIds();
            System.out.println("[Questory] Exporting " + playerIds.size() + " players to " + String.valueOf(exportDir));
            int exported = 0;
            for (UUID playerId : playerIds) {
                try {
                    QuestProgress progress = backend.loadProgress(playerId);
                    if (progress == null) continue;
                    Path file = progressDir.resolve("player_" + String.valueOf(playerId) + ".json");
                    String json = GSON.toJson((JsonElement)progress.toJson());
                    Files.writeString(file, (CharSequence)json, new OpenOption[0]);
                    ++exported;
                }
                catch (Exception e) {
                    System.err.println("[Questory] Failed to export player " + String.valueOf(playerId) + ": " + e.getMessage());
                }
            }
            System.out.println("[Questory] Exported " + exported + " players successfully");
            return true;
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to export player progress: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean exportTeams(ITeamStorageBackend backend, Path exportDir) {
        try {
            Path teamsDir = exportDir.resolve("teams");
            Files.createDirectories(teamsDir, new FileAttribute[0]);
            Map<UUID, QuestTeam> teams = backend.loadAllTeams();
            System.out.println("[Questory] Exporting " + teams.size() + " teams to " + String.valueOf(exportDir));
            int exported = 0;
            for (Map.Entry<UUID, QuestTeam> entry : teams.entrySet()) {
                try {
                    QuestTeam team = entry.getValue();
                    Path file = teamsDir.resolve(String.valueOf(team.getTeamId()) + ".json");
                    String json = GSON.toJson((JsonElement)team.toJson());
                    Files.writeString(file, (CharSequence)json, new OpenOption[0]);
                    ++exported;
                }
                catch (Exception e) {
                    System.err.println("[Questory] Failed to export team " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
                }
            }
            System.out.println("[Questory] Exported " + exported + " teams successfully");
            return true;
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to export teams: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean importPlayerProgress(IPlayerProgressBackend backend, Path importDir) {
        try {
            Path progressDir = importDir.resolve("player_progress");
            if (!Files.exists(progressDir, new LinkOption[0])) {
                System.err.println("[Questory] Player progress directory not found: " + String.valueOf(progressDir));
                return false;
            }
            int[] imported = new int[]{0};
            int[] errors = new int[]{0};
            Files.list(progressDir).filter(path -> path.toString().endsWith(".json")).forEach(file -> {
                try {
                    String json = Files.readString(file);
                    QuestProgress progress = QuestProgress.fromJson((JsonObject)GSON.fromJson(json, JsonObject.class));
                    if (backend.saveProgress(progress)) {
                        imported[0] = imported[0] + 1;
                    } else {
                        errors[0] = errors[0] + 1;
                    }
                }
                catch (Exception e) {
                    System.err.println("[Questory] Failed to import " + String.valueOf(file.getFileName()) + ": " + e.getMessage());
                    errors[0] = errors[0] + 1;
                }
            });
            System.out.println("[Questory] Imported " + imported[0] + " players (" + errors[0] + " errors)");
            return errors[0] == 0;
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to import player progress: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean importTeams(ITeamStorageBackend backend, Path importDir) {
        try {
            Path teamsDir = importDir.resolve("teams");
            if (!Files.exists(teamsDir, new LinkOption[0])) {
                System.err.println("[Questory] Teams directory not found: " + String.valueOf(teamsDir));
                return false;
            }
            int[] imported = new int[]{0};
            int[] errors = new int[]{0};
            Files.list(teamsDir).filter(path -> path.toString().endsWith(".json")).forEach(file -> {
                try {
                    String json = Files.readString(file);
                    QuestTeam team = QuestTeam.fromJson((JsonObject)GSON.fromJson(json, JsonObject.class));
                    if (backend.saveTeam(team)) {
                        imported[0] = imported[0] + 1;
                    } else {
                        errors[0] = errors[0] + 1;
                    }
                }
                catch (Exception e) {
                    System.err.println("[Questory] Failed to import " + String.valueOf(file.getFileName()) + ": " + e.getMessage());
                    errors[0] = errors[0] + 1;
                }
            });
            System.out.println("[Questory] Imported " + imported[0] + " teams (" + errors[0] + " errors)");
            return errors[0] == 0;
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to import teams: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

