/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.telemetry;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.UUID;

public class HardwareIdGenerator {
    private static String cachedHwid = null;
    private static final String SALT = "Questory-Telemetry-v1-7f3e8b2a-4d1c-9e5f-6a0b-8c7d4e9f1a3b";

    public static String getHardwareId() {
        if (cachedHwid != null) {
            return cachedHwid;
        }
        try {
            StringBuilder sb = new StringBuilder();
            String macAddress = HardwareIdGenerator.getMacAddress();
            if (macAddress != null && !macAddress.isEmpty()) {
                sb.append(macAddress);
            } else {
                sb.append(System.getProperty("os.name", "unknown"));
                sb.append(System.getProperty("os.arch", "unknown"));
                sb.append(System.getProperty("os.version", "unknown"));
                sb.append(System.getProperty("user.name", "unknown"));
                sb.append(System.getProperty("java.home", "unknown"));
                try {
                    String hostname = InetAddress.getLocalHost().getHostName();
                    sb.append(hostname);
                }
                catch (Exception hostname) {
                    // empty catch block
                }
            }
            String combined = sb.toString() + SALT;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(combined.getBytes(StandardCharsets.UTF_8));
            cachedHwid = HardwareIdGenerator.bytesToHex(hash);
            return cachedHwid;
        }
        catch (Exception e) {
            cachedHwid = UUID.randomUUID().toString().replace("-", "");
            return cachedHwid;
        }
    }

    private static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                byte[] mac;
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp() || (mac = iface.getHardwareAddress()) == null || mac.length <= 0) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : mac) {
                    sb.append(String.format("%02X", b));
                }
                return sb.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static void clearCache() {
        cachedHwid = null;
    }
}

