/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.telemetry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.UUID;

public class TelemetryEvent {
    private final UUID playerUuid;
    private final UUID sessionId;
    private final EventType eventType;
    private final String questId;
    private final String modpackId;
    private final String modpackVersion;
    private final Instant timestamp;
    private final JsonObject metadata;

    private TelemetryEvent(Builder builder) {
        this.playerUuid = builder.playerUuid;
        this.sessionId = builder.sessionId;
        this.eventType = builder.eventType;
        this.questId = builder.questId;
        this.modpackId = builder.modpackId;
        this.modpackVersion = builder.modpackVersion;
        this.timestamp = builder.timestamp;
        this.metadata = builder.metadata;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getQuestId() {
        return this.questId;
    }

    public String getModpackId() {
        return this.modpackId;
    }

    public String getModpackVersion() {
        return this.modpackVersion;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("player_uuid", this.playerUuid.toString());
        json.addProperty("session_id", this.sessionId.toString());
        json.addProperty("event_type", this.eventType.getValue());
        json.addProperty("quest_id", this.questId != null ? this.questId : "");
        json.addProperty("modpack_id", this.modpackId);
        json.addProperty("modpack_version", this.modpackVersion);
        json.addProperty("timestamp", this.timestamp.toString());
        if (this.metadata != null && this.metadata.size() > 0) {
            json.add("metadata", (JsonElement)this.metadata);
        }
        return json;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private UUID playerUuid;
        private UUID sessionId;
        private EventType eventType;
        private String questId;
        private String modpackId;
        private String modpackVersion;
        private Instant timestamp;
        private JsonObject metadata;

        public Builder playerUuid(UUID playerUuid) {
            this.playerUuid = playerUuid;
            return this;
        }

        public Builder sessionId(UUID sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder eventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder questId(String questId) {
            this.questId = questId;
            return this;
        }

        public Builder modpackId(String modpackId) {
            this.modpackId = modpackId;
            return this;
        }

        public Builder modpackVersion(String modpackVersion) {
            this.modpackVersion = modpackVersion;
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder metadata(JsonObject metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new JsonObject();
            }
            this.metadata.addProperty(key, value);
            return this;
        }

        public Builder addMetadata(String key, Number value) {
            if (this.metadata == null) {
                this.metadata = new JsonObject();
            }
            this.metadata.addProperty(key, value);
            return this;
        }

        public Builder addMetadata(String key, Boolean value) {
            if (this.metadata == null) {
                this.metadata = new JsonObject();
            }
            this.metadata.addProperty(key, value);
            return this;
        }

        public TelemetryEvent build() {
            if (this.playerUuid == null) {
                throw new IllegalStateException("playerUuid is required");
            }
            if (this.sessionId == null) {
                throw new IllegalStateException("sessionId is required");
            }
            if (this.eventType == null) {
                throw new IllegalStateException("eventType is required");
            }
            if (this.modpackId == null) {
                throw new IllegalStateException("modpackId is required");
            }
            if (this.modpackVersion == null) {
                throw new IllegalStateException("modpackVersion is required");
            }
            if (this.timestamp == null) {
                this.timestamp = Instant.now();
            }
            return new TelemetryEvent(this);
        }
    }

    public static enum EventType {
        QUEST_COMPLETED("quest_completed"),
        QUEST_VIEWED("quest_viewed"),
        QUEST_OPENED("quest_opened"),
        QUEST_FAILED("quest_failed"),
        SESSION_START("session_start"),
        SESSION_END("session_end");

        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

