/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class AnimationProperty {
    private String property;
    private float from;
    private float to;
    private int durationMs = 1000;
    private int delayMs = 0;
    private EasingFunction easing = EasingFunction.LINEAR;
    private boolean loop = false;
    private boolean pingPong = false;
    private int loopCount = -1;
    private transient long startTime = -1L;
    private transient int currentLoop = 0;
    private transient boolean forward = true;

    public AnimationProperty() {
    }

    public AnimationProperty(String property, float from, float to, int durationMs) {
        this.property = property;
        this.from = from;
        this.to = to;
        this.durationMs = durationMs;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.currentLoop = 0;
        this.forward = true;
    }

    public void reset() {
        this.startTime = -1L;
        this.currentLoop = 0;
        this.forward = true;
    }

    public float getCurrentValue() {
        if (this.startTime < 0L) {
            return this.from;
        }
        long elapsed = System.currentTimeMillis() - this.startTime - (long)this.delayMs;
        if (elapsed < 0L) {
            return this.from;
        }
        float progress = (float)elapsed / (float)this.durationMs;
        if (progress >= 1.0f) {
            if (this.loop && (this.loopCount < 0 || this.currentLoop < this.loopCount)) {
                ++this.currentLoop;
                this.startTime = System.currentTimeMillis();
                if (this.pingPong) {
                    this.forward = !this.forward;
                }
                progress = 0.0f;
            } else {
                progress = 1.0f;
            }
        }
        float easedProgress = this.applyEasing(progress);
        if (this.pingPong && !this.forward) {
            return this.to + (this.from - this.to) * easedProgress;
        }
        return this.from + (this.to - this.from) * easedProgress;
    }

    public boolean isRunning() {
        if (this.startTime < 0L) {
            return false;
        }
        if (!this.loop && this.loopCount <= 0) {
            long elapsed = System.currentTimeMillis() - this.startTime - (long)this.delayMs;
            return elapsed < (long)this.durationMs;
        }
        return this.loopCount < 0 || this.currentLoop < this.loopCount;
    }

    private float applyEasing(float t) {
        return switch (this.easing.ordinal()) {
            case 1 -> t * t;
            case 2 -> 1.0f - (1.0f - t) * (1.0f - t);
            case 3 -> {
                if (t < 0.5f) {
                    yield 2.0f * t * t;
                }
                yield 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 2.0) / 2.0f;
            }
            case 4 -> {
                float n1 = 7.5625f;
                float d1 = 2.75f;
                if (t < 1.0f / d1) {
                    yield n1 * t * t;
                }
                if (t < 2.0f / d1) {
                    yield n1 * (t -= 1.5f / d1) * t + 0.75f;
                }
                if ((double)t < 2.5 / (double)d1) {
                    yield n1 * (t -= 2.25f / d1) * t + 0.9375f;
                }
                yield n1 * (t -= 2.625f / d1) * t + 0.984375f;
            }
            default -> t;
        };
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.property != null) {
            json.addProperty("property", this.property);
        }
        json.addProperty("from", (Number)Float.valueOf(this.from));
        json.addProperty("to", (Number)Float.valueOf(this.to));
        json.addProperty("duration", (Number)this.durationMs);
        if (this.delayMs > 0) {
            json.addProperty("delay", (Number)this.delayMs);
        }
        if (this.easing != EasingFunction.LINEAR) {
            json.addProperty("easing", this.easing.name().toLowerCase());
        }
        if (this.loop) {
            json.addProperty("loop", Boolean.valueOf(true));
        }
        if (this.pingPong) {
            json.addProperty("pingPong", Boolean.valueOf(true));
        }
        if (this.loopCount >= 0) {
            json.addProperty("loopCount", (Number)this.loopCount);
        }
        return json;
    }

    public static AnimationProperty fromJson(JsonObject json) {
        AnimationProperty anim = new AnimationProperty();
        if (json.has("property")) {
            anim.property = json.get("property").getAsString();
        }
        if (json.has("from")) {
            anim.from = json.get("from").getAsFloat();
        }
        if (json.has("to")) {
            anim.to = json.get("to").getAsFloat();
        }
        if (json.has("duration")) {
            anim.durationMs = json.get("duration").getAsInt();
        }
        if (json.has("delay")) {
            anim.delayMs = json.get("delay").getAsInt();
        }
        if (json.has("easing")) {
            try {
                anim.easing = EasingFunction.valueOf(json.get("easing").getAsString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                anim.easing = EasingFunction.LINEAR;
            }
        }
        if (json.has("loop")) {
            anim.loop = json.get("loop").getAsBoolean();
        }
        if (json.has("pingPong")) {
            anim.pingPong = json.get("pingPong").getAsBoolean();
        }
        if (json.has("loopCount")) {
            anim.loopCount = json.get("loopCount").getAsInt();
        }
        return anim;
    }

    public static List<AnimationProperty> listFromJson(JsonArray arr) {
        ArrayList<AnimationProperty> list = new ArrayList<AnimationProperty>();
        for (JsonElement el : arr) {
            if (!el.isJsonObject()) continue;
            list.add(AnimationProperty.fromJson(el.getAsJsonObject()));
        }
        return list;
    }

    public static JsonArray listToJson(List<AnimationProperty> animations) {
        JsonArray arr = new JsonArray();
        for (AnimationProperty anim : animations) {
            arr.add((JsonElement)anim.toJson());
        }
        return arr;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public float getFrom() {
        return this.from;
    }

    public void setFrom(float from) {
        this.from = from;
    }

    public float getTo() {
        return this.to;
    }

    public void setTo(float to) {
        this.to = to;
    }

    public int getDurationMs() {
        return this.durationMs;
    }

    public void setDurationMs(int durationMs) {
        this.durationMs = durationMs;
    }

    public int getDelayMs() {
        return this.delayMs;
    }

    public void setDelayMs(int delayMs) {
        this.delayMs = delayMs;
    }

    public EasingFunction getEasing() {
        return this.easing;
    }

    public void setEasing(EasingFunction easing) {
        this.easing = easing;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean isPingPong() {
        return this.pingPong;
    }

    public void setPingPong(boolean pingPong) {
        this.pingPong = pingPong;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public static enum EasingFunction {
        LINEAR,
        EASE_IN,
        EASE_OUT,
        EASE_IN_OUT,
        BOUNCE;

    }
}

