/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.texboobcat.questory.quest.CheckmarkRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.property.ThemeProperties;
import org.texboobcat.questory.theme.property.ThemeProperty;

public class BindingContext {
    private final Quest quest;
    private final QuestProgress progress;
    private final Map<String, Object> extraData;

    public BindingContext(Quest quest, QuestProgress progress) {
        this.quest = quest;
        this.progress = progress;
        this.extraData = new HashMap<String, Object>();
    }

    public void put(String key, Object value) {
        this.extraData.put(key, value);
    }

    public Object get(String key) {
        return this.extraData.get(key);
    }

    public Object resolve(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String[] parts = path.split("\\.", 2);
        String root = parts[0];
        String subPath = parts.length > 1 ? parts[1] : null;
        return switch (root) {
            case "quest" -> this.resolveQuest(subPath);
            case "progress" -> this.resolveProgress(subPath);
            case "theme" -> this.resolveTheme(subPath);
            case "global" -> this.resolveGlobal(subPath);
            case "item" -> this.extraData.get("item");
            default -> null;
        };
    }

    private Object resolveGlobal(String subPath) {
        Object global = this.extraData.get("global");
        if (global instanceof Map) {
            return ((Map)global).get(subPath);
        }
        return null;
    }

    private Object resolveQuest(String subPath) {
        if (this.quest == null) {
            Object mockQuest = this.extraData.get("quest");
            if (mockQuest instanceof Map) {
                return ((Map)mockQuest).get(subPath);
            }
            return null;
        }
        if (subPath == null) {
            return null;
        }
        return switch (subPath) {
            case "id" -> this.quest.getId();
            case "title" -> this.quest.getTitle();
            case "description" -> this.quest.getDescription();
            case "descriptionFormatted" -> this.quest.getDescription();
            case "icon" -> this.quest.getIcon();
            case "requirements" -> this.buildRequirementsList();
            case "rewards" -> this.buildRewardsList();
            case "tags" -> this.quest.getTags();
            case "statusText" -> this.getStatusText();
            case "statusColor" -> this.getStatusColor();
            case "canComplete" -> this.progress != null && this.canComplete();
            case "images" -> new ArrayList();
            default -> null;
        };
    }

    private List<Map<String, Object>> buildRequirementsList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (this.quest == null || this.quest.getRequirements() == null) {
            return list;
        }
        int index = 0;
        for (Requirement req : this.quest.getRequirements()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("text", req.getProgressDisplay(this.progress, this.quest.getId()));
            map.put("met", req.isMet(this.progress, this.quest.getId()));
            map.put("index", index);
            map.put("isCheckmark", req instanceof CheckmarkRequirement);
            list.add(map);
            ++index;
        }
        return list;
    }

    private List<Map<String, Object>> buildRewardsList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (this.quest == null || this.quest.getRewards() == null) {
            return list;
        }
        for (Reward reward : this.quest.getRewards()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("text", reward.getDisplayString());
            list.add(map);
        }
        return list;
    }

    private String getStatusText() {
        if (this.progress == null) {
            return "Unknown";
        }
        boolean completed = this.progress.isQuestCompleted(this.quest.getId());
        boolean canComplete = this.canComplete();
        if (completed) {
            return "\u2713 Completed";
        }
        if (canComplete) {
            return "Ready to complete!";
        }
        return "In progress";
    }

    private int getStatusColor() {
        if (this.progress == null) {
            return -1;
        }
        boolean completed = this.progress.isQuestCompleted(this.quest.getId());
        boolean canComplete = this.canComplete();
        if (completed) {
            return -16711936;
        }
        if (canComplete) {
            return -22016;
        }
        return -1;
    }

    private boolean canComplete() {
        if (this.quest == null || this.progress == null) {
            return false;
        }
        if (this.progress.isQuestCompleted(this.quest.getId())) {
            return false;
        }
        for (Requirement req : this.quest.getRequirements()) {
            if (req.isMet(this.progress, this.quest.getId())) continue;
            return false;
        }
        return true;
    }

    private Object resolveProgress(String subPath) {
        if (this.progress == null || subPath == null) {
            return null;
        }
        return switch (subPath) {
            case "completed" -> this.quest != null && this.progress.isQuestCompleted(this.quest.getId());
            case "canComplete" -> this.quest != null && this.canComplete();
            default -> null;
        };
    }

    private Object resolveTheme(String subPath) {
        if (subPath == null || QuestTheme.instance == null) {
            return null;
        }
        try {
            Field field = ThemeProperties.class.getField(subPath.toUpperCase());
            Object prop = field.get(null);
            if (prop instanceof ThemeProperty) {
                ThemeProperty themeProp = (ThemeProperty)prop;
                return QuestTheme.instance.get(themeProp);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public Quest getQuest() {
        return this.quest;
    }

    public QuestProgress getProgress() {
        return this.progress;
    }
}

