/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.texboobcat.questory.theme.panel.BindingContext;

public class Expression {
    private static final Pattern BINDING_PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");

    public static String evaluate(String expression, BindingContext context) {
        if (expression == null) {
            return "";
        }
        if (!expression.contains("${")) {
            return expression;
        }
        Matcher matcher = BINDING_PATTERN.matcher(expression);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String bindingPath = matcher.group(1);
            Object value = Expression.evaluateBinding(bindingPath, context);
            String replacement = Expression.valueToString(value);
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static boolean evaluateBoolean(String expression, BindingContext context) {
        if (expression == null) {
            return true;
        }
        Object result = Expression.evaluateBinding(expression, context);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            String str = (String)result;
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return result != null;
    }

    public static int evaluateInt(String expression, BindingContext context, int defaultValue) {
        if (expression == null) {
            return defaultValue;
        }
        Object result = Expression.evaluateBinding(expression, context);
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        if (result instanceof String) {
            String s = ((String)result).trim();
            Integer parsedHex = Expression.tryParseHexInt(s);
            if (parsedHex != null) {
                return parsedHex;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static int evaluateColor(String expression, BindingContext context, int defaultValue) {
        if (expression == null) {
            return defaultValue;
        }
        Object result = Expression.evaluateBinding(expression, context);
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        if (result instanceof String) {
            String s = ((String)result).trim();
            Integer hex = Expression.tryParseHexInt(s);
            if (hex != null) {
                return hex;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static Object evaluateBinding(String binding, BindingContext context) {
        if ((binding = binding.trim()).startsWith("${") && binding.endsWith("}")) {
            binding = binding.substring(2, binding.length() - 1);
        }
        if (binding.contains("(")) {
            return Expression.evaluateFunction(binding, context);
        }
        if (binding.contains(" > ") || binding.contains(" < ") || binding.contains(" == ") || binding.contains(" != ") || binding.contains(" && ") || binding.contains(" || ")) {
            return Expression.evaluateComparison(binding, context);
        }
        if (binding.contains(" ? ")) {
            return Expression.evaluateTernary(binding, context);
        }
        return context.resolve(binding);
    }

    private static Integer tryParseHexInt(String s) {
        try {
            if (s.startsWith("#")) {
                String hex = s.substring(1);
                if (hex.length() == 6) {
                    int rgb = (int)Long.parseLong(hex, 16) & 0xFFFFFF;
                    return 0xFF000000 | rgb;
                }
                if (hex.length() == 8) {
                    return (int)Long.parseLong(hex, 16);
                }
            } else if (s.startsWith("0x") || s.startsWith("0X")) {
                return (int)Long.parseLong(s.substring(2), 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object evaluateFunction(String expression, BindingContext context) {
        int openParen = expression.indexOf(40);
        if (openParen == -1) {
            return null;
        }
        String funcName = expression.substring(0, openParen).trim();
        String argsStr = expression.substring(openParen + 1, expression.length() - 1);
        return switch (funcName) {
            case "len" -> {
                Object value = Expression.evaluateBinding(argsStr, context);
                if (value instanceof List) {
                    yield ((List)value).size();
                }
                if (value instanceof String) {
                    yield ((String)value).length();
                }
                yield 0;
            }
            case "upper" -> {
                Object value = Expression.evaluateBinding(argsStr, context);
                yield Expression.valueToString(value).toUpperCase();
            }
            case "lower" -> {
                Object value = Expression.evaluateBinding(argsStr, context);
                yield Expression.valueToString(value).toLowerCase();
            }
            case "concat" -> {
                String[] parts = Expression.splitArgs(argsStr);
                StringBuilder sb = new StringBuilder();
                for (String part : parts) {
                    sb.append(Expression.valueToString(Expression.evaluateBinding(part.trim(), context)));
                }
                yield sb.toString();
            }
            case "substr" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 2) {
                    String str = Expression.valueToString(Expression.evaluateBinding(parts[0].trim(), context));
                    int start = (int)Expression.toDouble(Expression.evaluateBinding(parts[1].trim(), context));
                    int end = parts.length >= 3 ? (int)Expression.toDouble(Expression.evaluateBinding(parts[2].trim(), context)) : str.length();
                    yield str.substring(Math.max(0, start), Math.min(str.length(), end));
                }
                yield "";
            }
            case "replace" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 3) {
                    String str = Expression.valueToString(Expression.evaluateBinding(parts[0].trim(), context));
                    String find = Expression.valueToString(Expression.evaluateBinding(parts[1].trim(), context));
                    String replacement = Expression.valueToString(Expression.evaluateBinding(parts[2].trim(), context));
                    yield str.replace(find, replacement);
                }
                yield "";
            }
            case "if" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 3) {
                    boolean condition = Expression.evaluateBoolean(parts[0], context);
                    if (condition) {
                        yield Expression.evaluateBinding(parts[1], context);
                    }
                    yield Expression.evaluateBinding(parts[2], context);
                }
                yield null;
            }
            case "min" -> {
                String[] parts = Expression.splitArgs(argsStr);
                double min = Double.MAX_VALUE;
                for (String part : parts) {
                    min = Math.min(min, Expression.toDouble(Expression.evaluateBinding(part.trim(), context)));
                }
                yield min;
            }
            case "max" -> {
                String[] parts = Expression.splitArgs(argsStr);
                double max = Double.MIN_VALUE;
                for (String part : parts) {
                    max = Math.max(max, Expression.toDouble(Expression.evaluateBinding(part.trim(), context)));
                }
                yield max;
            }
            case "round" -> {
                double val = Expression.toDouble(Expression.evaluateBinding(argsStr.trim(), context));
                yield Math.round(val);
            }
            case "floor" -> {
                double val = Expression.toDouble(Expression.evaluateBinding(argsStr.trim(), context));
                yield Math.floor(val);
            }
            case "ceil" -> {
                double val = Expression.toDouble(Expression.evaluateBinding(argsStr.trim(), context));
                yield Math.ceil(val);
            }
            case "abs" -> {
                double val = Expression.toDouble(Expression.evaluateBinding(argsStr.trim(), context));
                yield Math.abs(val);
            }
            case "clamp" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 3) {
                    double val = Expression.toDouble(Expression.evaluateBinding(parts[0].trim(), context));
                    double min = Expression.toDouble(Expression.evaluateBinding(parts[1].trim(), context));
                    double max = Expression.toDouble(Expression.evaluateBinding(parts[2].trim(), context));
                    yield Math.max(min, Math.min(max, val));
                }
                yield 0.0;
            }
            case "sqrt" -> {
                double val = Expression.toDouble(Expression.evaluateBinding(argsStr.trim(), context));
                yield Math.sqrt(val);
            }
            case "pow" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 2) {
                    double base = Expression.toDouble(Expression.evaluateBinding(parts[0].trim(), context));
                    double exp = Expression.toDouble(Expression.evaluateBinding(parts[1].trim(), context));
                    yield Math.pow(base, exp);
                }
                yield 0.0;
            }
            case "darken" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 2) {
                    int color = Expression.evaluateColor(parts[0].trim(), context, -1);
                    double amount = Expression.toDouble(Expression.evaluateBinding(parts[1].trim(), context));
                    yield Expression.darkenColor(color, (float)amount);
                }
                yield 0;
            }
            case "lighten" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 2) {
                    int color = Expression.evaluateColor(parts[0].trim(), context, -1);
                    double amount = Expression.toDouble(Expression.evaluateBinding(parts[1].trim(), context));
                    yield Expression.lightenColor(color, (float)amount);
                }
                yield 0;
            }
            case "mix" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 3) {
                    int color1 = Expression.evaluateColor(parts[0].trim(), context, -1);
                    int color2 = Expression.evaluateColor(parts[1].trim(), context, -16777216);
                    double ratio = Expression.toDouble(Expression.evaluateBinding(parts[2].trim(), context));
                    yield Expression.mixColors(color1, color2, (float)ratio);
                }
                yield 0;
            }
            case "alpha" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 2) {
                    int color = Expression.evaluateColor(parts[0].trim(), context, -1);
                    double alpha = Expression.toDouble(Expression.evaluateBinding(parts[1].trim(), context));
                    int a = (int)Math.max(0.0, Math.min(255.0, alpha * 255.0));
                    yield a << 24 | color & 0xFFFFFF;
                }
                yield 0;
            }
            case "rgb" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 3) {
                    int r = (int)Math.max(0.0, Math.min(255.0, Expression.toDouble(Expression.evaluateBinding(parts[0].trim(), context))));
                    int g = (int)Math.max(0.0, Math.min(255.0, Expression.toDouble(Expression.evaluateBinding(parts[1].trim(), context))));
                    int b = (int)Math.max(0.0, Math.min(255.0, Expression.toDouble(Expression.evaluateBinding(parts[2].trim(), context))));
                    yield 0xFF000000 | r << 16 | g << 8 | b;
                }
                yield 0;
            }
            case "rgba" -> {
                String[] parts = Expression.splitArgs(argsStr);
                if (parts.length >= 4) {
                    int r = (int)Math.max(0.0, Math.min(255.0, Expression.toDouble(Expression.evaluateBinding(parts[0].trim(), context))));
                    int g = (int)Math.max(0.0, Math.min(255.0, Expression.toDouble(Expression.evaluateBinding(parts[1].trim(), context))));
                    int b = (int)Math.max(0.0, Math.min(255.0, Expression.toDouble(Expression.evaluateBinding(parts[2].trim(), context))));
                    int a = (int)Math.max(0.0, Math.min(255.0, Expression.toDouble(Expression.evaluateBinding(parts[3].trim(), context)) * 255.0));
                    yield a << 24 | r << 16 | g << 8 | b;
                }
                yield 0;
            }
            default -> null;
        };
    }

    private static int darkenColor(int color, float amount) {
        int a = color >>> 24 & 0xFF;
        int r = (int)((float)(color >>> 16 & 0xFF) * (1.0f - amount));
        int g = (int)((float)(color >>> 8 & 0xFF) * (1.0f - amount));
        int b = (int)((float)(color & 0xFF) * (1.0f - amount));
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int lightenColor(int color, float amount) {
        int a = color >>> 24 & 0xFF;
        int r = (int)((float)(color >>> 16 & 0xFF) + (float)(255 - (color >>> 16 & 0xFF)) * amount);
        int g = (int)((float)(color >>> 8 & 0xFF) + (float)(255 - (color >>> 8 & 0xFF)) * amount);
        int b = (int)((float)(color & 0xFF) + (float)(255 - (color & 0xFF)) * amount);
        return a << 24 | Math.min(255, r) << 16 | Math.min(255, g) << 8 | Math.min(255, b);
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >>> 24 & 0xFF;
        int a2 = color2 >>> 24 & 0xFF;
        int r1 = color1 >>> 16 & 0xFF;
        int r2 = color2 >>> 16 & 0xFF;
        int g1 = color1 >>> 8 & 0xFF;
        int g2 = color2 >>> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * ratio);
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static Object evaluateComparison(String expression, BindingContext context) {
        String[] ops;
        for (String op : ops = new String[]{" == ", " != ", " > ", " < ", " >= ", " <= ", " && ", " || "}) {
            if (!expression.contains(op)) continue;
            String[] parts = expression.split(Pattern.quote(op), 2);
            if (parts.length != 2) break;
            Object left = Expression.evaluateBinding(parts[0].trim(), context);
            Object right = Expression.evaluateBinding(parts[1].trim(), context);
            return switch (op.trim()) {
                case "==" -> Expression.compareEquals(left, right);
                case "!=" -> !Expression.compareEquals(left, right);
                case ">" -> Expression.compareGreater(left, right);
                case "<" -> Expression.compareGreater(right, left);
                case ">=" -> Expression.compareGreater(left, right) || Expression.compareEquals(left, right);
                case "<=" -> Expression.compareGreater(right, left) || Expression.compareEquals(left, right);
                case "&&" -> Expression.toBoolean(left) && Expression.toBoolean(right);
                case "||" -> Expression.toBoolean(left) || Expression.toBoolean(right);
                default -> false;
            };
        }
        return false;
    }

    private static Object evaluateTernary(String expression, BindingContext context) {
        int questionMark = expression.indexOf(" ? ");
        int colon = expression.indexOf(" : ", questionMark);
        if (questionMark > 0 && colon > questionMark) {
            String condition = expression.substring(0, questionMark);
            String trueValue = expression.substring(questionMark + 3, colon);
            String falseValue = expression.substring(colon + 3);
            boolean cond = Expression.evaluateBoolean(condition, context);
            return cond ? Expression.evaluateBinding(trueValue, context) : Expression.evaluateBinding(falseValue, context);
        }
        return null;
    }

    private static boolean compareEquals(Object left, Object right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        return left.toString().equals(right.toString());
    }

    private static boolean compareGreater(Object left, Object right) {
        try {
            double leftNum = Expression.toDouble(left);
            double rightNum = Expression.toDouble(right);
            return leftNum > rightNum;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static double toDouble(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            return Double.parseDouble((String)obj);
        }
        return 0.0;
    }

    private static boolean toBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return !str.isEmpty() && !str.equalsIgnoreCase("false") && !str.equals("0");
        }
        return obj != null;
    }

    private static String[] splitArgs(String argsStr) {
        return argsStr.split(",");
    }

    private static String valueToString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

