/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.texboobcat.questory.theme.panel.BindingContext;
import org.texboobcat.questory.theme.panel.Expression;

public class GradientParser {
    private static final Pattern LINEAR_PATTERN = Pattern.compile("linear-gradient\\s*\\(\\s*([^,]+?)\\s*,\\s*(.+)\\s*\\)");
    private static final Pattern RADIAL_PATTERN = Pattern.compile("radial-gradient\\s*\\(\\s*(.+)\\s*\\)");

    public static GradientData parse(String gradient, BindingContext context) {
        if (gradient == null || gradient.isEmpty()) {
            return null;
        }
        if ((gradient = gradient.trim()).startsWith("linear-gradient")) {
            return GradientParser.parseLinear(gradient, context);
        }
        if (gradient.startsWith("radial-gradient")) {
            return GradientParser.parseRadial(gradient, context);
        }
        return null;
    }

    private static GradientData parseLinear(String gradient, BindingContext context) {
        Matcher m = LINEAR_PATTERN.matcher(gradient);
        if (!m.find()) {
            return null;
        }
        String angleStr = m.group(1).trim();
        float angle = GradientParser.parseAngle(angleStr);
        String colorsStr = m.group(2);
        int[] colors = GradientParser.parseColors(colorsStr, context);
        if (colors.length < 2) {
            return null;
        }
        return new GradientData(false, angle, colors);
    }

    private static GradientData parseRadial(String gradient, BindingContext context) {
        Matcher m = RADIAL_PATTERN.matcher(gradient);
        if (!m.find()) {
            return null;
        }
        String content = m.group(1);
        String[] parts = content.split(",");
        ArrayList<String> colorParts = new ArrayList<String>();
        for (String part : parts) {
            String trimmed = part.trim().toLowerCase();
            if (trimmed.equals("circle") || trimmed.equals("ellipse") || trimmed.startsWith("at ") || trimmed.startsWith("closest") || trimmed.startsWith("farthest")) continue;
            colorParts.add(part);
        }
        int[] colors = GradientParser.parseColors(String.join((CharSequence)",", colorParts), context);
        if (colors.length < 2) {
            return null;
        }
        return new GradientData(true, 0.0f, colors);
    }

    private static float parseAngle(String angleStr) {
        switch (angleStr = angleStr.trim().toLowerCase()) {
            case "to right": {
                return 90.0f;
            }
            case "to left": {
                return 270.0f;
            }
            case "to top": {
                return 0.0f;
            }
            case "to bottom": {
                return 180.0f;
            }
            case "to top right": 
            case "to right top": {
                return 45.0f;
            }
            case "to bottom right": 
            case "to right bottom": {
                return 135.0f;
            }
            case "to bottom left": 
            case "to left bottom": {
                return 225.0f;
            }
            case "to top left": 
            case "to left top": {
                return 315.0f;
            }
        }
        if (angleStr.endsWith("deg")) {
            try {
                return Float.parseFloat(angleStr.substring(0, angleStr.length() - 3).trim());
            }
            catch (NumberFormatException e) {
                return 90.0f;
            }
        }
        try {
            return Float.parseFloat(angleStr);
        }
        catch (NumberFormatException e) {
            return 90.0f;
        }
    }

    private static int[] parseColors(String colorsStr, BindingContext context) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        List<String> colorStrings = GradientParser.splitColorStops(colorsStr);
        for (String colorStr : colorStrings) {
            if ((colorStr = colorStr.trim()).isEmpty()) continue;
            String[] parts = colorStr.split("\\s+");
            String color = parts[0].trim();
            int parsed = Expression.evaluateColor(color, context, -1);
            colors.add(parsed);
        }
        return colors.stream().mapToInt(Integer::intValue).toArray();
    }

    private static List<String> splitColorStops(String str) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int parenDepth = 0;
        for (char c : str.toCharArray()) {
            if (c == '(') {
                ++parenDepth;
                current.append(c);
                continue;
            }
            if (c == ')') {
                --parenDepth;
                current.append(c);
                continue;
            }
            if (c == ',' && parenDepth == 0) {
                result.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    public record GradientData(boolean isRadial, float angle, int[] colors) {
    }
}

