/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.property;

import org.texboobcat.questory.theme.property.ThemeProperty;

public class IntProperty
extends ThemeProperty<Integer> {
    private final int min;
    private final int max;

    public IntProperty(String name, int min, int max) {
        super(name, min);
        this.min = min;
        this.max = max;
    }

    @Override
    public Integer parse(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            int value = Integer.parseInt(string.trim());
            return Math.max(this.min, Math.min(this.max, value));
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to parse int: " + string);
            return null;
        }
    }
}

