/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.ColorPickerScreen;
import org.texboobcat.questory.client.gui.IconPickerScreen;
import org.texboobcat.questory.quest.ChapterImage;

public class ChapterImageEditorScreen
extends Screen {
    private final Screen parent;
    private final ChapterImage image;
    private final Consumer<ChapterImage> onSave;
    private EditBox xField;
    private EditBox yField;
    private EditBox widthField;
    private EditBox heightField;
    private EditBox rotationField;
    private EditBox imageUrlField;
    private EditBox colorField;
    private EditBox alphaField;
    private EditBox orderField;
    private Button browseBtn;
    private Button colorPickerBtn;
    private EditBox clickUrlField;
    private EditBox depQuestIdField;
    private List<EditBox> hoverTextFields = new ArrayList<EditBox>();
    private Button addHoverBtn;
    private Button removeHoverBtn;
    private Button editorsOnlyBtn;
    private Button alignCornerBtn;
    private boolean editorsOnly = false;
    private boolean alignCorner = false;
    private Button saveBtn;
    private Button cancelBtn;
    private int scrollOffset = 0;

    public ChapterImageEditorScreen(Screen parent, ChapterImage image, Consumer<ChapterImage> onSave) {
        super((Component)Component.m_237113_((String)"Edit Chapter Image"));
        this.parent = parent;
        this.image = image;
        this.onSave = onSave;
    }

    protected void m_7856_() {
        super.m_7856_();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "chapter_image_editor");
        int panelW = Math.min(600, this.f_96543_ - 40);
        int panelX = (this.f_96543_ - panelW) / 2;
        int fieldY = 60;
        int fieldW = panelW - 140;
        this.xField = new EditBox(this.f_96547_, panelX + 120, fieldY, 80, 18, (Component)Component.m_237113_((String)"x"));
        this.xField.m_94144_(String.valueOf(this.image.getX()));
        this.m_142416_((GuiEventListener)this.xField);
        this.yField = new EditBox(this.f_96547_, panelX + 220, fieldY, 80, 18, (Component)Component.m_237113_((String)"y"));
        this.yField.m_94144_(String.valueOf(this.image.getY()));
        this.m_142416_((GuiEventListener)this.yField);
        this.widthField = new EditBox(this.f_96547_, panelX + 120, fieldY += 24, 80, 18, (Component)Component.m_237113_((String)"width"));
        this.widthField.m_94144_(String.valueOf(this.image.getWidth()));
        this.m_142416_((GuiEventListener)this.widthField);
        this.heightField = new EditBox(this.f_96547_, panelX + 220, fieldY, 80, 18, (Component)Component.m_237113_((String)"height"));
        this.heightField.m_94144_(String.valueOf(this.image.getHeight()));
        this.m_142416_((GuiEventListener)this.heightField);
        this.rotationField = new EditBox(this.f_96547_, panelX + 120, fieldY += 24, 100, 18, (Component)Component.m_237113_((String)"rotation"));
        this.rotationField.m_94144_(String.valueOf(this.image.getRotation()));
        this.rotationField.m_257771_((Component)Component.m_237113_((String)"0-360 degrees"));
        this.m_142416_((GuiEventListener)this.rotationField);
        this.imageUrlField = new EditBox(this.f_96547_, panelX + 120, fieldY += 30, fieldW - 90, 18, (Component)Component.m_237113_((String)"image"));
        this.imageUrlField.m_94144_(this.image.getImageUrl());
        this.imageUrlField.m_257771_((Component)Component.m_237113_((String)"textures/chapter/image.png"));
        this.m_142416_((GuiEventListener)this.imageUrlField);
        this.browseBtn = Button.m_253074_((Component)Component.m_237113_((String)"Browse..."), b -> this.openImageBrowser()).m_252987_(panelX + 120 + fieldW - 85, fieldY, 80, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.browseBtn);
        this.colorField = new EditBox(this.f_96547_, panelX + 120, fieldY += 24, 100, 18, (Component)Component.m_237113_((String)"color"));
        this.colorField.m_94144_(this.image.getColor());
        this.colorField.m_257771_((Component)Component.m_237113_((String)"#FFFFFF"));
        this.m_142416_((GuiEventListener)this.colorField);
        this.colorPickerBtn = Button.m_253074_((Component)Component.m_237113_((String)"Pick..."), b -> this.openColorPicker()).m_252987_(panelX + 230, fieldY, 70, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.colorPickerBtn);
        this.alphaField = new EditBox(this.f_96547_, panelX + 120, fieldY += 24, 80, 18, (Component)Component.m_237113_((String)"alpha"));
        this.alphaField.m_94144_(String.valueOf(this.image.getAlpha()));
        this.alphaField.m_257771_((Component)Component.m_237113_((String)"0-255"));
        this.m_142416_((GuiEventListener)this.alphaField);
        this.orderField = new EditBox(this.f_96547_, panelX + 120, fieldY += 24, 80, 18, (Component)Component.m_237113_((String)"order"));
        this.orderField.m_94144_(String.valueOf(this.image.getOrder()));
        this.orderField.m_257771_((Component)Component.m_237113_((String)"z-index/layer"));
        this.m_142416_((GuiEventListener)this.orderField);
        fieldY += 30;
        if (!this.image.getHoverText().isEmpty()) {
            for (int i = 0; i < Math.min(3, this.image.getHoverText().size()); ++i) {
                EditBox hoverField = new EditBox(this.f_96547_, panelX + 120, fieldY, fieldW, 18, (Component)Component.m_237113_((String)("hover" + i)));
                hoverField.m_94144_(this.image.getHoverText().get(i));
                hoverField.m_257771_((Component)Component.m_237113_((String)("Hover text line " + (i + 1))));
                this.m_142416_((GuiEventListener)hoverField);
                this.hoverTextFields.add(hoverField);
                fieldY += 20;
            }
        } else {
            EditBox hoverField = new EditBox(this.f_96547_, panelX + 120, fieldY, fieldW, 18, (Component)Component.m_237113_((String)"hover"));
            hoverField.m_257771_((Component)Component.m_237113_((String)"Hover text (optional)"));
            this.m_142416_((GuiEventListener)hoverField);
            this.hoverTextFields.add(hoverField);
            fieldY += 20;
        }
        this.addHoverBtn = Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> this.addHoverLine()).m_252987_(panelX + 120 + fieldW + 4, fieldY - 20, 20, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.addHoverBtn);
        this.clickUrlField = new EditBox(this.f_96547_, panelX + 120, fieldY += 10, fieldW, 18, (Component)Component.m_237113_((String)"click"));
        this.clickUrlField.m_94144_(this.image.getClickUrl());
        this.clickUrlField.m_257771_((Component)Component.m_237113_((String)"http://example.com (optional)"));
        this.m_142416_((GuiEventListener)this.clickUrlField);
        this.editorsOnly = this.image.isEditorsOnly();
        this.editorsOnlyBtn = Button.m_253074_((Component)Component.m_237113_((String)("Editors Only: " + (this.editorsOnly ? "Yes" : "No"))), b -> {
            this.editorsOnly = !this.editorsOnly;
            this.editorsOnlyBtn.m_93666_((Component)Component.m_237113_((String)("Editors Only: " + (this.editorsOnly ? "Yes" : "No"))));
        }).m_252987_(panelX + 120, fieldY += 30, 140, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.editorsOnlyBtn);
        this.alignCorner = this.image.isAlignToCorner();
        this.alignCornerBtn = Button.m_253074_((Component)Component.m_237113_((String)("Align To Corner: " + (this.alignCorner ? "Yes" : "No"))), b -> {
            this.alignCorner = !this.alignCorner;
            this.alignCornerBtn.m_93666_((Component)Component.m_237113_((String)("Align To Corner: " + (this.alignCorner ? "Yes" : "No"))));
        }).m_252987_(panelX + 120, fieldY += 22, 140, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.alignCornerBtn);
        this.depQuestIdField = new EditBox(this.f_96547_, panelX + 120, fieldY += 22, fieldW, 18, (Component)Component.m_237113_((String)"dependency"));
        this.depQuestIdField.m_94144_(this.image.getDependencyQuestId() == null ? "" : this.image.getDependencyQuestId());
        this.depQuestIdField.m_257771_((Component)Component.m_237113_((String)"quest_id (optional)"));
        this.m_142416_((GuiEventListener)this.depQuestIdField);
        int btnY = this.f_96544_ - 32;
        this.saveBtn = Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252987_(panelX + panelW - 130, btnY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveBtn);
        this.cancelBtn = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(panelX + panelW - 65, btnY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelBtn);
    }

    private void addHoverLine() {
        if (this.hoverTextFields.size() < 5) {
            this.save();
        }
    }

    private void openImageBrowser() {
        this.f_96541_.m_91152_((Screen)new IconPickerScreen(this, this.imageUrlField.m_94155_(), result -> {
            this.imageUrlField.m_94144_(result);
            this.f_96541_.m_91152_((Screen)this);
        }));
    }

    private void openColorPicker() {
        int currentColor = this.parseColor(this.colorField.m_94155_());
        this.f_96541_.m_91152_((Screen)new ColorPickerScreen(this, currentColor, color -> {
            this.colorField.m_94144_(String.format("#%06X", color & 0xFFFFFF));
            this.f_96541_.m_91152_((Screen)this);
        }));
    }

    private int parseColor(String hex) {
        try {
            String clean = hex.trim();
            if (clean.startsWith("#")) {
                clean = clean.substring(1);
            }
            return (int)Long.parseLong(clean, 16) | 0xFF000000;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void save() {
        try {
            ChapterImage updated = new ChapterImage(Integer.parseInt(this.xField.m_94155_().trim()), Integer.parseInt(this.yField.m_94155_().trim()), Double.parseDouble(this.widthField.m_94155_().trim()), Double.parseDouble(this.heightField.m_94155_().trim()), this.imageUrlField.m_94155_().trim());
            updated.setRotation(Double.parseDouble(this.rotationField.m_94155_().trim()));
            updated.setColor(this.colorField.m_94155_().trim());
            updated.setAlpha(Integer.parseInt(this.alphaField.m_94155_().trim()));
            updated.setOrder(Integer.parseInt(this.orderField.m_94155_().trim()));
            updated.setClickUrl(this.clickUrlField.m_94155_().trim());
            updated.setEditorsOnly(this.editorsOnly);
            updated.setAlignToCorner(this.alignCorner);
            String depId = this.depQuestIdField.m_94155_().trim();
            if (!depId.isEmpty()) {
                updated.setDependencyQuestId(depId);
            }
            for (EditBox hoverField : this.hoverTextFields) {
                String text = hoverField.m_94155_().trim();
                if (text.isEmpty()) continue;
                updated.addHoverText(text);
            }
            this.onSave.accept(updated);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        int panelW = Math.min(600, this.f_96543_ - 40);
        int panelX = (this.f_96543_ - panelW) / 2;
        int fieldY = 60 - this.scrollOffset;
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, -1);
        int labelX = panelX + 12;
        g.m_280488_(this.f_96547_, "\u00a7lPosition & Size", labelX, fieldY - 8, -86);
        g.m_280488_(this.f_96547_, "X:", labelX, fieldY + 5, -1);
        g.m_280488_(this.f_96547_, "Y:", labelX + 100, fieldY + 5, -1);
        g.m_280488_(this.f_96547_, "Width:", labelX, (fieldY += 24) + 5, -1);
        g.m_280488_(this.f_96547_, "Height:", labelX + 100, fieldY + 5, -1);
        g.m_280488_(this.f_96547_, "Rotation:", labelX, (fieldY += 24) + 5, -1);
        g.m_280488_(this.f_96547_, "\u00a7lAppearance", labelX, fieldY += 30, -86);
        g.m_280488_(this.f_96547_, "Image URL:", labelX, (fieldY += 12) + 5, -1);
        g.m_280488_(this.f_96547_, "Color Tint:", labelX, (fieldY += 24) + 5, -1);
        g.m_280488_(this.f_96547_, "Alpha:", labelX, (fieldY += 24) + 5, -1);
        g.m_280488_(this.f_96547_, "Order:", labelX, (fieldY += 24) + 5, -1);
        g.m_280488_(this.f_96547_, "\u00a7lInteractivity", labelX, fieldY += 30, -86);
        g.m_280488_(this.f_96547_, "Hover Text:", labelX, (fieldY += 12) + 5, -1);
        g.m_280488_(this.f_96547_, "Click URL:", labelX, (fieldY += 20 * this.hoverTextFields.size() + 10) + 5, -1);
        g.m_280488_(this.f_96547_, "\u00a7lOptions", labelX, fieldY += 30, -86);
        fieldY += 12;
        fieldY += 22;
        g.m_280488_(this.f_96547_, "Dependency:", labelX, (fieldY += 22) + 5, -1);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollOffset = (int)Math.max(0.0, (double)this.scrollOffset - Math.signum(delta) * 20.0);
        return true;
    }

    public boolean m_7043_() {
        return false;
    }
}

