/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfirmationDialog
extends Screen {
    private static final int WINDOW_WIDTH = 260;
    private static final int WINDOW_HEIGHT = 140;
    private final Screen parent;
    private final String title;
    private final String message;
    private final String confirmText;
    private final String cancelText;
    private final Runnable onConfirm;
    private final boolean isDangerous;
    private int leftPos;
    private int topPos;
    private Button confirmButton;
    private Button cancelButton;

    public ConfirmationDialog(Screen parent, String title, String message, Runnable onConfirm) {
        this(parent, title, message, "Confirm", "Cancel", onConfirm, false);
    }

    public ConfirmationDialog(Screen parent, String title, String message, String confirmText, String cancelText, Runnable onConfirm, boolean isDangerous) {
        super((Component)Component.m_237113_((String)title));
        this.parent = parent;
        this.title = title;
        this.message = message;
        this.confirmText = confirmText;
        this.cancelText = cancelText;
        this.onConfirm = onConfirm;
        this.isDangerous = isDangerous;
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 260) / 2;
        this.topPos = (this.f_96544_ - 140) / 2;
        int confirmColor = this.isDangerous ? 0xFF5555 : 0x55FF55;
        this.confirmButton = Button.m_253074_((Component)Component.m_237113_((String)this.confirmText), btn -> this.confirm()).m_252987_(this.leftPos + 10, this.topPos + 140 - 30, 115, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)this.cancelText), btn -> this.m_7379_()).m_252987_(this.leftPos + 135, this.topPos + 140 - 30, 115, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 140, -872415232);
        int titleBarColor = this.isDangerous ? -11202287 : -14540254;
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 25, titleBarColor);
        int titleWidth = this.f_96547_.m_92895_(this.title);
        graphics.m_280488_(this.f_96547_, this.title, this.leftPos + (260 - titleWidth) / 2, this.topPos + 8, 0xFFFFFF);
        String[] lines = this.wrapText(this.message, 240);
        int messageY = this.topPos + 40;
        for (String line : lines) {
            graphics.m_280488_(this.f_96547_, line, this.leftPos + 10, messageY, 0xFFFFFF);
            messageY += 12;
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void confirm() {
        if (this.onConfirm != null) {
            this.onConfirm.run();
        }
        this.m_7379_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private String[] wrapText(String text, int maxWidth) {
        String[] words = text.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() > 0 ? String.valueOf(currentLine) + " " + word : word;
            if (this.f_96547_.m_92895_(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
            }
            currentLine = new StringBuilder(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines.toArray(new String[0]);
    }
}

