/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.ClientRuntimeConfig;
import org.texboobcat.questory.client.gui.QuestHudOverlay;
import org.texboobcat.questory.config.QuestoryConfig;

public class QuestoryConfigScreen
extends Screen {
    private final Screen parent;
    private ConfigTab currentTab = ConfigTab.HUD;
    private Button hudTabButton;
    private Button notificationsTabButton;
    private Button displayTabButton;
    private Button generalTabButton;
    private Button serverTabButton;
    private Button environmentTabButton;
    private Button teamsTabButton;
    private Button dailyTabButton;
    private Button scriptingTabButton;
    private final List<Button> tabButtons = new ArrayList<Button>();
    private Button leftTabScrollBtn;
    private Button rightTabScrollBtn;
    private int tabsScrollPx = 0;
    private int tabsViewportX = 0;
    private int tabsViewportW = 0;
    private int tabsBarY = 10;
    private int tabButtonW = 80;
    private int tabButtonH = 16;
    private int tabSpacingBar = 4;
    private String hudPosition;
    private float hudScale;
    private int hudOpacity;
    private boolean hudCompactMode;
    private boolean hudShowIcons;
    private boolean hudShowProgressBars;
    private int hudOffsetX;
    private int hudOffsetY;
    private boolean enableNotifications;
    private boolean enableSounds;
    private boolean enableTitles;
    private boolean enableChatMessages;
    private boolean notifyOnUnlock;
    private boolean notifyOnReady;
    private boolean notifyOnComplete;
    private boolean showProgressPercentage;
    private boolean useColoredMessages;
    private boolean showQuestIDInList;
    private boolean mapIntegrationEnabled;
    private boolean journeyMapEnabled;
    private boolean clientEnableAdvancedEditor;
    private int autoSaveIntervalTicks;
    private boolean saveOnEveryProgress;
    private boolean trackCompletionTime;
    private boolean allowQuestReset;
    private boolean allowQuestReload;
    private boolean requireOPForAdmin;
    private int adminPermissionLevel;
    private int maxQuestsPerPlayer;
    private int maxRequirementsPerQuest;
    private int maxRewardsPerQuest;
    private boolean enableAdvancedEditorServer;
    private boolean advancedEditorRequiresOp;
    private boolean debugMode;
    private boolean logQuestProgress;
    private boolean logQuestCompletion;
    private boolean observationEnabled;
    private int observationScanIntervalTicks;
    private double observationMaxLookDistance;
    private boolean environmentOnlyVisibleQuests;
    private boolean autoCompleteWhenRequirementsMet;
    private boolean teamSystemEnabled;
    private boolean teamUseExternalProvider;
    private String teamPreferredProvider;
    private boolean teamFallbackToBuiltIn;
    private String teamDefaultProgressMode;
    private String teamDefaultRewardMode;
    private int teamMaxSize;
    private boolean teamAllowCreation;
    private boolean teamRequireAllOnlineDefault;
    private int teamSyncProgressDelay;
    private boolean dailyEnable;
    private boolean dailyFetchOnWorldLoad;
    private int dailyFetchIntervalMinutes;
    private int dailyCacheTtlMinutes;
    private String dailyOfflineFallback;
    private int dailyRolloverHour;
    private String dailyTimeZone;
    private String dailyGroupName;
    private String dailyTagKey;
    private String dailyPrefixQuestIds;
    private int dailyMaxActiveQuests;
    private String dailyCompletionMode;
    private int dailyMinQuestsToComplete;
    private boolean dailyStoreHistory;
    private String dailyRemoteUrl;
    private String dailyBackupUrlsCsv;
    private EditBox dailyRemoteUrlBox;
    private EditBox dailyBackupUrlsBox;
    private EditBox dailyTimeZoneBox;
    private EditBox dailyGroupNameBox;
    private EditBox dailyTagKeyBox;
    private EditBox dailyPrefixBox;
    private boolean scriptIntegrationEnabled;
    private boolean scriptAllowExternalHttp;
    private boolean scriptEmitOnUnlock;
    private boolean scriptEmitOnStarted;
    private boolean scriptEmitOnProgress;
    private boolean scriptEmitOnCompleted;
    private boolean scriptEmitOnRewardClaimed;
    private String scriptWebhookUrl;
    private int scriptHttpTimeoutMs;
    private String scriptCommandOnUnlock;
    private String scriptCommandOnStarted;
    private String scriptCommandOnProgress;
    private String scriptCommandOnComplete;
    private String scriptCommandOnRewardClaimed;
    private EditBox scriptWebhookUrlBox;
    private EditBox scriptCmdUnlockBox;
    private EditBox scriptCmdStartedBox;
    private EditBox scriptCmdProgressBox;
    private EditBox scriptCmdCompleteBox;
    private EditBox scriptCmdRewardBox;
    private Button saveButton;
    private Button cancelButton;
    private Button resetButton;
    private boolean draggingHud = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int originalOffsetX = 0;
    private int originalOffsetY = 0;
    private List<TooltipArea> tooltipAreas = new ArrayList<TooltipArea>();

    public QuestoryConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Questify Configuration"));
        this.parent = parent;
        this.loadConfig();
    }

    private boolean canEditServer() {
        try {
            return ClientRuntimeConfig.isPlayerPermitted();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private void loadConfig() {
        this.hudPosition = ClientConfig.getHudPosition();
        this.hudScale = ClientConfig.getHudScale();
        this.hudOpacity = ClientConfig.getHudOpacity();
        this.hudCompactMode = ClientConfig.isHudCompactMode();
        this.hudShowIcons = ClientConfig.isHudShowIcons();
        this.hudShowProgressBars = ClientConfig.isHudShowProgressBars();
        this.hudOffsetX = ClientConfig.getHudOffsetX();
        this.hudOffsetY = ClientConfig.getHudOffsetY();
        QuestoryConfig config = QuestoryConfig.getInstance();
        this.enableNotifications = config.enableQuestNotifications;
        this.enableSounds = config.enableQuestSounds;
        this.enableTitles = config.enableQuestTitles;
        this.enableChatMessages = config.enableQuestChatMessages;
        this.notifyOnUnlock = config.notifyOnQuestUnlock;
        this.notifyOnReady = config.notifyOnQuestReady;
        this.notifyOnComplete = config.notifyOnQuestComplete;
        this.showProgressPercentage = config.showProgressPercentage;
        this.useColoredMessages = config.useColoredMessages;
        this.showQuestIDInList = config.showQuestIDInList;
        this.mapIntegrationEnabled = ClientConfig.isMapIntegrationEnabled();
        this.journeyMapEnabled = ClientConfig.isJourneyMapEnabled();
        this.clientEnableAdvancedEditor = ClientConfig.isClientEnableAdvancedEditor();
        this.autoSaveIntervalTicks = config.autoSaveIntervalTicks;
        this.saveOnEveryProgress = config.saveOnEveryProgress;
        this.trackCompletionTime = config.trackCompletionTime;
        this.allowQuestReset = config.allowQuestReset;
        this.allowQuestReload = config.allowQuestReload;
        this.requireOPForAdmin = config.requireOPForAdmin;
        this.adminPermissionLevel = config.adminPermissionLevel;
        this.maxQuestsPerPlayer = config.maxQuestsPerPlayer;
        this.maxRequirementsPerQuest = config.maxRequirementsPerQuest;
        this.maxRewardsPerQuest = config.maxRewardsPerQuest;
        this.enableAdvancedEditorServer = config.enableAdvancedEditor;
        this.advancedEditorRequiresOp = config.advancedEditorRequiresOp;
        this.debugMode = config.debugMode;
        this.logQuestProgress = config.logQuestProgress;
        this.logQuestCompletion = config.logQuestCompletion;
        this.observationEnabled = config.observationEnabled;
        this.observationScanIntervalTicks = config.observationScanIntervalTicks;
        this.observationMaxLookDistance = config.observationMaxLookDistance;
        this.environmentOnlyVisibleQuests = config.environmentOnlyVisibleQuests;
        this.autoCompleteWhenRequirementsMet = config.autoCompleteWhenRequirementsMet;
        this.teamSystemEnabled = config.teamSystemEnabled;
        this.teamUseExternalProvider = config.teamUseExternalProvider;
        this.teamPreferredProvider = config.teamPreferredProvider;
        this.teamFallbackToBuiltIn = config.teamFallbackToBuiltIn;
        this.teamDefaultProgressMode = config.teamDefaultProgressMode;
        this.teamDefaultRewardMode = config.teamDefaultRewardMode;
        this.teamMaxSize = config.teamMaxSize;
        this.teamAllowCreation = config.teamAllowCreation;
        this.teamRequireAllOnlineDefault = config.teamRequireAllOnlineDefault;
        this.teamSyncProgressDelay = config.teamSyncProgressDelay;
        this.dailyEnable = config.dailyEnable;
        this.dailyFetchOnWorldLoad = config.dailyFetchOnWorldLoad;
        this.dailyFetchIntervalMinutes = config.dailyFetchIntervalMinutes;
        this.dailyCacheTtlMinutes = config.dailyCacheTtlMinutes;
        this.dailyOfflineFallback = config.dailyOfflineFallback;
        this.dailyRolloverHour = config.dailyRolloverHour;
        this.dailyTimeZone = config.dailyTimeZone;
        this.dailyGroupName = config.dailyGroupName;
        this.dailyTagKey = config.dailyTagKey;
        this.dailyPrefixQuestIds = config.dailyPrefixQuestIds;
        this.dailyMaxActiveQuests = config.dailyMaxActiveQuests;
        this.dailyCompletionMode = config.dailyCompletionMode;
        this.dailyMinQuestsToComplete = config.dailyMinQuestsToComplete;
        this.dailyStoreHistory = config.dailyStoreHistory;
        this.dailyRemoteUrl = config.dailyRemoteUrl != null ? config.dailyRemoteUrl : "";
        ArrayList bu = config.dailyBackupUrls != null ? config.dailyBackupUrls : new ArrayList();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bu.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((String)bu.get(i));
        }
        this.dailyBackupUrlsCsv = sb.toString();
        this.scriptIntegrationEnabled = config.scriptIntegrationEnabled;
        this.scriptAllowExternalHttp = config.scriptAllowExternalHttp;
        this.scriptEmitOnUnlock = config.scriptEmitOnUnlock;
        this.scriptEmitOnStarted = config.scriptEmitOnStarted;
        this.scriptEmitOnProgress = config.scriptEmitOnProgress;
        this.scriptEmitOnCompleted = config.scriptEmitOnCompleted;
        this.scriptEmitOnRewardClaimed = config.scriptEmitOnRewardClaimed;
        this.scriptWebhookUrl = config.scriptWebhookUrl != null ? config.scriptWebhookUrl : "";
        this.scriptHttpTimeoutMs = config.scriptHttpTimeoutMs;
        this.scriptCommandOnUnlock = config.scriptCommandOnUnlock != null ? config.scriptCommandOnUnlock : "";
        this.scriptCommandOnStarted = config.scriptCommandOnStarted != null ? config.scriptCommandOnStarted : "";
        this.scriptCommandOnProgress = config.scriptCommandOnProgress != null ? config.scriptCommandOnProgress : "";
        this.scriptCommandOnComplete = config.scriptCommandOnComplete != null ? config.scriptCommandOnComplete : "";
        this.scriptCommandOnRewardClaimed = config.scriptCommandOnRewardClaimed != null ? config.scriptCommandOnRewardClaimed : "";
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tooltipAreas = new ArrayList<TooltipArea>();
        this.tabsBarY = 10;
        int margin = 12;
        int arrowW = 14;
        int desiredViewportW = Math.min(this.f_96543_ - 120, 520);
        int barTotalW = arrowW + 4 + desiredViewportW + 4 + arrowW;
        int leftX = (this.f_96543_ - barTotalW) / 2;
        this.tabsViewportX = leftX + arrowW + 4;
        this.tabsViewportW = desiredViewportW;
        this.tabButtons.clear();
        this.leftTabScrollBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
            this.tabsScrollPx = Math.max(0, this.tabsScrollPx - (this.tabButtonW + this.tabSpacingBar));
            this.reflowTabs();
        }).m_252987_(leftX, this.tabsBarY, arrowW, this.tabButtonH).m_253136_());
        this.rightTabScrollBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
            this.tabsScrollPx += this.tabButtonW + this.tabSpacingBar;
            this.reflowTabs();
        }).m_252987_(leftX + barTotalW - arrowW, this.tabsBarY, arrowW, this.tabButtonH).m_253136_());
        int idx = 0;
        ConfigTab[] configTabArray = ConfigTab.values();
        int n = configTabArray.length;
        for (int i = 0; i < n; ++i) {
            ConfigTab t;
            ConfigTab tabRef = t = configTabArray[i];
            Button btn = Button.m_253074_((Component)Component.m_237113_((String)t.label), b -> {
                if (this.currentTab != tabRef) {
                    this.switchTab(tabRef);
                }
            }).m_252987_(0, this.tabsBarY, this.tabButtonW, this.tabButtonH).m_253136_();
            this.m_142416_((GuiEventListener)btn);
            this.tabButtons.add(btn);
            ++idx;
        }
        this.centerOnCurrentTab();
        this.reflowTabs();
        int bottomY = this.f_96544_ - 30;
        int bottomButtonWidth = 70;
        int centerX = this.f_96543_ / 2;
        this.resetButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset"), b -> this.resetCurrentTab()).m_252987_(centerX - bottomButtonWidth * 2 - 10, bottomY, bottomButtonWidth, 20).m_253136_());
        this.saveButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> {
            this.saveAllConfig();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(centerX - bottomButtonWidth / 2, bottomY, bottomButtonWidth, 20).m_253136_());
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(centerX + bottomButtonWidth + 10, bottomY, bottomButtonWidth, 20).m_253136_());
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.initHudTab();
                break;
            }
            case 1: {
                this.initNotificationsTab();
                break;
            }
            case 2: {
                this.initDisplayTab();
                break;
            }
            case 3: {
                this.initGeneralTab();
                break;
            }
            case 4: {
                this.initServerTab();
                break;
            }
            case 5: {
                this.initEnvironmentTab();
                break;
            }
            case 6: {
                this.initTeamsTab();
                break;
            }
            case 7: {
                this.initDailyTab();
                break;
            }
            case 8: {
                this.initScriptingTab();
            }
        }
    }

    private void reflowTabs() {
        int total = ConfigTab.values().length * (this.tabButtonW + this.tabSpacingBar) - this.tabSpacingBar;
        int maxScroll = Math.max(0, total - this.tabsViewportW);
        if (this.tabsScrollPx < 0) {
            this.tabsScrollPx = 0;
        }
        if (this.tabsScrollPx > maxScroll) {
            this.tabsScrollPx = maxScroll;
        }
        int x = this.tabsViewportX - this.tabsScrollPx;
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            Button btn = this.tabButtons.get(i);
            int bx = x + i * (this.tabButtonW + this.tabSpacingBar);
            btn.m_252865_(bx);
            btn.m_253211_(this.tabsBarY);
            btn.m_93674_(this.tabButtonW);
            btn.f_93624_ = bx >= this.tabsViewportX && bx + this.tabButtonW <= this.tabsViewportX + this.tabsViewportW;
            boolean isCurrent = this.currentTab == ConfigTab.values()[i];
            btn.f_93623_ = !isCurrent;
            String base = ConfigTab.values()[i].label;
            btn.m_93666_((Component)Component.m_237113_((String)(isCurrent ? "\u00bb " + base + " \u00ab" : base)));
        }
        if (this.leftTabScrollBtn != null) {
            boolean bl = this.leftTabScrollBtn.f_93623_ = this.tabsScrollPx > 0;
        }
        if (this.rightTabScrollBtn != null) {
            this.rightTabScrollBtn.f_93623_ = this.tabsScrollPx < maxScroll;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseY >= (double)this.tabsBarY && mouseY <= (double)(this.tabsBarY + this.tabButtonH + 2)) {
            this.tabsScrollPx -= (int)Math.signum(delta) * (this.tabButtonW + this.tabSpacingBar);
            this.reflowTabs();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void switchTab(ConfigTab tab) {
        this.currentTab = tab;
        this.centerOnCurrentTab();
        this.m_169413_();
        this.m_7856_();
    }

    private void centerOnCurrentTab() {
        int total = ConfigTab.values().length * (this.tabButtonW + this.tabSpacingBar) - this.tabSpacingBar;
        int maxScroll = Math.max(0, total - this.tabsViewportW);
        int idx = this.currentTab.ordinal();
        int tabCenterPx = idx * (this.tabButtonW + this.tabSpacingBar) + this.tabButtonW / 2;
        int desiredScroll = tabCenterPx - this.tabsViewportW / 2;
        if (desiredScroll < 0) {
            desiredScroll = 0;
        }
        if (desiredScroll > maxScroll) {
            desiredScroll = maxScroll;
        }
        this.tabsScrollPx = desiredScroll;
    }

    private void initHudTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 50;
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacing = 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Position: " + this.hudPosition)), b -> {
            this.hudPosition = switch (this.hudPosition) {
                case "TOP_LEFT" -> "TOP_RIGHT";
                case "TOP_RIGHT" -> "BOTTOM_RIGHT";
                case "BOTTOM_RIGHT" -> "BOTTOM_LEFT";
                default -> "TOP_LEFT";
            };
            b.m_93666_((Component)Component.m_237113_((String)("Position: " + this.hudPosition)));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        int scaleY = startY + spacing;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
            this.hudScale = Math.max(0.5f, this.hudScale - 0.1f);
        }).m_252987_(centerX - 60, scaleY, 20, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> {
            this.hudScale = Math.min(2.0f, this.hudScale + 0.1f);
        }).m_252987_(centerX + 40, scaleY, 20, buttonHeight).m_253136_());
        int opacityY = startY + spacing * 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
            this.hudOpacity = Math.max(0, this.hudOpacity - 10);
        }).m_252987_(centerX - 60, opacityY, 20, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> {
            this.hudOpacity = Math.min(100, this.hudOpacity + 10);
        }).m_252987_(centerX + 40, opacityY, 20, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Compact: " + (this.hudCompactMode ? "ON" : "OFF"))), b -> {
            this.hudCompactMode = !this.hudCompactMode;
            b.m_93666_((Component)Component.m_237113_((String)("Compact: " + (this.hudCompactMode ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Icons: " + (this.hudShowIcons ? "ON" : "OFF"))), b -> {
            this.hudShowIcons = !this.hudShowIcons;
            b.m_93666_((Component)Component.m_237113_((String)("Icons: " + (this.hudShowIcons ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Progress Bars: " + (this.hudShowProgressBars ? "ON" : "OFF"))), b -> {
            this.hudShowProgressBars = !this.hudShowProgressBars;
            b.m_93666_((Component)Component.m_237113_((String)("Progress Bars: " + (this.hudShowProgressBars ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).m_253136_());
    }

    private void initNotificationsTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 50;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        boolean permitted = this.canEditServer();
        Button b1 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Enable Notifications: " + (this.enableNotifications ? "ON" : "OFF"))), b -> {
            this.enableNotifications = !this.enableNotifications;
            b.m_93666_((Component)Component.m_237113_((String)("Enable Notifications: " + (this.enableNotifications ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        b1.f_93623_ = permitted;
        Button b2 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Sounds: " + (this.enableSounds ? "ON" : "OFF"))), b -> {
            this.enableSounds = !this.enableSounds;
            b.m_93666_((Component)Component.m_237113_((String)("Sounds: " + (this.enableSounds ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        b2.f_93623_ = permitted;
        Button b3 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Title Popups: " + (this.enableTitles ? "ON" : "OFF"))), b -> {
            this.enableTitles = !this.enableTitles;
            b.m_93666_((Component)Component.m_237113_((String)("Title Popups: " + (this.enableTitles ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        b3.f_93623_ = permitted;
        Button b4 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Chat Messages: " + (this.enableChatMessages ? "ON" : "OFF"))), b -> {
            this.enableChatMessages = !this.enableChatMessages;
            b.m_93666_((Component)Component.m_237113_((String)("Chat Messages: " + (this.enableChatMessages ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        b4.f_93623_ = permitted;
        Button b5 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Notify on Unlock: " + (this.notifyOnUnlock ? "ON" : "OFF"))), b -> {
            this.notifyOnUnlock = !this.notifyOnUnlock;
            b.m_93666_((Component)Component.m_237113_((String)("Notify on Unlock: " + (this.notifyOnUnlock ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
        b5.f_93623_ = permitted;
        Button b6 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Notify on Ready: " + (this.notifyOnReady ? "ON" : "OFF"))), b -> {
            this.notifyOnReady = !this.notifyOnReady;
            b.m_93666_((Component)Component.m_237113_((String)("Notify on Ready: " + (this.notifyOnReady ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).m_253136_());
        b6.f_93623_ = permitted;
        Button b7 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Notify on Complete: " + (this.notifyOnComplete ? "ON" : "OFF"))), b -> {
            this.notifyOnComplete = !this.notifyOnComplete;
            b.m_93666_((Component)Component.m_237113_((String)("Notify on Complete: " + (this.notifyOnComplete ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight).m_253136_());
        b7.f_93623_ = permitted;
    }

    private void initDisplayTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 50;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        boolean permitted = this.canEditServer();
        Button d1 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Show Progress Percentage: " + (this.showProgressPercentage ? "ON" : "OFF"))), b -> {
            this.showProgressPercentage = !this.showProgressPercentage;
            b.m_93666_((Component)Component.m_237113_((String)("Show Progress Percentage: " + (this.showProgressPercentage ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        d1.f_93623_ = permitted;
        Button d2 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Colored Messages: " + (this.useColoredMessages ? "ON" : "OFF"))), b -> {
            this.useColoredMessages = !this.useColoredMessages;
            b.m_93666_((Component)Component.m_237113_((String)("Colored Messages: " + (this.useColoredMessages ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        d2.f_93623_ = permitted;
        Button d3 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Show Quest IDs: " + (this.showQuestIDInList ? "ON" : "OFF"))), b -> {
            this.showQuestIDInList = !this.showQuestIDInList;
            b.m_93666_((Component)Component.m_237113_((String)("Show Quest IDs: " + (this.showQuestIDInList ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        d3.f_93623_ = permitted;
    }

    private void initGeneralTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 60;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        Button mapBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Map Integration: " + (this.mapIntegrationEnabled ? "ON" : "OFF"))), b -> {
            this.mapIntegrationEnabled = !this.mapIntegrationEnabled;
            b.m_93666_((Component)Component.m_237113_((String)("Map Integration: " + (this.mapIntegrationEnabled ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        this.addTooltipArea(mapBtn.m_252754_(), mapBtn.m_252907_(), buttonWidth, buttonHeight, "Enable Questory's client map integration layer.", "When ON, supported map mods (e.g., JourneyMap) get waypoints for tracked quests.");
        boolean jmPresent = false;
        try {
            jmPresent = Platform.isModLoaded((String)"journeymap");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Button jmBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("JourneyMap Support: " + (this.journeyMapEnabled ? "ON" : "OFF"))), b -> {
            this.journeyMapEnabled = !this.journeyMapEnabled;
            b.m_93666_((Component)Component.m_237113_((String)("JourneyMap Support: " + (this.journeyMapEnabled ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        jmBtn.f_93623_ = jmPresent;
        this.addTooltipArea(jmBtn.m_252754_(), jmBtn.m_252907_(), buttonWidth, buttonHeight, jmPresent ? "Toggle per-client export of waypoints to JourneyMap." : "JourneyMap not detected. This toggle is disabled.");
        Button edBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Advanced Editor: " + (this.clientEnableAdvancedEditor ? "ON" : "OFF"))), b -> {
            this.clientEnableAdvancedEditor = !this.clientEnableAdvancedEditor;
            b.m_93666_((Component)Component.m_237113_((String)("Advanced Editor: " + (this.clientEnableAdvancedEditor ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        this.addTooltipArea(edBtn.m_252754_(), edBtn.m_252907_(), buttonWidth, buttonHeight, "Locally show/hide Advanced Editor entry points on this client.");
    }

    private void initServerTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 60;
        int buttonWidth = 220;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            Button info = Button.m_253074_((Component)Component.m_237113_((String)"Server settings require OP"), b -> {}).m_252987_(centerX - 140, startY, 280, buttonHeight).m_253136_();
            info.f_93623_ = false;
            this.m_142416_((GuiEventListener)info);
            return;
        }
        IntSlider autoSaveSlider = new IntSlider(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight, "AutoSave Interval: ", 600, 24000, 600, this.autoSaveIntervalTicks, v -> {
            this.autoSaveIntervalTicks = v;
        });
        this.m_142416_((GuiEventListener)autoSaveSlider);
        this.addTooltipArea(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight, "How often to auto-save progress (in ticks).", "20 ticks = 1 second.");
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Save On Every Progress: " + (this.saveOnEveryProgress ? "ON" : "OFF"))), b -> {
            this.saveOnEveryProgress = !this.saveOnEveryProgress;
            b.m_93666_((Component)Component.m_237113_((String)("Save On Every Progress: " + (this.saveOnEveryProgress ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Track Completion Time: " + (this.trackCompletionTime ? "ON" : "OFF"))), b -> {
            this.trackCompletionTime = !this.trackCompletionTime;
            b.m_93666_((Component)Component.m_237113_((String)("Track Completion Time: " + (this.trackCompletionTime ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Allow Quest Reset: " + (this.allowQuestReset ? "ON" : "OFF"))), b -> {
            this.allowQuestReset = !this.allowQuestReset;
            b.m_93666_((Component)Component.m_237113_((String)("Allow Quest Reset: " + (this.allowQuestReset ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Allow Quest Reload: " + (this.allowQuestReload ? "ON" : "OFF"))), b -> {
            this.allowQuestReload = !this.allowQuestReload;
            b.m_93666_((Component)Component.m_237113_((String)("Allow Quest Reload: " + (this.allowQuestReload ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Require OP For Admin: " + (this.requireOPForAdmin ? "YES" : "NO"))), b -> {
            this.requireOPForAdmin = !this.requireOPForAdmin;
            b.m_93666_((Component)Component.m_237113_((String)("Require OP For Admin: " + (this.requireOPForAdmin ? "YES" : "NO"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).m_253136_());
        IntSlider permSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight, "Admin Permission Level: ", 0, 4, 1, this.adminPermissionLevel, v -> {
            this.adminPermissionLevel = v;
        });
        this.m_142416_((GuiEventListener)permSlider);
        this.m_142416_((GuiEventListener)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 7, buttonWidth, buttonHeight, "Max Quests Per Player: ", 100, 5000, 100, this.maxQuestsPerPlayer, v -> {
            this.maxQuestsPerPlayer = v;
        }));
        this.m_142416_((GuiEventListener)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 8, buttonWidth, buttonHeight, "Max Requirements Per Quest: ", 10, 200, 5, this.maxRequirementsPerQuest, v -> {
            this.maxRequirementsPerQuest = v;
        }));
        this.m_142416_((GuiEventListener)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 9, buttonWidth, buttonHeight, "Max Rewards Per Quest: ", 5, 100, 5, this.maxRewardsPerQuest, v -> {
            this.maxRewardsPerQuest = v;
        }));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Advanced Editor (Server): " + (this.enableAdvancedEditorServer ? "ON" : "OFF"))), b -> {
            this.enableAdvancedEditorServer = !this.enableAdvancedEditorServer;
            b.m_93666_((Component)Component.m_237113_((String)("Advanced Editor (Server): " + (this.enableAdvancedEditorServer ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 10, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Editor Requires OP: " + (this.advancedEditorRequiresOp ? "YES" : "NO"))), b -> {
            this.advancedEditorRequiresOp = !this.advancedEditorRequiresOp;
            b.m_93666_((Component)Component.m_237113_((String)("Editor Requires OP: " + (this.advancedEditorRequiresOp ? "YES" : "NO"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 11, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Debug Mode: " + (this.debugMode ? "ON" : "OFF"))), b -> {
            this.debugMode = !this.debugMode;
            b.m_93666_((Component)Component.m_237113_((String)("Debug Mode: " + (this.debugMode ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 12, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Log Quest Progress: " + (this.logQuestProgress ? "ON" : "OFF"))), b -> {
            this.logQuestProgress = !this.logQuestProgress;
            b.m_93666_((Component)Component.m_237113_((String)("Log Quest Progress: " + (this.logQuestProgress ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 13, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Log Quest Completion: " + (this.logQuestCompletion ? "ON" : "OFF"))), b -> {
            this.logQuestCompletion = !this.logQuestCompletion;
            b.m_93666_((Component)Component.m_237113_((String)("Log Quest Completion: " + (this.logQuestCompletion ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 14, buttonWidth, buttonHeight).m_253136_());
    }

    private void initEnvironmentTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 60;
        int buttonWidth = 260;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            Button info = Button.m_253074_((Component)Component.m_237113_((String)"Server settings require OP"), b -> {}).m_252987_(centerX - 140, startY, 280, buttonHeight).m_253136_();
            info.f_93623_ = false;
            this.m_142416_((GuiEventListener)info);
            return;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Observation Enabled: " + (this.observationEnabled ? "ON" : "OFF"))), b -> {
            this.observationEnabled = !this.observationEnabled;
            b.m_93666_((Component)Component.m_237113_((String)("Observation Enabled: " + (this.observationEnabled ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)new IntSlider(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight, "Scan Interval: ", 1, 60, 1, this.observationScanIntervalTicks, v -> {
            this.observationScanIntervalTicks = v;
        }));
        this.addTooltipArea(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight, "Environment scan cadence in ticks (1-60).", "Lower = more frequent checks.");
        this.m_142416_((GuiEventListener)new DoubleSlider(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight, "Max Look Distance: ", 1.0, 64.0, 0.5, this.observationMaxLookDistance, v -> {
            this.observationMaxLookDistance = v;
        }));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Only Visible Quests: " + (this.environmentOnlyVisibleQuests ? "YES" : "NO"))), b -> {
            this.environmentOnlyVisibleQuests = !this.environmentOnlyVisibleQuests;
            b.m_93666_((Component)Component.m_237113_((String)("Only Visible Quests: " + (this.environmentOnlyVisibleQuests ? "YES" : "NO"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Auto-Complete On Requirements Met: " + (this.autoCompleteWhenRequirementsMet ? "ON" : "OFF"))), b -> {
            this.autoCompleteWhenRequirementsMet = !this.autoCompleteWhenRequirementsMet;
            b.m_93666_((Component)Component.m_237113_((String)("Auto-Complete On Requirements Met: " + (this.autoCompleteWhenRequirementsMet ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
    }

    private void initTeamsTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 60;
        int buttonWidth = 280;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            Button info = Button.m_253074_((Component)Component.m_237113_((String)"Server settings require OP"), b -> {}).m_252987_(centerX - 140, startY, 280, buttonHeight).m_253136_();
            info.f_93623_ = false;
            this.m_142416_((GuiEventListener)info);
            return;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Team System Enabled: " + (this.teamSystemEnabled ? "ON" : "OFF"))), b -> {
            this.teamSystemEnabled = !this.teamSystemEnabled;
            b.m_93666_((Component)Component.m_237113_((String)("Team System Enabled: " + (this.teamSystemEnabled ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Use External Provider: " + (this.teamUseExternalProvider ? "YES" : "NO"))), b -> {
            this.teamUseExternalProvider = !this.teamUseExternalProvider;
            b.m_93666_((Component)Component.m_237113_((String)("Use External Provider: " + (this.teamUseExternalProvider ? "YES" : "NO"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Preferred Provider: " + this.teamPreferredProvider)), b -> {
            String[] opts = new String[]{"ftbteams", "simpleteams"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.teamPreferredProvider)) continue;
                i = k;
                break;
            }
            this.teamPreferredProvider = opts[(i + 1) % opts.length];
            b.m_93666_((Component)Component.m_237113_((String)("Preferred Provider: " + this.teamPreferredProvider)));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Fallback To Built-In: " + (this.teamFallbackToBuiltIn ? "YES" : "NO"))), b -> {
            this.teamFallbackToBuiltIn = !this.teamFallbackToBuiltIn;
            b.m_93666_((Component)Component.m_237113_((String)("Fallback To Built-In: " + (this.teamFallbackToBuiltIn ? "YES" : "NO"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Default Progress Mode: " + this.teamDefaultProgressMode)), b -> {
            String[] opts = new String[]{"SHARED", "INDIVIDUAL", "COMBINED", "PARALLEL"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.teamDefaultProgressMode)) continue;
                i = k;
                break;
            }
            this.teamDefaultProgressMode = opts[(i + 1) % opts.length];
            b.m_93666_((Component)Component.m_237113_((String)("Default Progress Mode: " + this.teamDefaultProgressMode)));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Default Reward Mode: " + this.teamDefaultRewardMode)), b -> {
            String[] opts = new String[]{"SHARED", "COMPLETER_ONLY", "DISTRIBUTED", "ALL_MEMBERS"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.teamDefaultRewardMode)) continue;
                i = k;
                break;
            }
            this.teamDefaultRewardMode = opts[(i + 1) % opts.length];
            b.m_93666_((Component)Component.m_237113_((String)("Default Reward Mode: " + this.teamDefaultRewardMode)));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight, "Team Max Size: ", 2, 100, 1, this.teamMaxSize, v -> {
            this.teamMaxSize = v;
        }));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Allow Team Creation: " + (this.teamAllowCreation ? "YES" : "NO"))), b -> {
            this.teamAllowCreation = !this.teamAllowCreation;
            b.m_93666_((Component)Component.m_237113_((String)("Allow Team Creation: " + (this.teamAllowCreation ? "YES" : "NO"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 7, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Require All Online: " + (this.teamRequireAllOnlineDefault ? "YES" : "NO"))), b -> {
            this.teamRequireAllOnlineDefault = !this.teamRequireAllOnlineDefault;
            b.m_93666_((Component)Component.m_237113_((String)("Require All Online: " + (this.teamRequireAllOnlineDefault ? "YES" : "NO"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 8, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 9, buttonWidth, buttonHeight, "Progress Sync Delay: ", 1, 120, 1, this.teamSyncProgressDelay, v -> {
            this.teamSyncProgressDelay = v;
        }));
    }

    private void initDailyTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 60;
        int buttonWidth = 280;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            Button info = Button.m_253074_((Component)Component.m_237113_((String)"Server settings require OP"), b -> {}).m_252987_(centerX - 140, startY, 280, buttonHeight).m_253136_();
            info.f_93623_ = false;
            this.m_142416_((GuiEventListener)info);
            return;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Daily System: " + (this.dailyEnable ? "ON" : "OFF"))), b -> {
            this.dailyEnable = !this.dailyEnable;
            b.m_93666_((Component)Component.m_237113_((String)("Daily System: " + (this.dailyEnable ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Fetch On World Load: " + (this.dailyFetchOnWorldLoad ? "ON" : "OFF"))), b -> {
            this.dailyFetchOnWorldLoad = !this.dailyFetchOnWorldLoad;
            b.m_93666_((Component)Component.m_237113_((String)("Fetch On World Load: " + (this.dailyFetchOnWorldLoad ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        IntSlider fetchIntSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight, "Fetch Interval (min): ", 0, 1440, 15, this.dailyFetchIntervalMinutes, v -> {
            this.dailyFetchIntervalMinutes = v;
        });
        this.m_142416_((GuiEventListener)fetchIntSlider);
        IntSlider ttlSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight, "Cache TTL (min): ", 60, 4320, 60, this.dailyCacheTtlMinutes, v -> {
            this.dailyCacheTtlMinutes = v;
        });
        this.m_142416_((GuiEventListener)ttlSlider);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Offline Fallback: " + this.dailyOfflineFallback)), b -> {
            String[] opts = new String[]{"use_cache", "keep_previous", "disable"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.dailyOfflineFallback)) continue;
                i = k;
                break;
            }
            this.dailyOfflineFallback = opts[(i + 1) % opts.length];
            b.m_93666_((Component)Component.m_237113_((String)("Offline Fallback: " + this.dailyOfflineFallback)));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
        IntSlider hourSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight, "Rollover Hour: ", 0, 23, 1, this.dailyRolloverHour, v -> {
            this.dailyRolloverHour = v;
        });
        this.m_142416_((GuiEventListener)hourSlider);
        IntSlider maxActiveSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight, "Max Active Quests: ", 0, 50, 1, this.dailyMaxActiveQuests, v -> {
            this.dailyMaxActiveQuests = v;
        });
        this.m_142416_((GuiEventListener)maxActiveSlider);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Completion Mode: " + this.dailyCompletionMode)), b -> {
            String[] opts = new String[]{"ALL", "ANY"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.dailyCompletionMode)) continue;
                i = k;
                break;
            }
            this.dailyCompletionMode = opts[(i + 1) % opts.length];
            b.m_93666_((Component)Component.m_237113_((String)("Completion Mode: " + this.dailyCompletionMode)));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 7, buttonWidth, buttonHeight).m_253136_());
        IntSlider minCompSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 8, buttonWidth, buttonHeight, "Min Quests To Complete: ", 0, 10, 1, this.dailyMinQuestsToComplete, v -> {
            this.dailyMinQuestsToComplete = v;
        });
        this.m_142416_((GuiEventListener)minCompSlider);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Store History: " + (this.dailyStoreHistory ? "YES" : "NO"))), b -> {
            this.dailyStoreHistory = !this.dailyStoreHistory;
            b.m_93666_((Component)Component.m_237113_((String)("Store History: " + (this.dailyStoreHistory ? "YES" : "NO"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 9, buttonWidth, buttonHeight).m_253136_());
        int fieldW = buttonWidth;
        int fieldX = centerX - fieldW / 2;
        int fy = startY + spacing * 10;
        this.dailyRemoteUrlBox = new EditBox(this.f_96547_, fieldX, fy, fieldW, 18, (Component)Component.m_237113_((String)"Remote URL"));
        this.dailyRemoteUrlBox.m_94144_(this.dailyRemoteUrl);
        this.dailyRemoteUrlBox.m_257771_((Component)Component.m_237113_((String)"dailyRemoteUrl (http/https)"));
        this.dailyRemoteUrlBox.m_94186_(true);
        this.dailyRemoteUrlBox.m_94151_(s -> {
            this.dailyRemoteUrl = s;
        });
        this.m_142416_((GuiEventListener)this.dailyRemoteUrlBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Primary source for Daily payload JSON (http/https).", "Leave blank to disable remote fetching.");
        this.dailyBackupUrlsBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"Backup URLs (CSV)"));
        this.dailyBackupUrlsBox.m_94144_(this.dailyBackupUrlsCsv);
        this.dailyBackupUrlsBox.m_257771_((Component)Component.m_237113_((String)"url1, url2, ..."));
        this.dailyBackupUrlsBox.m_94151_(s -> {
            this.dailyBackupUrlsCsv = s;
        });
        this.m_142416_((GuiEventListener)this.dailyBackupUrlsBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Comma-separated fallback URLs if primary fails.");
        this.dailyTimeZoneBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"Time Zone"));
        this.dailyTimeZoneBox.m_94144_(this.dailyTimeZone);
        this.dailyTimeZoneBox.m_257771_((Component)Component.m_237113_((String)"IANA TZ, e.g. UTC"));
        this.dailyTimeZoneBox.m_94151_(s -> {
            this.dailyTimeZone = s;
        });
        this.m_142416_((GuiEventListener)this.dailyTimeZoneBox);
        this.dailyGroupNameBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"Group Name"));
        this.dailyGroupNameBox.m_94144_(this.dailyGroupName);
        this.dailyGroupNameBox.m_94151_(s -> {
            this.dailyGroupName = s;
        });
        this.m_142416_((GuiEventListener)this.dailyGroupNameBox);
        this.dailyTagKeyBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"Tag Key"));
        this.dailyTagKeyBox.m_94144_(this.dailyTagKey);
        this.dailyTagKeyBox.m_94151_(s -> {
            this.dailyTagKey = s;
        });
        this.m_142416_((GuiEventListener)this.dailyTagKeyBox);
        this.dailyPrefixBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"ID Prefix"));
        this.dailyPrefixBox.m_94144_(this.dailyPrefixQuestIds);
        this.dailyPrefixBox.m_94151_(s -> {
            this.dailyPrefixQuestIds = s;
        });
        this.m_142416_((GuiEventListener)this.dailyPrefixBox);
    }

    private void initScriptingTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 60;
        int buttonWidth = 280;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            Button info = Button.m_253074_((Component)Component.m_237113_((String)"Server settings require OP"), b -> {}).m_252987_(centerX - 140, startY, 280, buttonHeight).m_253136_();
            info.f_93623_ = false;
            this.m_142416_((GuiEventListener)info);
            return;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Scripting Bridge: " + (this.scriptIntegrationEnabled ? "ON" : "OFF"))), b -> {
            this.scriptIntegrationEnabled = !this.scriptIntegrationEnabled;
            b.m_93666_((Component)Component.m_237113_((String)("Scripting Bridge: " + (this.scriptIntegrationEnabled ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Allow External HTTP: " + (this.scriptAllowExternalHttp ? "YES" : "NO"))), b -> {
            this.scriptAllowExternalHttp = !this.scriptAllowExternalHttp;
            b.m_93666_((Component)Component.m_237113_((String)("Allow External HTTP: " + (this.scriptAllowExternalHttp ? "YES" : "NO"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Emit On Unlock: " + (this.scriptEmitOnUnlock ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnUnlock = !this.scriptEmitOnUnlock;
            b.m_93666_((Component)Component.m_237113_((String)("Emit On Unlock: " + (this.scriptEmitOnUnlock ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Emit On Started: " + (this.scriptEmitOnStarted ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnStarted = !this.scriptEmitOnStarted;
            b.m_93666_((Component)Component.m_237113_((String)("Emit On Started: " + (this.scriptEmitOnStarted ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Emit On Progress: " + (this.scriptEmitOnProgress ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnProgress = !this.scriptEmitOnProgress;
            b.m_93666_((Component)Component.m_237113_((String)("Emit On Progress: " + (this.scriptEmitOnProgress ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Emit On Completed: " + (this.scriptEmitOnCompleted ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnCompleted = !this.scriptEmitOnCompleted;
            b.m_93666_((Component)Component.m_237113_((String)("Emit On Completed: " + (this.scriptEmitOnCompleted ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Emit On Reward Claimed: " + (this.scriptEmitOnRewardClaimed ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnRewardClaimed = !this.scriptEmitOnRewardClaimed;
            b.m_93666_((Component)Component.m_237113_((String)("Emit On Reward Claimed: " + (this.scriptEmitOnRewardClaimed ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight).m_253136_());
        int fieldW = buttonWidth;
        int fieldX = centerX - fieldW / 2;
        int fy = startY + spacing * 7;
        this.scriptWebhookUrlBox = new EditBox(this.f_96547_, fieldX, fy, fieldW, 18, (Component)Component.m_237113_((String)"Webhook URL"));
        this.scriptWebhookUrlBox.m_94144_(this.scriptWebhookUrl);
        this.scriptWebhookUrlBox.m_257771_((Component)Component.m_237113_((String)"http/https webhook URL"));
        this.scriptWebhookUrlBox.m_94151_(s -> {
            this.scriptWebhookUrl = s;
        });
        this.m_142416_((GuiEventListener)this.scriptWebhookUrlBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "HTTP endpoint to receive quest events as JSON.", "Use http/https. Leave blank to disable webhooks.");
        IntSlider httpTimeoutSlider = new IntSlider(fieldX, fy += spacing, fieldW, buttonHeight, "HTTP Timeout: ", 1000, 30000, 1000, this.scriptHttpTimeoutMs, val -> {
            this.scriptHttpTimeoutMs = val;
        });
        this.m_142416_((GuiEventListener)httpTimeoutSlider);
        this.addTooltipArea(fieldX, fy, fieldW, buttonHeight, "Request timeout for webhook POST/commands (milliseconds).", "Typical: 5000\u201310000 ms");
        this.scriptCmdUnlockBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"Command On Unlock"));
        this.scriptCmdUnlockBox.m_94144_(this.scriptCommandOnUnlock);
        this.scriptCmdUnlockBox.m_257771_((Component)Component.m_237113_((String)"/cmd {player} {quest_title}"));
        this.scriptCmdUnlockBox.m_94151_(s -> {
            this.scriptCommandOnUnlock = s;
        });
        this.m_142416_((GuiEventListener)this.scriptCmdUnlockBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Server command executed when a quest is unlocked.", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
        this.scriptCmdStartedBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"Command On Started"));
        this.scriptCmdStartedBox.m_94144_(this.scriptCommandOnStarted);
        this.scriptCmdStartedBox.m_257771_((Component)Component.m_237113_((String)"/cmd {player} {quest_id}"));
        this.scriptCmdStartedBox.m_94151_(s -> {
            this.scriptCommandOnStarted = s;
        });
        this.m_142416_((GuiEventListener)this.scriptCmdStartedBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Command when a quest is first started.", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
        this.scriptCmdProgressBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"Command On Progress"));
        this.scriptCmdProgressBox.m_94144_(this.scriptCommandOnProgress);
        this.scriptCmdProgressBox.m_257771_((Component)Component.m_237113_((String)"/cmd {player} {quest_id} progress"));
        this.scriptCmdProgressBox.m_94151_(s -> {
            this.scriptCommandOnProgress = s;
        });
        this.m_142416_((GuiEventListener)this.scriptCmdProgressBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Command on progress updates (can be noisy).", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
        this.scriptCmdCompleteBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"Command On Complete"));
        this.scriptCmdCompleteBox.m_94144_(this.scriptCommandOnComplete);
        this.scriptCmdCompleteBox.m_257771_((Component)Component.m_237113_((String)"/cmd {player} completed {quest_title}"));
        this.scriptCmdCompleteBox.m_94151_(s -> {
            this.scriptCommandOnComplete = s;
        });
        this.m_142416_((GuiEventListener)this.scriptCmdCompleteBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Command when a quest is completed.", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
        this.scriptCmdRewardBox = new EditBox(this.f_96547_, fieldX, fy += spacing, fieldW, 18, (Component)Component.m_237113_((String)"Command On Reward Claimed"));
        this.scriptCmdRewardBox.m_94144_(this.scriptCommandOnRewardClaimed);
        this.scriptCmdRewardBox.m_257771_((Component)Component.m_237113_((String)"/cmd {player} reward {quest_id}"));
        this.scriptCmdRewardBox.m_94151_(s -> {
            this.scriptCommandOnRewardClaimed = s;
        });
        this.m_142416_((GuiEventListener)this.scriptCmdRewardBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Command when a reward is claimed.", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
    }

    private void resetCurrentTab() {
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.hudPosition = "TOP_LEFT";
                this.hudScale = 1.0f;
                this.hudOpacity = 80;
                this.hudCompactMode = false;
                this.hudShowIcons = true;
                this.hudShowProgressBars = true;
                this.hudOffsetX = 10;
                this.hudOffsetY = 10;
                break;
            }
            case 1: {
                this.enableNotifications = true;
                this.enableSounds = true;
                this.enableTitles = true;
                this.enableChatMessages = true;
                this.notifyOnUnlock = true;
                this.notifyOnReady = true;
                this.notifyOnComplete = true;
                break;
            }
            case 2: {
                this.showProgressPercentage = true;
                this.useColoredMessages = true;
                this.showQuestIDInList = false;
                break;
            }
            case 3: {
                this.mapIntegrationEnabled = true;
                this.journeyMapEnabled = true;
                this.clientEnableAdvancedEditor = true;
                break;
            }
            case 4: {
                this.autoSaveIntervalTicks = 6000;
                this.saveOnEveryProgress = false;
                this.trackCompletionTime = true;
                this.allowQuestReset = true;
                this.allowQuestReload = true;
                this.requireOPForAdmin = true;
                this.adminPermissionLevel = 2;
                this.maxQuestsPerPlayer = 1000;
                this.maxRequirementsPerQuest = 50;
                this.maxRewardsPerQuest = 20;
                this.enableAdvancedEditorServer = false;
                this.advancedEditorRequiresOp = true;
                this.debugMode = false;
                this.logQuestProgress = false;
                this.logQuestCompletion = true;
                break;
            }
            case 5: {
                this.observationEnabled = true;
                this.observationScanIntervalTicks = 10;
                this.observationMaxLookDistance = 5.0;
                this.environmentOnlyVisibleQuests = false;
                this.autoCompleteWhenRequirementsMet = false;
                break;
            }
            case 6: {
                this.teamSystemEnabled = true;
                this.teamUseExternalProvider = true;
                this.teamPreferredProvider = "ftbteams";
                this.teamFallbackToBuiltIn = true;
                this.teamDefaultProgressMode = "SHARED";
                this.teamDefaultRewardMode = "SHARED";
                this.teamMaxSize = 10;
                this.teamAllowCreation = true;
                this.teamRequireAllOnlineDefault = false;
                this.teamSyncProgressDelay = 20;
                break;
            }
            case 7: {
                this.dailyEnable = false;
                this.dailyFetchOnWorldLoad = true;
                this.dailyFetchIntervalMinutes = 0;
                this.dailyCacheTtlMinutes = 1440;
                this.dailyOfflineFallback = "use_cache";
                this.dailyRolloverHour = 0;
                this.dailyTimeZone = "UTC";
                this.dailyGroupName = "Daily";
                this.dailyTagKey = "daily";
                this.dailyPrefixQuestIds = "daily_";
                this.dailyMaxActiveQuests = 0;
                this.dailyCompletionMode = "ALL";
                this.dailyMinQuestsToComplete = 0;
                this.dailyStoreHistory = true;
                this.dailyRemoteUrl = "";
                this.dailyBackupUrlsCsv = "";
                break;
            }
            case 8: {
                this.scriptIntegrationEnabled = false;
                this.scriptAllowExternalHttp = false;
                this.scriptEmitOnUnlock = true;
                this.scriptEmitOnStarted = true;
                this.scriptEmitOnProgress = false;
                this.scriptEmitOnCompleted = true;
                this.scriptEmitOnRewardClaimed = true;
                this.scriptWebhookUrl = "";
                this.scriptHttpTimeoutMs = 5000;
                this.scriptCommandOnUnlock = "";
                this.scriptCommandOnStarted = "";
                this.scriptCommandOnProgress = "";
                this.scriptCommandOnComplete = "";
                this.scriptCommandOnRewardClaimed = "";
            }
        }
        this.m_169413_();
        this.m_7856_();
    }

    private void saveAllConfig() {
        ClientConfig.setHudPosition(this.hudPosition);
        ClientConfig.setHudScale(this.hudScale);
        ClientConfig.setHudOpacity(this.hudOpacity);
        ClientConfig.setHudCompactMode(this.hudCompactMode);
        ClientConfig.setHudShowIcons(this.hudShowIcons);
        ClientConfig.setHudShowProgressBars(this.hudShowProgressBars);
        ClientConfig.setHudOffsetX(this.hudOffsetX);
        ClientConfig.setHudOffsetY(this.hudOffsetY);
        QuestoryConfig config = QuestoryConfig.getInstance();
        boolean permitted = this.canEditServer();
        if (permitted) {
            config.enableQuestNotifications = this.enableNotifications;
            config.enableQuestSounds = this.enableSounds;
            config.enableQuestTitles = this.enableTitles;
            config.enableQuestChatMessages = this.enableChatMessages;
            config.notifyOnQuestUnlock = this.notifyOnUnlock;
            config.notifyOnQuestReady = this.notifyOnReady;
            config.notifyOnQuestComplete = this.notifyOnComplete;
            config.showProgressPercentage = this.showProgressPercentage;
            config.useColoredMessages = this.useColoredMessages;
            config.showQuestIDInList = this.showQuestIDInList;
        }
        ClientConfig.setMapIntegrationEnabled(this.mapIntegrationEnabled);
        ClientConfig.setJourneyMapEnabled(this.journeyMapEnabled);
        ClientConfig.setClientEnableAdvancedEditor(this.clientEnableAdvancedEditor);
        if (permitted) {
            config.autoSaveIntervalTicks = this.autoSaveIntervalTicks;
            config.saveOnEveryProgress = this.saveOnEveryProgress;
            config.trackCompletionTime = this.trackCompletionTime;
            config.allowQuestReset = this.allowQuestReset;
            config.allowQuestReload = this.allowQuestReload;
            config.requireOPForAdmin = this.requireOPForAdmin;
            config.adminPermissionLevel = this.adminPermissionLevel;
            config.maxQuestsPerPlayer = this.maxQuestsPerPlayer;
            config.maxRequirementsPerQuest = this.maxRequirementsPerQuest;
            config.maxRewardsPerQuest = this.maxRewardsPerQuest;
            config.enableAdvancedEditor = this.enableAdvancedEditorServer;
            config.advancedEditorRequiresOp = this.advancedEditorRequiresOp;
            config.debugMode = this.debugMode;
            config.logQuestProgress = this.logQuestProgress;
            config.logQuestCompletion = this.logQuestCompletion;
            config.observationEnabled = this.observationEnabled;
            config.observationScanIntervalTicks = this.observationScanIntervalTicks;
            config.observationMaxLookDistance = this.observationMaxLookDistance;
            config.environmentOnlyVisibleQuests = this.environmentOnlyVisibleQuests;
            config.autoCompleteWhenRequirementsMet = this.autoCompleteWhenRequirementsMet;
            config.teamSystemEnabled = this.teamSystemEnabled;
            config.teamUseExternalProvider = this.teamUseExternalProvider;
            config.teamPreferredProvider = this.teamPreferredProvider;
            config.teamFallbackToBuiltIn = this.teamFallbackToBuiltIn;
            config.teamDefaultProgressMode = this.teamDefaultProgressMode;
            config.teamDefaultRewardMode = this.teamDefaultRewardMode;
            config.teamMaxSize = this.teamMaxSize;
            config.teamAllowCreation = this.teamAllowCreation;
            config.teamRequireAllOnlineDefault = this.teamRequireAllOnlineDefault;
            config.teamSyncProgressDelay = this.teamSyncProgressDelay;
            config.dailyEnable = this.dailyEnable;
            config.dailyFetchOnWorldLoad = this.dailyFetchOnWorldLoad;
            config.dailyFetchIntervalMinutes = this.dailyFetchIntervalMinutes;
            config.dailyCacheTtlMinutes = this.dailyCacheTtlMinutes;
            config.dailyOfflineFallback = this.dailyOfflineFallback;
            config.dailyRolloverHour = this.dailyRolloverHour;
            String tz = this.dailyTimeZone == null ? "" : this.dailyTimeZone.trim();
            try {
                ZoneId.of(tz);
            }
            catch (Throwable t) {
                tz = "UTC";
            }
            config.dailyTimeZone = tz;
            config.dailyGroupName = this.dailyGroupName;
            config.dailyTagKey = this.dailyTagKey;
            config.dailyPrefixQuestIds = this.dailyPrefixQuestIds;
            config.dailyMaxActiveQuests = this.dailyMaxActiveQuests;
            config.dailyCompletionMode = this.dailyCompletionMode;
            config.dailyMinQuestsToComplete = this.dailyMinQuestsToComplete;
            config.dailyStoreHistory = this.dailyStoreHistory;
            Predicate<String> urlOk = s -> {
                if (s == null) {
                    return false;
                }
                String u = s.trim().toLowerCase(Locale.ROOT);
                return u.startsWith("http://") || u.startsWith("https://");
            };
            config.dailyRemoteUrl = urlOk.test(this.dailyRemoteUrl) ? this.dailyRemoteUrl.trim() : "";
            ArrayList<String> list = new ArrayList<String>();
            if (this.dailyBackupUrlsCsv != null && !this.dailyBackupUrlsCsv.isBlank()) {
                for (String s2 : this.dailyBackupUrlsCsv.split(",")) {
                    String t = s2.trim();
                    if (t.isEmpty() || !urlOk.test(t)) continue;
                    list.add(t);
                }
            }
            config.dailyBackupUrls = list;
            config.scriptIntegrationEnabled = this.scriptIntegrationEnabled;
            config.scriptAllowExternalHttp = this.scriptAllowExternalHttp;
            config.scriptEmitOnUnlock = this.scriptEmitOnUnlock;
            config.scriptEmitOnStarted = this.scriptEmitOnStarted;
            config.scriptEmitOnProgress = this.scriptEmitOnProgress;
            config.scriptEmitOnCompleted = this.scriptEmitOnCompleted;
            config.scriptEmitOnRewardClaimed = this.scriptEmitOnRewardClaimed;
            config.scriptWebhookUrl = this.scriptWebhookUrl;
            config.scriptHttpTimeoutMs = this.scriptHttpTimeoutMs;
            config.scriptCommandOnUnlock = this.scriptCommandOnUnlock;
            config.scriptCommandOnStarted = this.scriptCommandOnStarted;
            config.scriptCommandOnProgress = this.scriptCommandOnProgress;
            config.scriptCommandOnComplete = this.scriptCommandOnComplete;
            config.scriptCommandOnRewardClaimed = this.scriptCommandOnRewardClaimed;
        }
        try {
            Path configPath = this.f_96541_.f_91069_.toPath().resolve("config");
            QuestoryConfig.save(configPath);
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to save config: " + e.getMessage());
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1072689136);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        if (this.currentTab == ConfigTab.HUD) {
            this.renderHudTabContent(graphics, mouseX, mouseY, partialTick);
        } else if (this.currentTab == ConfigTab.GENERAL) {
            this.renderGeneralTabContent(graphics);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.tooltipAreas != null) {
            for (TooltipArea ta : this.tooltipAreas) {
                if (mouseX < ta.x() || mouseX > ta.x() + ta.w() || mouseY < ta.y() || mouseY > ta.y() + ta.h()) continue;
                this.drawSimpleTooltip(graphics, mouseX + 12, mouseY + 12, ta.lines());
            }
        }
    }

    private void addTooltipArea(int x, int y, int w, int h, String ... lines) {
        if (lines == null || lines.length == 0) {
            return;
        }
        this.tooltipAreas.add(new TooltipArea(x, y, w, h, Arrays.asList(lines)));
    }

    private void drawSimpleTooltip(GuiGraphics g, int x, int y, List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        int maxW = 0;
        for (String s : lines) {
            maxW = Math.max(maxW, this.f_96547_.m_92895_(s));
        }
        int pad = 5;
        int w = maxW + pad * 2;
        int h = lines.size() * 10 + pad * 2;
        g.m_280509_(x, y, x + w, y + h, -535489259);
        g.m_280509_(x, y, x + w, y + 1, -12566464);
        g.m_280509_(x, y + h - 1, x + w, y + h, -12566464);
        g.m_280509_(x, y, x + 1, y + h, -12566464);
        g.m_280509_(x + w - 1, y, x + w, y + h, -12566464);
        int ty = y + pad;
        for (String s : lines) {
            g.m_280488_(this.f_96547_, s, x + pad, ty, -1);
            ty += 10;
        }
    }

    private void renderHudTabContent(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.f_96543_ / 2;
        String instruction = "Click and drag the HUD preview to reposition it";
        graphics.m_280137_(this.f_96547_, instruction, centerX, this.f_96544_ - 50, 0xAAAAFF);
        String scaleText = String.format("Scale: %.1fx", Float.valueOf(this.hudScale));
        graphics.m_280137_(this.f_96547_, scaleText, centerX, 78, 0xFFFFFF);
        String opacityText = String.format("Opacity: %d%%", this.hudOpacity);
        graphics.m_280137_(this.f_96547_, opacityText, centerX, 103, 0xFFFFFF);
        this.renderHudPreview(graphics, partialTick);
    }

    private void renderGeneralTabContent(GuiGraphics graphics) {
        int centerX = this.f_96543_ / 2;
        int startY = 200;
        graphics.m_280137_(this.f_96547_, "Additional settings can be configured in:", centerX, startY, 0xCCCCCC);
        graphics.m_280137_(this.f_96547_, "config/questory-common.json", centerX, startY + 15, 0xFFAA00);
        graphics.m_280137_(this.f_96547_, "Use /quest reload to apply changes", centerX, startY + 35, 0x88FF88);
    }

    private void renderHudPreview(GuiGraphics graphics, float partialTick) {
        String oldPos = ClientConfig.getHudPosition();
        float oldScale = ClientConfig.getHudScale();
        int oldOpacity = ClientConfig.getHudOpacity();
        boolean oldCompact = ClientConfig.isHudCompactMode();
        boolean oldIcons = ClientConfig.isHudShowIcons();
        boolean oldBars = ClientConfig.isHudShowProgressBars();
        int oldOffsetX = ClientConfig.getHudOffsetX();
        int oldOffsetY = ClientConfig.getHudOffsetY();
        ClientConfig.setHudPosition(this.hudPosition);
        ClientConfig.setHudScale(this.hudScale);
        ClientConfig.setHudOpacity(this.hudOpacity);
        ClientConfig.setHudCompactMode(this.hudCompactMode);
        ClientConfig.setHudShowIcons(this.hudShowIcons);
        ClientConfig.setHudShowProgressBars(this.hudShowProgressBars);
        ClientConfig.setHudOffsetX(this.hudOffsetX);
        ClientConfig.setHudOffsetY(this.hudOffsetY);
        QuestHudOverlay.render(graphics, partialTick);
        ClientConfig.setHudPosition(oldPos);
        ClientConfig.setHudScale(oldScale);
        ClientConfig.setHudOpacity(oldOpacity);
        ClientConfig.setHudCompactMode(oldCompact);
        ClientConfig.setHudShowIcons(oldIcons);
        ClientConfig.setHudShowProgressBars(oldBars);
        ClientConfig.setHudOffsetX(oldOffsetX);
        ClientConfig.setHudOffsetY(oldOffsetY);
        if (this.draggingHud) {
            this.drawDragIndicator(graphics);
        }
    }

    private void drawDragIndicator(GuiGraphics graphics) {
        int hudX;
        int panelWidth = this.hudCompactMode ? 200 : 240;
        int panelHeight = 100;
        int hudY = switch (this.hudPosition) {
            case "TOP_RIGHT" -> {
                hudX = this.f_96543_ - panelWidth - this.hudOffsetX;
                yield this.hudOffsetY;
            }
            case "BOTTOM_LEFT" -> {
                hudX = this.hudOffsetX;
                yield this.f_96544_ - panelHeight - this.hudOffsetY;
            }
            case "BOTTOM_RIGHT" -> {
                hudX = this.f_96543_ - panelWidth - this.hudOffsetX;
                yield this.f_96544_ - panelHeight - this.hudOffsetY;
            }
            default -> {
                hudX = this.hudOffsetX;
                yield this.hudOffsetY;
            }
        };
        graphics.m_280509_(hudX - 2, hudY - 2, hudX + panelWidth + 2, hudY, -2013200640);
        graphics.m_280509_(hudX - 2, hudY + panelHeight, hudX + panelWidth + 2, hudY + panelHeight + 2, -2013200640);
        graphics.m_280509_(hudX - 2, hudY, hudX, hudY + panelHeight, -2013200640);
        graphics.m_280509_(hudX + panelWidth, hudY, hudX + panelWidth + 2, hudY + panelHeight, -2013200640);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.currentTab == ConfigTab.HUD && button == 0) {
            int hudX;
            int panelWidth = this.hudCompactMode ? 200 : 240;
            int panelHeight = 100;
            int hudY = switch (this.hudPosition) {
                case "TOP_RIGHT" -> {
                    hudX = this.f_96543_ - panelWidth - this.hudOffsetX;
                    yield this.hudOffsetY;
                }
                case "BOTTOM_LEFT" -> {
                    hudX = this.hudOffsetX;
                    yield this.f_96544_ - panelHeight - this.hudOffsetY;
                }
                case "BOTTOM_RIGHT" -> {
                    hudX = this.f_96543_ - panelWidth - this.hudOffsetX;
                    yield this.f_96544_ - panelHeight - this.hudOffsetY;
                }
                default -> {
                    hudX = this.hudOffsetX;
                    yield this.hudOffsetY;
                }
            };
            if (mouseX >= (double)hudX && mouseX <= (double)(hudX + panelWidth) && mouseY >= (double)hudY && mouseY <= (double)(hudY + panelHeight)) {
                this.draggingHud = true;
                this.dragStartX = (int)mouseX;
                this.dragStartY = (int)mouseY;
                this.originalOffsetX = this.hudOffsetX;
                this.originalOffsetY = this.hudOffsetY;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingHud) {
            this.draggingHud = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingHud) {
            int deltaX = (int)(mouseX - (double)this.dragStartX);
            int deltaY = (int)(mouseY - (double)this.dragStartY);
            this.hudOffsetX = this.hudPosition.contains("RIGHT") ? Math.max(0, Math.min(this.f_96543_ / 2, this.originalOffsetX - deltaX)) : Math.max(0, Math.min(this.f_96543_ / 2, this.originalOffsetX + deltaX));
            this.hudOffsetY = this.hudPosition.contains("BOTTOM") ? Math.max(0, Math.min(this.f_96544_ / 2, this.originalOffsetY - deltaY)) : Math.max(0, Math.min(this.f_96544_ / 2, this.originalOffsetY + deltaY));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private static enum ConfigTab {
        HUD("HUD"),
        NOTIFICATIONS("Notifications"),
        DISPLAY("Display"),
        GENERAL("General"),
        SERVER("Server"),
        ENVIRONMENT("Environment"),
        TEAMS("Teams"),
        DAILY("Daily"),
        SCRIPTING("Scripting");

        final String label;

        private ConfigTab(String label) {
            this.label = label;
        }
    }

    private static class IntSlider
    extends AbstractSliderButton {
        private final int min;
        private final int max;
        private final int step;
        private final String prefix;
        private final IntConsumer onChange;
        private int current;

        public IntSlider(int x, int y, int w, int h, String prefix, int min, int max, int step, int initial, IntConsumer onChange) {
            super(x, y, w, h, (Component)Component.m_237119_(), 0.0);
            this.prefix = prefix;
            this.min = min;
            this.max = Math.max(min + step, max);
            this.step = Math.max(1, step);
            this.onChange = onChange;
            this.setInt(initial);
        }

        private void setInt(int v) {
            int snapped;
            v = Math.max(this.min, Math.min(this.max, v));
            this.current = snapped = this.min + (v - this.min) / this.step * this.step;
            this.f_93577_ = (double)(snapped - this.min) / (double)(this.max - this.min);
            this.m_5695_();
        }

        private int getInt() {
            return this.min + (int)Math.round(this.f_93577_ * (double)(this.max - this.min));
        }

        protected void m_5695_() {
            this.m_93666_((Component)Component.m_237113_((String)(this.prefix + this.getInt())));
        }

        protected void m_5697_() {
            int snapped;
            int raw = this.getInt();
            this.current = snapped = this.min + (raw - this.min) / this.step * this.step;
            this.f_93577_ = (double)(snapped - this.min) / (double)(this.max - this.min);
            if (this.onChange != null) {
                this.onChange.accept(snapped);
            }
        }
    }

    private static class DoubleSlider
    extends AbstractSliderButton {
        private final double min;
        private final double max;
        private final double step;
        private final String prefix;
        private final DoubleConsumer onChange;

        public DoubleSlider(int x, int y, int w, int h, String prefix, double min, double max, double step, double initial, DoubleConsumer onChange) {
            super(x, y, w, h, (Component)Component.m_237119_(), 0.0);
            this.prefix = prefix;
            this.min = min;
            this.max = Math.max(min + step, max);
            this.step = step <= 0.0 ? 0.1 : step;
            this.onChange = onChange;
            this.setDouble(initial);
        }

        private void setDouble(double v) {
            v = Math.max(this.min, Math.min(this.max, v));
            double snapped = this.min + (double)Math.round((v - this.min) / this.step) * this.step;
            this.f_93577_ = (snapped - this.min) / (this.max - this.min);
            this.m_5695_();
        }

        private double getDouble() {
            return this.min + this.f_93577_ * (this.max - this.min);
        }

        protected void m_5695_() {
            this.m_93666_((Component)Component.m_237113_((String)(this.prefix + String.format(Locale.ROOT, "%.1f", this.getDouble()))));
        }

        protected void m_5697_() {
            double raw = this.getDouble();
            double snapped = this.min + (double)Math.round((raw - this.min) / this.step) * this.step;
            this.f_93577_ = (snapped - this.min) / (this.max - this.min);
            if (this.onChange != null) {
                this.onChange.accept(snapped);
            }
        }
    }

    private record TooltipArea(int x, int y, int w, int h, List<String> lines) {
    }
}

