/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class TextFormatter {
    private static final Pattern TAG_PATTERN = Pattern.compile("<(/?)([a-zA-Z_#][a-zA-Z0-9_]*)(\\s+[^>]*)?>");
    private static final Pattern LINK_PATTERN = Pattern.compile("<link\\s+href=\"([^\"]+)\">([^<]+)</link>");
    private static final Pattern ANCHOR_PATTERN = Pattern.compile("<a\\s+href=\"([^\"]+)\">([^<]+)</a>");
    private static final Pattern MARKDOWN_HEADER = Pattern.compile("^##\\s+(.+)$", 8);
    private static final Pattern MARKDOWN_BOLD = Pattern.compile("\\*\\*([^*]+)\\*\\*");
    private static final Pattern SLASH_E_PATTERN = Pattern.compile("/e/([^/]+)/e/");
    private static final Pattern SLASH_9_PATTERN = Pattern.compile("/9/([^/]+)/9/");

    public static Component parse(String text) {
        if (text == null || text.isEmpty()) {
            return Component.m_237119_();
        }
        text = TextFormatter.preprocessMarkdown(text);
        text = TextFormatter.processLinks(text, new ArrayList<String>());
        MutableComponent root = Component.m_237119_();
        StyleStack styleStack = new StyleStack();
        Matcher matcher = TAG_PATTERN.matcher(text);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String content = text.substring(lastEnd, matcher.start());
                root.m_7220_((Component)Component.m_237113_((String)content).m_6270_(styleStack.current()));
            }
            boolean isClosing = matcher.group(1).equals("/");
            String tagName = matcher.group(2).toLowerCase();
            String attributes = matcher.group(3);
            if (isClosing) {
                styleStack.pop(tagName);
            } else if (tagName.equals("reset")) {
                styleStack.reset();
            } else if (tagName.equals("__link__")) {
                if (attributes != null) {
                    String url = attributes.trim();
                    styleStack.pushLink(tagName, url);
                }
            } else if (tagName.startsWith("#")) {
                styleStack.pushColor(tagName, TextFormatter.parseHexColor(tagName));
            } else {
                TextFormatter.applyTag(styleStack, tagName);
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < text.length()) {
            String content = text.substring(lastEnd);
            root.m_7220_((Component)Component.m_237113_((String)content).m_6270_(styleStack.current()));
        }
        return root;
    }

    private static String preprocessMarkdown(String text) {
        text = MARKDOWN_HEADER.matcher(text).replaceAll("<gold><bold>$1</bold></gold>");
        text = MARKDOWN_BOLD.matcher(text).replaceAll("<bold>$1</bold>");
        text = SLASH_E_PATTERN.matcher(text).replaceAll("<italic>$1</italic>");
        text = SLASH_9_PATTERN.matcher(text).replaceAll("<aqua>$1</aqua>");
        return text;
    }

    private static String processLinks(String text, List<String> urls) {
        StringBuffer result = new StringBuffer();
        Matcher linkMatcher = LINK_PATTERN.matcher(text);
        while (linkMatcher.find()) {
            String url = linkMatcher.group(1);
            String linkText = linkMatcher.group(2);
            String replacement = "<__link__ " + url + ">" + linkText + "</__link__>";
            linkMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        linkMatcher.appendTail(result);
        text = result.toString();
        result = new StringBuffer();
        Matcher anchorMatcher = ANCHOR_PATTERN.matcher(text);
        while (anchorMatcher.find()) {
            String url = anchorMatcher.group(1);
            String linkText = anchorMatcher.group(2);
            String replacement = "<__link__ " + url + ">" + linkText + "</__link__>";
            anchorMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        anchorMatcher.appendTail(result);
        return result.toString();
    }

    public static String stripTags(String text) {
        if (text == null) {
            return "";
        }
        return TAG_PATTERN.matcher(text).replaceAll("");
    }

    public static String getPreview(String text, int maxLength) {
        String plain = TextFormatter.stripTags(text);
        if (plain.length() <= maxLength) {
            return plain;
        }
        return plain.substring(0, maxLength - 3) + "...";
    }

    private static void applyTag(StyleStack stack, String tag) {
        switch (tag) {
            case "black": {
                stack.pushColor(tag, ChatFormatting.BLACK);
                break;
            }
            case "dark_blue": {
                stack.pushColor(tag, ChatFormatting.DARK_BLUE);
                break;
            }
            case "dark_green": {
                stack.pushColor(tag, ChatFormatting.DARK_GREEN);
                break;
            }
            case "dark_aqua": 
            case "dark_cyan": {
                stack.pushColor(tag, ChatFormatting.DARK_AQUA);
                break;
            }
            case "dark_red": {
                stack.pushColor(tag, ChatFormatting.DARK_RED);
                break;
            }
            case "dark_purple": 
            case "purple": {
                stack.pushColor(tag, ChatFormatting.DARK_PURPLE);
                break;
            }
            case "gold": 
            case "orange": {
                stack.pushColor(tag, ChatFormatting.GOLD);
                break;
            }
            case "gray": 
            case "grey": {
                stack.pushColor(tag, ChatFormatting.GRAY);
                break;
            }
            case "dark_gray": 
            case "dark_grey": {
                stack.pushColor(tag, ChatFormatting.DARK_GRAY);
                break;
            }
            case "blue": {
                stack.pushColor(tag, ChatFormatting.BLUE);
                break;
            }
            case "green": 
            case "lime": {
                stack.pushColor(tag, ChatFormatting.GREEN);
                break;
            }
            case "aqua": 
            case "cyan": {
                stack.pushColor(tag, ChatFormatting.AQUA);
                break;
            }
            case "red": {
                stack.pushColor(tag, ChatFormatting.RED);
                break;
            }
            case "light_purple": 
            case "pink": 
            case "magenta": {
                stack.pushColor(tag, ChatFormatting.LIGHT_PURPLE);
                break;
            }
            case "yellow": {
                stack.pushColor(tag, ChatFormatting.YELLOW);
                break;
            }
            case "white": {
                stack.pushColor(tag, ChatFormatting.WHITE);
                break;
            }
            case "bold": 
            case "b": {
                stack.pushFormat(tag, "bold");
                break;
            }
            case "italic": 
            case "i": 
            case "em": {
                stack.pushFormat(tag, "italic");
                break;
            }
            case "underline": 
            case "u": {
                stack.pushFormat(tag, "underline");
                break;
            }
            case "strikethrough": 
            case "strike": 
            case "s": {
                stack.pushFormat(tag, "strikethrough");
                break;
            }
            case "obfuscated": 
            case "obf": {
                stack.pushFormat(tag, "obfuscated");
            }
        }
    }

    private static TextColor parseHexColor(String hex) {
        try {
            String color = hex.startsWith("#") ? hex.substring(1) : hex;
            int rgb = Integer.parseInt(color, 16);
            return TextColor.m_131266_((int)rgb);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class StyleStack {
        private final List<StyleLayer> stack = new ArrayList<StyleLayer>();

        private StyleStack() {
        }

        public Style current() {
            Style style = Style.f_131099_;
            for (StyleLayer layer : this.stack) {
                style = layer.apply(style);
            }
            return style;
        }

        public void pushColor(String tag, ChatFormatting formatting) {
            Integer color = formatting.m_126665_();
            if (color != null) {
                this.stack.add(new StyleLayer(tag, "color", TextColor.m_131266_((int)color), null));
            }
        }

        public void pushColor(String tag, TextColor color) {
            if (color != null) {
                this.stack.add(new StyleLayer(tag, "color", color, null));
            }
        }

        public void pushFormat(String tag, String formatType) {
            this.stack.add(new StyleLayer(tag, formatType, null, null));
        }

        public void pushLink(String tag, String url) {
            this.stack.add(new StyleLayer(tag, "link", null, url));
        }

        public void pop(String tag) {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                if (!this.stack.get((int)i).tag.equals(tag)) continue;
                this.stack.remove(i);
                break;
            }
        }

        public void reset() {
            this.stack.clear();
        }
    }

    private static class StyleLayer {
        final String tag;
        final String type;
        final TextColor color;
        final String url;

        StyleLayer(String tag, String type, TextColor color, String url) {
            this.tag = tag;
            this.type = type;
            this.color = color;
            this.url = url;
        }

        Style apply(Style base) {
            Style result;
            switch (this.type) {
                case "color": {
                    Style style = base.m_131148_(this.color);
                    break;
                }
                case "bold": {
                    Style style = base.m_131136_(Boolean.valueOf(true));
                    break;
                }
                case "italic": {
                    Style style = base.m_131155_(Boolean.valueOf(true));
                    break;
                }
                case "underline": {
                    Style style = base.m_131162_(Boolean.valueOf(true));
                    break;
                }
                case "strikethrough": {
                    Style style = base.m_178522_(Boolean.valueOf(true));
                    break;
                }
                case "obfuscated": {
                    Style style = base.m_178524_(Boolean.valueOf(true));
                    break;
                }
                case "link": {
                    Style style = base.m_131148_(TextColor.m_131266_((int)0x55FFFF)).m_131162_(Boolean.valueOf(true));
                    break;
                }
                default: {
                    Style style = result = base;
                }
            }
            if (this.type.equals("link") && this.url != null && !this.url.isEmpty()) {
                try {
                    result = result.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, this.url)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Click to open: " + this.url))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

