/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class ThemePreviewPanel {
    private final int x;
    private final int y;
    private final int w;
    private final int h;
    private final Font font;

    public ThemePreviewPanel(int x, int y, int w, int h, Font font) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.font = font;
    }

    public void render(GuiGraphics g, int mouseX, int mouseY) {
        g.m_280488_(this.font, "\u00a7lLive Preview", this.x + 8, this.y + 8, -86);
        int previewY = this.y + 28;
        int previewX = this.x + 12;
        this.renderSampleQuestPanel(g, previewX, previewY);
        this.renderSampleDependencyLine(g, previewX, previewY + 80);
        this.renderSampleText(g, previewX, previewY + 120);
    }

    private void renderSampleQuestPanel(GuiGraphics g, int px, int py) {
        g.m_280488_(this.font, "\u00a77Quest Panel:", px, py - 12, -3355444);
        int background = QuestTheme.instance.get(ThemeProperties.WIDGET_BACKGROUND);
        int borderColor = QuestTheme.instance.get(ThemeProperties.QUEST_VIEW_BORDER);
        int titleColor = QuestTheme.instance.get(ThemeProperties.QUEST_VIEW_TITLE);
        int descColor = QuestTheme.instance.get(ThemeProperties.TEXT_COLOR);
        int panelW = Math.min(200, this.w - 40);
        int panelH = 60;
        g.m_280509_(px, py, px + panelW, py + panelH, background);
        g.m_280509_(px, py, px + panelW, py + 1, borderColor);
        g.m_280509_(px, py + panelH - 1, px + panelW, py + panelH, borderColor);
        g.m_280509_(px, py, px + 1, py + panelH, borderColor);
        g.m_280509_(px + panelW - 1, py, px + panelW, py + panelH, borderColor);
        g.m_280488_(this.font, "Example Quest", px + 8, py + 8, titleColor);
        g.m_280488_(this.font, "Quest description text", px + 8, py + 24, descColor);
        g.m_280488_(this.font, "showing theme colors", px + 8, py + 36, descColor);
    }

    private void renderSampleDependencyLine(GuiGraphics g, int px, int py) {
        g.m_280488_(this.font, "\u00a77Dependency Lines:", px, py - 12, -3355444);
        int lineColor = QuestTheme.instance.get(ThemeProperties.DEPENDENCY_LINE_UNCOMPLETED_COLOR);
        int completedColor = QuestTheme.instance.get(ThemeProperties.DEPENDENCY_LINE_COMPLETED_COLOR);
        g.m_280509_(px, py + 5, px + 60, py + 7, lineColor);
        g.m_280488_(this.font, "Normal", px + 65, py + 2, -1);
        g.m_280509_(px, py + 18, px + 60, py + 20, completedColor);
        g.m_280488_(this.font, "Completed", px + 65, py + 15, -1);
    }

    private void renderSampleText(GuiGraphics g, int px, int py) {
        g.m_280488_(this.font, "\u00a77Text Colors:", px, py - 12, -3355444);
        int titleColor = QuestTheme.instance.get(ThemeProperties.QUEST_VIEW_TITLE);
        int descColor = QuestTheme.instance.get(ThemeProperties.TEXT_COLOR);
        int tasksColor = QuestTheme.instance.get(ThemeProperties.TASKS_TEXT_COLOR);
        g.m_280488_(this.font, "Quest Title", px, py, titleColor);
        g.m_280488_(this.font, "Description", px, py + 12, descColor);
        g.m_280488_(this.font, "Tasks", px, py + 24, tasksColor);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX <= this.x + this.w && mouseY >= this.y && mouseY <= this.y + this.h;
    }
}

