/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestSyncPacket;
import org.texboobcat.questory.quest.Quest;

public class QuestCreateRequestPacket {
    private static final Gson GSON = new Gson();
    private final String questJson;

    public QuestCreateRequestPacket(String questJson) {
        this.questJson = questJson;
    }

    public static void encode(QuestCreateRequestPacket pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.questJson);
    }

    public static QuestCreateRequestPacket decode(FriendlyByteBuf buf) {
        return new QuestCreateRequestPacket(buf.m_130277_());
    }

    public void handle(ServerPlayer player) {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.enableAdvancedEditor) {
            return;
        }
        if (cfg.advancedEditorRequiresOp && !player.m_20310_(cfg.adminPermissionLevel)) {
            return;
        }
        try {
            JsonObject json = (JsonObject)GSON.fromJson(this.questJson, JsonObject.class);
            Quest quest = Quest.fromJson(json);
            QuestManager qm = QuestManager.getInstance();
            qm.registerQuest(quest);
            List list = player.f_8924_.m_6846_().m_11314_();
            ArrayList<Quest> all = new ArrayList<Quest>(qm.getAllQuests());
            for (ServerPlayer p : list) {
                NetworkManager.sendToClient(p, new QuestSyncPacket(all));
            }
            player.m_213846_((Component)Component.m_237113_((String)("Created quest: " + quest.getId())));
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("Failed to create quest: " + e.getMessage())));
        }
    }
}

