/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class FluidRequirement
extends Requirement {
    private String fluidId;
    private long amount;
    private CompoundTag nbt;

    public FluidRequirement(String fluidId, long amount) {
        super("fluid");
        this.fluidId = fluidId;
        this.amount = amount;
        this.nbt = null;
    }

    public String getFluidId() {
        return this.fluidId;
    }

    public void setFluidId(String fluidId) {
        this.fluidId = fluidId;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public CompoundTag getNbt() {
        return this.nbt;
    }

    public void setNbt(CompoundTag nbt) {
        this.nbt = nbt;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return (long)progress.getRequirementProgress(questId, this) >= this.amount;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        long current = progress.getRequirementProgress(questId, this);
        return current + "/" + this.amount + "mB " + this.fluidId;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "fluid");
        json.addProperty("fluid", this.fluidId);
        json.addProperty("amount", (Number)this.amount);
        if (this.nbt != null) {
            json.addProperty("nbt", this.nbt.toString());
        }
        return json;
    }

    public static FluidRequirement fromJson(JsonObject json) {
        String fluidId = json.get("fluid").getAsString();
        long amount = json.has("amount") ? json.get("amount").getAsLong() : 1000L;
        FluidRequirement req = new FluidRequirement(fluidId, amount);
        if (json.has("nbt")) {
            try {
                req.setNbt(TagParser.m_129359_((String)json.get("nbt").getAsString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return req;
    }
}

