/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.texboobcat.questory.team.QuestTeam;

public class TeamStorage {
    private final Path teamsPath;
    private final Gson gson;

    public TeamStorage(Path dataPath) {
        this.teamsPath = dataPath.resolve("teams");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Files.createDirectories(this.teamsPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to create teams directory: " + e.getMessage());
        }
    }

    public Map<UUID, QuestTeam> loadAllTeams() {
        HashMap<UUID, QuestTeam> teams = new HashMap<UUID, QuestTeam>();
        try {
            if (!Files.exists(this.teamsPath, new LinkOption[0])) {
                return teams;
            }
            Files.list(this.teamsPath).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                try {
                    QuestTeam team = this.loadTeam((Path)path);
                    if (team != null) {
                        teams.put(team.getTeamId(), team);
                    }
                }
                catch (Exception e) {
                    System.err.println("[Questory] Failed to load team from " + String.valueOf(path) + ": " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to list teams directory: " + e.getMessage());
        }
        return teams;
    }

    private QuestTeam loadTeam(Path path) {
        QuestTeam questTeam;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                JsonObject json = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                questTeam = QuestTeam.fromJson(json);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("[Questory] Failed to load team: " + e.getMessage());
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return questTeam;
    }

    public void saveTeam(QuestTeam team) {
        Path teamPath = this.teamsPath.resolve(String.valueOf(team.getTeamId()) + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(teamPath, new OpenOption[0]);){
            this.gson.toJson((JsonElement)team.toJson(), (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to save team " + team.getTeamName() + ": " + e.getMessage());
        }
    }

    public void saveAllTeams(Collection<QuestTeam> teams) {
        for (QuestTeam team : teams) {
            this.saveTeam(team);
        }
    }

    public void deleteTeam(UUID teamId) {
        Path teamPath = this.teamsPath.resolve(String.valueOf(teamId) + ".json");
        try {
            Files.deleteIfExists(teamPath);
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to delete team: " + e.getMessage());
        }
    }
}

