/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.modpack.ModpackDetector;
import org.texboobcat.questory.modpack.ModpackInfo;
import org.texboobcat.questory.telemetry.TelemetryManager;

public class ConsentScreen
extends Screen {
    private final Screen parent;
    private final Runnable onComplete;
    private boolean showingPrivacyDetails = false;

    public ConsentScreen(Screen parent, Runnable onComplete) {
        super((Component)Component.m_237113_((String)"Questify Telemetry"));
        this.parent = parent;
        this.onComplete = onComplete;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 120;
        int buttonHeight = 20;
        int centerX = this.f_96543_ / 2;
        int bottomY = this.f_96544_ - 40;
        Button optInButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7a\u2713 Opt In"), btn -> {
            TelemetryManager.getInstance().enableTelemetry();
            this.m_7379_();
        }).m_252987_(centerX - buttonWidth - 10, bottomY, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)optInButton);
        Button noThanksButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a77No Thanks"), btn -> {
            TelemetryManager.getInstance().disableTelemetry();
            this.m_7379_();
        }).m_252987_(centerX + 10, bottomY, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)noThanksButton);
        Button privacyButton = Button.m_253074_((Component)Component.m_237113_((String)(this.showingPrivacyDetails ? "Hide Details" : "Show Privacy Details")), btn -> {
            this.showingPrivacyDetails = !this.showingPrivacyDetails;
            btn.m_93666_((Component)Component.m_237113_((String)(this.showingPrivacyDetails ? "Hide Details" : "Show Privacy Details")));
        }).m_252987_(centerX - 80, bottomY - 30, 160, 20).m_253136_();
        this.m_142416_((GuiEventListener)privacyButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -536870912);
        int centerX = this.f_96543_ / 2;
        int startY = 40;
        int lineHeight = 12;
        int currentY = startY;
        graphics.m_280137_(this.f_96547_, "\u00a7l\u00a76Questify Telemetry", centerX, currentY, 0xFFFFFF);
        currentY += lineHeight * 2;
        ModpackInfo modpack = ModpackDetector.detect();
        String modpackName = modpack.getName();
        if (!this.showingPrivacyDetails) {
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add("\u00a77Questify can collect anonymous usage data to help");
            lines.add("\u00a77quest designers understand how players interact with quests.");
            lines.add("");
            lines.add("\u00a7fDetected Modpack: \u00a7e" + modpackName);
            lines.add("");
            lines.add("\u00a77\u00a7lCentralized Database - No Setup Needed!");
            lines.add("\u00a77All users send data to a central database.");
            lines.add("");
            lines.add("\u00a7aWhat we collect:");
            lines.add("  \u00a77\u2022 Which quests you complete");
            lines.add("  \u00a77\u2022 How long quests take to complete");
            lines.add("  \u00a77\u2022 Which quests you view");
            lines.add("  \u00a77\u2022 Anonymous session data");
            lines.add("");
            lines.add("\u00a7cWhat we DON'T collect:");
            lines.add("  \u00a77\u2022 Your username or Minecraft account");
            lines.add("  \u00a77\u2022 Your IP address");
            lines.add("  \u00a77\u2022 Any personal information");
            lines.add("");
            lines.add("\u00a77You can change this later via:");
            lines.add("  \u00a7f/questory telemetry optin\u00a77 or \u00a7f/questory telemetry optout");
            for (String string : lines) {
                graphics.m_280137_(this.f_96547_, string, centerX, currentY, 0xFFFFFF);
                currentY += lineHeight;
            }
        } else {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("\u00a7l\u00a7ePrivacy & Data Protection");
            lines.add("");
            lines.add("\u00a7fAnonymization:");
            lines.add("  \u00a77\u2022 Hardware ID (not linked to your account)");
            lines.add("  \u00a77\u2022 Machine-specific, not player-specific");
            lines.add("  \u00a77\u2022 No personally identifiable information");
            lines.add("");
            lines.add("\u00a7fGDPR Compliance:");
            lines.add("  \u00a7a\u2022 Right to Access: \u00a7f/questory telemetry export");
            lines.add("  \u00a7a\u2022 Right to Delete: \u00a7f/questory telemetry delete");
            lines.add("  \u00a7a\u2022 Right to Opt-Out: \u00a77Anytime via commands");
            lines.add("");
            lines.add("\u00a7fData Storage:");
            lines.add("  \u00a77\u2022 Stored in centralized Supabase database");
            lines.add("  \u00a77\u2022 Shared across ALL Questify users");
            lines.add("  \u00a77\u2022 Used only for aggregate analytics");
            lines.add("  \u00a77\u2022 Never sold or shared");
            lines.add("");
            lines.add("\u00a7fBenefits:");
            lines.add("  \u00a77\u2022 Help improve quest design for everyone");
            lines.add("  \u00a77\u2022 View heatmaps of popular quests");
            lines.add("  \u00a77\u2022 Contribute to the community");
            for (String string : lines) {
                graphics.m_280137_(this.f_96547_, string, centerX, currentY, 0xFFFFFF);
                currentY += lineHeight;
            }
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        if (this.onComplete != null) {
            this.onComplete.run();
        }
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return true;
    }
}

