/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.storage.StorageBackendFactory;
import org.texboobcat.questory.storage.backend.IPlayerProgressBackend;
import org.texboobcat.questory.storage.backend.ITeamStorageBackend;
import org.texboobcat.questory.storage.migration.BackupManager;
import org.texboobcat.questory.storage.migration.DataExporter;
import org.texboobcat.questory.storage.migration.StorageMigrator;

public class StorageCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"questify").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"storage").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"info").executes(StorageCommands::showStorageInfo))).then(Commands.m_82127_((String)"migrate").then(Commands.m_82129_((String)"targetBackend", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("json");
            builder.suggest("sqlite");
            builder.suggest("mysql");
            return builder.buildFuture();
        }).executes(StorageCommands::migrateStorage)))).then(Commands.m_82127_((String)"export").then(Commands.m_82129_((String)"targetPath", (ArgumentType)StringArgumentType.greedyString()).executes(StorageCommands::exportData)))).then(Commands.m_82127_((String)"import").then(Commands.m_82129_((String)"sourcePath", (ArgumentType)StringArgumentType.greedyString()).executes(StorageCommands::importData)))).then(Commands.m_82127_((String)"backup").executes(StorageCommands::createBackup))).then(Commands.m_82127_((String)"verify").executes(StorageCommands::verifyConnections))));
    }

    private static int showStorageInfo(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        QuestoryConfig config = QuestoryConfig.getInstance();
        source.m_288197_(() -> Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.GOLD), false);
        source.m_288197_(() -> Component.m_237113_((String)"Storage Backend Information").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.GOLD), false);
        source.m_288197_(() -> Component.m_237113_((String)("Current Backend: " + config.storageType.toUpperCase())).m_130940_(ChatFormatting.YELLOW), false);
        switch (config.storageType.toLowerCase()) {
            case "sqlite": {
                source.m_288197_(() -> Component.m_237113_((String)("Database Path: " + config.sqliteDatabasePath)).m_130940_(ChatFormatting.WHITE), false);
                break;
            }
            case "mysql": {
                source.m_288197_(() -> Component.m_237113_((String)("Host: " + config.mysqlHost + ":" + config.mysqlPort)).m_130940_(ChatFormatting.WHITE), false);
                source.m_288197_(() -> Component.m_237113_((String)("Database: " + config.mysqlDatabase)).m_130940_(ChatFormatting.WHITE), false);
                source.m_288197_(() -> Component.m_237113_((String)("Pool Size: " + config.mysqlPoolMinConnections + "-" + config.mysqlPoolMaxConnections)).m_130940_(ChatFormatting.WHITE), false);
                break;
            }
            case "json": {
                source.m_288197_(() -> Component.m_237113_((String)"Storage: File-based JSON").m_130940_(ChatFormatting.WHITE), false);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int migrateStorage(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String targetBackend = StringArgumentType.getString(context, (String)"targetBackend").toLowerCase();
        if (!(targetBackend.equals("json") || targetBackend.equals("sqlite") || targetBackend.equals("mysql"))) {
            source.m_81352_((Component)Component.m_237113_((String)("Invalid backend: " + targetBackend + ". Must be 'json', 'sqlite', or 'mysql'")));
            return 0;
        }
        QuestoryConfig config = QuestoryConfig.getInstance();
        String currentBackend = config.storageType.toLowerCase();
        if (currentBackend.equals(targetBackend)) {
            source.m_81352_((Component)Component.m_237113_((String)("Already using " + targetBackend + " backend!")));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)("Starting migration from " + currentBackend + " to " + targetBackend + "...")).m_130940_(ChatFormatting.YELLOW), true);
        try {
            Path dataPath = Questory.getDataPath();
            source.m_288197_(() -> Component.m_237113_((String)"Creating backup before migration...").m_130940_(ChatFormatting.YELLOW), false);
            BackupManager backupManager = new BackupManager(dataPath);
            Path backupFile = backupManager.createBackup(currentBackend);
            if (backupFile == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Failed to create backup! Migration aborted."));
                return 0;
            }
            source.m_288197_(() -> Component.m_237113_((String)("Backup created: " + String.valueOf(backupFile.getFileName()))).m_130940_(ChatFormatting.GREEN), false);
            IPlayerProgressBackend sourceProgress = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
            ITeamStorageBackend sourceTeams = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
            String originalStorageType = config.storageType;
            config.storageType = targetBackend;
            try {
                IPlayerProgressBackend targetProgress = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
                ITeamStorageBackend targetTeams = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
                source.m_288197_(() -> Component.m_237113_((String)"Migrating player progress...").m_130940_(ChatFormatting.YELLOW), false);
                boolean progressSuccess = StorageMigrator.migratePlayerProgress(sourceProgress, targetProgress, new MigrationProgressReporter(source, "players"));
                if (!progressSuccess) {
                    source.m_81352_((Component)Component.m_237113_((String)"Player progress migration failed! Check console for details."));
                    source.m_288197_(() -> Component.m_237113_((String)("Backup available at: " + String.valueOf(backupFile))).m_130940_(ChatFormatting.YELLOW), false);
                    int n = 0;
                    return n;
                }
                source.m_288197_(() -> Component.m_237113_((String)"Migrating teams...").m_130940_(ChatFormatting.YELLOW), false);
                boolean teamsSuccess = StorageMigrator.migrateTeams(sourceTeams, targetTeams, new MigrationProgressReporter(source, "teams"));
                if (!teamsSuccess) {
                    source.m_81352_((Component)Component.m_237113_((String)"Team migration failed! Check console for details."));
                    source.m_288197_(() -> Component.m_237113_((String)("Backup available at: " + String.valueOf(backupFile))).m_130940_(ChatFormatting.YELLOW), false);
                    int n = 0;
                    return n;
                }
                sourceProgress.disconnect();
                sourceTeams.disconnect();
                targetProgress.disconnect();
                targetTeams.disconnect();
                source.m_288197_(() -> Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.GREEN), false);
                source.m_288197_(() -> Component.m_237113_((String)"Migration completed successfully!").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), true);
                source.m_288197_(() -> Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.GREEN), false);
                source.m_288197_(() -> Component.m_237113_((String)("IMPORTANT: Update your config file to set storageType to '" + targetBackend + "' and restart the server!")), false);
                source.m_288197_(() -> Component.m_237113_((String)("Backup available at: " + String.valueOf(backupFile))).m_130940_(ChatFormatting.GRAY), false);
                int n = 1;
                return n;
            }
            finally {
                config.storageType = originalStorageType;
            }
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Migration error: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            e.printStackTrace();
            return 0;
        }
    }

    private static int exportData(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String targetPath = StringArgumentType.getString(context, (String)"targetPath");
        source.m_288197_(() -> Component.m_237113_((String)("Exporting data to: " + targetPath)).m_130940_(ChatFormatting.YELLOW), true);
        try {
            Path dataPath = Questory.getDataPath();
            Path exportDir = Paths.get(targetPath, new String[0]);
            QuestoryConfig config = QuestoryConfig.getInstance();
            IPlayerProgressBackend progressBackend = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
            ITeamStorageBackend teamBackend = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
            boolean progressExported = DataExporter.exportPlayerProgress(progressBackend, exportDir);
            boolean teamsExported = DataExporter.exportTeams(teamBackend, exportDir);
            progressBackend.disconnect();
            teamBackend.disconnect();
            if (progressExported && teamsExported) {
                source.m_288197_(() -> Component.m_237113_((String)("Data exported successfully to: " + String.valueOf(exportDir))).m_130940_(ChatFormatting.GREEN), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)"Export failed! Check console for details."));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Export error: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            e.printStackTrace();
            return 0;
        }
    }

    private static int importData(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String sourcePath = StringArgumentType.getString(context, (String)"sourcePath");
        source.m_288197_(() -> Component.m_237113_((String)("Importing data from: " + sourcePath)).m_130940_(ChatFormatting.YELLOW), true);
        try {
            Path dataPath = Questory.getDataPath();
            Path importDir = Paths.get(sourcePath, new String[0]);
            QuestoryConfig config = QuestoryConfig.getInstance();
            IPlayerProgressBackend progressBackend = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
            ITeamStorageBackend teamBackend = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
            boolean progressImported = DataExporter.importPlayerProgress(progressBackend, importDir);
            boolean teamsImported = DataExporter.importTeams(teamBackend, importDir);
            progressBackend.disconnect();
            teamBackend.disconnect();
            if (progressImported && teamsImported) {
                source.m_288197_(() -> Component.m_237113_((String)("Data imported successfully from: " + String.valueOf(importDir))).m_130940_(ChatFormatting.GREEN), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)"Import failed! Check console for details."));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Import error: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            e.printStackTrace();
            return 0;
        }
    }

    private static int createBackup(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            Path dataPath = Questory.getDataPath();
            QuestoryConfig config = QuestoryConfig.getInstance();
            BackupManager backupManager = new BackupManager(dataPath);
            Path backupFile = backupManager.createBackup(config.storageType);
            if (backupFile != null) {
                source.m_288197_(() -> Component.m_237113_((String)("Backup created: " + String.valueOf(backupFile.getFileName()))).m_130940_(ChatFormatting.GREEN), true);
                source.m_288197_(() -> Component.m_237113_((String)("Location: " + backupFile.toString())).m_130940_(ChatFormatting.GRAY), false);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)"Failed to create backup"));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Backup error: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }

    private static int verifyConnections(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            Path dataPath = Questory.getDataPath();
            QuestoryConfig config = QuestoryConfig.getInstance();
            source.m_288197_(() -> Component.m_237113_((String)"Verifying storage connections...").m_130940_(ChatFormatting.YELLOW), false);
            IPlayerProgressBackend progressBackend = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
            ITeamStorageBackend teamBackend = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
            boolean progressHealthy = progressBackend.healthCheck();
            boolean teamsHealthy = teamBackend.healthCheck();
            source.m_288197_(() -> Component.m_237113_((String)("Player Progress Backend: " + (progressHealthy ? "\u2713 Healthy" : "\u2717 Unhealthy"))).m_130940_(progressHealthy ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            source.m_288197_(() -> Component.m_237113_((String)("Team Storage Backend: " + (teamsHealthy ? "\u2713 Healthy" : "\u2717 Unhealthy"))).m_130940_(teamsHealthy ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            progressBackend.disconnect();
            teamBackend.disconnect();
            return progressHealthy && teamsHealthy ? 1 : 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Verification error: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            e.printStackTrace();
            return 0;
        }
    }

    private static class MigrationProgressReporter
    implements StorageMigrator.MigrationProgressCallback {
        private final CommandSourceStack source;
        private final String dataType;

        public MigrationProgressReporter(CommandSourceStack source, String dataType) {
            this.source = source;
            this.dataType = dataType;
        }

        @Override
        public void onStart(int total) {
            this.source.m_288197_(() -> Component.m_237113_((String)("Starting migration of " + total + " " + this.dataType + "...")).m_130940_(ChatFormatting.YELLOW), false);
        }

        @Override
        public void onProgress(int current, int total) {
            int percentage = current * 100 / total;
            this.source.m_288197_(() -> Component.m_237113_((String)("Progress: " + current + "/" + total + " (" + percentage + "%)")).m_130940_(ChatFormatting.YELLOW), false);
        }

        @Override
        public void onComplete(int migrated, int errors) {
            if (errors == 0) {
                this.source.m_288197_(() -> Component.m_237113_((String)("\u2713 Successfully migrated " + migrated + " " + this.dataType)).m_130940_(ChatFormatting.GREEN), false);
            } else {
                this.source.m_288197_(() -> Component.m_237113_((String)("\u26a0 Migrated " + migrated + " " + this.dataType + " with " + errors + " errors")).m_130940_(ChatFormatting.YELLOW), false);
            }
        }

        @Override
        public void onError(Exception e) {
            this.source.m_81352_((Component)Component.m_237113_((String)("Migration error: " + e.getMessage())).m_130940_(ChatFormatting.RED));
        }
    }
}

