/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.manager.QuestManager;

public class CustomProgressPacket {
    private final String questId;
    private final String requirementId;
    private final int amount;

    public CustomProgressPacket(String questId, String requirementId, int amount) {
        this.questId = questId;
        this.requirementId = requirementId;
        this.amount = amount;
    }

    public static void encode(CustomProgressPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.questId == null ? "" : packet.questId);
        buf.m_130070_(packet.requirementId == null ? "" : packet.requirementId);
        buf.m_130130_(packet.amount);
    }

    public static CustomProgressPacket decode(FriendlyByteBuf buf) {
        String q = buf.m_130277_();
        String r = buf.m_130277_();
        int a = buf.m_130242_();
        return new CustomProgressPacket(q, r, a);
    }

    public void handle(ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (this.amount <= 0) {
            return;
        }
        QuestManager.getInstance().trackCustomProgress(player.m_20148_(), this.questId, this.requirementId, this.amount, player);
    }
}

