/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class ItemTagRequirement
extends Requirement {
    private String tag;
    private int count;
    private boolean consume;

    public ItemTagRequirement(String tag, int count) {
        super("item_tag");
        this.tag = tag.startsWith("#") ? tag.substring(1) : tag;
        this.count = count;
        this.consume = false;
    }

    public String getTag() {
        return this.tag;
    }

    public int getCount() {
        return this.count;
    }

    public boolean shouldConsume() {
        return this.consume;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.count;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        return current + "/" + this.count + " #" + this.tag;
    }

    public boolean matches(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(this.tag));
        return stack.m_204117_(key);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("tag", "#" + this.tag);
        json.addProperty("count", (Number)this.count);
        json.addProperty("consume", Boolean.valueOf(this.consume));
        return json;
    }

    public static ItemTagRequirement fromJson(JsonObject json) {
        String tag = json.get("tag").getAsString();
        int count = json.get("count").getAsInt();
        ItemTagRequirement req = new ItemTagRequirement(tag, count);
        if (json.has("consume")) {
            req.setConsume(json.get("consume").getAsBoolean());
        }
        return req;
    }
}

