/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage.backend.mysql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.texboobcat.questory.config.QuestoryConfig;

public class HikariConnectionManager {
    private HikariDataSource dataSource;
    private final QuestoryConfig config;

    public HikariConnectionManager(QuestoryConfig config) {
        this.config = config;
    }

    public boolean initialize() {
        try {
            HikariConfig hikariConfig = new HikariConfig();
            String jdbcUrl = String.format("jdbc:mysql://%s:%d/%s?useSSL=false&allowPublicKeyRetrieval=true&serverTimezone=UTC", this.config.mysqlHost, this.config.mysqlPort, this.config.mysqlDatabase);
            hikariConfig.setJdbcUrl(jdbcUrl);
            hikariConfig.setUsername(this.config.mysqlUsername);
            hikariConfig.setPassword(this.resolvePassword(this.config.mysqlPassword));
            hikariConfig.setMinimumIdle(this.config.mysqlPoolMinConnections);
            hikariConfig.setMaximumPoolSize(this.config.mysqlPoolMaxConnections);
            hikariConfig.setConnectionTimeout(this.config.mysqlConnectionTimeoutMs);
            hikariConfig.setIdleTimeout(this.config.mysqlIdleTimeoutMs);
            hikariConfig.setMaxLifetime(1800000L);
            hikariConfig.setAutoCommit(true);
            hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
            hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
            hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            hikariConfig.setPoolName("QuestoryMySQLPool");
            this.dataSource = new HikariDataSource(hikariConfig);
            try (Connection conn = this.dataSource.getConnection();){
                System.out.println("[Questory] HikariCP connection pool initialized successfully");
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to initialize HikariCP: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private String resolvePassword(String password) {
        if (password == null || password.isEmpty()) {
            return "";
        }
        if (password.startsWith("${") && password.endsWith("}")) {
            String envVar = password.substring(2, password.length() - 1);
            String envValue = System.getenv(envVar);
            if (envValue != null) {
                System.out.println("[Questory] Using password from environment variable: " + envVar);
                return envValue;
            }
            System.err.println("[Questory] Warning: Environment variable " + envVar + " not found");
            return "";
        }
        return password;
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("Connection pool not initialized");
        }
        return this.dataSource.getConnection();
    }

    public void shutdown() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            System.out.println("[Questory] HikariCP connection pool closed");
        }
    }

    public boolean isRunning() {
        return this.dataSource != null && !this.dataSource.isClosed();
    }

    public boolean healthCheck() {
        boolean bl;
        block9: {
            if (!this.isRunning()) {
                return false;
            }
            Connection conn = this.dataSource.getConnection();
            try {
                bl = conn.isValid(5);
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }
}

