/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage.backend.mysql;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.storage.backend.ITeamStorageBackend;
import org.texboobcat.questory.storage.backend.mysql.HikariConnectionManager;
import org.texboobcat.questory.team.QuestTeam;

public class MysqlTeamStorageBackend
implements ITeamStorageBackend {
    private static final Gson GSON = new GsonBuilder().create();
    private final QuestoryConfig config;
    private final HikariConnectionManager connectionManager;
    private final String tablePrefix;

    public MysqlTeamStorageBackend(QuestoryConfig config) {
        this.config = config;
        this.connectionManager = new HikariConnectionManager(config);
        this.tablePrefix = config.mysqlTablePrefix;
    }

    @Override
    public boolean connect() {
        if (!this.connectionManager.initialize()) {
            return false;
        }
        try {
            this.createTables();
            System.out.println("[Questory] MySQL team storage backend connected");
            return true;
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to create MySQL team tables: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void createTables() throws SQLException {
        String createTeamsTable = String.format("    CREATE TABLE IF NOT EXISTS %steams (\n        team_id VARCHAR(36) PRIMARY KEY,\n        team_data TEXT NOT NULL,\n        last_updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n        INDEX idx_team (team_id)\n    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4\n", this.tablePrefix);
        try (Connection conn = this.connectionManager.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(createTeamsTable);
        }
    }

    @Override
    public void disconnect() {
        this.connectionManager.shutdown();
        System.out.println("[Questory] MySQL team storage backend disconnected");
    }

    @Override
    public boolean isConnected() {
        return this.connectionManager.isRunning();
    }

    @Override
    public boolean healthCheck() {
        return this.connectionManager.healthCheck();
    }

    @Override
    public String getBackendType() {
        return "MySQL";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public QuestTeam loadTeam(UUID teamId) {
        try (Connection conn = this.connectionManager.getConnection();){
            String query = String.format("SELECT team_data FROM %steams WHERE team_id = ?", this.tablePrefix);
            try (PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.setString(1, teamId.toString());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    String jsonData = rs.getString("team_data");
                    JsonObject json = JsonParser.parseString((String)jsonData).getAsJsonObject();
                    QuestTeam questTeam = QuestTeam.fromJson(json);
                    return questTeam;
                }
            }
            QuestTeam questTeam = null;
            return questTeam;
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to load team " + String.valueOf(teamId) + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public boolean saveTeam(QuestTeam team) {
        boolean bl;
        block15: {
            Connection conn = this.connectionManager.getConnection();
            try {
                String upsert = String.format("    INSERT INTO %steams (team_id, team_data)\n    VALUES (?, ?)\n    ON DUPLICATE KEY UPDATE team_data = VALUES(team_data)\n", this.tablePrefix);
                try (PreparedStatement stmt = conn.prepareStatement(upsert);){
                    stmt.setString(1, team.getTeamId().toString());
                    stmt.setString(2, GSON.toJson((JsonElement)team.toJson()));
                    stmt.executeUpdate();
                }
                bl = true;
                if (conn == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    System.err.println("[Questory] Failed to save team " + team.getTeamName() + ": " + e.getMessage());
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    @Override
    public boolean deleteTeam(UUID teamId) {
        boolean bl;
        block15: {
            Connection conn = this.connectionManager.getConnection();
            try {
                String delete = String.format("DELETE FROM %steams WHERE team_id = ?", this.tablePrefix);
                try (PreparedStatement stmt = conn.prepareStatement(delete);){
                    stmt.setString(1, teamId.toString());
                    stmt.executeUpdate();
                }
                bl = true;
                if (conn == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    System.err.println("[Questory] Failed to delete team " + String.valueOf(teamId) + ": " + e.getMessage());
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<UUID, QuestTeam> loadAllTeams() {
        HashMap<UUID, QuestTeam> teams = new HashMap<UUID, QuestTeam>();
        try (Connection conn = this.connectionManager.getConnection();){
            String query = String.format("SELECT team_id, team_data FROM %steams", this.tablePrefix);
            try (Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(query);){
                while (rs.next()) {
                    try {
                        UUID teamId = UUID.fromString(rs.getString("team_id"));
                        String jsonData = rs.getString("team_data");
                        JsonObject json = JsonParser.parseString((String)jsonData).getAsJsonObject();
                        QuestTeam team = QuestTeam.fromJson(json);
                        if (team == null) continue;
                        teams.put(teamId, team);
                    }
                    catch (Exception e) {
                        System.err.println("[Questory] Failed to parse team data: " + e.getMessage());
                    }
                }
                return teams;
            }
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to load all teams: " + e.getMessage());
        }
        return teams;
    }
}

