/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage.migration;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.storage.backend.IPlayerProgressBackend;
import org.texboobcat.questory.storage.backend.ITeamStorageBackend;
import org.texboobcat.questory.team.QuestTeam;

public class StorageMigrator {
    public static boolean migratePlayerProgress(IPlayerProgressBackend source, IPlayerProgressBackend destination, MigrationProgressCallback progressCallback) {
        try {
            System.out.println("[Questory] Starting player progress migration from " + source.getBackendType() + " to " + destination.getBackendType());
            List<UUID> playerIds = source.getAllPlayerIds();
            int total = playerIds.size();
            AtomicInteger current = new AtomicInteger(0);
            AtomicInteger errors = new AtomicInteger(0);
            System.out.println("[Questory] Found " + total + " players to migrate");
            if (progressCallback != null) {
                progressCallback.onStart(total);
            }
            for (UUID playerId : playerIds) {
                try {
                    QuestProgress progress = source.loadProgress(playerId);
                    if (progress == null) {
                        System.err.println("[Questory] Failed to load progress for player " + String.valueOf(playerId));
                        errors.incrementAndGet();
                        continue;
                    }
                    boolean saved = destination.saveProgress(progress);
                    if (!saved) {
                        System.err.println("[Questory] Failed to save progress for player " + String.valueOf(playerId));
                        errors.incrementAndGet();
                        continue;
                    }
                    int currentCount = current.incrementAndGet();
                    if (currentCount % 10 != 0 && currentCount != total) continue;
                    System.out.println("[Questory] Migrated " + currentCount + "/" + total + " players");
                    if (progressCallback == null) continue;
                    progressCallback.onProgress(currentCount, total);
                }
                catch (Exception e) {
                    System.err.println("[Questory] Error migrating player " + String.valueOf(playerId) + ": " + e.getMessage());
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
            if (progressCallback != null) {
                progressCallback.onComplete(current.get(), errors.get());
            }
            if (errors.get() > 0) {
                System.err.println("[Questory] Migration completed with " + errors.get() + " errors");
                return false;
            }
            System.out.println("[Questory] Successfully migrated " + current.get() + " players");
            return true;
        }
        catch (Exception e) {
            System.err.println("[Questory] Fatal error during migration: " + e.getMessage());
            e.printStackTrace();
            if (progressCallback != null) {
                progressCallback.onError(e);
            }
            return false;
        }
    }

    public static boolean migrateTeams(ITeamStorageBackend source, ITeamStorageBackend destination, MigrationProgressCallback progressCallback) {
        try {
            System.out.println("[Questory] Starting team migration from " + source.getBackendType() + " to " + destination.getBackendType());
            Map<UUID, QuestTeam> teams = source.loadAllTeams();
            int total = teams.size();
            AtomicInteger current = new AtomicInteger(0);
            AtomicInteger errors = new AtomicInteger(0);
            System.out.println("[Questory] Found " + total + " teams to migrate");
            if (progressCallback != null) {
                progressCallback.onStart(total);
            }
            for (Map.Entry<UUID, QuestTeam> entry : teams.entrySet()) {
                try {
                    QuestTeam team = entry.getValue();
                    boolean saved = destination.saveTeam(team);
                    if (!saved) {
                        System.err.println("[Questory] Failed to save team " + String.valueOf(team.getTeamId()));
                        errors.incrementAndGet();
                        continue;
                    }
                    int currentCount = current.incrementAndGet();
                    if (currentCount % 5 != 0 && currentCount != total) continue;
                    System.out.println("[Questory] Migrated " + currentCount + "/" + total + " teams");
                    if (progressCallback == null) continue;
                    progressCallback.onProgress(currentCount, total);
                }
                catch (Exception e) {
                    System.err.println("[Questory] Error migrating team " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
            if (progressCallback != null) {
                progressCallback.onComplete(current.get(), errors.get());
            }
            if (errors.get() > 0) {
                System.err.println("[Questory] Team migration completed with " + errors.get() + " errors");
                return false;
            }
            System.out.println("[Questory] Successfully migrated " + current.get() + " teams");
            return true;
        }
        catch (Exception e) {
            System.err.println("[Questory] Fatal error during team migration: " + e.getMessage());
            e.printStackTrace();
            if (progressCallback != null) {
                progressCallback.onError(e);
            }
            return false;
        }
    }

    public static boolean verifyPlayerMigration(IPlayerProgressBackend source, IPlayerProgressBackend destination, int sampleSize) {
        try {
            List<UUID> sourceIds = source.getAllPlayerIds();
            List<UUID> destIds = destination.getAllPlayerIds();
            if (sourceIds.size() != destIds.size()) {
                System.err.println("[Questory] Verification failed: Player count mismatch. Source: " + sourceIds.size() + ", Destination: " + destIds.size());
                return false;
            }
            System.out.println("[Questory] Verifying migration (" + sampleSize + " samples)...");
            Random random = new Random();
            int toCheck = Math.min(sampleSize, sourceIds.size());
            for (int i = 0; i < toCheck; ++i) {
                String destJson;
                UUID playerId = sourceIds.get(random.nextInt(sourceIds.size()));
                QuestProgress sourceProgress = source.loadProgress(playerId);
                QuestProgress destProgress = destination.loadProgress(playerId);
                if (sourceProgress == null || destProgress == null) {
                    System.err.println("[Questory] Verification failed: Missing data for player " + String.valueOf(playerId));
                    return false;
                }
                String sourceJson = sourceProgress.toJson().toString();
                if (sourceJson.equals(destJson = destProgress.toJson().toString())) continue;
                System.err.println("[Questory] Verification failed: Data mismatch for player " + String.valueOf(playerId));
                return false;
            }
            System.out.println("[Questory] Verification passed! All " + toCheck + " samples matched.");
            return true;
        }
        catch (Exception e) {
            System.err.println("[Questory] Verification error: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static interface MigrationProgressCallback {
        public void onStart(int var1);

        public void onProgress(int var1, int var2);

        public void onComplete(int var1, int var2);

        public void onError(Exception var1);
    }
}

