/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.texboobcat.questory.theme.panel.PanelTemplate;

public class PanelTemplateLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PanelTemplateLoader.class);
    private static final Gson GSON = new Gson();

    public static Map<String, PanelTemplate> loadPanels(String themeName) {
        HashMap<String, PanelTemplate> panels = new HashMap<String, PanelTemplate>();
        Path panelsDir = Paths.get("config", "questory", "themes", themeName, "panels");
        if (Files.exists(panelsDir, new LinkOption[0]) && Files.isDirectory(panelsDir, new LinkOption[0])) {
            try {
                Files.list(panelsDir).filter(p -> p.toString().endsWith(".json")).forEach(path -> {
                    String name = path.getFileName().toString().replace(".json", "");
                    PanelTemplate template = PanelTemplateLoader.loadTemplate(path);
                    if (template != null) {
                        panels.put(name, template);
                        LOGGER.info("Loaded panel template: {}", (Object)name);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Failed to load panel templates from: {}", (Object)panelsDir, (Object)e);
            }
        }
        PanelTemplateLoader.loadDefaultPanels(panels);
        return panels;
    }

    private static void loadDefaultPanels(Map<String, PanelTemplate> panels) {
        String[] defaultPanels;
        for (String name : defaultPanels = new String[]{"quest_details", "chapter_panel", "quest_list_item", "sidebar"}) {
            PanelTemplate template;
            if (panels.containsKey(name) || (template = PanelTemplateLoader.loadDefaultTemplate(name)) == null) continue;
            panels.put(name, template);
            LOGGER.info("Loaded default panel template: {}", (Object)name);
        }
    }

    private static PanelTemplate loadTemplate(Path path) {
        try {
            String json = Files.readString(path, StandardCharsets.UTF_8);
            return PanelTemplateLoader.parseTemplate(path.getFileName().toString().replace(".json", ""), json);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load panel template from: {}", (Object)path, (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PanelTemplate loadDefaultTemplate(String name) {
        String resourcePath = "panels/default/" + name + ".json";
        try (InputStream in = PanelTemplateLoader.class.getClassLoader().getResourceAsStream(resourcePath);){
            String line;
            if (in == null) return null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            PanelTemplate panelTemplate = PanelTemplateLoader.parseTemplate(name, sb.toString());
            return panelTemplate;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load default panel template: {}", (Object)name, (Object)e);
        }
        return null;
    }

    private static PanelTemplate parseTemplate(String name, String json) {
        try {
            JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
            return PanelTemplate.fromJson(name, jsonObject);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse panel template JSON for: {}", (Object)name, (Object)e);
            return null;
        }
    }
}

