/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.texboobcat.questory.api.RewardFactory;
import org.texboobcat.questory.quest.Reward;

public class RewardRegistry {
    private static final Map<String, RewardFactory> REGISTRY = new HashMap<String, RewardFactory>();

    public static void register(String type, RewardFactory factory) {
        if (REGISTRY.containsKey(type)) {
            System.err.println("[Questory API] Warning: Overwriting reward type: " + type);
        }
        REGISTRY.put(type, factory);
        System.out.println("[Questory API] Registered custom reward type: " + type);
    }

    public static Reward create(String type, JsonObject json) {
        RewardFactory factory = REGISTRY.get(type);
        if (factory == null) {
            return null;
        }
        return factory.create(json);
    }

    public static boolean isRegistered(String type) {
        return REGISTRY.containsKey(type);
    }
}

