/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.ChapterDefaultsTabPanel;
import org.texboobcat.questory.client.gui.ChapterGeneralTabPanel;
import org.texboobcat.questory.client.gui.ChapterImagesTabPanel;
import org.texboobcat.questory.client.gui.ChapterLinksTabPanel;
import org.texboobcat.questory.client.gui.ChapterPreviewTabPanel;
import org.texboobcat.questory.network.ChapterDataUpdateRequestPacket;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.quest.ChapterData;

public class ChapterArtEditorScreen
extends Screen {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final int SIDEBAR_W = 240;
    private static final int TAB_H = 24;
    private static final int HEADER_H = 32;
    private static final int FOOTER_H = 36;
    private static final int PAD = 8;
    private final Screen parent;
    private ChapterData workingChapter;
    private String originalId;
    private Tab activeTab = Tab.GENERAL;
    private EditBox searchBox;
    private List<ChapterData> filtered = new ArrayList<ChapterData>();
    private int listScroll = 0;
    private ChapterGeneralTabPanel generalTab;
    private ChapterDefaultsTabPanel defaultsTab;
    private ChapterImagesTabPanel imagesTab;
    private ChapterLinksTabPanel linksTab;
    private ChapterPreviewTabPanel previewTab;
    private Button tabGeneralBtn;
    private Button tabDefaultsBtn;
    private Button tabImagesBtn;
    private Button tabLinksBtn;
    private Button tabPreviewBtn;
    private Button newBtn;
    private Button saveBtn;
    private Button closeBtn;

    public ChapterArtEditorScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Chapter Art Editor"));
        this.parent = parent;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    protected void m_7856_() {
        super.m_7856_();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "chapter_editor");
        this.searchBox = new EditBox(this.f_96547_, 8, 8, 224, 18, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search chapters..."));
        this.m_142416_((GuiEventListener)this.searchBox);
        int tabX = 248;
        int tabY = 8;
        int tabW = 85;
        this.tabGeneralBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"General"), b -> this.switchTab(Tab.GENERAL)).m_252987_(tabX, tabY, tabW, 22).m_253136_());
        this.tabDefaultsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Defaults"), b -> this.switchTab(Tab.DEFAULTS)).m_252987_(tabX += tabW + 2, tabY, tabW, 22).m_253136_());
        this.tabImagesBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Images"), b -> this.switchTab(Tab.IMAGES)).m_252987_(tabX += tabW + 2, tabY, tabW, 22).m_253136_());
        this.tabLinksBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Quest Links"), b -> this.switchTab(Tab.QUEST_LINKS)).m_252987_(tabX += tabW + 2, tabY, tabW + 20, 22).m_253136_());
        this.tabPreviewBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Preview"), b -> this.switchTab(Tab.PREVIEW)).m_252987_(tabX += tabW + 22, tabY, tabW, 22).m_253136_());
        int footerY = this.f_96544_ - 36 + 8;
        int btnX = 248;
        this.newBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"New"), b -> this.createNew()).m_252987_(btnX, footerY, 60, 20).m_253136_());
        this.saveBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252987_(btnX += 64, footerY, 60, 20).m_253136_());
        int closeX = this.f_96543_ - 8 - 60;
        this.closeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(closeX, footerY, 60, 20).m_253136_());
        this.initTabPanels();
        this.reloadChapterList();
        if (!this.filtered.isEmpty()) {
            this.selectChapter(this.filtered.get(0));
        } else {
            this.createNew();
        }
    }

    private void initTabPanels() {
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        this.generalTab = new ChapterGeneralTabPanel(this, contentX, contentY, contentW, contentH);
        this.defaultsTab = new ChapterDefaultsTabPanel(this, contentX, contentY, contentW, contentH);
        this.imagesTab = new ChapterImagesTabPanel(this, contentX, contentY, contentW, contentH);
        this.linksTab = new ChapterLinksTabPanel(this, contentX, contentY, contentW, contentH);
        this.previewTab = new ChapterPreviewTabPanel(this, contentX, contentY, contentW, contentH);
    }

    private void switchTab(Tab tab) {
        if (this.activeTab == tab) {
            return;
        }
        this.saveCurrentTabToChapter();
        this.activeTab = tab;
        this.loadTabFromChapter();
    }

    private void saveCurrentTabToChapter() {
        if (this.workingChapter == null) {
            return;
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.saveToChapter(this.workingChapter);
                break;
            }
            case 1: {
                this.defaultsTab.saveToChapter(this.workingChapter);
                break;
            }
            case 2: {
                this.imagesTab.saveToChapter(this.workingChapter);
                break;
            }
            case 3: {
                this.linksTab.saveToChapter(this.workingChapter);
            }
        }
    }

    private void loadTabFromChapter() {
        if (this.workingChapter == null) {
            return;
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 1: {
                this.defaultsTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 2: {
                this.imagesTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 3: {
                this.linksTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 4: {
                this.previewTab.loadFromChapter(this.workingChapter);
            }
        }
    }

    private void reloadChapterList() {
        String query = this.searchBox.m_94155_().trim().toLowerCase();
        ArrayList<ChapterData> all = new ArrayList<ChapterData>(ClientQuestManager.getInstance().getAllChapters());
        all.sort((a, b) -> a.getTitle().compareToIgnoreCase(b.getTitle()));
        this.filtered = query.isEmpty() ? all : all.stream().filter(ch -> ch.getId().toLowerCase().contains(query) || ch.getTitle().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    private void selectChapter(ChapterData chapter) {
        this.saveCurrentTabToChapter();
        this.workingChapter = chapter;
        this.originalId = chapter.getId();
        this.loadTabFromChapter();
    }

    private void createNew() {
        this.saveCurrentTabToChapter();
        this.workingChapter = new ChapterData("chapter_" + System.currentTimeMillis(), "New Chapter");
        this.originalId = null;
        this.activeTab = Tab.GENERAL;
        this.loadTabFromChapter();
    }

    private void save() {
        block4: {
            if (this.workingChapter == null) {
                return;
            }
            this.saveCurrentTabToChapter();
            try {
                JsonObject json = this.workingChapter.toJson();
                String payload = GSON.toJson((JsonElement)json);
                NetworkManager.sendToServer(new ChapterDataUpdateRequestPacket(payload));
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aChapter saved successfully"));
                }
                this.originalId = this.workingChapter.getId();
            }
            catch (Exception e) {
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block4;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7cSave failed: " + e.getMessage())));
            }
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280509_(0, 0, 240, this.f_96544_, -804253680);
        int listTop = 32;
        int listBottom = this.f_96544_ - 8;
        g.m_280509_(8, listTop, 232, listBottom, -534765536);
        this.renderChapterList(g, mouseX, mouseY);
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        g.m_280509_(contentX, contentY, contentX + contentW, contentY + contentH, -535291880);
        this.renderActiveTab(g, mouseX, mouseY, partialTick);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280430_(this.f_96547_, this.f_96539_, 248, -4, -1);
    }

    private void renderChapterList(GuiGraphics g, int mouseX, int mouseY) {
        this.reloadChapterList();
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        g.m_280588_(listX, listTop, listX + listW, listBottom);
        int maxLines = Math.max(1, (listBottom - listTop) / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.filtered.size() - maxLines)));
        for (int i = 0; i < Math.min(maxLines, this.filtered.size() - this.listScroll); ++i) {
            boolean hover;
            ChapterData ch = this.filtered.get(this.listScroll + i);
            int y = listTop + 2 + i * lineH;
            boolean selected = this.workingChapter != null && this.workingChapter.getId().equals(ch.getId());
            boolean bl = hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= y && mouseY < y + lineH;
            if (selected) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -12952966);
            } else if (hover) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -14013910);
            }
            Object label = ch.getTitle();
            if (this.f_96547_.m_92895_((String)label) > listW - 4) {
                label = this.f_96547_.m_92834_((String)label, listW - 10) + "...";
            }
            g.m_280488_(this.f_96547_, (String)label, listX + 2, y, -1);
        }
        g.m_280618_();
    }

    private void renderActiveTab(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 1: {
                this.defaultsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 2: {
                this.imagesTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 3: {
                this.linksTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 4: {
                this.previewTab.render(g, mouseX, mouseY, partialTick);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean tabHandled;
        int relY;
        int index;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom && (index = this.listScroll + (relY = (int)mouseY - listTop - 2) / lineH) >= 0 && index < this.filtered.size()) {
            this.selectChapter(this.filtered.get(index));
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 1: {
                boolean bl = this.defaultsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 2: {
                boolean bl = this.imagesTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 3: {
                boolean bl = this.linksTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 4: {
                boolean bl = tabHandled = this.previewTab.mouseClicked(mouseX, mouseY, button);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean tabHandled;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta) * 3.0);
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 1: {
                boolean bl = this.defaultsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 2: {
                boolean bl = this.imagesTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 3: {
                boolean bl = this.linksTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 4: {
                boolean bl = tabHandled = this.previewTab.mouseScrolled(mouseX, mouseY, delta);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum Tab {
        GENERAL,
        DEFAULTS,
        IMAGES,
        QUEST_LINKS,
        PREVIEW;

    }
}

