/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ColorPickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<Integer> onSelect;
    private int selectedColor;
    private EditBox hexField;
    private Button saveBtn;
    private Button cancelBtn;
    private static final int[] PRESETS = new int[]{0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0, 0x808080, 0xC0C0C0, 0x800000, 32768, 128, 0x808000, 0x800080, 32896};

    public ColorPickerScreen(Screen parent, int currentColor, Consumer<Integer> onSelect) {
        super((Component)Component.m_237113_((String)"Pick Color"));
        this.parent = parent;
        this.selectedColor = currentColor;
        this.onSelect = onSelect;
    }

    protected void m_7856_() {
        super.m_7856_();
        int panelW = 300;
        int panelX = (this.f_96543_ - panelW) / 2;
        int fieldY = this.f_96544_ / 2 - 60;
        this.hexField = new EditBox(this.f_96547_, panelX + 60, fieldY, 120, 18, (Component)Component.m_237113_((String)"hex"));
        this.hexField.m_94144_(String.format("%06X", this.selectedColor & 0xFFFFFF));
        this.hexField.m_257771_((Component)Component.m_237113_((String)"RRGGBB"));
        this.m_142416_((GuiEventListener)this.hexField);
        int btnY = this.f_96544_ / 2 + 80;
        this.saveBtn = Button.m_253074_((Component)Component.m_237113_((String)"Select"), b -> this.save()).m_252987_(panelX + panelW - 130, btnY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveBtn);
        this.cancelBtn = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(panelX + panelW - 65, btnY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelBtn);
    }

    private void save() {
        try {
            String hex = this.hexField.m_94155_().trim();
            if (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            int color = (int)Long.parseLong(hex, 16);
            this.onSelect.accept(color | 0xFF000000);
        }
        catch (Exception e) {
            this.onSelect.accept(this.selectedColor);
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        int panelW = 300;
        int panelX = (this.f_96543_ - panelW) / 2;
        int panelY = this.f_96544_ / 2 - 100;
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, panelY, -1);
        int fieldY = panelY + 40;
        g.m_280488_(this.f_96547_, "Hex:", panelX + 12, fieldY + 5, -1);
        int previewY = fieldY + 30;
        g.m_280509_(panelX + 12, previewY, panelX + 12 + 40, previewY + 40, -16777216);
        try {
            String hex = this.hexField.m_94155_().trim();
            if (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            int color = (int)Long.parseLong(hex, 16) | 0xFF000000;
            g.m_280509_(panelX + 14, previewY + 2, panelX + 14 + 36, previewY + 36, color);
        }
        catch (Exception hex) {
            // empty catch block
        }
        int presetY = previewY;
        g.m_280488_(this.f_96547_, "Presets:", panelX + 60, presetY - 12, -1);
        int px = panelX + 60;
        int py = presetY;
        for (int i = 0; i < PRESETS.length; ++i) {
            int color = PRESETS[i] | 0xFF000000;
            g.m_280509_(px, py, px + 20, py + 20, -16777216);
            g.m_280509_(px + 1, py + 1, px + 19, py + 19, color);
            if (mouseX >= px && mouseX < px + 20 && mouseY >= py && mouseY < py + 20) {
                g.m_280509_(px, py, px + 20, py + 20, -1426063361);
            }
            px += 22;
            if ((i + 1) % 8 != 0) continue;
            px = panelX + 60;
            py += 22;
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int panelX = (this.f_96543_ - 300) / 2;
            int panelY = this.f_96544_ / 2 - 100;
            int presetY = panelY + 70;
            int px = panelX + 60;
            int py = presetY;
            for (int i = 0; i < PRESETS.length; ++i) {
                if (mouseX >= (double)px && mouseX < (double)(px + 20) && mouseY >= (double)py && mouseY < (double)(py + 20)) {
                    this.hexField.m_94144_(String.format("%06X", PRESETS[i]));
                    return true;
                }
                px += 22;
                if ((i + 1) % 8 != 0) continue;
                px = panelX + 60;
                py += 22;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }
}

