/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.texboobcat.questory.client.gui.NewThemeEditorScreen;

class IconPickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<String> onOk;
    private String initial;
    private EditBox pathBox;
    private EditBox tileBox;
    private EditBox colorBox;
    private EditBox searchBox;
    private List<ResourceLocation> resources = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> filtered = new ArrayList<ResourceLocation>();
    private int listScroll = 0;
    private String nsFilter = "all";
    private ResourceLocation selectedRL = null;
    private static final int PAD = 12;
    private static final int TOP_H = 24;
    private static final int BOTTOM_H = 34;
    private int browserX;
    private int browserY;
    private int browserW;
    private int browserH;
    private int rightX;
    private int rightY;
    private int rightW;
    private int rightH;

    protected IconPickerScreen(Screen parent, String seed, Consumer<String> onOk) {
        super((Component)Component.m_237113_((String)"Icon Browser"));
        this.parent = parent;
        this.initial = seed == null ? "" : seed;
        this.onOk = onOk;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.browserX = 12;
        this.browserY = 60;
        this.browserW = (int)((double)(this.f_96543_ - 36) * 0.6);
        this.browserH = this.f_96544_ - this.browserY - 34 - 12;
        this.rightX = this.browserX + this.browserW + 12;
        this.rightY = 36;
        this.rightW = this.f_96543_ - this.rightX - 12;
        this.rightH = this.f_96544_ - this.rightY - 34 - 12;
        this.searchBox = new EditBox(this.f_96547_, this.browserX, 36, this.browserW, 18, (Component)Component.m_237113_((String)"Search textures..."));
        this.searchBox.m_94199_(200);
        this.searchBox.m_94144_("");
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Type to filter textures..."));
        this.m_142416_((GuiEventListener)this.searchBox);
        int tx = this.browserX;
        int ty = 58;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"All"), b -> {
            this.nsFilter = "all";
            this.updateFiltered();
        }).m_252987_(tx, ty, 48, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Minecraft"), b -> {
            this.nsFilter = "minecraft";
            this.updateFiltered();
        }).m_252987_(tx += 52, ty, 70, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"FTBQuests"), b -> {
            this.nsFilter = "ftbquests";
            this.updateFiltered();
        }).m_252987_(tx += 74, ty, 70, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Other"), b -> {
            this.nsFilter = "other";
            this.updateFiltered();
        }).m_252987_(tx += 74, ty, 48, 18).m_253136_());
        int fy = this.rightY + 60;
        this.pathBox = new EditBox(this.f_96547_, this.rightX, fy, this.rightW, 18, (Component)Component.m_237113_((String)"Path"));
        this.pathBox.m_94199_(500);
        this.pathBox.m_94144_(IconPickerScreen.extractPath(this.initial));
        this.pathBox.m_257771_((Component)Component.m_237113_((String)"namespace:path or item:id or tag:id"));
        this.m_142416_((GuiEventListener)this.pathBox);
        this.tileBox = new EditBox(this.f_96547_, this.rightX, fy += 24, (this.rightW - 4) / 2, 18, (Component)Component.m_237113_((String)"tile_size"));
        this.tileBox.m_94199_(10);
        this.tileBox.m_94144_(IconPickerScreen.extractModifier(this.initial, "tile_size"));
        this.tileBox.m_257771_((Component)Component.m_237113_((String)"Optional tile size"));
        this.m_142416_((GuiEventListener)this.tileBox);
        this.colorBox = new EditBox(this.f_96547_, this.rightX + (this.rightW + 4) / 2, fy, (this.rightW - 4) / 2, 18, (Component)Component.m_237113_((String)"color"));
        this.colorBox.m_94199_(20);
        this.colorBox.m_94144_(IconPickerScreen.extractModifier(this.initial, "color"));
        this.colorBox.m_257771_((Component)Component.m_237113_((String)"Optional tint #AARRGGBB"));
        this.m_142416_((GuiEventListener)this.colorBox);
        int bx = this.f_96543_ / 2 - 60;
        int by = this.f_96544_ - 34 + 6;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"OK"), b -> {
            String result = this.build();
            if (!this.validateResource(result) && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7eWarning: texture not found"));
            }
            this.onOk.accept(result);
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(bx, by, 56, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(bx + 60, by, 56, 20).m_253136_());
        this.loadResources();
        this.updateFiltered();
    }

    private void loadResources() {
        try {
            ResourceManager rm = Minecraft.m_91087_().m_91098_();
            Map map = rm.m_214159_("textures", rl -> rl.m_135815_().endsWith(".png"));
            this.resources = new ArrayList(map.keySet());
            Collections.sort(this.resources, (a, b) -> a.toString().compareTo(b.toString()));
        }
        catch (Throwable t) {
            this.resources = Collections.emptyList();
        }
    }

    private void updateFiltered() {
        this.filtered.clear();
        String q = this.searchBox == null ? "" : this.searchBox.m_94155_().trim().toLowerCase();
        for (ResourceLocation rl : this.resources) {
            boolean qok;
            boolean bl = qok = q.isEmpty() || rl.toString().toLowerCase().contains(q);
            if (!qok) continue;
            String ns = rl.m_135827_();
            boolean nsok = this.nsFilter.equals("all") || this.nsFilter.equals("other") && !ns.equals("minecraft") && !ns.equals("ftbquests") || ns.equals(this.nsFilter);
            if (!nsok) continue;
            this.filtered.add(rl);
        }
        this.listScroll = 0;
    }

    private boolean validateResource(String value) {
        try {
            String v = value.trim();
            if (v.isEmpty() || v.startsWith("item:") || v.startsWith("tag:") || v.equals("builtin")) {
                return true;
            }
            String rlStr = IconPickerScreen.extractPath(v);
            ResourceLocation rl = new ResourceLocation(rlStr);
            ResourceManager rm = Minecraft.m_91087_().m_91098_();
            Optional opt = rm.m_213713_(rl);
            if (opt.isPresent()) {
                return true;
            }
            if (!rl.m_135815_().startsWith("textures/")) {
                rl = new ResourceLocation(rl.m_135827_(), "textures/" + rl.m_135815_());
                return rm.m_213713_(rl).isPresent();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String build() {
        String c;
        String p = this.pathBox.m_94155_().trim();
        ArrayList<CallSite> mods = new ArrayList<CallSite>();
        String t = this.tileBox.m_94155_().trim();
        if (!t.isEmpty()) {
            mods.add((CallSite)((Object)("tile_size=" + t)));
        }
        if (!(c = this.colorBox.m_94155_().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("color=" + c)));
        }
        if (mods.isEmpty()) {
            return p;
        }
        StringBuilder sb = new StringBuilder(p);
        for (String string : mods) {
            sb.append("; ").append(string);
        }
        return sb.toString();
    }

    private static String extractPath(String s) {
        if (s == null) {
            return "";
        }
        int semi = s.indexOf(59);
        return semi < 0 ? s.trim() : s.substring(0, semi).trim();
    }

    private static String extractModifier(String s, String k) {
        if (s == null) {
            return "";
        }
        int idx = s.indexOf(k + "=");
        if (idx < 0) {
            return "";
        }
        String sub = s.substring(idx + k.length() + 1).trim();
        int semi = sub.indexOf(59);
        return (semi < 0 ? sub : sub.substring(0, semi)).trim();
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float p) {
        this.m_280273_(g);
        g.m_280430_(this.f_96547_, this.f_96539_, 12, 12, -1);
        if (this.searchBox != null && this.m_7222_() == this.searchBox) {
            String q = this.searchBox.m_94155_().trim().toLowerCase();
            this.updateFiltered();
        }
        g.m_280509_(this.browserX, this.browserY, this.browserX + this.browserW, this.browserY + this.browserH, -535818224);
        int lineH = 18;
        int visibleLines = Math.max(1, this.browserH / lineH);
        int maxScroll = Math.max(0, this.filtered.size() - visibleLines);
        this.listScroll = Math.max(0, Math.min(this.listScroll, maxScroll));
        g.m_280588_(this.browserX, this.browserY, this.browserX + this.browserW, this.browserY + this.browserH);
        for (int i = 0; i < visibleLines && this.listScroll + i < this.filtered.size(); ++i) {
            ResourceLocation rl = this.filtered.get(this.listScroll + i);
            int y = this.browserY + i * lineH;
            boolean hover = mx >= this.browserX && mx <= this.browserX + this.browserW && my >= y && my < y + lineH;
            boolean selected = rl.equals((Object)this.selectedRL);
            if (selected) {
                g.m_280509_(this.browserX, y, this.browserX + this.browserW, y + lineH, -12952966);
            } else if (hover) {
                g.m_280509_(this.browserX, y, this.browserX + this.browserW, y + lineH, -14013910);
            }
            try {
                g.m_280163_(rl, this.browserX + 2, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object txt = rl.toString();
            if (this.f_96547_.m_92895_((String)txt) > this.browserW - 24) {
                txt = ((String)txt).substring(0, Math.max(0, (this.browserW - 24) / 6)) + "...";
            }
            g.m_280488_(this.f_96547_, (String)txt, this.browserX + 22, y + 5, -1);
        }
        g.m_280618_();
        g.m_280509_(this.rightX, this.rightY, this.rightX + this.rightW, this.rightY + this.rightH, -535818224);
        g.m_280488_(this.f_96547_, "Preview:", this.rightX + 4, this.rightY + 4, -5592321);
        if (this.selectedRL != null) {
            int px = this.rightX + this.rightW / 2 - 32;
            int py = this.rightY + 24;
            try {
                g.m_280509_(px - 2, py - 2, px + 66, py + 66, -12566464);
                g.m_280163_(this.selectedRL, px, py, 0.0f, 0.0f, 64, 64, 64, 64);
            }
            catch (Throwable y) {
                // empty catch block
            }
        }
        int recentY = this.rightY + 100;
        g.m_280488_(this.f_96547_, "Recent:", this.rightX + 4, recentY, -5592321);
        List<String> rec = NewThemeEditorScreen.getRecentIconsSnapshot();
        int ry = recentY + 12;
        for (int i = 0; i < Math.min(5, rec.size()); ++i) {
            Object s = rec.get(i);
            if (this.f_96547_.m_92895_((String)s) > this.rightW - 8) {
                s = ((String)s).substring(0, Math.max(0, (this.rightW - 8) / 6)) + "...";
            }
            g.m_280488_(this.f_96547_, (String)s, this.rightX + 6, ry, -3355444);
            ry += 10;
        }
        super.m_88315_(g, mx, my, p);
    }

    public boolean m_6375_(double mx, double my, int btn) {
        int lineH;
        int row;
        int idx;
        if (mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW) && my >= (double)this.browserY && my <= (double)(this.browserY + this.browserH) && (idx = this.listScroll + (row = (int)((my - (double)this.browserY) / (double)(lineH = 18)))) >= 0 && idx < this.filtered.size()) {
            this.selectedRL = this.filtered.get(idx);
            this.pathBox.m_94144_(this.selectedRL.m_135827_() + ":" + this.selectedRL.m_135815_());
            return true;
        }
        return super.m_6375_(mx, my, btn);
    }

    public boolean m_6050_(double mx, double my, double d) {
        if (mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW) && my >= (double)this.browserY && my <= (double)(this.browserY + this.browserH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(d) * 3.0);
            return true;
        }
        return super.m_6050_(mx, my, d);
    }

    public boolean m_7043_() {
        return false;
    }
}

