/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.rendering.AnimationHelper;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.ThemeLoader;
import org.texboobcat.questory.theme.property.ColorProperty;
import org.texboobcat.questory.theme.property.DoubleProperty;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.IntProperty;
import org.texboobcat.questory.theme.property.StringProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;
import org.texboobcat.questory.theme.property.ThemeProperty;

public class ThemeEditorScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeEditorScreen.class);
    private static final int PANEL_WIDTH = 300;
    private static final int PREVIEW_WIDTH = 400;
    private static final int SPACING = 10;
    private final Screen parent;
    private QuestTheme currentTheme;
    private String themeName = "custom_theme";
    private EditBox themeNameBox;
    private EditBox propertySearchBox;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int contentTopY = 200;
    private int contentBottomY = 0;
    private final Map<String, PropertyEditor> propertyEditors = new HashMap<String, PropertyEditor>();
    private final List<String> propertyCategories = new ArrayList<String>();
    private final Map<String, String> propertyCategoryByLabel = new HashMap<String, String>();
    private final Map<String, String> propertyKeyByLabel = new HashMap<String, String>();
    private String selectedCategory = "Quest Appearance";
    private final List<EditorSlot> visibleEditorSlots = new ArrayList<EditorSlot>();
    private EditorSlot draggingSliderSlot = null;
    private boolean draggingSlider = false;
    private EditBox activeTextEditor = null;
    private EditorSlot activeTextSlot = null;
    private boolean previewDirty = true;
    private long lastPreviewUpdate = 0L;
    private static final String[] BUILTIN_PRESETS = new String[]{"dark", "light", "ftb_like", "minimal"};
    private int presetIndex = 0;

    public ThemeEditorScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Theme Editor"));
        this.parent = parent;
        this.currentTheme = new QuestTheme();
        this.initializePropertyCategories();
    }

    public ThemeEditorScreen(Screen parent, QuestTheme theme, String name) {
        this(parent);
        this.currentTheme = theme;
        this.themeName = name;
    }

    private void initializePropertyCategories() {
        this.propertyCategories.add("Quest Appearance");
        this.propertyCategories.add("Colors");
        this.propertyCategories.add("Dependency Lines");
        this.propertyCategories.add("Background");
        this.propertyCategories.add("Icons");
        this.propertyCategories.add("Animation");
    }

    protected void m_7856_() {
        super.m_7856_();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "theme_editor");
        this.themeNameBox = new EditBox(this.f_96547_, this.f_96543_ - 300 + 10, 30, 280, 20, (Component)Component.m_237113_((String)"Theme Name"));
        this.themeNameBox.m_94144_(this.themeName);
        this.themeNameBox.m_94199_(50);
        this.m_142416_((GuiEventListener)this.themeNameBox);
        int categoryY = 60;
        for (String category : this.propertyCategories) {
            Button categoryButton = Button.m_253074_((Component)Component.m_237113_((String)category), b -> this.selectCategory(category)).m_252987_(this.f_96543_ - 300 + 10, categoryY, 280, 20).m_253136_();
            this.m_142416_((GuiEventListener)categoryButton);
            categoryY += 25;
        }
        this.propertySearchBox = new EditBox(this.f_96547_, this.f_96543_ - 300 + 10, categoryY + 5, 280, 18, (Component)Component.m_237113_((String)"Search"));
        this.propertySearchBox.m_94144_("");
        this.m_142416_((GuiEventListener)this.propertySearchBox);
        this.contentTopY = this.propertySearchBox.m_252907_() + this.propertySearchBox.m_93694_() + 8;
        this.contentBottomY = this.f_96544_ - 60;
        int bottomY = this.f_96544_ - 30;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save Theme"), b -> this.saveTheme()).m_252987_(this.f_96543_ - 300 + 10, bottomY, 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Load"), b -> this.loadTheme()).m_252987_(this.f_96543_ - 300 + 100, bottomY, 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset"), b -> this.resetTheme()).m_252987_(this.f_96543_ - 300 + 170, bottomY, 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(this.f_96543_ - 300 + 240, bottomY, 50, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Apply & Back"), b -> {
            this.saveTheme();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(this.f_96543_ - 300 + 120, bottomY, 110, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Preset"), b -> this.loadNextPreset()).m_252987_(this.f_96543_ - 300 + 10, bottomY - 26, 70, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Export JSON"), b -> this.exportThemeJson()).m_252987_(this.f_96543_ - 300 + 10 + 75, bottomY - 26, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Import JSON"), b -> this.importThemeJson()).m_252987_(this.f_96543_ - 300 + 10 + 180, bottomY - 26, 100, 20).m_253136_());
        this.initializePropertyEditors();
        this.assignPropertyCategories();
        if (!this.propertyCategories.isEmpty()) {
            this.selectedCategory = this.propertyCategories.get(0);
        }
    }

    private void initializePropertyEditors() {
        this.propertyEditors.clear();
        this.propertyCategoryByLabel.clear();
        this.propertyKeyByLabel.clear();
        try {
            Field[] fields;
            for (Field f : fields = ThemeProperties.class.getFields()) {
                PropertyEditor editor;
                Object v = f.get(null);
                if (!(v instanceof ThemeProperty)) continue;
                ThemeProperty tp = (ThemeProperty)v;
                String key = tp.getName();
                String label = this.toDisplayLabel(key);
                if (v instanceof ColorProperty) {
                    int seed = (Integer)((ColorProperty)v).get();
                    editor = new ColorEditor(key, seed);
                } else if (v instanceof IntProperty) {
                    IntProperty ip = (IntProperty)v;
                    int seed = (Integer)ip.get();
                    editor = new NumberEditor(key, String.valueOf(seed), true);
                } else if (v instanceof DoubleProperty) {
                    DoubleProperty dp = (DoubleProperty)v;
                    double seed = (Double)dp.get();
                    editor = new NumberEditor(key, this.trimDouble(seed), false);
                } else if (v instanceof IconProperty) {
                    IconProperty ic = (IconProperty)v;
                    IconProperty.IconData data = (IconProperty.IconData)ic.get();
                    editor = new TextEditor(key, data == null ? "" : data.toString());
                } else {
                    if (!(v instanceof StringProperty)) continue;
                    StringProperty sp = (StringProperty)v;
                    editor = new TextEditor(key, (String)sp.get());
                }
                this.propertyEditors.put(label, editor);
                this.propertyKeyByLabel.put(label, key);
                String cat = this.categorizeKey(key, v);
                this.propertyCategoryByLabel.put(label, cat);
                if (this.propertyCategories.contains(cat)) continue;
                this.propertyCategories.add(cat);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to build editors from ThemeProperties", t);
        }
    }

    private void selectCategory(String category) {
        if (category != null) {
            this.selectedCategory = category;
        }
        this.scrollOffset = 0;
        this.previewDirty = true;
    }

    private void assignPropertyCategories() {
        if (this.propertyCategories.isEmpty()) {
            this.propertyCategories.add("Quest Appearance");
            this.propertyCategories.add("Colors");
            this.propertyCategories.add("Dependency Lines");
            this.propertyCategories.add("Background");
            this.propertyCategories.add("Icons");
            this.propertyCategories.add("Animation");
        }
    }

    private void saveTheme() {
        block13: {
            String name = this.themeNameBox.m_94155_();
            if (name.isEmpty()) {
                name = "custom_theme";
            }
            try {
                Path configDir = Paths.get("config", "questory", "themes");
                Files.createDirectories(configDir, new FileAttribute[0]);
                Path themePath = configDir.resolve(name + ".txt");
                try (BufferedWriter writer = Files.newBufferedWriter(themePath, new OpenOption[0]);){
                    writer.write("// Questory Theme: " + name);
                    writer.newLine();
                    writer.write("// Generated by Theme Editor");
                    writer.newLine();
                    writer.newLine();
                    writer.write("[*]");
                    writer.newLine();
                    for (Map.Entry<String, PropertyEditor> entry : this.propertyEditors.entrySet()) {
                        String key;
                        String display = entry.getKey();
                        Object value = entry.getValue().getValue();
                        if (value == null || (key = this.propertyKeyByLabel.get(display)) == null || key.isEmpty()) continue;
                        String valueStr = this.formatPropertyValue(value);
                        writer.write(key + ": " + valueStr);
                        writer.newLine();
                    }
                    String bg = this.buildBackgroundIconString((String)this.getEditorValue("Background Path"), (Number)this.getEditorValue("Background Tile Size"), (Integer)this.getEditorValue("Background Tint"));
                    if (bg != null) {
                        writer.write("background: " + bg);
                        writer.newLine();
                    }
                }
                LOGGER.info("Saved theme to: {}", (Object)themePath);
                QuestTheme.instance = this.currentTheme = ThemeLoader.loadTheme(themePath);
                QuestTheme.instance.clearCache();
                QuestoryConfig config = QuestoryConfig.getInstance();
                config.customThemeName = name;
                QuestoryConfig.save(Paths.get("config", new String[0]));
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Theme saved: " + String.valueOf(themePath.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to save theme", (Throwable)e);
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block13;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to save theme: " + e.getMessage())));
            }
        }
    }

    private String mapDisplayToThemeKey(String displayName) {
        return this.propertyKeyByLabel.get(displayName);
    }

    private Object getEditorValue(String displayName) {
        PropertyEditor ed = this.propertyEditors.get(displayName);
        return ed == null ? null : ed.getValue();
    }

    private String buildBackgroundIconString(String path, Number tileSizeValue, Integer tint) {
        int a;
        int tile;
        if (path == null || path.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(path.trim());
        if (tileSizeValue != null && (tile = Math.max(0, (int)Math.round(tileSizeValue.doubleValue()))) > 0) {
            sb.append("; tile_size=").append(tile);
        }
        if (tint != null && (a = tint >> 24 & 0xFF) != 0) {
            sb.append("; color=").append(String.format("#%08X", tint));
        }
        return sb.toString();
    }

    private String formatPropertyValue(Object value) {
        if (value instanceof Integer) {
            int color = (Integer)value;
            return String.format("#%08X", color);
        }
        if (value instanceof Float) {
            return String.format("%.2f", (Float)value);
        }
        if (value instanceof Double) {
            return this.trimDouble((Double)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        return value.toString();
    }

    private String trimDouble(double d) {
        String s = String.format(Locale.ROOT, "%.4f", d);
        while (s.contains(".") && (s.endsWith("0") || s.endsWith("."))) {
            s = s.substring(0, s.length() - 1);
        }
        return s.isEmpty() ? "0" : s;
    }

    private String toDisplayLabel(String key) {
        String[] parts = key.split("_");
        StringBuilder b = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            b.append(Character.toUpperCase(p.charAt(0))).append(p.length() > 1 ? p.substring(1) : "").append(" ");
        }
        return b.toString().trim();
    }

    private String categorizeKey(String key, Object prop) {
        if (key.contains("dependency_line")) {
            return "Dependency Lines";
        }
        if (key.contains("background")) {
            return "Background";
        }
        if (prop instanceof IconProperty) {
            return "Icons";
        }
        if (prop instanceof ColorProperty) {
            return "Colors";
        }
        if (key.contains("quest") || key.contains("widget") || key.contains("spacing") || key.contains("pinned")) {
            return "Quest Appearance";
        }
        if (key.contains("animation") || key.contains("pulse")) {
            return "Animation";
        }
        return "Quest Appearance";
    }

    private void loadTheme() {
        block7: {
            try {
                Path themesDir = Paths.get("config", "questory", "themes");
                if (!Files.exists(themesDir, new LinkOption[0])) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"No themes directory found"));
                    }
                    return;
                }
                ArrayList themes = new ArrayList();
                Files.list(themesDir).filter(p -> p.toString().endsWith(".txt")).forEach(p -> themes.add(p.getFileName().toString().replace(".txt", "")));
                if (themes.isEmpty()) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("No themes found in " + String.valueOf(themesDir))));
                    }
                    return;
                }
                String themeName = (String)themes.get(0);
                Path themePath = themesDir.resolve(themeName + ".txt");
                QuestTheme.instance = this.currentTheme = ThemeLoader.loadTheme(themePath);
                QuestTheme.instance.clearCache();
                this.previewDirty = true;
                LOGGER.info("Loaded theme: {}", (Object)themeName);
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Loaded theme: " + themeName + " (" + themes.size() + " available)")));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load theme", (Throwable)e);
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block7;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to load theme: " + e.getMessage())));
            }
        }
    }

    private void resetTheme() {
        this.currentTheme = new QuestTheme();
        this.previewDirty = true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.renderEditorPanel(graphics, mouseX, mouseY);
        this.renderPreviewPanel(graphics, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, -1);
        if (this.previewDirty && System.currentTimeMillis() - this.lastPreviewUpdate > 120L) {
            this.applyInMemoryThemeFromEditors();
            this.lastPreviewUpdate = System.currentTimeMillis();
            this.previewDirty = false;
        }
    }

    private void renderEditorPanel(GuiGraphics graphics, int mouseX, int mouseY) {
        int panelX = this.f_96543_ - 300;
        int panelY = 0;
        int panelHeight = this.f_96544_;
        graphics.m_280509_(panelX, panelY, panelX + 300, panelY + panelHeight, -536870912);
        graphics.m_280509_(panelX, panelY, panelX + 2, panelY + panelHeight, -12566464);
        this.visibleEditorSlots.clear();
        this.contentBottomY = this.f_96544_ - 60;
        int panelLeft = this.f_96543_ - 300;
        try {
            graphics.m_280588_(panelLeft, this.contentTopY, 300, Math.max(1, this.contentBottomY - this.contentTopY));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int propertyY = this.contentTopY - this.scrollOffset;
        String filter = this.propertySearchBox != null ? this.propertySearchBox.m_94155_().trim().toLowerCase() : "";
        for (Map.Entry<String, PropertyEditor> entry : this.propertyEditors.entrySet()) {
            String label = entry.getKey();
            String cat = this.propertyCategoryByLabel.getOrDefault(label, "");
            if (!cat.equals(this.selectedCategory)) continue;
            if (!filter.isEmpty() && !label.toLowerCase().contains(filter)) {
                propertyY += 40;
                continue;
            }
            int editorTop = propertyY;
            int editorBottom = propertyY + 40;
            if (editorBottom > this.contentTopY && editorTop < this.contentBottomY) {
                PropertyEditor editor = entry.getValue();
                graphics.m_280488_(this.f_96547_, label, panelLeft + 10, propertyY, -1);
                int edX = panelLeft + 10;
                int edY = propertyY + 12;
                int edW = 280;
                int edH = 20;
                editor.render(graphics, edX, edY, edW, edH, mouseX, mouseY);
                this.visibleEditorSlots.add(new EditorSlot(label, editor, edX, edY, edW, edH));
            }
            propertyY += 40;
        }
        int viewportH = Math.max(0, this.contentBottomY - this.contentTopY);
        int contentH = Math.max(0, propertyY - this.contentTopY);
        this.maxScroll = Math.max(0, contentH - viewportH);
        try {
            graphics.m_280618_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void applyInMemoryThemeFromEditors() {
        try {
            QuestTheme theme;
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("[*]");
            for (Map.Entry<String, PropertyEditor> e : this.propertyEditors.entrySet()) {
                Object val;
                String key = this.propertyKeyByLabel.get(e.getKey());
                if (key == null || (val = e.getValue().getValue()) == null) continue;
                lines.add(key + ": " + this.formatPropertyValue(val));
            }
            QuestTheme.instance = theme = ThemeLoader.parseTheme(lines);
            QuestTheme.instance.clearCache();
        }
        catch (Throwable t) {
            LOGGER.warn("Live apply failed: {}", (Object)t.toString());
        }
    }

    private void renderPreviewPanel(GuiGraphics graphics, int mouseX, int mouseY) {
        int previewX = 10;
        int previewY = 40;
        int previewHeight = this.f_96544_ - 80;
        graphics.m_280509_(previewX, previewY, previewX + 400, previewY + previewHeight, -536870912);
        graphics.m_280509_(previewX, previewY, previewX + 400, previewY + 2, -12566464);
        graphics.m_280137_(this.f_96547_, "Preview", previewX + 200, previewY + 10, -256);
        this.renderPreviewQuest(graphics, previewX + 50, previewY + 100, mouseX, mouseY);
        this.renderPreviewDependencyLine(graphics, previewX + 50, previewY + 100, previewX + 200, previewY + 200);
        this.renderPreviewQuest(graphics, previewX + 200, previewY + 200, mouseX, mouseY);
    }

    private void renderPreviewQuest(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        int size = 40;
        int pulseColor = AnimationHelper.getPulsingColor(-1);
        graphics.m_280509_(x - 1, y - 1, x + size + 1, y + size + 1, pulseColor);
        graphics.m_280509_(x, y, x + size, y + size, -12566464);
        graphics.m_280509_(x + 10, y + 10, x + 30, y + 30, -16711681);
        int indicatorSize = 12;
        graphics.m_280509_(x + size - indicatorSize, y, x + size, y + indicatorSize, -16711936);
    }

    private void renderPreviewDependencyLine(GuiGraphics graphics, int x1, int y1, int x2, int y2) {
        float offset = AnimationHelper.DependencyLineAnimation.getLineOffset(true, 0.001);
        int lineColor = AnimationHelper.DependencyLineAnimation.getAnimatedLineColor(-1, false, true);
        graphics.m_280509_(x1, y1, x2, y1 + 2, lineColor);
        graphics.m_280509_(x2 - 2, y1, x2, y2, lineColor);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseX > (double)(this.f_96543_ - 300) && mouseY >= (double)this.contentTopY && mouseY <= (double)this.contentBottomY) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScroll, (double)this.scrollOffset - delta * 10.0));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handledByWidget = super.m_6375_(mouseX, mouseY, button);
        if (mouseX > (double)(this.f_96543_ - 300) && mouseY >= (double)this.contentTopY && mouseY <= (double)this.contentBottomY) {
            for (EditorSlot s : this.visibleEditorSlots) {
                if (!this.inside(mouseX, mouseY, s)) continue;
                if (s.editor instanceof SliderEditor && button == 0) {
                    float newVal;
                    double ratio = (mouseX - (double)s.x) / (double)Math.max(1, s.w);
                    ratio = Math.max(0.0, Math.min(1.0, ratio));
                    SliderEditor se = (SliderEditor)s.editor;
                    se.current = newVal = (float)((double)se.min + ratio * (double)(se.max - se.min));
                    this.draggingSliderSlot = s;
                    this.draggingSlider = true;
                    this.previewDirty = true;
                    return true;
                }
                if (s.editor instanceof BooleanEditor && button == 0) {
                    BooleanEditor be = (BooleanEditor)s.editor;
                    be.value = !be.value;
                    this.previewDirty = true;
                    return true;
                }
                if (s.editor instanceof ColorEditor && button == 0) {
                    ColorEditor ce = (ColorEditor)s.editor;
                    ce.color = this.nextPaletteColor(ce.color);
                    this.previewDirty = true;
                    return true;
                }
                if (!(s.editor instanceof TextEditor) && !(s.editor instanceof NumberEditor) || button != 0) continue;
                this.openInlineTextEditor(s);
                return true;
            }
            return handledByWidget;
        }
        return handledByWidget;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingSlider && this.draggingSliderSlot != null && this.draggingSliderSlot.editor instanceof SliderEditor && mouseX > (double)(this.f_96543_ - 300) && mouseY >= (double)this.contentTopY && mouseY <= (double)this.contentBottomY) {
            EditorSlot s = this.draggingSliderSlot;
            SliderEditor se = (SliderEditor)s.editor;
            double ratio = (mouseX - (double)s.x) / (double)Math.max(1, s.w);
            ratio = Math.max(0.0, Math.min(1.0, ratio));
            se.current = (float)((double)se.min + ratio * (double)(se.max - se.min));
            this.previewDirty = true;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.draggingSlider = false;
        this.draggingSliderSlot = null;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.activeTextEditor != null) {
            if (keyCode == 257 || keyCode == 335) {
                this.commitInlineTextEditor();
                return true;
            }
            if (keyCode == 256) {
                this.cancelInlineTextEditor();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void openInlineTextEditor(EditorSlot slot) {
        String seed;
        this.cancelInlineTextEditor();
        this.activeTextSlot = slot;
        PropertyEditor propertyEditor = slot.editor;
        if (propertyEditor instanceof TextEditor) {
            TextEditor te = (TextEditor)propertyEditor;
            seed = te.text;
        } else {
            propertyEditor = slot.editor;
            if (propertyEditor instanceof NumberEditor) {
                NumberEditor ne = (NumberEditor)propertyEditor;
                seed = ne.text;
            } else {
                seed = "";
            }
        }
        this.activeTextEditor = new EditBox(this.f_96547_, slot.x, slot.y, slot.w, slot.h, (Component)Component.m_237113_((String)"Value"));
        this.activeTextEditor.m_94144_(seed);
        this.m_142416_((GuiEventListener)this.activeTextEditor);
        this.m_7522_((GuiEventListener)this.activeTextEditor);
    }

    private void commitInlineTextEditor() {
        if (this.activeTextSlot != null && this.activeTextEditor != null) {
            if (this.activeTextSlot.editor instanceof TextEditor) {
                ((TextEditor)this.activeTextSlot.editor).text = this.activeTextEditor.m_94155_();
                this.previewDirty = true;
            } else if (this.activeTextSlot.editor instanceof NumberEditor) {
                ((NumberEditor)this.activeTextSlot.editor).text = this.activeTextEditor.m_94155_();
                this.previewDirty = true;
            }
        }
        this.removeInlineTextEditor();
    }

    private void cancelInlineTextEditor() {
        this.removeInlineTextEditor();
    }

    private void removeInlineTextEditor() {
        if (this.activeTextEditor != null) {
            this.m_169411_((GuiEventListener)this.activeTextEditor);
            this.activeTextEditor = null;
            this.activeTextSlot = null;
        }
    }

    private boolean inside(double mx, double my, EditorSlot s) {
        return mx >= (double)s.x && mx <= (double)(s.x + s.w) && my >= (double)s.y && my <= (double)(s.y + s.h);
    }

    private int nextPaletteColor(int current) {
        int[] palette = new int[]{-1, -16777216, -65536, -16711936, -16776961, -256, -16711681, -65281, -8355712, -12566464};
        for (int i = 0; i < palette.length; ++i) {
            if (palette[i] != current) continue;
            return palette[(i + 1) % palette.length];
        }
        return palette[0];
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void loadNextPreset() {
        block13: {
            try {
                if (this.f_96541_ == null) {
                    return;
                }
                String name = BUILTIN_PRESETS[this.presetIndex];
                this.presetIndex = (this.presetIndex + 1) % BUILTIN_PRESETS.length;
                ResourceLocation rl = new ResourceLocation("questory", "presets/" + name + ".txt");
                ResourceManager rm = this.f_96541_.m_91098_();
                Optional res = rm.m_213713_(rl);
                if (res.isPresent()) {
                    List<String> lines;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Resource)res.get()).m_215507_(), StandardCharsets.UTF_8));){
                        lines = reader.lines().toList();
                    }
                    QuestTheme.instance = this.currentTheme = ThemeLoader.parseTheme(lines);
                    QuestTheme.instance.clearCache();
                    this.themeName = name;
                    if (this.themeNameBox != null) {
                        this.themeNameBox.m_94144_(this.themeName);
                    }
                    this.previewDirty = true;
                    if (this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Loaded preset: " + name)));
                    }
                    break block13;
                }
                if (this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Preset not found: " + name)));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load preset", (Throwable)e);
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block13;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to load preset: " + e.getMessage())));
            }
        }
    }

    private void exportThemeJson() {
        block4: {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                JsonObject root = new JsonObject();
                root.addProperty("name", this.themeNameBox != null ? this.themeNameBox.m_94155_() : this.themeName);
                JsonObject props = new JsonObject();
                for (Map.Entry<String, PropertyEditor> e : this.propertyEditors.entrySet()) {
                    String display = e.getKey();
                    Object v = e.getValue().getValue();
                    if (v == null) continue;
                    props.add(display, this.toJsonPrimitive(v));
                }
                root.add("properties", (JsonElement)props);
                Path dir = Paths.get("config", "questory", "themes");
                Files.createDirectories(dir, new FileAttribute[0]);
                Path out = dir.resolve((this.themeNameBox != null ? this.themeNameBox.m_94155_() : this.themeName) + ".json");
                Files.writeString(out, (CharSequence)gson.toJson((JsonElement)root), new OpenOption[0]);
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Exported JSON: " + String.valueOf(out.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to export JSON", (Throwable)e);
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block4;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to export JSON: " + e.getMessage())));
            }
        }
    }

    private void importThemeJson() {
        block18: {
            Gson gson = new GsonBuilder().create();
            try {
                JsonObject props;
                String name;
                Path dir = Paths.get("config", "questory", "themes");
                if (!Files.exists(dir, new LinkOption[0])) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("No themes dir: " + String.valueOf(dir))));
                    }
                    return;
                }
                Path chosen = null;
                try (Stream<Path> stream = Files.list(dir);){
                    Iterator<Path> iterator = stream.filter(p -> p.toString().endsWith(".json")).toList().iterator();
                    if (iterator.hasNext()) {
                        Path p2;
                        chosen = p2 = iterator.next();
                    }
                }
                if (chosen == null) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"No JSON themes found"));
                    }
                    return;
                }
                String content = Files.readString(chosen);
                JsonObject root = (JsonObject)gson.fromJson(content, JsonObject.class);
                this.themeName = name = root.has("name") ? root.get("name").getAsString() : "imported_theme";
                if (this.themeNameBox != null) {
                    this.themeNameBox.m_94144_(name);
                }
                if ((props = root.getAsJsonObject("properties")) != null) {
                    for (Map.Entry e : props.entrySet()) {
                        PropertyEditor ed = this.propertyEditors.get(e.getKey());
                        if (ed == null) continue;
                        ed.setValue(this.fromJsonPrimitive((JsonElement)e.getValue()));
                    }
                }
                this.previewDirty = true;
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Imported JSON: " + String.valueOf(chosen.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to import JSON", (Throwable)e);
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block18;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to import JSON: " + e.getMessage())));
            }
        }
    }

    private JsonElement toJsonPrimitive(Object v) {
        if (v instanceof Integer) {
            Integer i = (Integer)v;
            return new JsonPrimitive((Number)i);
        }
        if (v instanceof Float) {
            Float f = (Float)v;
            return new JsonPrimitive((Number)f);
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return new JsonPrimitive(b);
        }
        return new JsonPrimitive(String.valueOf(v));
    }

    private Object fromJsonPrimitive(JsonElement el) {
        if (el != null && el.isJsonPrimitive()) {
            JsonPrimitive prim = el.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isNumber()) {
                double d = prim.getAsDouble();
                if (Math.floor(d) == d) {
                    return (int)d;
                }
                return Float.valueOf((float)d);
            }
            if (prim.isString()) {
                return prim.getAsString();
            }
        }
        return null;
    }

    private static class EditorSlot {
        final String label;
        final PropertyEditor editor;
        final int x;
        final int y;
        final int w;
        final int h;

        EditorSlot(String label, PropertyEditor editor, int x, int y, int w, int h) {
            this.label = label;
            this.editor = editor;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }

    private static class ColorEditor
    extends PropertyEditor {
        private int color;

        public ColorEditor(String name, int defaultColor) {
            super(name);
            this.color = defaultColor;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.m_280509_(x, y, x + height, y + height, this.color);
            graphics.m_280509_(x, y, x + height, y + 1, -1);
            graphics.m_280509_(x, y, x + 1, y + height, -1);
            graphics.m_280509_(x + height - 1, y, x + height, y + height, -1);
            graphics.m_280509_(x, y + height - 1, x + height, y + height, -1);
            String hexStr = String.format("#%08X", this.color);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, hexStr, x + height + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.color;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Integer) {
                this.color = (Integer)value;
            }
        }
    }

    private static class NumberEditor
    extends PropertyEditor {
        private String text;
        private final boolean isInt;

        public NumberEditor(String name, String initial, boolean isInt) {
            super(name);
            this.text = initial == null ? "0" : initial;
            this.isInt = isInt;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.m_280509_(x, y, x + width, y + height, -14671840);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, this.text, x + 2, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            try {
                if (this.isInt) {
                    return Integer.parseInt(this.text.trim());
                }
                return Double.parseDouble(this.text.trim());
            }
            catch (Exception e) {
                return this.isInt ? 0.0 : 0.0;
            }
        }

        @Override
        public void setValue(Object value) {
            this.text = value == null ? "" : String.valueOf(value);
        }
    }

    private static class TextEditor
    extends PropertyEditor {
        private String text;

        public TextEditor(String name, String defaultValue) {
            super(name);
            this.text = defaultValue;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.m_280509_(x, y, x + width, y + height, -14671840);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, this.text, x + 2, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.text;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof String) {
                this.text = (String)value;
            }
        }
    }

    private static abstract class PropertyEditor {
        protected String propertyName;

        public PropertyEditor(String propertyName) {
            this.propertyName = propertyName;
        }

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public abstract Object getValue();

        public abstract void setValue(Object var1);
    }

    private static class SliderEditor
    extends PropertyEditor {
        private float min;
        private float max;
        private float current;

        public SliderEditor(String name, float min, float max, float defaultValue) {
            super(name);
            this.min = min;
            this.max = max;
            this.current = defaultValue;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.m_280509_(x, y + height / 2 - 2, x + width, y + height / 2 + 2, -12566464);
            int handleX = (int)((float)x + (this.current - this.min) / (this.max - this.min) * (float)width);
            graphics.m_280509_(handleX - 3, y, handleX + 3, y + height, -1);
            String valueStr = String.format("%.2f", Float.valueOf(this.current));
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, valueStr, x + width + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.current);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Number) {
                this.current = ((Number)value).floatValue();
            }
        }
    }

    private static class BooleanEditor
    extends PropertyEditor {
        private boolean value;

        public BooleanEditor(String name, boolean defaultValue) {
            super(name);
            this.value = defaultValue;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.m_280509_(x, y, x + height, y + height, this.value ? -16711936 : -12566464);
            graphics.m_280509_(x, y, x + height, y + 1, -1);
            graphics.m_280509_(x, y, x + 1, y + height, -1);
            graphics.m_280509_(x + height - 1, y, x + height, y + height, -1);
            graphics.m_280509_(x, y + height - 1, x + height, y + height, -1);
            String label = this.value ? "Enabled" : "Disabled";
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, label, x + height + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Boolean) {
                this.value = (Boolean)value;
            }
        }
    }
}

