/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.forge.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.ThemeLoader;

public class ClientThemeReloadListener
implements PreparableReloadListener {
    private static final ResourceLocation THEME_RL = ResourceLocation.fromNamespaceAndPath((String)"ftbquests", (String)"ftb_quests_theme.txt");

    @NotNull
    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> {
            QuestoryConfig config = QuestoryConfig.getInstance();
            if (config.customThemeName != null && !config.customThemeName.trim().isEmpty()) {
                try {
                    Path themesDir = Paths.get("config", "questory", "themes");
                    Path customThemePath = themesDir.resolve(config.customThemeName.trim() + ".txt");
                    if (Files.exists(customThemePath, new LinkOption[0])) {
                        QuestTheme theme;
                        QuestTheme.instance = theme = ThemeLoader.loadTheme(customThemePath);
                        QuestTheme.instance.clearCache();
                        System.out.println("[Questory] Loaded custom theme: " + config.customThemeName);
                        return;
                    }
                    System.out.println("[Questory] Custom theme not found: " + String.valueOf(customThemePath) + ", falling back to resource pack theme");
                }
                catch (Throwable t) {
                    System.err.println("[Questory] Failed to load custom theme: " + t.getMessage());
                }
            }
            try {
                ArrayList<String> combined = new ArrayList<String>();
                List resources = resourceManager.m_213829_(THEME_RL);
                Object theme = resources.iterator();
                while (theme.hasNext()) {
                    Resource res = (Resource)theme.next();
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(res.m_215507_(), StandardCharsets.UTF_8));){
                        combined.addAll(br.lines().collect(Collectors.toList()));
                        combined.add("");
                    }
                }
                if (!combined.isEmpty()) {
                    QuestTheme.instance = theme = ThemeLoader.parseTheme(combined);
                    QuestTheme.instance.clearCache();
                    System.out.println("[Questory] Loaded theme from ResourceManager: " + String.valueOf(THEME_RL));
                    return;
                }
            }
            catch (Throwable t) {
                System.err.println("[Questory] Failed to load theme from ResourceManager: " + t.getMessage());
            }
            if (QuestTheme.instance == null) {
                QuestTheme.instance = ThemeLoader.createDefaultTheme();
            }
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0));
    }
}

