/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.theme.SelectorProperties;
import org.texboobcat.questory.theme.property.ThemeProperty;

public class QuestTheme {
    public static QuestTheme instance;
    public static Quest currentObject;
    public final List<SelectorProperties> selectors = new ArrayList<SelectorProperties>();
    private final Map<QuestPropertyKey, Object> cache = new HashMap<QuestPropertyKey, Object>();
    private final Map<String, Object> defaultCache = new HashMap<String, Object>();
    public SelectorProperties defaults;

    public void clearCache() {
        this.cache.clear();
        this.defaultCache.clear();
    }

    public <T> T get(ThemeProperty<T> property) {
        String value;
        Object cachedValue = this.defaultCache.get(property.getName());
        if (cachedValue != null) {
            return (T)cachedValue;
        }
        if (this.defaults != null && (value = this.defaults.properties.get(property.getName())) != null && (cachedValue = property.parse(this.replaceVariables(value, 0))) != null) {
            this.defaultCache.put(property.getName(), cachedValue);
            return (T)cachedValue;
        }
        return property.getDefaultValue();
    }

    public <T> T get(ThemeProperty<T> property, Quest quest) {
        if (quest == null) {
            quest = currentObject;
        }
        if (quest == null) {
            return this.get(property);
        }
        QuestPropertyKey key = new QuestPropertyKey(property.getName(), quest.getId());
        Object cachedValue = this.cache.get(key);
        if (cachedValue != null) {
            return (T)cachedValue;
        }
        for (SelectorProperties selectorProperties : this.selectors) {
            String value;
            if (!selectorProperties.selector.matches(quest) || (value = selectorProperties.properties.get(property.getName())) == null || (cachedValue = property.parse(this.replaceVariables(value, 0))) == null) continue;
            this.cache.put(key, cachedValue);
            return (T)cachedValue;
        }
        return this.get(property);
    }

    public String replaceVariables(String value, int iteration) {
        if (iteration >= 30 || this.defaults == null) {
            return value;
        }
        String original = value;
        for (String key : this.defaults.properties.keySet()) {
            value = value.replace("{{" + key + "}}", this.defaults.properties.get(key));
        }
        return original.equals(value) ? value : this.replaceVariables(value, iteration + 1);
    }

    private static class QuestPropertyKey {
        private final String property;
        private final String questId;

        private QuestPropertyKey(String p, String qId) {
            this.property = p;
            this.questId = qId;
        }

        public int hashCode() {
            return this.property.hashCode() * 31 + (this.questId != null ? this.questId.hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (o instanceof QuestPropertyKey) {
                QuestPropertyKey key = (QuestPropertyKey)o;
                return this.property.equals(key.property) && (this.questId == null ? key.questId == null : this.questId.equals(key.questId));
            }
            return false;
        }
    }
}

