/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.ChapterDefaultsTabPanel;
import org.texboobcat.questory.client.gui.ChapterGeneralTabPanel;
import org.texboobcat.questory.client.gui.ChapterImagesTabPanel;
import org.texboobcat.questory.client.gui.ChapterLinksTabPanel;
import org.texboobcat.questory.client.gui.ChapterPreviewTabPanel;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;
import org.texboobcat.questory.client.gui.editor.CloseConfirmationDialog;
import org.texboobcat.questory.client.gui.editor.EditorSettingsScreen;
import org.texboobcat.questory.client.gui.editor.EditorStateManager;
import org.texboobcat.questory.client.gui.editor.ManagedEditor;
import org.texboobcat.questory.client.gui.editor.UnsavedChangesCache;
import org.texboobcat.questory.network.ChapterDataUpdateRequestPacket;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.quest.ChapterData;

public class ChapterArtEditorScreen
extends Screen
implements ManagedEditor<ChapterData> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final int SIDEBAR_W = 240;
    private static final int TAB_H = 24;
    private static final int HEADER_H = 32;
    private static final int FOOTER_H = 36;
    private static final int PAD = 8;
    private final Screen parent;
    private ChapterData workingChapter;
    private String originalId;
    private final EditorStateManager<ChapterData> stateManager;
    private final UnsavedChangesCache<ChapterData> unsavedCache;
    private final AutoSaveManager autoSaveManager;
    private Tab activeTab = Tab.GENERAL;
    private EditBox searchBox;
    private List<ChapterData> filtered = new ArrayList<ChapterData>();
    private int listScroll = 0;
    private ChapterGeneralTabPanel generalTab;
    private ChapterDefaultsTabPanel defaultsTab;
    private ChapterImagesTabPanel imagesTab;
    private ChapterLinksTabPanel linksTab;
    private ChapterPreviewTabPanel previewTab;
    private Button tabGeneralBtn;
    private Button tabDefaultsBtn;
    private Button tabImagesBtn;
    private Button tabLinksBtn;
    private Button tabPreviewBtn;
    private Button newBtn;
    private Button saveBtn;
    private Button closeBtn;
    private Button settingsBtn;

    public ChapterArtEditorScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Chapter Art Editor"));
        this.parent = parent;
        this.stateManager = new EditorStateManager<ChapterData>(this::cloneChapter, ChapterData::getId);
        this.unsavedCache = new UnsavedChangesCache(50);
        this.autoSaveManager = AutoSaveManager.getInstance();
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    @Override
    public EditorStateManager<ChapterData> getStateManager() {
        return this.stateManager;
    }

    @Override
    public void saveEntity(ChapterData chapter) {
        block4: {
            if (chapter == null) {
                return;
            }
            try {
                JsonObject json = chapter.toJson();
                String payload = GSON.toJson((JsonElement)json);
                NetworkManager.sendToServer(new ChapterDataUpdateRequestPacket(payload));
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aChapter saved successfully"));
                }
                this.originalId = chapter.getId();
                this.stateManager.markClean();
                this.unsavedCache.remove(chapter.getId());
            }
            catch (Exception e) {
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block4;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7cSave failed: " + e.getMessage())));
            }
        }
    }

    @Override
    public void autoSaveEntity(ChapterData chapter) {
        if (chapter == null || !this.stateManager.hasUnsavedChanges()) {
            return;
        }
        this.unsavedCache.put(chapter.getId(), chapter, this.getEntityDisplayName(chapter));
    }

    @Override
    public String getEntityDisplayName(ChapterData chapter) {
        if (chapter == null) {
            return "Unknown Chapter";
        }
        String title = chapter.getTitle();
        return title == null || title.isEmpty() ? chapter.getId() : title;
    }

    private ChapterData cloneChapter(ChapterData chapter) {
        if (chapter == null) {
            return null;
        }
        try {
            JsonObject json = chapter.toJson();
            String jsonStr = GSON.toJson((JsonElement)json);
            JsonObject clonedJson = (JsonObject)GSON.fromJson(jsonStr, JsonObject.class);
            return ChapterData.fromJson(clonedJson);
        }
        catch (Exception e) {
            System.err.println("[ChapterEditor] Failed to clone chapter: " + e.getMessage());
            return chapter;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "chapter_editor");
        this.autoSaveManager.register(this.getEditorId(), () -> {
            if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
                this.autoSaveEntity(this.stateManager.getWorkingCopy());
            }
        });
        this.searchBox = new EditBox(this.f_96547_, 8, 8, 224, 18, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search chapters..."));
        this.m_142416_((GuiEventListener)this.searchBox);
        int tabX = 248;
        int tabY = 8;
        int tabW = 85;
        this.tabGeneralBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"General"), b -> this.switchTab(Tab.GENERAL)).m_252987_(tabX, tabY, tabW, 22).m_253136_());
        this.tabDefaultsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Defaults"), b -> this.switchTab(Tab.DEFAULTS)).m_252987_(tabX += tabW + 2, tabY, tabW, 22).m_253136_());
        this.tabImagesBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Images"), b -> this.switchTab(Tab.IMAGES)).m_252987_(tabX += tabW + 2, tabY, tabW, 22).m_253136_());
        this.tabLinksBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Quest Links"), b -> this.switchTab(Tab.QUEST_LINKS)).m_252987_(tabX += tabW + 2, tabY, tabW + 20, 22).m_253136_());
        this.tabPreviewBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Preview"), b -> this.switchTab(Tab.PREVIEW)).m_252987_(tabX += tabW + 22, tabY, tabW, 22).m_253136_());
        int footerY = this.f_96544_ - 36 + 8;
        int btnX = 248;
        this.newBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"New"), b -> this.createNew()).m_252987_(btnX, footerY, 60, 20).m_253136_());
        this.saveBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252987_(btnX += 64, footerY, 60, 20).m_253136_());
        this.settingsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2699"), b -> this.openSettings()).m_252987_(btnX += 64, footerY, 20, 20).m_253136_());
        int closeX = this.f_96543_ - 8 - 60;
        this.closeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(closeX, footerY, 60, 20).m_253136_());
        this.initTabPanels();
        this.reloadChapterList();
        if (this.workingChapter != null && this.stateManager.isLoaded()) {
            this.loadTabFromChapter();
        } else if (this.workingChapter != null) {
            this.stateManager.load(this.workingChapter);
            this.originalId = this.workingChapter.getId();
            this.loadTabFromChapter();
        } else if (!this.filtered.isEmpty()) {
            this.selectChapter(this.filtered.get(0));
        } else {
            this.createNew();
        }
    }

    private void initTabPanels() {
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        this.generalTab = new ChapterGeneralTabPanel(this, contentX, contentY, contentW, contentH);
        this.defaultsTab = new ChapterDefaultsTabPanel(this, contentX, contentY, contentW, contentH);
        this.imagesTab = new ChapterImagesTabPanel(this, contentX, contentY, contentW, contentH);
        this.linksTab = new ChapterLinksTabPanel(this, contentX, contentY, contentW, contentH);
        this.previewTab = new ChapterPreviewTabPanel(this, contentX, contentY, contentW, contentH);
    }

    private void switchTab(Tab tab) {
        if (this.activeTab == tab) {
            return;
        }
        this.saveCurrentTabToChapter();
        this.activeTab = tab;
        this.loadTabFromChapter();
    }

    private void saveCurrentTabToChapter() {
        if (this.workingChapter == null || !this.stateManager.isLoaded()) {
            return;
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.saveToChapter(this.workingChapter);
                break;
            }
            case 1: {
                this.defaultsTab.saveToChapter(this.workingChapter);
                break;
            }
            case 2: {
                this.imagesTab.saveToChapter(this.workingChapter);
                break;
            }
            case 3: {
                this.linksTab.saveToChapter(this.workingChapter);
            }
        }
        this.stateManager.markDirty();
        this.stateManager.setWorkingCopy(this.workingChapter);
    }

    private void loadTabFromChapter() {
        if (this.workingChapter == null) {
            return;
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 1: {
                this.defaultsTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 2: {
                this.imagesTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 3: {
                this.linksTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 4: {
                this.previewTab.loadFromChapter(this.workingChapter);
            }
        }
    }

    private void reloadChapterList() {
        String query = this.searchBox.m_94155_().trim().toLowerCase();
        ArrayList<ChapterData> all = new ArrayList<ChapterData>(ClientQuestManager.getInstance().getAllChapters());
        all.sort((a, b) -> a.getTitle().compareToIgnoreCase(b.getTitle()));
        this.filtered = query.isEmpty() ? all : all.stream().filter(ch -> ch.getId().toLowerCase().contains(query) || ch.getTitle().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    private void selectChapter(ChapterData chapter) {
        Optional<UnsavedChangesCache.CacheEntry<ChapterData>> cachedEntry;
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
            this.saveCurrentTabToChapter();
            this.unsavedCache.put(this.stateManager.getEntityId(), this.stateManager.getWorkingCopy(), this.stateManager.getChangedFields(), this.getEntityDisplayName(this.stateManager.getWorkingCopy()));
        }
        if ((cachedEntry = this.unsavedCache.get(chapter.getId())).isPresent()) {
            this.workingChapter = cachedEntry.get().getEntity();
            this.stateManager.load(this.workingChapter);
            this.stateManager.markDirty();
        } else {
            this.workingChapter = this.cloneChapter(chapter);
            this.stateManager.load(this.workingChapter);
        }
        this.originalId = chapter.getId();
        this.loadTabFromChapter();
    }

    private void createNew() {
        ChapterData newChapter;
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
            this.saveCurrentTabToChapter();
            this.unsavedCache.put(this.stateManager.getEntityId(), this.stateManager.getWorkingCopy(), this.stateManager.getChangedFields(), this.getEntityDisplayName(this.stateManager.getWorkingCopy()));
        }
        this.workingChapter = newChapter = new ChapterData("chapter_" + System.currentTimeMillis(), "New Chapter");
        this.stateManager.load(newChapter);
        this.stateManager.markDirty();
        this.originalId = null;
        this.activeTab = Tab.GENERAL;
        this.loadTabFromChapter();
    }

    private void save() {
        if (this.workingChapter == null || !this.stateManager.isLoaded()) {
            return;
        }
        this.saveCurrentTabToChapter();
        this.saveEntity(this.stateManager.getWorkingCopy());
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280509_(0, 0, 240, this.f_96544_, -804253680);
        int unsavedCount = this.unsavedCache.size();
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges() && !this.unsavedCache.contains(this.stateManager.getEntityId())) {
            ++unsavedCount;
        }
        if (unsavedCount > 0) {
            String unsavedText = "(" + unsavedCount + " unsaved)";
            int textX = 10;
            int textY = 36;
            g.m_280488_(this.f_96547_, unsavedText, textX, textY, -22016);
        }
        if (this.autoSaveManager.isEnabled()) {
            String status = this.autoSaveManager.getStatusString();
            int statusW = this.f_96547_.m_92895_(status);
            int statusX = 232 - statusW;
            int statusY = 50;
            g.m_280488_(this.f_96547_, status, statusX, statusY, -7829368);
        }
        int listTop = 32;
        int listBottom = this.f_96544_ - 8;
        g.m_280509_(8, listTop, 232, listBottom, -534765536);
        this.renderChapterList(g, mouseX, mouseY);
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        g.m_280509_(contentX, contentY, contentX + contentW, contentY + contentH, -535291880);
        this.renderActiveTab(g, mouseX, mouseY, partialTick);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280430_(this.f_96547_, this.f_96539_, 248, -4, -1);
    }

    private void renderChapterList(GuiGraphics g, int mouseX, int mouseY) {
        this.reloadChapterList();
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        g.m_280588_(listX, listTop, listX + listW, listBottom);
        int maxLines = Math.max(1, (listBottom - listTop) / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.filtered.size() - maxLines)));
        for (int i = 0; i < Math.min(maxLines, this.filtered.size() - this.listScroll); ++i) {
            boolean hasUnsavedChanges;
            ChapterData ch = this.filtered.get(this.listScroll + i);
            int y = listTop + 2 + i * lineH;
            boolean selected = this.workingChapter != null && this.workingChapter.getId().equals(ch.getId());
            boolean hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= y && mouseY < y + lineH;
            boolean bl = hasUnsavedChanges = this.unsavedCache.contains(ch.getId()) || selected && this.stateManager.hasUnsavedChanges();
            if (selected) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -12952966);
            } else if (hover) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -14013910);
            }
            Object label = ch.getTitle();
            if (hasUnsavedChanges) {
                label = "* " + (String)label;
            }
            if (this.f_96547_.m_92895_((String)label) > listW - 4) {
                label = this.f_96547_.m_92834_((String)label, listW - 10) + "...";
            }
            int color = hasUnsavedChanges ? -22016 : -1;
            g.m_280488_(this.f_96547_, (String)label, listX + 2, y, color);
        }
        g.m_280618_();
    }

    private void renderActiveTab(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 1: {
                this.defaultsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 2: {
                this.imagesTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 3: {
                this.linksTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 4: {
                this.previewTab.render(g, mouseX, mouseY, partialTick);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int relY;
        int index;
        boolean tabHandled;
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 1: {
                boolean bl = this.defaultsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 2: {
                boolean bl = this.imagesTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 3: {
                boolean bl = this.linksTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 4: {
                boolean bl = tabHandled = this.previewTab.mouseClicked(mouseX, mouseY, button);
            }
        }
        if (tabHandled) {
            return true;
        }
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom && (index = this.listScroll + (relY = (int)mouseY - listTop - 2) / lineH) >= 0 && index < this.filtered.size()) {
            this.selectChapter(this.filtered.get(index));
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean tabHandled;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta) * 3.0);
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 1: {
                boolean bl = this.defaultsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 2: {
                boolean bl = this.imagesTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 3: {
                boolean bl = this.linksTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 4: {
                boolean bl = tabHandled = this.previewTab.mouseScrolled(mouseX, mouseY, delta);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean tabHandled;
        block0 : switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl;
                for (EditBox field : this.generalTab.getFields()) {
                    if (!field.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                for (EditBox field : this.defaultsTab.getFields()) {
                    if (!field.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                for (EditBox field : this.imagesTab.getFields()) {
                    if (!field.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                for (EditBox field : this.linksTab.getFields()) {
                    if (!field.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 4: {
                boolean bl = tabHandled = false;
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        boolean tabHandled;
        block0 : switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl;
                for (EditBox field : this.generalTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                for (EditBox field : this.defaultsTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                for (EditBox field : this.imagesTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                for (EditBox field : this.linksTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 4: {
                boolean bl = tabHandled = false;
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_5534_(chr, modifiers);
    }

    private void openSettings() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new EditorSettingsScreen(this));
        }
    }

    public void m_7379_() {
        if (this.stateManager.hasUnsavedChanges() || !this.unsavedCache.isEmpty()) {
            this.showCloseConfirmationDialog();
        } else {
            this.autoSaveManager.unregister(this.getEditorId());
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }
    }

    private void showCloseConfirmationDialog() {
        ArrayList<CloseConfirmationDialog.UnsavedEntity> unsavedEntities = new ArrayList<CloseConfirmationDialog.UnsavedEntity>();
        for (Map.Entry<String, UnsavedChangesCache.CacheEntry<ChapterData>> entry : this.unsavedCache.getAllEntries()) {
            unsavedEntities.add(new CloseConfirmationDialog.UnsavedEntity(entry.getValue().getDisplayName(), "Chapter", entry.getValue().getTimestamp()));
        }
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges() && !this.unsavedCache.contains(this.stateManager.getEntityId())) {
            unsavedEntities.add(new CloseConfirmationDialog.UnsavedEntity(this.getEntityDisplayName(this.stateManager.getWorkingCopy()), "Chapter", this.stateManager.getLastModifiedTime()));
        }
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new CloseConfirmationDialog(this, this.parent, unsavedEntities, () -> {
                for (Map.Entry<String, UnsavedChangesCache.CacheEntry<ChapterData>> entry : this.unsavedCache.getAllEntries()) {
                    this.saveEntity(entry.getValue().getEntity());
                }
                if (this.stateManager.hasUnsavedChanges()) {
                    this.save();
                }
            }, () -> {
                this.unsavedCache.clear();
                this.stateManager.clear();
            }, () -> {}));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum Tab {
        GENERAL,
        DEFAULTS,
        IMAGES,
        QUEST_LINKS,
        PREVIEW;

    }
}

