/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import org.texboobcat.questory.client.gui.ChapterArtEditorScreen;
import org.texboobcat.questory.client.gui.ChapterTabPanel;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.ChapterImage;
import org.texboobcat.questory.quest.QuestLink;

public class ChapterPreviewTabPanel
extends ChapterTabPanel {
    private ChapterData previewChapter;

    public ChapterPreviewTabPanel(ChapterArtEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
    }

    @Override
    public void loadFromChapter(ChapterData chapter) {
        this.previewChapter = chapter;
    }

    @Override
    public void saveToChapter(ChapterData chapter) {
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        if (this.previewChapter == null) {
            g.m_280137_(this.getFont(), "\u00a77No chapter loaded", this.x + this.w / 2, this.y + this.h / 2, -1);
            return;
        }
        int contentX = this.x + 20;
        int contentY = this.y + 20;
        g.m_280588_(this.x, this.y, this.x + this.w, this.y + this.h);
        g.m_280488_(this.getFont(), "\u00a7l\u00a76Chapter Preview: " + this.previewChapter.getTitle(), contentX, contentY, -1);
        g.m_280488_(this.getFont(), "\u00a77ID: \u00a7f" + this.previewChapter.getId(), contentX, contentY += 20, -1);
        g.m_280488_(this.getFont(), "\u00a77Always Invisible: \u00a7f" + (this.previewChapter.isAlwaysInvisible() ? "Yes" : "No"), contentX, contentY += 12, -1);
        g.m_280488_(this.getFont(), "\u00a7lDefault Quest Properties:", contentX, contentY += 20, -86);
        String defaultShape = this.previewChapter.getDefaultQuestShape().isEmpty() ? "default" : this.previewChapter.getDefaultQuestShape();
        g.m_280488_(this.getFont(), "\u00a77Shape: \u00a7f" + defaultShape, contentX + 4, contentY += 12, -1);
        g.m_280488_(this.getFont(), "\u00a77Size: \u00a7f" + this.previewChapter.getDefaultQuestSize(), contentX + 4, contentY += 10, -1);
        g.m_280488_(this.getFont(), "\u00a77Hide Dependency Lines: \u00a7f" + (this.previewChapter.isDefaultHideDependencyLines() ? "Yes" : "No"), contentX + 4, contentY += 10, -1);
        g.m_280488_(this.getFont(), "\u00a77Min Width: \u00a7f" + this.previewChapter.getDefaultMinWidth(), contentX + 4, contentY += 10, -1);
        contentY += 18;
        if (!this.previewChapter.getImages().isEmpty()) {
            g.m_280488_(this.getFont(), "\u00a7lChapter Images (" + this.previewChapter.getImages().size() + "):", contentX, contentY, -86);
            contentY += 12;
            int imgNum = 1;
            for (ChapterImage img : this.previewChapter.getImages()) {
                if (imgNum > 5) {
                    g.m_280488_(this.getFont(), "  \u00a77... and " + (this.previewChapter.getImages().size() - 5) + " more", contentX + 4, contentY, -7829368);
                    contentY += 10;
                    break;
                }
                Object imgInfo = String.format("  \u00a77%d. \u00a7f%s \u00a77at (%d, %d) size %.0f\u00d7%.0f", imgNum, img.getImageUrl(), img.getX(), img.getY(), img.getWidth(), img.getHeight());
                if (this.getFont().m_92895_((String)imgInfo) > this.w - 50) {
                    imgInfo = this.getFont().m_92834_((String)imgInfo, this.w - 60) + "...";
                }
                g.m_280488_(this.getFont(), (String)imgInfo, contentX + 4, contentY, -1);
                contentY += 10;
                ++imgNum;
            }
            contentY += 8;
        }
        if (!this.previewChapter.getQuestLinks().isEmpty()) {
            g.m_280488_(this.getFont(), "\u00a7lQuest Links (" + this.previewChapter.getQuestLinks().size() + "):", contentX, contentY, -86);
            contentY += 12;
            int linkNum = 1;
            for (QuestLink link : this.previewChapter.getQuestLinks()) {
                if (linkNum > 5) {
                    g.m_280488_(this.getFont(), "  \u00a77... and " + (this.previewChapter.getQuestLinks().size() - 5) + " more", contentX + 4, contentY, -7829368);
                    contentY += 10;
                    break;
                }
                String shape = link.getShape().isEmpty() ? "default" : link.getShape();
                Object linkInfo = String.format("  \u00a77%d. \u00a7f\u2192 %s \u00a77at (%d, %d) [%s, %.1f]", linkNum, link.getLinkedQuestId(), link.getX(), link.getY(), shape, link.getSize());
                if (this.getFont().m_92895_((String)linkInfo) > this.w - 50) {
                    linkInfo = this.getFont().m_92834_((String)linkInfo, this.w - 60) + "...";
                }
                g.m_280488_(this.getFont(), (String)linkInfo, contentX + 4, contentY, -1);
                contentY += 10;
                ++linkNum;
            }
            contentY += 8;
        }
        if (this.previewChapter.getImages().isEmpty() && this.previewChapter.getQuestLinks().isEmpty()) {
            g.m_280488_(this.getFont(), "\u00a77No images or quest links configured yet.", contentX, contentY += 10, -5592406);
            g.m_280488_(this.getFont(), "\u00a77Use the Images and Quest Links tabs to add content.", contentX, contentY += 12, -5592406);
        }
        int legendY = this.y + this.h - 40;
        g.m_280488_(this.getFont(), "\u00a77Legend:", contentX, legendY, -5592406);
        g.m_280488_(this.getFont(), "\u00a7a\ud83d\udfe6 \u00a77Image  \u00a76\ud83d\udd17 \u00a77Quest Link", contentX, legendY += 12, -1);
        g.m_280618_();
    }
}

