/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.EntityPickerScreen;
import org.texboobcat.questory.client.gui.IconPickerScreen;
import org.texboobcat.questory.client.gui.MultilineTextEditorScreen;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.QuestPositionPickerScreen;
import org.texboobcat.questory.client.gui.ShapeDesignerScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;

public class GeneralTabPanel
extends TabPanel {
    private EditBox idField;
    private EditBox titleField;
    private Button titleEditBtn;
    private EditBox descField;
    private Button descEditBtn;
    private EditBox iconField;
    private Button iconBrowseBtn;
    private Button entityBrowseBtn;
    private EditBox groupField;
    private EditBox tagsField;
    private EditBox xField;
    private EditBox yField;
    private Button positionBtn;
    private EditBox shapeField;
    private EditBox sizeField;
    private EditBox iconScaleField;
    private Button hiddenBtn;
    private Button shapeDesignBtn;
    private EditBox entityFitField;
    private EditBox entityMinField;
    private EditBox entityMaxField;
    private EditBox entitySpinField;
    private EditBox entityBobField;
    private EditBox entityBobSpeedField;
    private boolean hidden = false;

    public GeneralTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void openShapeDesigner() {
        this.editor.saveCurrentTabToQuest();
        String initial = this.shapeField.m_94155_();
        this.getMinecraft().m_91152_((Screen)new ShapeDesignerScreen(this.editor, initial, shapeId -> {
            String val = shapeId == null || shapeId.isBlank() ? initial : shapeId.trim();
            this.shapeField.m_94144_(val);
            this.editor.getWorkingQuest().setShape(val);
            this.getMinecraft().m_91152_((Screen)this.editor);
        }));
    }

    private static Map<String, String> parseEntityMods(String icon) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String raw = icon.substring("entity:".length()).trim();
            int semi = raw.indexOf(59);
            if (semi < 0) {
                return map;
            }
            String rest = raw.substring(semi + 1);
            for (String part : rest.split(";")) {
                int eq;
                String p = part.trim();
                if (p.isEmpty() || (eq = p.indexOf(61)) <= 0) continue;
                map.put(p.substring(0, eq).trim().toLowerCase(Locale.ROOT), p.substring(eq + 1).trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private static String buildEntityIconString(String current, String fit, String min, String max, String spin, String bob, String bobSpeed) {
        try {
            String raw = current.substring("entity:".length()).trim();
            int semi = raw.indexOf(59);
            String id = semi >= 0 ? raw.substring(0, semi).trim() : raw;
            ArrayList<CallSite> mods = new ArrayList<CallSite>();
            if (fit != null && !fit.isBlank()) {
                mods.add((CallSite)((Object)("fit=" + fit.trim())));
            }
            if (min != null && !min.isBlank()) {
                mods.add((CallSite)((Object)("min=" + min.trim())));
            }
            if (max != null && !max.isBlank()) {
                mods.add((CallSite)((Object)("max=" + max.trim())));
            }
            if (spin != null && !spin.isBlank()) {
                mods.add((CallSite)((Object)("spin=" + spin.trim())));
            }
            if (bob != null && !bob.isBlank()) {
                mods.add((CallSite)((Object)("bob=" + bob.trim())));
            }
            if (bobSpeed != null && !bobSpeed.isBlank()) {
                mods.add((CallSite)((Object)("bob_speed=" + bobSpeed.trim())));
            }
            if (mods.isEmpty()) {
                return "entity:" + id;
            }
            StringBuilder sb = new StringBuilder("entity:").append(id).append("; ");
            for (int i = 0; i < mods.size(); ++i) {
                if (i > 0) {
                    sb.append("; ");
                }
                sb.append((String)mods.get(i));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return current;
        }
    }

    private void openEntityPicker() {
        this.editor.saveCurrentTabToQuest();
        int suggestedPx = this.suggestIconPx(this.editor.getWorkingQuest());
        this.getMinecraft().m_91152_((Screen)new EntityPickerScreen(this.editor, this.iconField.m_94155_(), result -> {
            this.editor.getWorkingQuest().setIcon((String)result);
            this.getMinecraft().m_91152_((Screen)this.editor);
        }, suggestedPx));
    }

    private int suggestIconPx(Quest q) {
        if (q == null) {
            return 42;
        }
        double base = 64.0 * Math.max(0.5, q.getSize()) * Math.max(0.5, q.getIconScale());
        double clamped = Math.max(20.0, Math.min(96.0, base));
        int iconPx = (int)Math.round(clamped * 0.65);
        return Math.max(64, Math.min(128, iconPx));
    }

    public String getIdFieldValue() {
        return this.idField.m_94155_();
    }

    private void initWidgets() {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int fieldW = Math.min(400, this.w - 24);
        int labelW = 120;
        int inputW = fieldW - labelW - 8;
        this.idField = this.createField(fieldX + labelW, fieldY, inputW, "quest_id");
        this.idField.m_94199_(200);
        int titleW = inputW - 70;
        this.titleField = this.createField(fieldX + labelW, fieldY += 26, titleW, "Quest Title");
        this.titleField.m_94199_(500);
        this.titleEditBtn = Button.m_253074_((Component)Component.m_237113_((String)"Edit..."), b -> this.openTitleEditor()).m_252987_(fieldX + labelW + titleW + 4, fieldY, 66, 18).m_253136_();
        int descW = inputW - 70;
        this.descField = this.createField(fieldX + labelW, fieldY += 26, descW, "Enter quest description...");
        this.descField.m_94199_(500);
        this.descEditBtn = Button.m_253074_((Component)Component.m_237113_((String)"Edit..."), b -> this.openDescriptionEditor()).m_252987_(fieldX + labelW + descW + 4, fieldY, 66, 18).m_253136_();
        int iconW = inputW - 160;
        this.iconField = this.createField(fieldX + labelW, fieldY += 26, iconW, "minecraft:writable_book");
        this.iconField.m_94199_(200);
        this.iconBrowseBtn = Button.m_253074_((Component)Component.m_237113_((String)"Texture..."), b -> this.openIconPicker()).m_252987_(fieldX + labelW + iconW + 4, fieldY, 76, 18).m_253136_();
        this.entityBrowseBtn = Button.m_253074_((Component)Component.m_237113_((String)"Entity..."), b -> this.openEntityPicker()).m_252987_(fieldX + labelW + iconW + 4 + 80, fieldY, 76, 18).m_253136_();
        this.entityFitField = this.createField(fieldX + labelW, fieldY += 30, 60, "");
        this.entityMinField = this.createField(fieldX + labelW + 66, fieldY, 60, "");
        this.entityMaxField = this.createField(fieldX + labelW + 132, fieldY, 60, "");
        this.entitySpinField = this.createField(fieldX + labelW, fieldY += 24, 60, "");
        this.entityBobField = this.createField(fieldX + labelW + 66, fieldY, 60, "");
        this.entityBobSpeedField = this.createField(fieldX + labelW + 132, fieldY, 60, "");
        fieldY += 10;
        this.groupField = this.createField(fieldX + labelW, fieldY += 12, inputW, "default");
        this.groupField.m_94199_(200);
        this.tagsField = this.createField(fieldX + labelW, fieldY += 26, inputW, "comma, separated, tags");
        this.tagsField.m_94199_(500);
        int halfW = (inputW - 90) / 2;
        this.xField = this.createField(fieldX + labelW, fieldY += 26, halfW, "0");
        this.yField = this.createField(fieldX + labelW + halfW + 4, fieldY, halfW, "0");
        this.positionBtn = Button.m_253074_((Component)Component.m_237113_((String)"Position..."), b -> this.openPositionPicker()).m_252987_(fieldX + labelW + halfW * 2 + 8, fieldY, 82, 18).m_253136_();
        fieldY += 30;
        int shapeW = inputW - 90;
        this.shapeField = this.createField(fieldX + labelW, fieldY += 12, shapeW, "square (or circle, hexagon...)");
        this.shapeDesignBtn = Button.m_253074_((Component)Component.m_237113_((String)"Design..."), b -> this.openShapeDesigner()).m_252987_(fieldX + labelW + shapeW + 4, fieldY, 84, 18).m_253136_();
        this.shapeField.m_94199_(100);
        this.sizeField = this.createField(fieldX + labelW, fieldY += 26, 80, "1.0");
        this.iconScaleField = this.createField(fieldX + labelW, fieldY += 26, 80, "1.0");
        this.hiddenBtn = Button.m_253074_((Component)Component.m_237113_((String)"Hidden: No"), b -> this.toggleHidden()).m_252987_(fieldX + labelW, fieldY += 26, 120, 20).m_253136_();
    }

    private void toggleHidden() {
        this.hidden = !this.hidden;
        this.hiddenBtn.m_93666_((Component)Component.m_237113_((String)("Hidden: " + (this.hidden ? "Yes" : "No"))));
    }

    private void openTitleEditor() {
        this.editor.saveCurrentTabToQuest();
        MultilineTextEditorScreen titleEditor = new MultilineTextEditorScreen(this.editor, this.titleField.m_94155_(), result -> {
            this.editor.getWorkingQuest().setTitle((String)result);
            this.getMinecraft().m_91152_((Screen)this.editor);
        });
        titleEditor.setCustomTitle((Component)Component.m_237113_((String)"Edit Title (recommended: single line)"));
        this.getMinecraft().m_91152_((Screen)titleEditor);
    }

    private void openDescriptionEditor() {
        this.editor.saveCurrentTabToQuest();
        this.getMinecraft().m_91152_((Screen)new MultilineTextEditorScreen(this.editor, this.descField.m_94155_(), result -> {
            this.editor.getWorkingQuest().setDescription((String)result);
            this.getMinecraft().m_91152_((Screen)this.editor);
        }));
    }

    private void openIconPicker() {
        System.out.println("[GeneralTab] openIconPicker() - BEFORE save - ID field: " + this.idField.m_94155_() + ", Title field: " + this.titleField.m_94155_());
        this.editor.saveCurrentTabToQuest();
        System.out.println("[GeneralTab] openIconPicker() - AFTER save - WorkingQuest ID: " + this.editor.getWorkingQuest().getId() + ", Title: " + this.editor.getWorkingQuest().getTitle());
        this.getMinecraft().m_91152_((Screen)new IconPickerScreen(this.editor, this.iconField.m_94155_(), result -> {
            System.out.println("[GeneralTab] IconPicker callback - Selected icon: " + result);
            this.editor.getWorkingQuest().setIcon((String)result);
            System.out.println("[GeneralTab] IconPicker callback - Saved icon to quest: " + this.editor.getWorkingQuest().getIcon());
            this.getMinecraft().m_91152_((Screen)this.editor);
        }));
    }

    private void openPositionPicker() {
        System.out.println("[GeneralTab] openPositionPicker() - Current position: X=" + this.xField.m_94155_() + ", Y=" + this.yField.m_94155_());
        this.editor.saveCurrentTabToQuest();
        this.getMinecraft().m_91152_((Screen)new QuestPositionPickerScreen(this.editor, this.editor.getWorkingQuest(), (x, y) -> {
            System.out.println("[GeneralTab] PositionPicker callback - New position: X=" + x + ", Y=" + y);
            this.editor.getWorkingQuest().setX((int)x);
            this.editor.getWorkingQuest().setY((int)y);
            System.out.println("[GeneralTab] PositionPicker callback - Saved position to quest");
        }));
    }

    @Override
    public void loadFromQuest(Quest quest) {
        System.out.println("[GeneralTab] loadFromQuest() - Loading quest: " + quest.getId() + ", Title: " + quest.getTitle() + ", Icon: " + quest.getIcon());
        this.idField.m_94144_(quest.getId());
        this.titleField.m_94144_(quest.getTitle());
        this.descField.m_94144_(quest.getDescription());
        this.iconField.m_94144_(quest.getIcon());
        System.out.println("[GeneralTab] loadFromQuest() - Set iconField to: " + this.iconField.m_94155_());
        this.groupField.m_94144_(quest.getGroup());
        this.tagsField.m_94144_(String.join((CharSequence)", ", quest.getTags()));
        this.xField.m_94144_(String.valueOf(quest.getX()));
        this.yField.m_94144_(String.valueOf(quest.getY()));
        this.shapeField.m_94144_(quest.getShape().isEmpty() ? "" : quest.getShape());
        this.sizeField.m_94144_(String.valueOf(quest.getSize()));
        this.iconScaleField.m_94144_(String.valueOf(quest.getIconScale()));
        this.hidden = quest.isHidden();
        this.hiddenBtn.m_93666_((Component)Component.m_237113_((String)("Hidden: " + (this.hidden ? "Yes" : "No"))));
        System.out.println("[GeneralTab] loadFromQuest() - Loaded fields - ID: " + this.idField.m_94155_() + ", Title: " + this.titleField.m_94155_());
    }

    @Override
    public void saveToQuest(Quest quest) {
        String[] tags;
        System.out.println("[GeneralTab] saveToQuest() - BEFORE save - Quest ID: " + quest.getId() + ", Title: " + quest.getTitle());
        System.out.println("[GeneralTab] saveToQuest() - Field values - ID: " + this.idField.m_94155_() + ", Title: " + this.titleField.m_94155_());
        System.out.println("[GeneralTab] saveToQuest() - WARNING: Quest.setId() does not exist - ID field edits CANNOT be saved!");
        System.out.println("[GeneralTab] saveToQuest() - If user edited ID from '" + quest.getId() + "' to '" + this.idField.m_94155_() + "', this change will be LOST!");
        quest.setTitle(this.titleField.m_94155_().trim().isEmpty() ? quest.getId() : this.titleField.m_94155_().trim());
        quest.setDescription(this.descField.m_94155_());
        String iconVal = this.iconField.m_94155_().trim().isEmpty() ? "minecraft:writable_book" : this.iconField.m_94155_().trim();
        quest.setIcon(iconVal);
        quest.setGroup(this.groupField.m_94155_().trim().isEmpty() ? "default" : this.groupField.m_94155_().trim());
        quest.getTags().clear();
        for (String tag : tags = this.tagsField.m_94155_().split(",")) {
            String t = tag.trim();
            if (t.isEmpty()) continue;
            quest.addTag(t);
        }
        try {
            quest.setX(Integer.parseInt(this.xField.m_94155_().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            quest.setY(Integer.parseInt(this.yField.m_94155_().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setShape(this.shapeField.m_94155_().trim());
        try {
            double size = Double.parseDouble(this.sizeField.m_94155_().trim());
            quest.setSize(Math.max(0.1, Math.min(5.0, size)));
        }
        catch (Exception size) {
            // empty catch block
        }
        try {
            double scale = Double.parseDouble(this.iconScaleField.m_94155_().trim());
            quest.setIconScale(Math.max(0.1, Math.min(3.0, scale)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setHidden(this.hidden);
        System.out.println("[GeneralTab] saveToQuest() - AFTER save - Quest ID: " + quest.getId() + ", Title: " + quest.getTitle());
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.updateFieldPositions();
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int labelW = 120;
        g.m_280588_(this.x, this.y, this.x + this.w, this.y + this.h);
        g.m_280488_(this.getFont(), "\u00a7lIdentity", fieldX, fieldY - 8, -86);
        g.m_280488_(this.getFont(), "ID:", fieldX, fieldY += 12, -1);
        this.idField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Title:", fieldX, fieldY += 26, -1);
        this.titleField.m_88315_(g, mouseX, mouseY, partialTick);
        this.titleEditBtn.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Description:", fieldX, fieldY += 26, -1);
        this.descField.m_88315_(g, mouseX, mouseY, partialTick);
        this.descEditBtn.m_88315_(g, mouseX, mouseY, partialTick);
        String desc = this.descField.m_94155_();
        if (desc.contains("\n")) {
            String preview = desc.substring(0, Math.min(40, desc.length())).replace("\n", " ") + "...";
            g.m_280488_(this.getFont(), "\u00a77" + preview, fieldX + labelW, fieldY + 20, -7829368);
        }
        int inputW = Math.min(400, this.w - 24) - labelW - 8;
        int iconW = inputW - 160;
        g.m_280488_(this.getFont(), "Icon:", fieldX, fieldY += 26, -1);
        this.iconField.m_88315_(g, mouseX, mouseY, partialTick);
        this.iconBrowseBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.entityBrowseBtn.m_88315_(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        g.m_280488_(this.getFont(), "\u00a7lOrganization", fieldX, fieldY += 4, -86);
        g.m_280488_(this.getFont(), "Group/Chapter:", fieldX, fieldY += 12, -1);
        this.groupField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Tags:", fieldX, fieldY += 26, -1);
        this.tagsField.m_88315_(g, mouseX, mouseY, partialTick);
        int halfW = (inputW - 90) / 2;
        g.m_280488_(this.getFont(), "Position:", fieldX, fieldY += 26, -1);
        g.m_280488_(this.getFont(), "X:", fieldX + labelW, fieldY, -3355444);
        this.xField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Y:", fieldX + labelW + halfW + 4, fieldY, -3355444);
        this.yField.m_88315_(g, mouseX, mouseY, partialTick);
        this.positionBtn.m_88315_(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        g.m_280488_(this.getFont(), "\u00a7lAppearance", fieldX, fieldY += 4, -86);
        g.m_280488_(this.getFont(), "Shape:", fieldX, fieldY += 12, -1);
        this.shapeField.m_88315_(g, mouseX, mouseY, partialTick);
        this.shapeDesignBtn.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Size:", fieldX, fieldY += 26, -1);
        this.sizeField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "(0.5 - 3.0)", fieldX + labelW + 88, fieldY, -7829368);
        g.m_280488_(this.getFont(), "Icon Scale:", fieldX, fieldY += 26, -1);
        this.iconScaleField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "(0.5 - 2.0)", fieldX + labelW + 88, fieldY, -7829368);
        g.m_280488_(this.getFont(), "Visibility:", fieldX, fieldY += 26, -1);
        this.hiddenBtn.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280618_();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateFieldPositions();
        if (this.titleEditBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.descEditBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.iconBrowseBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.entityBrowseBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.positionBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.shapeDesignBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hiddenBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void updateFieldPositions() {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int labelW = 120;
        int inputW = Math.min(400, this.w - 24) - labelW - 8;
        this.idField.m_252865_(fieldX + labelW);
        this.idField.m_253211_(fieldY);
        int titleW = inputW - 70;
        this.titleField.m_252865_(fieldX + labelW);
        this.titleField.m_253211_(fieldY += 26);
        this.titleEditBtn.m_252865_(fieldX + labelW + titleW + 4);
        this.titleEditBtn.m_253211_(fieldY);
        int descW = inputW - 70;
        this.descField.m_252865_(fieldX + labelW);
        this.descField.m_253211_(fieldY += 26);
        this.descEditBtn.m_252865_(fieldX + labelW + descW + 4);
        this.descEditBtn.m_253211_(fieldY);
        int iconW = inputW - 160;
        this.iconField.m_252865_(fieldX + labelW);
        this.iconField.m_253211_(fieldY += 26);
        this.iconBrowseBtn.m_252865_(fieldX + labelW + iconW + 4);
        this.iconBrowseBtn.m_253211_(fieldY);
        this.entityBrowseBtn.m_252865_(fieldX + labelW + iconW + 4 + 80);
        this.entityBrowseBtn.m_253211_(fieldY);
        fieldY += 30;
        this.groupField.m_252865_(fieldX + labelW);
        this.groupField.m_253211_(fieldY += 12);
        this.tagsField.m_252865_(fieldX + labelW);
        this.tagsField.m_253211_(fieldY += 26);
        int halfW = (inputW - 90) / 2;
        this.xField.m_252865_(fieldX + labelW);
        this.xField.m_253211_(fieldY += 26);
        this.yField.m_252865_(fieldX + labelW + halfW + 4);
        this.yField.m_253211_(fieldY);
        this.positionBtn.m_252865_(fieldX + labelW + halfW * 2 + 8);
        this.positionBtn.m_253211_(fieldY);
        fieldY += 30;
        this.shapeField.m_252865_(fieldX + labelW);
        this.shapeField.m_253211_(fieldY += 12);
        this.shapeDesignBtn.m_252865_(fieldX + labelW + (Math.min(400, this.w - 24) - 120 - 8) - 90 + 4);
        this.shapeDesignBtn.m_253211_(fieldY);
        this.sizeField.m_252865_(fieldX + labelW);
        this.sizeField.m_253211_(fieldY += 26);
        this.iconScaleField.m_252865_(fieldX + labelW);
        this.iconScaleField.m_253211_(fieldY += 26);
        this.hiddenBtn.m_252865_(fieldX + labelW);
        this.hiddenBtn.m_253211_(fieldY += 26);
    }
}

