/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;

public class AutoSaveHistoryScreen
extends Screen {
    private final Screen parent;
    private final AutoSaveManager autoSaveManager;
    private List<AutoSaveManager.AutoSaveEntry> history;
    private int scroll = 0;
    private Button refreshBtn;
    private Button clearBtn;
    private Button closeBtn;
    private static final int ENTRY_HEIGHT = 40;
    private static final int PADDING = 10;

    public AutoSaveHistoryScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Auto-Save History"));
        this.parent = parent;
        this.autoSaveManager = AutoSaveManager.getInstance();
        this.refreshHistory();
    }

    private void refreshHistory() {
        this.history = this.autoSaveManager.getAutoSaveHistory();
        Collections.reverse(this.history);
    }

    protected void m_7856_() {
        super.m_7856_();
        int btnY = this.f_96544_ - 35;
        int btnWidth = 80;
        int btnSpacing = 10;
        int centerX = this.f_96543_ / 2;
        this.refreshBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Refresh"), b -> {
            this.refreshHistory();
            this.scroll = 0;
        }).m_252987_(centerX - btnWidth - btnSpacing - btnWidth / 2, btnY, btnWidth, 20).m_253136_());
        this.clearBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Clear All"), b -> {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7eHistory is automatically pruned to 100 entries"));
            }
        }).m_252987_(centerX - btnWidth / 2, btnY, btnWidth, 20).m_253136_());
        this.closeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(centerX + btnWidth / 2 + btnSpacing, btnY, btnWidth, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, -1);
        String info = String.format("\u00a77Showing %d entries | Auto-Save Status: %s", this.history.size(), this.autoSaveManager.getStatusString());
        g.m_280137_(this.f_96547_, info, this.f_96543_ / 2, 30, -1);
        int listTop = 50;
        int listBottom = this.f_96544_ - 50;
        int listHeight = listBottom - listTop;
        int listWidth = Math.min(700, this.f_96543_ - 40);
        int listX = this.f_96543_ / 2 - listWidth / 2;
        g.m_280509_(listX, listTop, listX + listWidth, listBottom, -587202560);
        g.m_280588_(listX, listTop, listX + listWidth, listBottom);
        int maxVisibleEntries = listHeight / 40;
        this.scroll = Math.max(0, Math.min(this.scroll, Math.max(0, this.history.size() - maxVisibleEntries)));
        if (this.history.isEmpty()) {
            g.m_280137_(this.f_96547_, "\u00a77No auto-save history yet", this.f_96543_ / 2, listTop + 20, -1);
        } else {
            int y = listTop + 10;
            for (int i = this.scroll; i < Math.min(this.scroll + maxVisibleEntries + 1, this.history.size()); ++i) {
                AutoSaveManager.AutoSaveEntry entry = this.history.get(i);
                this.renderEntry(g, entry, listX + 10, y, listWidth - 20, mouseX, mouseY);
                y += 40;
            }
        }
        g.m_280618_();
        if (this.history.size() > maxVisibleEntries) {
            String scrollInfo = String.format("\u00a77(%d-%d of %d)", this.scroll + 1, Math.min(this.scroll + maxVisibleEntries, this.history.size()), this.history.size());
            g.m_280488_(this.f_96547_, scrollInfo, listX + listWidth - this.f_96547_.m_92895_(scrollInfo) - 5, listTop - 15, -5592406);
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderEntry(GuiGraphics g, AutoSaveManager.AutoSaveEntry entry, int x, int y, int width, int mouseX, int mouseY) {
        boolean hover = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 40 - 5;
        int bgColor = hover ? 0x33FFFFFF : 0x22FFFFFF;
        g.m_280509_(x, y, x + width, y + 40 - 5, bgColor);
        String statusIcon = entry.isSuccess() ? "\u00a7a\u2713" : "\u00a7c\u2717";
        g.m_280488_(this.f_96547_, statusIcon, x + 5, y + 5, -1);
        String editorInfo = String.format("\u00a7f%s \u00a77| \u00a7f%s", entry.getEditorId(), entry.getEntityId());
        g.m_280488_(this.f_96547_, editorInfo, x + 20, y + 5, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, HH:mm:ss");
        String timestamp = sdf.format(new Date(entry.getTimestamp()));
        String timeInfo = String.format("\u00a77%s (%s)", timestamp, entry.getAgeString());
        g.m_280488_(this.f_96547_, timeInfo, x + 20, y + 18, -1);
        if (!entry.isSuccess() && entry.getError() != null) {
            String error = "\u00a7c" + entry.getError();
            if (this.f_96547_.m_92895_(error) > width - 25) {
                error = this.f_96547_.m_92834_(error, width - 40) + "...";
            }
            g.m_280488_(this.f_96547_, error, x + 20, y + 28, -1);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int listTop = 50;
        int listBottom = this.f_96544_ - 50;
        if (mouseY >= (double)listTop && mouseY <= (double)listBottom) {
            int maxVisibleEntries = (listBottom - listTop) / 40;
            int maxScroll = Math.max(0, this.history.size() - maxVisibleEntries);
            this.scroll = delta > 0.0 ? Math.max(0, this.scroll - 1) : Math.min(maxScroll, this.scroll + 1);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return true;
    }
}

