/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.editor.AutoSaveConfigScreen;
import org.texboobcat.questory.client.gui.editor.AutoSaveHistoryScreen;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;

public class EditorSettingsScreen
extends Screen {
    private final Screen parent;
    private final AutoSaveManager autoSaveManager;
    private Button autoSaveConfigBtn;
    private Button autoSaveHistoryBtn;
    private Button pauseResumeBtn;
    private Button diagnosticsBtn;
    private Button closeBtn;

    public EditorSettingsScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Editor Settings"));
        this.parent = parent;
        this.autoSaveManager = AutoSaveManager.getInstance();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = 80;
        int btnWidth = 300;
        int btnHeight = 30;
        int spacing = 40;
        int y = startY;
        this.autoSaveConfigBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2699 Auto-Save Configuration"), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new AutoSaveConfigScreen(this));
            }
        }).m_252987_(centerX - btnWidth / 2, y, btnWidth, btnHeight).m_253136_());
        this.autoSaveHistoryBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udcdc View Auto-Save History"), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new AutoSaveHistoryScreen(this));
            }
        }).m_252987_(centerX - btnWidth / 2, y += spacing, btnWidth, btnHeight).m_253136_());
        this.updatePauseResumeButton();
        this.pauseResumeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(this.autoSaveManager.isPaused() ? "\u25b6 Resume Auto-Save" : "\u23f8 Pause Auto-Save")), b -> {
            if (this.autoSaveManager.isPaused()) {
                this.autoSaveManager.resumeAutoSave();
            } else {
                this.autoSaveManager.pauseAutoSave();
            }
            this.updatePauseResumeButton();
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)(this.autoSaveManager.isPaused() ? "\u00a7eAuto-save paused" : "\u00a7aAuto-save resumed")));
            }
        }).m_252987_(centerX - btnWidth / 2, y += spacing, btnWidth, btnHeight).m_253136_());
        this.diagnosticsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd0d Performance Diagnostics"), b -> this.showDiagnostics()).m_252987_(centerX - btnWidth / 2, y += spacing, btnWidth, btnHeight).m_253136_());
        this.closeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(centerX - 60, y += spacing + 20, 120, 20).m_253136_());
    }

    private void updatePauseResumeButton() {
        if (this.pauseResumeBtn != null) {
            this.pauseResumeBtn.m_93666_((Component)Component.m_237113_((String)(this.autoSaveManager.isPaused() ? "\u25b6 Resume Auto-Save" : "\u23f8 Pause Auto-Save")));
        }
    }

    private void showDiagnostics() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7e=== Editor Diagnostics ==="));
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7f" + this.autoSaveManager.getDebugInfo())));
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7fRegistered Editors: " + this.autoSaveManager.getRegisteredCount())));
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7fHistory Entries: " + this.autoSaveManager.getAutoSaveHistory().size())));
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7fStatus: " + this.autoSaveManager.getStatusString())));
            Runtime runtime = Runtime.getRuntime();
            long usedMemory = (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L;
            long maxMemory = runtime.maxMemory() / 1024L / 1024L;
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)String.format("\u00a7fMemory: %dMB / %dMB", usedMemory, maxMemory)));
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, -1);
        g.m_280137_(this.f_96547_, "\u00a77Configure auto-save behavior and view history", this.f_96543_ / 2, 35, -5592406);
        int panelWidth = 500;
        int panelHeight = 100;
        int panelX = this.f_96543_ / 2 - panelWidth / 2;
        int panelY = 320;
        g.m_280509_(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -1442840576);
        AutoSaveManager.AutoSaveConfig config = this.autoSaveManager.getConfig();
        String[] statusLines = new String[]{"\u00a77=== Current Status ===", "\u00a7fAuto-Save: " + (config.enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"), "\u00a7fInterval: \u00a7e" + config.intervalSeconds + "s \u00a77| Max Auto-Saves: \u00a7e" + config.maxAutoSaves, "\u00a7fPurge After: \u00a7e" + config.purgeAfterDays + " days", "\u00a7fRegistered Editors: \u00a7e" + this.autoSaveManager.getRegisteredCount(), "\u00a7fLast Save: \u00a7e" + this.autoSaveManager.getStatusString()};
        int lineY = panelY + 10;
        for (String line : statusLines) {
            g.m_280137_(this.f_96547_, line, this.f_96543_ / 2, lineY, -1);
            lineY += 13;
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return true;
    }
}

