/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.function.Function;
import org.texboobcat.questory.client.gui.editor.ChangeTracker;

public class EditorStateManager<T> {
    private static final Gson GSON = new GsonBuilder().create();
    private T workingCopy;
    private T originalCopy;
    private String entityId;
    private boolean isDirty;
    private long lastModifiedTime;
    private final ChangeTracker changeTracker = new ChangeTracker();
    private final Function<T, T> cloneFunction;
    private final Function<T, String> idExtractor;

    public EditorStateManager(Function<T, T> cloneFunction, Function<T, String> idExtractor) {
        this.cloneFunction = cloneFunction;
        this.idExtractor = idExtractor;
        this.isDirty = false;
        this.lastModifiedTime = 0L;
    }

    public void load(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Cannot load null entity");
        }
        this.originalCopy = this.cloneFunction.apply(entity);
        this.workingCopy = this.cloneFunction.apply(entity);
        this.entityId = this.idExtractor.apply(entity);
        this.isDirty = false;
        this.lastModifiedTime = System.currentTimeMillis();
        this.changeTracker.reset();
    }

    public void markDirty() {
        if (!this.isDirty) {
            this.isDirty = true;
            this.lastModifiedTime = System.currentTimeMillis();
        }
    }

    public void markClean() {
        this.isDirty = false;
        this.changeTracker.commitChanges();
    }

    public boolean hasUnsavedChanges() {
        return this.isDirty || this.changeTracker.hasChanges();
    }

    public T getWorkingCopy() {
        return this.workingCopy;
    }

    public T getOriginalCopy() {
        return this.originalCopy;
    }

    public void setWorkingCopy(T newWorkingCopy) {
        this.workingCopy = newWorkingCopy;
        this.entityId = this.idExtractor.apply(newWorkingCopy);
        this.markDirty();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    public void resetToOriginal() {
        this.workingCopy = this.cloneFunction.apply(this.originalCopy);
        this.isDirty = false;
        this.changeTracker.revertChanges();
    }

    public Map<String, Object> getChangedFields() {
        return this.changeTracker.getChangedValues();
    }

    public void commitAsOriginal() {
        this.originalCopy = this.cloneFunction.apply(this.workingCopy);
        this.isDirty = false;
        this.changeTracker.commitChanges();
    }

    public boolean isLoaded() {
        return this.workingCopy != null && this.originalCopy != null;
    }

    public String getDebugSummary() {
        return String.format("EditorStateManager[id=%s, dirty=%s, changes=%d, lastModified=%d]", this.entityId, this.isDirty, this.changeTracker.getChangeCount(), this.lastModifiedTime);
    }

    public void clear() {
        this.workingCopy = null;
        this.originalCopy = null;
        this.entityId = null;
        this.isDirty = false;
        this.lastModifiedTime = 0L;
        this.changeTracker.reset();
    }
}

