/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class UnsavedChangesCache<T> {
    private final Map<String, CacheEntry<T>> cache;
    private final LinkedList<String> accessOrder;
    private final int maxSize;

    public UnsavedChangesCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be positive");
        }
        this.cache = new ConcurrentHashMap<String, CacheEntry<T>>();
        this.accessOrder = new LinkedList();
        this.maxSize = maxSize;
    }

    public synchronized void put(String key, T entity, Map<String, Object> changedFields, String displayName) {
        if (key == null || entity == null) {
            throw new IllegalArgumentException("key and entity cannot be null");
        }
        if (this.cache.containsKey(key)) {
            this.accessOrder.remove(key);
        }
        if (this.cache.size() >= this.maxSize && !this.cache.containsKey(key)) {
            this.evictOldest();
        }
        CacheEntry<T> entry = new CacheEntry<T>(entity, System.currentTimeMillis(), changedFields, displayName);
        this.cache.put(key, entry);
        this.accessOrder.addLast(key);
    }

    public void put(String key, T entity, String displayName) {
        this.put(key, entity, Collections.emptyMap(), displayName);
    }

    public synchronized Optional<CacheEntry<T>> get(String key) {
        if (key == null) {
            return Optional.empty();
        }
        CacheEntry<T> entry = this.cache.get(key);
        if (entry != null) {
            this.accessOrder.remove(key);
            this.accessOrder.addLast(key);
        }
        return Optional.ofNullable(entry);
    }

    public synchronized void remove(String key) {
        if (key == null) {
            return;
        }
        this.cache.remove(key);
        this.accessOrder.remove(key);
    }

    public boolean contains(String key) {
        return this.cache.containsKey(key);
    }

    public synchronized List<Map.Entry<String, CacheEntry<T>>> getAllEntries() {
        ArrayList<Map.Entry<String, CacheEntry<T>>> entries = new ArrayList<Map.Entry<String, CacheEntry<T>>>();
        for (String key : this.accessOrder) {
            CacheEntry<T> entry = this.cache.get(key);
            if (entry == null) continue;
            entries.add(new AbstractMap.SimpleEntry<String, CacheEntry<T>>(key, entry));
        }
        return entries;
    }

    public synchronized Set<String> getAllKeys() {
        return new LinkedHashSet<String>(this.accessOrder);
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public synchronized void clear() {
        this.cache.clear();
        this.accessOrder.clear();
    }

    public synchronized void evictOldest() {
        if (!this.accessOrder.isEmpty()) {
            String oldestKey = this.accessOrder.removeFirst();
            this.cache.remove(oldestKey);
        }
    }

    public synchronized int evictOlderThan(long maxAgeMs) {
        int evicted = 0;
        long now = System.currentTimeMillis();
        Iterator it = this.accessOrder.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            CacheEntry<T> entry = this.cache.get(key);
            if (entry == null || now - entry.getTimestamp() <= maxAgeMs) continue;
            it.remove();
            this.cache.remove(key);
            ++evicted;
        }
        return evicted;
    }

    public synchronized String getStats() {
        return String.format("UnsavedChangesCache[size=%d, maxSize=%d, utilization=%.1f%%]", this.cache.size(), this.maxSize, (double)this.cache.size() * 100.0 / (double)this.maxSize);
    }

    public static class CacheEntry<T> {
        private final T entity;
        private final long timestamp;
        private final Map<String, Object> changedFields;
        private final String displayName;

        public CacheEntry(T entity, long timestamp, Map<String, Object> changedFields, String displayName) {
            this.entity = entity;
            this.timestamp = timestamp;
            this.changedFields = changedFields != null ? new HashMap<String, Object>(changedFields) : Collections.emptyMap();
            this.displayName = displayName;
        }

        public T getEntity() {
            return this.entity;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Map<String, Object> getChangedFields() {
            return Collections.unmodifiableMap(this.changedFields);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public long getAge() {
            return System.currentTimeMillis() - this.timestamp;
        }

        public String getAgeString() {
            long ageMs = this.getAge();
            long seconds = ageMs / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            long days = hours / 24L;
            if (days > 0L) {
                return days + "d ago";
            }
            if (hours > 0L) {
                return hours + "h ago";
            }
            if (minutes > 0L) {
                return minutes + "m ago";
            }
            return seconds + "s ago";
        }
    }
}

