/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.editor.UnsavedChangesCache;

public class UnsavedChangesRecoveryScreen
extends Screen {
    private final Screen parent;
    private final UnsavedChangesCache<?> cache;
    private final String editorType;
    private final RecoveryCallback callback;
    private List<CacheEntryDisplay> entries;
    private int selectedIndex = -1;
    private int scroll = 0;
    private Button recoverBtn;
    private Button discardBtn;
    private Button closeBtn;
    private static final int ENTRY_HEIGHT = 50;
    private static final int PADDING = 10;

    public UnsavedChangesRecoveryScreen(Screen parent, UnsavedChangesCache<?> cache, String editorType, RecoveryCallback callback) {
        super((Component)Component.m_237113_((String)("Recover Unsaved Changes - " + editorType)));
        this.parent = parent;
        this.cache = cache;
        this.editorType = editorType;
        this.callback = callback;
        this.loadEntries();
    }

    private void loadEntries() {
        this.entries = new ArrayList<CacheEntryDisplay>();
        for (Map.Entry<String, UnsavedChangesCache.CacheEntry<?>> entry : this.cache.getAllEntries()) {
            this.entries.add(new CacheEntryDisplay(entry.getKey(), entry.getValue().getDisplayName(), entry.getValue().getTimestamp(), entry.getValue().getChangedFields().keySet()));
        }
        this.entries.sort((a, b) -> Long.compare(b.timestamp, a.timestamp));
    }

    protected void m_7856_() {
        super.m_7856_();
        int btnY = this.f_96544_ - 35;
        int btnWidth = 90;
        int btnSpacing = 10;
        int centerX = this.f_96543_ / 2;
        this.recoverBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u00a7aRecover"), b -> {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.entries.size()) {
                CacheEntryDisplay entry = this.entries.get(this.selectedIndex);
                if (this.callback != null) {
                    this.callback.onRecover(entry.entityId);
                }
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7aRecovered: " + entry.displayName)));
                }
                this.loadEntries();
                this.selectedIndex = -1;
                this.updateButtons();
            }
        }).m_252987_(centerX - btnWidth - btnSpacing - btnWidth / 2, btnY, btnWidth, 20).m_253136_());
        this.discardBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cDiscard"), b -> {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.entries.size()) {
                CacheEntryDisplay entry = this.entries.get(this.selectedIndex);
                if (this.callback != null) {
                    this.callback.onDiscard(entry.entityId);
                }
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7cDiscarded: " + entry.displayName)));
                }
                this.cache.remove(entry.entityId);
                this.loadEntries();
                this.selectedIndex = -1;
                this.updateButtons();
            }
        }).m_252987_(centerX - btnWidth / 2, btnY, btnWidth, 20).m_253136_());
        this.closeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(centerX + btnWidth / 2 + btnSpacing, btnY, btnWidth, 20).m_253136_());
        this.updateButtons();
    }

    private void updateButtons() {
        boolean hasSelection;
        boolean bl = hasSelection = this.selectedIndex >= 0 && this.selectedIndex < this.entries.size();
        if (this.recoverBtn != null) {
            this.recoverBtn.f_93623_ = hasSelection;
        }
        if (this.discardBtn != null) {
            this.discardBtn.f_93623_ = hasSelection;
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, -1);
        String info = this.entries.isEmpty() ? "\u00a77No unsaved changes to recover" : String.format("\u00a77%d %s(s) with unsaved changes", this.entries.size(), this.editorType);
        g.m_280137_(this.f_96547_, info, this.f_96543_ / 2, 30, -1);
        if (!this.entries.isEmpty()) {
            g.m_280137_(this.f_96547_, "\u00a77Click an entry to select it, then use Recover or Discard", this.f_96543_ / 2, 42, -5592406);
        }
        int listTop = 60;
        int listBottom = this.f_96544_ - 50;
        int listHeight = listBottom - listTop;
        int listWidth = Math.min(750, this.f_96543_ - 40);
        int listX = this.f_96543_ / 2 - listWidth / 2;
        g.m_280509_(listX, listTop, listX + listWidth, listBottom, -587202560);
        g.m_280588_(listX, listTop, listX + listWidth, listBottom);
        int maxVisibleEntries = listHeight / 50;
        this.scroll = Math.max(0, Math.min(this.scroll, Math.max(0, this.entries.size() - maxVisibleEntries)));
        if (this.entries.isEmpty()) {
            g.m_280137_(this.f_96547_, "\u00a77All changes are saved!", this.f_96543_ / 2, listTop + listHeight / 2, -1);
        } else {
            int y = listTop + 10;
            for (int i = this.scroll; i < Math.min(this.scroll + maxVisibleEntries + 1, this.entries.size()); ++i) {
                CacheEntryDisplay entry = this.entries.get(i);
                boolean selected = i == this.selectedIndex;
                boolean hover = mouseX >= listX + 10 && mouseX <= listX + listWidth - 10 && mouseY >= y && mouseY <= y + 50 - 5;
                this.renderEntry(g, entry, listX + 10, y, listWidth - 20, selected, hover);
                y += 50;
            }
        }
        g.m_280618_();
        if (this.entries.size() > maxVisibleEntries) {
            String scrollInfo = String.format("\u00a77(%d-%d of %d)", this.scroll + 1, Math.min(this.scroll + maxVisibleEntries, this.entries.size()), this.entries.size());
            g.m_280488_(this.f_96547_, scrollInfo, listX + listWidth - this.f_96547_.m_92895_(scrollInfo) - 5, listTop - 15, -5592406);
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderEntry(GuiGraphics g, CacheEntryDisplay entry, int x, int y, int width, boolean selected, boolean hover) {
        Object name;
        int bgColor = selected ? 1716162786 : (hover ? 0x33FFFFFF : 0x22FFFFFF);
        g.m_280509_(x, y, x + width, y + 50 - 5, bgColor);
        if (selected) {
            g.m_280509_(x, y, x + 2, y + 50 - 5, -11890462);
        }
        if (this.f_96547_.m_92895_((String)(name = entry.displayName)) > width - 100) {
            name = this.f_96547_.m_92834_((String)name, width - 120) + "...";
        }
        g.m_280488_(this.f_96547_, "\u00a7f" + (String)name, x + 10, y + 5, -1);
        String id = "\u00a77ID: " + entry.entityId;
        if (this.f_96547_.m_92895_(id) > width - 100) {
            id = this.f_96547_.m_92834_(id, width - 120) + "...";
        }
        g.m_280488_(this.f_96547_, id, x + 10, y + 17, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, HH:mm");
        String timestamp = sdf.format(new Date(entry.timestamp));
        String meta = String.format("\u00a7e%d field(s) changed \u00a77| %s (%s)", entry.changedFields.size(), timestamp, entry.getAgeString());
        g.m_280488_(this.f_96547_, meta, x + 10, y + 30, -1);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int relativeY;
        int clickedIndex;
        int listTop = 60;
        int listBottom = this.f_96544_ - 50;
        int listWidth = Math.min(750, this.f_96543_ - 40);
        int listX = this.f_96543_ / 2 - listWidth / 2;
        if (mouseX >= (double)(listX + 10) && mouseX <= (double)(listX + listWidth - 10) && mouseY >= (double)listTop && mouseY <= (double)listBottom && (clickedIndex = this.scroll + (relativeY = (int)mouseY - listTop - 10) / 50) >= 0 && clickedIndex < this.entries.size()) {
            this.selectedIndex = clickedIndex;
            this.updateButtons();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int listTop = 60;
        int listBottom = this.f_96544_ - 50;
        if (mouseY >= (double)listTop && mouseY <= (double)listBottom) {
            int maxVisibleEntries = (listBottom - listTop) / 50;
            int maxScroll = Math.max(0, this.entries.size() - maxVisibleEntries);
            this.scroll = delta > 0.0 ? Math.max(0, this.scroll - 1) : Math.min(maxScroll, this.scroll + 1);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return true;
    }

    public static interface RecoveryCallback {
        public void onRecover(String var1);

        public void onDiscard(String var1);
    }

    private static class CacheEntryDisplay {
        final String entityId;
        final String displayName;
        final long timestamp;
        final Set<String> changedFields;

        CacheEntryDisplay(String entityId, String displayName, long timestamp, Set<String> changedFields) {
            this.entityId = entityId;
            this.displayName = displayName;
            this.timestamp = timestamp;
            this.changedFields = changedFields;
        }

        String getAgeString() {
            long ageMs = System.currentTimeMillis() - this.timestamp;
            long seconds = ageMs / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            long days = hours / 24L;
            if (days > 0L) {
                return days + "d ago";
            }
            if (hours > 0L) {
                return hours + "h ago";
            }
            if (minutes > 0L) {
                return minutes + "m ago";
            }
            return seconds + "s ago";
        }
    }
}

