/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.quest.Reward;

public class AdvancementReward
extends Reward {
    private String advancementId;
    private String criterion;

    public AdvancementReward(String advancementId, String criterion) {
        super("advancement");
        this.advancementId = advancementId;
        this.criterion = criterion;
    }

    public String getAdvancementId() {
        return this.advancementId;
    }

    public String getCriterion() {
        return this.criterion;
    }

    public void setAdvancementId(String advancementId) {
        this.advancementId = advancementId;
    }

    public void setCriterion(String criterion) {
        this.criterion = criterion;
    }

    @Override
    public void grant(ServerPlayer player) {
        try {
            if (player.f_8924_ == null) {
                return;
            }
            ResourceLocation advId = ResourceLocation.m_135820_((String)this.advancementId);
            if (advId == null) {
                return;
            }
            for (Advancement advancement : player.f_8924_.m_129889_().m_136028_()) {
                boolean matches = false;
                try {
                    Object reflectId = advancement.getClass().getMethod("getId", new Class[0]).invoke((Object)advancement, new Object[0]);
                    matches = advId.equals(reflectId);
                }
                catch (Exception e1) {
                    try {
                        Object reflectId = advancement.getClass().getMethod("id", new Class[0]).invoke((Object)advancement, new Object[0]);
                        matches = advId.equals(reflectId);
                    }
                    catch (Exception e2) {
                        matches = advancement.toString().contains(advId.toString());
                    }
                }
                if (!matches) continue;
                AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
                if (this.criterion == null || this.criterion.isEmpty()) {
                    for (String c : progress.m_8219_()) {
                        player.m_8960_().m_135988_(advancement, c);
                    }
                } else {
                    player.m_8960_().m_135988_(advancement, this.criterion);
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getDisplayString() {
        String desc = "Grant advancement: " + this.advancementId;
        if (this.criterion != null && !this.criterion.isEmpty()) {
            desc = desc + " [" + this.criterion + "]";
        }
        return desc;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "advancement");
        json.addProperty("advancement", this.advancementId);
        if (this.criterion != null && !this.criterion.isEmpty()) {
            json.addProperty("criterion", this.criterion);
        }
        return json;
    }

    public static AdvancementReward fromJson(JsonObject json) {
        String advancementId = json.get("advancement").getAsString();
        String criterion = json.has("criterion") ? json.get("criterion").getAsString() : null;
        return new AdvancementReward(advancementId, criterion);
    }
}

