/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.team;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.api.events.TeamEventBus;
import org.texboobcat.questory.api.events.TeamQuestCompletedEvent;
import org.texboobcat.questory.events.QuestNotifications;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.quest.ItemReward;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.quest.XpLevelsReward;
import org.texboobcat.questory.quest.XpReward;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.TeamManager;
import org.texboobcat.questory.team.TeamProgressMode;
import org.texboobcat.questory.team.TeamQuestSettings;
import org.texboobcat.questory.team.TeamRewardMode;

public class TeamQuestHelper {
    public static QuestProgress getQuestProgress(UUID playerId, Quest quest) {
        if (quest.getTeamSettings() == null || !quest.getTeamSettings().isTeamEnabled()) {
            return QuestManager.getInstance().getProgress(playerId);
        }
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
        if (teamId == null) {
            if (quest.getTeamSettings().isAllowSoloCompletion()) {
                return QuestManager.getInstance().getProgress(playerId);
            }
            return null;
        }
        TeamProgressMode mode = quest.getTeamSettings().getProgressMode();
        if (mode == TeamProgressMode.INDIVIDUAL) {
            return QuestManager.getInstance().getProgress(playerId);
        }
        return TeamManager.getInstance().getTeamProgress(teamId, quest.getId());
    }

    public static void trackTeamProgress(UUID playerId, Quest quest, Requirement requirement, int amount) {
        if (quest.getTeamSettings() == null || !quest.getTeamSettings().isTeamEnabled()) {
            return;
        }
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
        if (teamId == null) {
            return;
        }
        TeamProgressMode mode = quest.getTeamSettings().getProgressMode();
        switch (mode) {
            case SHARED: {
                QuestProgress progress = TeamManager.getInstance().getTeamProgress(teamId, quest.getId());
                if (progress == null) break;
                progress.addRequirementProgress(quest.getId(), requirement, amount);
                TeamManager.getInstance().saveTeamProgress(teamId);
                break;
            }
            case COMBINED: {
                QuestProgress progress = TeamManager.getInstance().getTeamProgress(teamId, quest.getId());
                if (progress == null) break;
                progress.addRequirementProgress(quest.getId(), requirement, amount);
                TeamManager.getInstance().saveTeamProgress(teamId);
                break;
            }
            case INDIVIDUAL: 
            case PARALLEL: {
                QuestProgress progress = QuestManager.getInstance().getProgress(playerId);
                progress.addRequirementProgress(quest.getId(), requirement, amount);
            }
        }
    }

    public static boolean canTeamCompleteQuest(UUID teamId, Quest quest) {
        TeamQuestSettings settings = quest.getTeamSettings();
        if (settings == null || !settings.isTeamEnabled()) {
            return false;
        }
        Set<UUID> members = TeamManager.getInstance().getTeamMembers(teamId);
        if (members.size() < settings.getMinTeamSize() || members.size() > settings.getMaxTeamSize()) {
            return false;
        }
        TeamProgressMode mode = settings.getProgressMode();
        switch (mode) {
            case SHARED: 
            case COMBINED: {
                QuestProgress teamProgress = TeamManager.getInstance().getTeamProgress(teamId, quest.getId());
                return teamProgress != null && quest.canComplete(teamProgress);
            }
            case PARALLEL: {
                for (UUID memberId : members) {
                    QuestProgress memberProgress = QuestManager.getInstance().getProgress(memberId);
                    if (quest.canComplete(memberProgress)) continue;
                    return false;
                }
                return true;
            }
            case INDIVIDUAL: {
                for (UUID memberId : members) {
                    QuestProgress memberProgress = QuestManager.getInstance().getProgress(memberId);
                    if (!quest.canComplete(memberProgress)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static void distributeTeamRewards(ServerPlayer completer, Quest quest, Set<ServerPlayer> onlineMembers) {
        TeamQuestSettings settings = quest.getTeamSettings();
        if (settings == null || !settings.isTeamEnabled()) {
            for (Reward reward : quest.getRewards()) {
                reward.grant(completer);
            }
            return;
        }
        TeamRewardMode rewardMode = settings.getRewardMode();
        switch (rewardMode) {
            case COMPLETER_ONLY: {
                for (Reward reward : quest.getRewards()) {
                    reward.grant(completer);
                }
                break;
            }
            case SHARED: {
                for (ServerPlayer member : onlineMembers) {
                    for (Reward reward : quest.getRewards()) {
                        reward.grant(member);
                    }
                }
                break;
            }
            case DISTRIBUTED: {
                UUID teamId = TeamManager.getInstance().getPlayerTeamId(completer.m_20148_());
                if (teamId == null) break;
                Set<UUID> allMembers = TeamManager.getInstance().getTeamMembers(teamId);
                int memberCount = allMembers.size();
                for (UUID memberId : allMembers) {
                    ServerPlayer member = completer.m_20194_().m_6846_().m_11259_(memberId);
                    for (Reward reward : quest.getRewards()) {
                        Reward distributedReward = TeamQuestHelper.createDistributedReward(reward, memberCount);
                        if (member != null) {
                            distributedReward.grant(member);
                            continue;
                        }
                        try {
                            PendingRewardManager.getInstance().addPendingReward(memberId, quest.getId(), quest.getTitle(), distributedReward);
                        }
                        catch (Throwable t) {
                            System.err.println("[Questory] Error adding pending reward: " + t.getMessage());
                        }
                    }
                }
                break;
            }
            case ALL_MEMBERS: {
                UUID teamId = TeamManager.getInstance().getPlayerTeamId(completer.m_20148_());
                if (teamId == null) break;
                Set<UUID> allMembers = TeamManager.getInstance().getTeamMembers(teamId);
                for (UUID memberId : allMembers) {
                    ServerPlayer member = completer.m_20194_().m_6846_().m_11259_(memberId);
                    for (Reward reward : quest.getRewards()) {
                        if (member != null) {
                            reward.grant(member);
                            continue;
                        }
                        try {
                            PendingRewardManager.getInstance().addPendingReward(memberId, quest.getId(), quest.getTitle(), reward);
                        }
                        catch (Throwable t) {
                            System.err.println("[Questory] Error adding pending reward: " + t.getMessage());
                        }
                    }
                }
                break;
            }
        }
    }

    private static Reward createDistributedReward(Reward original, int memberCount) {
        if (memberCount <= 1) {
            return original;
        }
        if (original instanceof ItemReward) {
            ItemReward itemReward = (ItemReward)original;
            ItemReward distributed = new ItemReward(itemReward.getItem(), Math.max(1, itemReward.getCount() / memberCount));
            distributed.setNbt(itemReward.getNbt());
            return distributed;
        }
        if (original instanceof XpReward) {
            XpReward xpReward = (XpReward)original;
            return new XpReward(Math.max(1, xpReward.getAmount() / memberCount));
        }
        if (original instanceof XpLevelsReward) {
            XpLevelsReward xpLevelsReward = (XpLevelsReward)original;
            return new XpLevelsReward(Math.max(1, xpLevelsReward.getLevels() / memberCount));
        }
        return original;
    }

    public static Set<ServerPlayer> getOnlineTeamMembers(ServerPlayer player, UUID teamId) {
        HashSet<ServerPlayer> onlineMembers = new HashSet<ServerPlayer>();
        Set<UUID> memberIds = TeamManager.getInstance().getTeamMembers(teamId);
        for (UUID memberId : memberIds) {
            ServerPlayer member = player.m_20194_().m_6846_().m_11259_(memberId);
            if (member == null) continue;
            onlineMembers.add(member);
        }
        return onlineMembers;
    }

    public static boolean completeTeamQuest(ServerPlayer player, Quest quest) {
        TeamProgressMode mode;
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.m_20148_());
        if (teamId == null) {
            return false;
        }
        TeamQuestSettings settings = quest.getTeamSettings();
        if (settings == null || !settings.isTeamEnabled()) {
            return false;
        }
        if (!TeamQuestHelper.canTeamCompleteQuest(teamId, quest)) {
            return false;
        }
        Set<ServerPlayer> onlineMembers = TeamQuestHelper.getOnlineTeamMembers(player, teamId);
        if (settings.isRequireAllOnline()) {
            Set<UUID> allMembers = TeamManager.getInstance().getTeamMembers(teamId);
            if (onlineMembers.size() < allMembers.size()) {
                return false;
            }
        }
        if ((mode = settings.getProgressMode()) == TeamProgressMode.SHARED || mode == TeamProgressMode.COMBINED) {
            QuestProgress teamProgress = TeamManager.getInstance().getTeamProgress(teamId, quest.getId());
            if (teamProgress != null && !teamProgress.isQuestCompleted(quest.getId())) {
                teamProgress.completeQuest(quest.getId());
                TeamManager.getInstance().saveTeamProgress(teamId);
            }
        } else {
            for (UUID memberId : TeamManager.getInstance().getTeamMembers(teamId)) {
                QuestProgress memberProgress = QuestManager.getInstance().getProgress(memberId);
                if (memberProgress.isQuestCompleted(quest.getId())) continue;
                memberProgress.completeQuest(quest.getId());
            }
        }
        TeamQuestHelper.distributeTeamRewards(player, quest, onlineMembers);
        for (ServerPlayer member : onlineMembers) {
            QuestNotifications.notifyQuestClaimed(member, quest);
        }
        try {
            Set<UUID> allMembers = TeamManager.getInstance().getTeamMembers(teamId);
            TeamEventBus.post(new TeamQuestCompletedEvent(teamId, quest, player, allMembers));
        }
        catch (Throwable t) {
            System.err.println("[Questory] Error firing TeamQuestCompletedEvent: " + t.getMessage());
        }
        return true;
    }
}

