/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.texboobcat.questory.client.rendering.AnimationHelper;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.ThemeLoader;

public class ThemeEditorScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeEditorScreen.class);
    private static final int PANEL_WIDTH = 300;
    private static final int PREVIEW_WIDTH = 400;
    private static final int SPACING = 10;
    private final class_437 parent;
    private QuestTheme currentTheme;
    private String themeName = "custom_theme";
    private class_342 themeNameBox;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private final Map<String, PropertyEditor> propertyEditors = new HashMap<String, PropertyEditor>();
    private final List<String> propertyCategories = new ArrayList<String>();
    private boolean previewDirty = true;
    private long lastPreviewUpdate = 0L;
    private static final String[] BUILTIN_PRESETS = new String[]{"dark", "light", "ftb_like", "minimal"};
    private int presetIndex = 0;

    public ThemeEditorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Theme Editor"));
        this.parent = parent;
        this.currentTheme = new QuestTheme();
        this.initializePropertyCategories();
    }

    public ThemeEditorScreen(class_437 parent, QuestTheme theme, String name) {
        this(parent);
        this.currentTheme = theme;
        this.themeName = name;
    }

    private void initializePropertyCategories() {
        this.propertyCategories.add("Quest Appearance");
        this.propertyCategories.add("Colors");
        this.propertyCategories.add("Dependency Lines");
        this.propertyCategories.add("Background");
        this.propertyCategories.add("Icons");
        this.propertyCategories.add("Animation");
    }

    protected void method_25426() {
        super.method_25426();
        this.themeNameBox = new class_342(this.field_22793, this.field_22789 - 300 + 10, 30, 280, 20, (class_2561)class_2561.method_43470((String)"Theme Name"));
        this.themeNameBox.method_1852(this.themeName);
        this.themeNameBox.method_1880(50);
        this.method_37063((class_364)this.themeNameBox);
        int categoryY = 60;
        for (String category : this.propertyCategories) {
            class_4185 categoryButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)category), b -> this.selectCategory(category)).method_46434(this.field_22789 - 300 + 10, categoryY, 280, 20).method_46431();
            this.method_37063((class_364)categoryButton);
            categoryY += 25;
        }
        int bottomY = this.field_22790 - 30;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save Theme"), b -> this.saveTheme()).method_46434(this.field_22789 - 300 + 10, bottomY, 90, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Load"), b -> this.loadTheme()).method_46434(this.field_22789 - 300 + 100, bottomY, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> this.resetTheme()).method_46434(this.field_22789 - 300 + 170, bottomY, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(this.field_22789 - 300 + 240, bottomY, 50, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Preset"), b -> this.loadNextPreset()).method_46434(this.field_22789 - 300 + 10, bottomY - 26, 70, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Export JSON"), b -> this.exportThemeJson()).method_46434(this.field_22789 - 300 + 10 + 75, bottomY - 26, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Import JSON"), b -> this.importThemeJson()).method_46434(this.field_22789 - 300 + 10 + 180, bottomY - 26, 100, 20).method_46431());
        this.initializePropertyEditors();
    }

    private void initializePropertyEditors() {
        this.propertyEditors.put("Quest Size", new SliderEditor("size", 0.5f, 3.0f, 1.0f));
        this.propertyEditors.put("Quest Spacing", new SliderEditor("spacing", 0.0f, 8.0f, 2.0f));
        this.propertyEditors.put("Icon Scale", new SliderEditor("icon_scale", 0.5f, 2.0f, 1.0f));
        this.propertyEditors.put("Shape", new TextEditor("shape", "circle"));
        this.propertyEditors.put("Completed Color", new ColorEditor("completed_color", -16711936));
        this.propertyEditors.put("Started Color", new ColorEditor("started_color", -256));
        this.propertyEditors.put("Locked Color", new ColorEditor("locked_color", -8355712));
        this.propertyEditors.put("Not Started Color", new ColorEditor("not_started_color", -1));
        this.propertyEditors.put("Line Thickness", new SliderEditor("line_thickness", 1.0f, 5.0f, 2.0f));
        this.propertyEditors.put("Line Animation Speed", new SliderEditor("line_speed", 0.0f, 10.0f, 1.0f));
        this.propertyEditors.put("Line Color", new ColorEditor("line_color", -1));
        this.propertyEditors.put("Background Path", new TextEditor("background_path", "minecraft:textures/block/stone.png"));
        this.propertyEditors.put("Background Tile Size", new SliderEditor("background_tile", 0.0f, 64.0f, 16.0f));
        this.propertyEditors.put("Background Tint", new ColorEditor("background_tint", 0));
        this.propertyEditors.put("Enable Animations", new BooleanEditor("animations", true));
        this.propertyEditors.put("Pulse Speed", new SliderEditor("pulse_speed", 0.0f, 10.0f, 3.0f));
    }

    private void selectCategory(String category) {
        this.scrollOffset = 0;
        this.previewDirty = true;
    }

    private void saveTheme() {
        block14: {
            String name = this.themeNameBox.method_1882();
            if (name.isEmpty()) {
                name = "custom_theme";
            }
            try {
                Path configDir = Paths.get("config", "questory", "themes");
                Files.createDirectories(configDir, new FileAttribute[0]);
                Path themePath = configDir.resolve(name + ".txt");
                try (BufferedWriter writer = Files.newBufferedWriter(themePath, new OpenOption[0]);){
                    writer.write("// Questory Theme: " + name);
                    writer.newLine();
                    writer.write("// Generated by Theme Editor");
                    writer.newLine();
                    writer.newLine();
                    writer.write("[*]");
                    writer.newLine();
                    for (Map.Entry<String, PropertyEditor> entry : this.propertyEditors.entrySet()) {
                        String display = entry.getKey();
                        Object value = entry.getValue().getValue();
                        if (value == null) continue;
                        if ("Line Animation Speed".equals(display)) {
                            String v = this.formatPropertyValue(value);
                            writer.write("dependency_line_selected_speed: " + v);
                            writer.newLine();
                            writer.write("dependency_line_unselected_speed: " + v);
                            writer.newLine();
                            continue;
                        }
                        String key = this.mapDisplayToThemeKey(display);
                        if (key == null || key.isEmpty()) continue;
                        String valueStr = this.formatPropertyValue(value);
                        writer.write(key + ": " + valueStr);
                        writer.newLine();
                    }
                    String bg = this.buildBackgroundIconString((String)this.getEditorValue("Background Path"), (Number)this.getEditorValue("Background Tile Size"), (Integer)this.getEditorValue("Background Tint"));
                    if (bg != null) {
                        writer.write("background: " + bg);
                        writer.newLine();
                    }
                }
                LOGGER.info("Saved theme to: {}", (Object)themePath);
                QuestTheme.instance = this.currentTheme = ThemeLoader.loadTheme(themePath);
                QuestTheme.instance.clearCache();
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Theme saved: " + String.valueOf(themePath.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to save theme", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block14;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to save theme: " + e.getMessage())));
            }
        }
    }

    private String mapDisplayToThemeKey(String displayName) {
        switch (displayName) {
            case "Quest Spacing": {
                return "quest_spacing";
            }
            case "Completed Color": {
                return "quest_completed_color";
            }
            case "Started Color": {
                return "quest_started_color";
            }
            case "Locked Color": {
                return "quest_locked_color";
            }
            case "Not Started Color": {
                return "quest_not_started_color";
            }
            case "Line Thickness": {
                return "dependency_line_thickness";
            }
            case "Line Color": {
                return "dependency_line_uncompleted_color";
            }
        }
        return null;
    }

    private Object getEditorValue(String displayName) {
        PropertyEditor ed = this.propertyEditors.get(displayName);
        return ed == null ? null : ed.getValue();
    }

    private String buildBackgroundIconString(String path, Number tileSizeValue, Integer tint) {
        int a;
        int tile;
        if (path == null || path.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(path.trim());
        if (tileSizeValue != null && (tile = Math.max(0, (int)Math.round(tileSizeValue.doubleValue()))) > 0) {
            sb.append("; tile_size=").append(tile);
        }
        if (tint != null && (a = tint >> 24 & 0xFF) != 0) {
            sb.append("; color=").append(String.format("#%08X", tint));
        }
        return sb.toString();
    }

    private String formatPropertyValue(Object value) {
        if (value instanceof Integer) {
            int color = (Integer)value;
            return String.format("#%08X", color);
        }
        if (value instanceof Float) {
            return String.format("%.2f", (Float)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        return value.toString();
    }

    private void loadTheme() {
        block7: {
            try {
                Path themesDir = Paths.get("config", "questory", "themes");
                if (!Files.exists(themesDir, new LinkOption[0])) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"No themes directory found"));
                    }
                    return;
                }
                ArrayList themes = new ArrayList();
                Files.list(themesDir).filter(p -> p.toString().endsWith(".txt")).forEach(p -> themes.add(p.getFileName().toString().replace(".txt", "")));
                if (themes.isEmpty()) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("No themes found in " + String.valueOf(themesDir))));
                    }
                    return;
                }
                String themeName = (String)themes.get(0);
                Path themePath = themesDir.resolve(themeName + ".txt");
                QuestTheme.instance = this.currentTheme = ThemeLoader.loadTheme(themePath);
                QuestTheme.instance.clearCache();
                this.previewDirty = true;
                LOGGER.info("Loaded theme: {}", (Object)themeName);
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Loaded theme: " + themeName + " (" + themes.size() + " available)")));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load theme", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block7;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to load theme: " + e.getMessage())));
            }
        }
    }

    private void resetTheme() {
        this.currentTheme = new QuestTheme();
        this.previewDirty = true;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        this.renderEditorPanel(graphics, mouseX, mouseY);
        this.renderPreviewPanel(graphics, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, -1);
    }

    private void renderEditorPanel(class_332 graphics, int mouseX, int mouseY) {
        int panelX = this.field_22789 - 300;
        int panelY = 0;
        int panelHeight = this.field_22790;
        graphics.method_25294(panelX, panelY, panelX + 300, panelY + panelHeight, -536870912);
        graphics.method_25294(panelX, panelY, panelX + 2, panelY + panelHeight, -12566464);
        int propertyY = 200 - this.scrollOffset;
        for (Map.Entry<String, PropertyEditor> entry : this.propertyEditors.entrySet()) {
            if (propertyY > 200 && propertyY < this.field_22790 - 60) {
                String label = entry.getKey();
                PropertyEditor editor = entry.getValue();
                graphics.method_25303(this.field_22793, label, panelX + 10, propertyY, -1);
                editor.render(graphics, panelX + 10, propertyY + 12, 280, 20, mouseX, mouseY);
                propertyY += 40;
                continue;
            }
            propertyY += 40;
        }
        this.maxScroll = Math.max(0, propertyY - (this.field_22790 - 260));
    }

    private void renderPreviewPanel(class_332 graphics, int mouseX, int mouseY) {
        int previewX = 10;
        int previewY = 40;
        int previewHeight = this.field_22790 - 80;
        graphics.method_25294(previewX, previewY, previewX + 400, previewY + previewHeight, -536870912);
        graphics.method_25294(previewX, previewY, previewX + 400, previewY + 2, -12566464);
        graphics.method_25300(this.field_22793, "Preview", previewX + 200, previewY + 10, -256);
        this.renderPreviewQuest(graphics, previewX + 50, previewY + 100, mouseX, mouseY);
        this.renderPreviewDependencyLine(graphics, previewX + 50, previewY + 100, previewX + 200, previewY + 200);
        this.renderPreviewQuest(graphics, previewX + 200, previewY + 200, mouseX, mouseY);
    }

    private void renderPreviewQuest(class_332 graphics, int x, int y, int mouseX, int mouseY) {
        int size = 40;
        int pulseColor = AnimationHelper.getPulsingColor(-1);
        graphics.method_25294(x - 1, y - 1, x + size + 1, y + size + 1, pulseColor);
        graphics.method_25294(x, y, x + size, y + size, -12566464);
        graphics.method_25294(x + 10, y + 10, x + 30, y + 30, -16711681);
        int indicatorSize = 12;
        graphics.method_25294(x + size - indicatorSize, y, x + size, y + indicatorSize, -16711936);
    }

    private void renderPreviewDependencyLine(class_332 graphics, int x1, int y1, int x2, int y2) {
        float offset = AnimationHelper.DependencyLineAnimation.getLineOffset(true, 0.001);
        int lineColor = AnimationHelper.DependencyLineAnimation.getAnimatedLineColor(-1, false, true);
        graphics.method_25294(x1, y1, x2, y1 + 2, lineColor);
        graphics.method_25294(x2 - 2, y1, x2, y2, lineColor);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (mouseX > (double)(this.field_22789 - 300)) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScroll, (double)this.scrollOffset - delta * 10.0));
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void loadNextPreset() {
        block13: {
            try {
                if (this.field_22787 == null) {
                    return;
                }
                String name = BUILTIN_PRESETS[this.presetIndex];
                this.presetIndex = (this.presetIndex + 1) % BUILTIN_PRESETS.length;
                class_2960 rl = new class_2960("questory", "presets/" + name + ".txt");
                class_3300 rm = this.field_22787.method_1478();
                Optional res = rm.method_14486(rl);
                if (res.isPresent()) {
                    List<String> lines;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(((class_3298)res.get()).method_14482(), StandardCharsets.UTF_8));){
                        lines = reader.lines().toList();
                    }
                    QuestTheme.instance = this.currentTheme = ThemeLoader.parseTheme(lines);
                    QuestTheme.instance.clearCache();
                    this.themeName = name;
                    if (this.themeNameBox != null) {
                        this.themeNameBox.method_1852(this.themeName);
                    }
                    this.previewDirty = true;
                    if (this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Loaded preset: " + name)));
                    }
                    break block13;
                }
                if (this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Preset not found: " + name)));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load preset", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block13;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to load preset: " + e.getMessage())));
            }
        }
    }

    private void exportThemeJson() {
        block4: {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                JsonObject root = new JsonObject();
                root.addProperty("name", this.themeNameBox != null ? this.themeNameBox.method_1882() : this.themeName);
                JsonObject props = new JsonObject();
                for (Map.Entry<String, PropertyEditor> e : this.propertyEditors.entrySet()) {
                    String display = e.getKey();
                    Object v = e.getValue().getValue();
                    if (v == null) continue;
                    props.add(display, this.toJsonPrimitive(v));
                }
                root.add("properties", (JsonElement)props);
                Path dir = Paths.get("config", "questory", "themes");
                Files.createDirectories(dir, new FileAttribute[0]);
                Path out = dir.resolve((this.themeNameBox != null ? this.themeNameBox.method_1882() : this.themeName) + ".json");
                Files.writeString(out, (CharSequence)gson.toJson((JsonElement)root), new OpenOption[0]);
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Exported JSON: " + String.valueOf(out.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to export JSON", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block4;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to export JSON: " + e.getMessage())));
            }
        }
    }

    private void importThemeJson() {
        block18: {
            Gson gson = new GsonBuilder().create();
            try {
                JsonObject props;
                String name;
                Path dir = Paths.get("config", "questory", "themes");
                if (!Files.exists(dir, new LinkOption[0])) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("No themes dir: " + String.valueOf(dir))));
                    }
                    return;
                }
                Path chosen = null;
                try (Stream<Path> stream = Files.list(dir);){
                    Iterator<Path> iterator = stream.filter(p -> p.toString().endsWith(".json")).toList().iterator();
                    if (iterator.hasNext()) {
                        Path p2;
                        chosen = p2 = iterator.next();
                    }
                }
                if (chosen == null) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"No JSON themes found"));
                    }
                    return;
                }
                String content = Files.readString(chosen);
                JsonObject root = (JsonObject)gson.fromJson(content, JsonObject.class);
                this.themeName = name = root.has("name") ? root.get("name").getAsString() : "imported_theme";
                if (this.themeNameBox != null) {
                    this.themeNameBox.method_1852(name);
                }
                if ((props = root.getAsJsonObject("properties")) != null) {
                    for (Map.Entry e : props.entrySet()) {
                        PropertyEditor ed = this.propertyEditors.get(e.getKey());
                        if (ed == null) continue;
                        ed.setValue(this.fromJsonPrimitive((JsonElement)e.getValue()));
                    }
                }
                this.previewDirty = true;
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Imported JSON: " + String.valueOf(chosen.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to import JSON", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block18;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to import JSON: " + e.getMessage())));
            }
        }
    }

    private JsonElement toJsonPrimitive(Object v) {
        if (v instanceof Integer) {
            Integer i = (Integer)v;
            return new JsonPrimitive((Number)i);
        }
        if (v instanceof Float) {
            Float f = (Float)v;
            return new JsonPrimitive((Number)f);
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return new JsonPrimitive(b);
        }
        return new JsonPrimitive(String.valueOf(v));
    }

    private Object fromJsonPrimitive(JsonElement el) {
        if (el != null && el.isJsonPrimitive()) {
            JsonPrimitive prim = el.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isNumber()) {
                double d = prim.getAsDouble();
                if (Math.floor(d) == d) {
                    return (int)d;
                }
                return Float.valueOf((float)d);
            }
            if (prim.isString()) {
                return prim.getAsString();
            }
        }
        return null;
    }

    private static class SliderEditor
    extends PropertyEditor {
        private float min;
        private float max;
        private float current;

        public SliderEditor(String name, float min, float max, float defaultValue) {
            super(name);
            this.min = min;
            this.max = max;
            this.current = defaultValue;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.method_25294(x, y + height / 2 - 2, x + width, y + height / 2 + 2, -12566464);
            int handleX = (int)((float)x + (this.current - this.min) / (this.max - this.min) * (float)width);
            graphics.method_25294(handleX - 3, y, handleX + 3, y + height, -1);
            String valueStr = String.format("%.2f", Float.valueOf(this.current));
            graphics.method_25303(class_310.method_1551().field_1772, valueStr, x + width + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.current);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Number) {
                this.current = ((Number)value).floatValue();
            }
        }
    }

    private static class TextEditor
    extends PropertyEditor {
        private String text;

        public TextEditor(String name, String defaultValue) {
            super(name);
            this.text = defaultValue;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.method_25294(x, y, x + width, y + height, -14671840);
            graphics.method_25303(class_310.method_1551().field_1772, this.text, x + 2, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.text;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof String) {
                this.text = (String)value;
            }
        }
    }

    private static class ColorEditor
    extends PropertyEditor {
        private int color;

        public ColorEditor(String name, int defaultColor) {
            super(name);
            this.color = defaultColor;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.method_25294(x, y, x + height, y + height, this.color);
            graphics.method_25294(x, y, x + height, y + 1, -1);
            graphics.method_25294(x, y, x + 1, y + height, -1);
            graphics.method_25294(x + height - 1, y, x + height, y + height, -1);
            graphics.method_25294(x, y + height - 1, x + height, y + height, -1);
            String hexStr = String.format("#%08X", this.color);
            graphics.method_25303(class_310.method_1551().field_1772, hexStr, x + height + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.color;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Integer) {
                this.color = (Integer)value;
            }
        }
    }

    private static class BooleanEditor
    extends PropertyEditor {
        private boolean value;

        public BooleanEditor(String name, boolean defaultValue) {
            super(name);
            this.value = defaultValue;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.method_25294(x, y, x + height, y + height, this.value ? -16711936 : -12566464);
            graphics.method_25294(x, y, x + height, y + 1, -1);
            graphics.method_25294(x, y, x + 1, y + height, -1);
            graphics.method_25294(x + height - 1, y, x + height, y + height, -1);
            graphics.method_25294(x, y + height - 1, x + height, y + height, -1);
            String label = this.value ? "Enabled" : "Disabled";
            graphics.method_25303(class_310.method_1551().field_1772, label, x + height + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Boolean) {
                this.value = (Boolean)value;
            }
        }
    }

    private static abstract class PropertyEditor {
        protected String propertyName;

        public PropertyEditor(String propertyName) {
            this.propertyName = propertyName;
        }

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public abstract Object getValue();

        public abstract void setValue(Object var1);
    }
}

