/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.importer.FTBQuestImporter;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.OpenGuiPacket;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.storage.QuestStorage;
import org.texboobcat.questory.validation.QuestValidator;

public class QuestCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"quest").then(class_2170.method_9247((String)"list").executes(QuestCommands::listQuests))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"questId", (ArgumentType)StringArgumentType.string()).executes(QuestCommands::showQuestInfo)))).then(class_2170.method_9247((String)"progress").executes(QuestCommands::showProgress))).then(class_2170.method_9247((String)"complete").then(class_2170.method_9244((String)"questId", (ArgumentType)StringArgumentType.string()).executes(QuestCommands::completeQuest)))).then(class_2170.method_9247((String)"reset").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"questId", (ArgumentType)StringArgumentType.string()).requires(source -> source.method_9259(2))).executes(QuestCommands::resetQuest)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(2))).executes(QuestCommands::reloadQuests))).then(class_2170.method_9247((String)"track").then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).requires(source -> source.method_9259(2))).executes(QuestCommands::trackProgress))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"import").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ftb").requires(source -> source.method_9259(2))).executes(QuestCommands::importFTBQuestsAuto)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).requires(source -> source.method_9259(2))).executes(QuestCommands::importFTBQuests)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ftb-clean").requires(source -> source.method_9259(2))).executes(QuestCommands::cleanFTBQuests)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"validate").requires(source -> source.method_9259(2))).executes(QuestCommands::validateQuests))).then(class_2170.method_9247((String)"config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(2))).executes(QuestCommands::reloadConfig)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"daily").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"status").executes(ctx -> {
            String s = DailyQuestManager.getInstance().getStatusSummary();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)s).method_27692(class_124.field_1054), false);
            return 1;
        }))).then(class_2170.method_9247((String)"reload").executes(ctx -> {
            boolean ok = DailyQuestManager.getInstance().reload();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)(ok ? "Daily reloaded" : "Daily reload failed")).method_27692(ok ? class_124.field_1060 : class_124.field_1061), true);
            if (ok) {
                MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
                QuestManager qm = QuestManager.getInstance();
                for (class_3222 sp : server.method_3760().method_14571()) {
                    qm.onPlayerJoin(sp);
                }
            }
            return ok ? 1 : 0;
        }))).then(class_2170.method_9247((String)"enable").executes(ctx -> {
            DailyQuestManager.getInstance().setEnabled(true);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Daily enabled").method_27692(class_124.field_1060), true);
            return 1;
        }))).then(class_2170.method_9247((String)"disable").executes(ctx -> {
            DailyQuestManager.getInstance().setEnabled(false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Daily disabled").method_27692(class_124.field_1054), true);
            return 1;
        }))).then(class_2170.method_9247((String)"seturl").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String url = StringArgumentType.getString((CommandContext)ctx, (String)"url");
            DailyQuestManager.getInstance().setRemoteUrl(url);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Daily URL set").method_27692(class_124.field_1060), true);
            return 1;
        }))))).then(class_2170.method_9247((String)"gui").executes(QuestCommands::openGui)));
    }

    private static int cleanFTBQuests(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        QuestManager manager = QuestManager.getInstance();
        int removed = 0;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Quest q : manager.getAllQuests()) {
            if (!q.getId().startsWith("ftb_")) continue;
            toRemove.add(q.getId());
        }
        for (String id : toRemove) {
            manager.unregisterQuest(id);
            ++removed;
        }
        int removedCount = removed;
        source.method_9226(() -> class_2561.method_43470((String)("Removed " + removedCount + " imported FTB quests")).method_27692(class_124.field_1054), true);
        manager.reload();
        return removed;
    }

    private static int listQuests(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        QuestManager manager = QuestManager.getInstance();
        List<Quest> visibleQuests = manager.getVisibleQuests(player.method_5667());
        QuestProgress progress = manager.getProgress(player.method_5667());
        player.method_43496((class_2561)class_2561.method_43470((String)"=== Your Quests ===").method_27692(class_124.field_1065));
        for (Quest quest : visibleQuests) {
            boolean completed = progress.isQuestCompleted(quest.getId());
            String status = completed ? "\u2713" : " ";
            class_124 color = completed ? class_124.field_1060 : class_124.field_1068;
            player.method_43496((class_2561)class_2561.method_43470((String)("[" + status + "] " + quest.getTitle() + " (" + quest.getId() + ")")).method_27692(color));
        }
        player.method_43496((class_2561)class_2561.method_43470((String)("Total: " + visibleQuests.size() + " quests")).method_27692(class_124.field_1080));
        return visibleQuests.size();
    }

    private static int showQuestInfo(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String questId = StringArgumentType.getString(context, (String)"questId");
        QuestManager manager = QuestManager.getInstance();
        Quest quest = manager.getQuest(questId);
        if (quest == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Quest not found: " + questId)).method_27692(class_124.field_1061));
            return 0;
        }
        QuestProgress progress = manager.getProgress(player.method_5667());
        player.method_43496((class_2561)class_2561.method_43470((String)("=== " + quest.getTitle() + " ===")).method_27692(class_124.field_1065));
        player.method_43496((class_2561)class_2561.method_43470((String)quest.getDescription()).method_27692(class_124.field_1068));
        player.method_43496((class_2561)class_2561.method_43470((String)""));
        player.method_43496((class_2561)class_2561.method_43470((String)"Requirements:").method_27692(class_124.field_1054));
        for (Requirement req : quest.getRequirements()) {
            String progressText = req.getProgressDisplay(progress, questId);
            player.method_43496((class_2561)class_2561.method_43470((String)("  - " + progressText)).method_27692(class_124.field_1068));
        }
        player.method_43496((class_2561)class_2561.method_43470((String)""));
        player.method_43496((class_2561)class_2561.method_43470((String)"Rewards:").method_27692(class_124.field_1054));
        for (Reward reward : quest.getRewards()) {
            player.method_43496((class_2561)class_2561.method_43470((String)("  - " + reward.getDisplayString())).method_27692(class_124.field_1060));
        }
        player.method_43496((class_2561)class_2561.method_43470((String)""));
        if (progress.isQuestCompleted(questId)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Status: Completed \u2713").method_27692(class_124.field_1060));
        } else if (quest.canComplete(progress)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Status: Ready to complete!").method_27692(class_124.field_1060));
        } else if (quest.areRequirementsMet(progress)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Status: Requirements met, but dependencies not satisfied").method_27692(class_124.field_1054));
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"Status: In progress").method_27692(class_124.field_1054));
        }
        return 1;
    }

    private static int showProgress(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.method_5667());
        Collection<Quest> allQuests = manager.getAllQuests();
        int completed = progress.getCompletedQuests().size();
        player.method_43496((class_2561)class_2561.method_43470((String)"=== Quest Progress ===").method_27692(class_124.field_1065));
        player.method_43496((class_2561)class_2561.method_43470((String)("Completed: " + completed + "/" + allQuests.size())).method_27692(class_124.field_1068));
        List<Quest> completable = manager.getCompletableQuests(player.method_5667());
        if (!completable.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43470((String)""));
            player.method_43496((class_2561)class_2561.method_43470((String)("Ready to complete (" + completable.size() + "):")).method_27692(class_124.field_1060));
            for (Quest quest : completable) {
                player.method_43496((class_2561)class_2561.method_43470((String)("  - " + quest.getTitle())).method_27692(class_124.field_1068));
            }
        }
        return 1;
    }

    private static int completeQuest(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String questId = StringArgumentType.getString(context, (String)"questId");
        QuestManager manager = QuestManager.getInstance();
        if (manager.completeQuest(player, questId)) {
            Quest quest = manager.getQuest(questId);
            player.method_43496((class_2561)class_2561.method_43470((String)("Quest completed: " + quest.getTitle())).method_27692(class_124.field_1060));
            return 1;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)("Cannot complete quest: " + questId)).method_27692(class_124.field_1061));
        return 0;
    }

    private static int importFTBQuestsAuto(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        Path configPath = Questory.getConfigPath();
        List<Path> candidates = List.of(configPath.resolve("fabric").resolve("ftbquests"), configPath.resolve("neoforge").resolve("ftbquests"), configPath.resolve("forge").resolve("ftbquests"), configPath.resolve("ftbquests"));
        Path detected = null;
        for (Path p : candidates) {
            if (!Files.exists(p, new LinkOption[0])) continue;
            boolean hasQuests = Files.exists(p.resolve("quests"), new LinkOption[0]);
            boolean hasSNBT = false;
            try (Stream<Path> s2 = Files.walk(p, 2, new FileVisitOption[0]);){
                hasSNBT = s2.anyMatch(pp -> pp.toString().endsWith(".snbt"));
            }
            catch (Exception s2) {
                // empty catch block
            }
            if (!hasQuests && !hasSNBT) continue;
            detected = p;
            break;
        }
        if (detected == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Could not auto-detect FTB Quests folder under config/. Provide a path: /quest import ftb <path>"));
            return 0;
        }
        Path detectedPath = detected;
        source.method_9226(() -> class_2561.method_43470((String)("Auto-detected FTB Quests at: " + String.valueOf(detectedPath))).method_27692(class_124.field_1054), true);
        try {
            FTBQuestImporter importer = new FTBQuestImporter(detected, new QuestStorage(Questory.getDataPath()));
            FTBQuestImporter.ImportResult result = importer.importFromFTBQuests();
            if (result.success) {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully imported " + result.questCount + " quests!")).method_27692(class_124.field_1060), true);
                for (String logLine : result.log) {
                    source.method_9226(() -> class_2561.method_43470((String)("  " + logLine)).method_27692(class_124.field_1080), false);
                }
                QuestManager.getInstance().reload();
                return result.questCount;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)"Import failed! Check console for details."));
            return 0;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Import error: " + e.getMessage())).method_27692(class_124.field_1061));
            e.printStackTrace();
            return 0;
        }
    }

    private static int resetQuest(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String questId = StringArgumentType.getString(context, (String)"questId");
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.method_5667());
        progress.resetQuest(questId);
        player.method_43496((class_2561)class_2561.method_43470((String)("Quest reset: " + questId)).method_27692(class_124.field_1054));
        return 1;
    }

    private static int reloadQuests(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        QuestManager.getInstance().reload();
        source.method_9226(() -> class_2561.method_43470((String)"Reloaded quest system").method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int trackProgress(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String type = StringArgumentType.getString(context, (String)"type");
        String id = StringArgumentType.getString(context, (String)"id");
        QuestManager manager = QuestManager.getInstance();
        switch (type.toLowerCase()) {
            case "item": {
                manager.trackItemProgress(player.method_5667(), id, 1);
                break;
            }
            case "craft": {
                manager.trackCraftingProgress(player.method_5667(), id, 1);
                break;
            }
            case "kill": {
                manager.trackEntityKillProgress(player.method_5667(), id, 1);
                break;
            }
            case "advancement": {
                manager.trackAdvancementProgress(player.method_5667(), id);
                break;
            }
            case "command": {
                manager.trackCommandProgress(player.method_5667(), id);
                break;
            }
            default: {
                player.method_43496((class_2561)class_2561.method_43470((String)("Unknown tracking type: " + type)).method_27692(class_124.field_1061));
                return 0;
            }
        }
        player.method_43496((class_2561)class_2561.method_43470((String)("Tracked progress: " + type + " - " + id)).method_27692(class_124.field_1060));
        return 1;
    }

    private static int importFTBQuests(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String pathString = StringArgumentType.getString(context, (String)"path");
        source.method_9226(() -> class_2561.method_43470((String)("Starting FTB Quests import from: " + pathString)).method_27692(class_124.field_1054), true);
        try {
            Path ftbPath = Paths.get(pathString, new String[0]);
            FTBQuestImporter importer = new FTBQuestImporter(ftbPath, new QuestStorage(Questory.getDataPath()));
            FTBQuestImporter.ImportResult result = importer.importFromFTBQuests();
            if (result.success) {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully imported " + result.questCount + " quests!")).method_27692(class_124.field_1060), true);
                for (String logLine : result.log) {
                    source.method_9226(() -> class_2561.method_43470((String)("  " + logLine)).method_27692(class_124.field_1080), false);
                }
                QuestManager.getInstance().reload();
                return result.questCount;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)"Import failed! Check console for details."));
            return 0;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Import error: " + e.getMessage())).method_27692(class_124.field_1061));
            e.printStackTrace();
            return 0;
        }
    }

    private static int validateQuests(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"Validating all quests...").method_27692(class_124.field_1054), true);
        QuestManager manager = QuestManager.getInstance();
        Map<String, QuestValidator.ValidationResult> results = QuestValidator.validateAll(manager.getAllQuests().stream().collect(Collectors.toMap(Quest::getId, q -> q)));
        int totalQuests = results.size();
        int validQuests = (int)results.values().stream().filter(r -> r.isValid()).count();
        int questsWithWarnings = (int)results.values().stream().filter(r -> r.hasWarnings()).count();
        int invalidQuests = totalQuests - validQuests;
        source.method_9226(() -> class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)"Quest Validation Results").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Total Quests: " + totalQuests)), false);
        source.method_9226(() -> class_2561.method_43470((String)("Valid: " + validQuests)).method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Invalid: " + invalidQuests)).method_27692(invalidQuests > 0 ? class_124.field_1061 : class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("With Warnings: " + questsWithWarnings)).method_27692(questsWithWarnings > 0 ? class_124.field_1054 : class_124.field_1060), false);
        for (Map.Entry<String, QuestValidator.ValidationResult> entry : results.entrySet()) {
            QuestValidator.ValidationResult result = entry.getValue();
            if (result.isValid() && !result.hasWarnings()) continue;
            source.method_9226(() -> class_2561.method_43470((String)("\n" + result.getSummary())).method_27692(class_124.field_1068), false);
        }
        return validQuests;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            QuestoryConfig.reload(Questory.getConfigPath());
            source.method_9226(() -> class_2561.method_43470((String)"Config reloaded successfully").method_27692(class_124.field_1060), true);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Failed to reload config: " + e.getMessage())).method_27692(class_124.field_1061));
            return 0;
        }
    }

    private static int openGui(CommandContext<class_2168> context) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            NetworkManager.sendToClient(player, new OpenGuiPacket());
            return 1;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Failed to open GUI: " + e.getMessage())).method_27692(class_124.field_1061));
            return 0;
        }
    }
}

