/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.api.events.QuestCompletedEvent;
import org.texboobcat.questory.api.events.QuestEventBus;
import org.texboobcat.questory.api.events.QuestProgressEvent;
import org.texboobcat.questory.api.events.QuestStartedEvent;
import org.texboobcat.questory.api.events.QuestUnlockedEvent;
import org.texboobcat.questory.api.events.RewardClaimedEvent;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.quest.Quest;

public final class ScriptIntegration {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    private ScriptIntegration() {
    }

    public static void init() {
        QuestEventBus.register(QuestUnlockedEvent.class, ScriptIntegration::onQuestUnlocked);
        QuestEventBus.register(QuestCompletedEvent.class, ScriptIntegration::onQuestCompleted);
        QuestEventBus.register(QuestStartedEvent.class, ScriptIntegration::onQuestStarted);
        QuestEventBus.register(QuestProgressEvent.class, ScriptIntegration::onQuestProgress);
        QuestEventBus.register(RewardClaimedEvent.class, ScriptIntegration::onRewardClaimed);
        System.out.println("[Questory] ScriptIntegration initialized (listeners registered)");
    }

    private static void onQuestUnlocked(QuestUnlockedEvent ev) {
        if (!QuestoryConfig.getInstance().scriptEmitOnUnlock) {
            return;
        }
        ScriptIntegration.handleEvent("quest_unlocked", ev.getPlayer(), ev.getQuest(), null);
    }

    private static void onQuestCompleted(QuestCompletedEvent ev) {
        if (!QuestoryConfig.getInstance().scriptEmitOnCompleted) {
            return;
        }
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("completion_time", ev.getCompletionTime());
        ScriptIntegration.handleEvent("quest_completed", ev.getPlayer(), ev.getQuest(), extra);
    }

    private static void onQuestStarted(QuestStartedEvent ev) {
        if (!QuestoryConfig.getInstance().scriptEmitOnStarted) {
            return;
        }
        ScriptIntegration.handleEvent("quest_started", ev.getPlayer(), ev.getQuest(), null);
    }

    private static void onQuestProgress(QuestProgressEvent ev) {
        if (!QuestoryConfig.getInstance().scriptEmitOnProgress) {
            return;
        }
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("requirement_type", ev.getRequirement().getType());
        extra.put("old_progress", ev.getOldProgress());
        extra.put("new_progress", ev.getNewProgress());
        ScriptIntegration.handleEvent("quest_progress", ev.getPlayer(), ev.getQuest(), extra);
    }

    private static void onRewardClaimed(RewardClaimedEvent ev) {
        if (!QuestoryConfig.getInstance().scriptEmitOnRewardClaimed) {
            return;
        }
        ScriptIntegration.handleEvent("reward_claimed", ev.getPlayer(), ev.getQuest(), null);
    }

    private static void handleEvent(String type, class_3222 player, Quest quest, Map<String, Object> extra) {
        String template;
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.scriptIntegrationEnabled) {
            return;
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("type", type);
        payload.put("player", player.method_7334().getName());
        payload.put("uuid", player.method_5667().toString());
        payload.put("quest_id", quest.getId());
        payload.put("quest_title", quest.getTitle());
        payload.put("group", quest.getGroup());
        payload.put("timestamp", Instant.now().toString());
        if (extra != null) {
            payload.putAll(extra);
        }
        if (cfg.scriptAllowExternalHttp && cfg.scriptWebhookUrl != null && !cfg.scriptWebhookUrl.isBlank()) {
            try {
                String json = GSON.toJson(payload);
                Object client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
                HttpRequest req = HttpRequest.newBuilder().uri(URI.create(cfg.scriptWebhookUrl)).timeout(Duration.ofMillis(Math.max(1000, cfg.scriptHttpTimeoutMs))).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build();
                CompletableFuture.runAsync(() -> ScriptIntegration.lambda$handleEvent$0((HttpClient)client, req));
            }
            catch (Throwable t) {
                System.err.println("[Questory] Failed to queue webhook: " + t.getMessage());
            }
        }
        switch (type) {
            case "quest_unlocked": {
                String string = cfg.scriptCommandOnUnlock;
                break;
            }
            case "quest_started": {
                String string = cfg.scriptCommandOnStarted;
                break;
            }
            case "quest_progress": {
                String string = cfg.scriptCommandOnProgress;
                break;
            }
            case "quest_completed": {
                String string = cfg.scriptCommandOnComplete;
                break;
            }
            case "reward_claimed": {
                String string = cfg.scriptCommandOnRewardClaimed;
                break;
            }
            default: {
                String string = template = "";
            }
        }
        if (template != null && !template.isBlank()) {
            String snbt = ScriptIntegration.toSnbt(payload);
            ScriptIntegration.runServerCommand(player, "data modify storage questory:ctx set value " + snbt);
            String cmd = ScriptIntegration.substitute(template, payload);
            ScriptIntegration.runServerCommand(player, cmd);
        }
    }

    private static String substitute(String template, Map<String, Object> ctx) {
        String out = template;
        out = out.replace("{player}", String.valueOf(ctx.get("player")));
        out = out.replace("{uuid}", String.valueOf(ctx.get("uuid")));
        out = out.replace("{quest_id}", String.valueOf(ctx.get("quest_id")));
        out = out.replace("{quest_title}", String.valueOf(ctx.get("quest_title")));
        out = out.replace("{group}", String.valueOf(ctx.get("group")));
        out = out.replace("{timestamp}", String.valueOf(ctx.get("timestamp")));
        if (ctx.containsKey("completion_time")) {
            out = out.replace("{completion_time}", String.valueOf(ctx.get("completion_time")));
        }
        if (ctx.containsKey("requirement_type")) {
            out = out.replace("{requirement_type}", String.valueOf(ctx.get("requirement_type")));
        }
        if (ctx.containsKey("old_progress")) {
            out = out.replace("{old_progress}", String.valueOf(ctx.get("old_progress")));
        }
        if (ctx.containsKey("new_progress")) {
            out = out.replace("{new_progress}", String.valueOf(ctx.get("new_progress")));
        }
        return out;
    }

    private static String toSnbt(Map<String, Object> map) {
        String json = GSON.toJson(map);
        return json;
    }

    private static void runServerCommand(class_3222 player, String command) {
        try {
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            class_2168 source = server.method_3739().method_9217().method_9206(4);
            String cmd = command.startsWith("/") ? command.substring(1) : command;
            int res = server.method_3734().method_44252(source, cmd);
            if (res < 1) {
                System.err.println("[Questory] Command returned code " + res + ": " + command);
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to run command: " + t.getMessage());
        }
    }

    private static /* synthetic */ void lambda$handleEvent$0(HttpClient client, HttpRequest req) {
        try {
            HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                System.out.println("[Questory] Webhook OK: " + resp.statusCode());
            } else {
                System.err.println("[Questory] Webhook failed: " + resp.statusCode());
            }
        }
        catch (Exception ex) {
            System.err.println("[Questory] Webhook error: " + ex.getMessage());
        }
    }
}

