/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_310;

public class ClientConfig {
    private static final Gson GSON = new Gson();
    private static final String FILE_NAME = "questory_client.json";
    private static Set<String> pinnedGroups = new HashSet<String>();
    private static Set<String> trackedQuests = new HashSet<String>();
    private static boolean chapterPanelPinned = false;
    private static Set<String> collapsedSections = new HashSet<String>();
    private static boolean loaded = false;
    private static boolean clientEnableAdvancedEditor = true;
    private static int miniMapX = -1;
    private static int miniMapY = -1;
    private static int miniMapW = 0;
    private static int miniMapH = 0;
    private static int miniMapOpacityPct = 75;
    private static int heatX = -1;
    private static int heatY = -1;
    private static int heatW = 180;
    private static int heatH = 74;
    private static int heatOpacityPct = 90;
    private static boolean mapIntegrationEnabled = true;
    private static boolean journeyMapEnabled = true;
    private static String hudPosition = "TOP_LEFT";
    private static float hudScale = 1.0f;
    private static int hudOpacity = 80;
    private static boolean hudCompactMode = false;
    private static boolean hudShowIcons = true;
    private static boolean hudShowProgressBars = true;
    private static int hudOffsetX = 10;
    private static int hudOffsetY = 10;
    private static boolean suppressUiScaleEditorWarning = false;

    private static File getConfigFile() {
        File dir = new File(class_310.method_1551().field_1697, "config");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, FILE_NAME);
    }

    public static void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            File f = ClientConfig.getConfigFile();
            if (!f.exists()) {
                return;
            }
            String s = Files.readString(f.toPath());
            JsonObject o = (JsonObject)GSON.fromJson(s, JsonObject.class);
            pinnedGroups.clear();
            if (o.has("pinnedGroups") && o.get("pinnedGroups").isJsonArray()) {
                o.getAsJsonArray("pinnedGroups").forEach(e -> pinnedGroups.add(e.getAsString()));
            }
            if (o.has("chapterPanelPinned")) {
                chapterPanelPinned = o.get("chapterPanelPinned").getAsBoolean();
            }
            if (o.has("collapsedSections") && o.get("collapsedSections").isJsonArray()) {
                o.getAsJsonArray("collapsedSections").forEach(e -> collapsedSections.add(e.getAsString()));
            }
            if (o.has("trackedQuests") && o.get("trackedQuests").isJsonArray()) {
                o.getAsJsonArray("trackedQuests").forEach(e -> trackedQuests.add(e.getAsString()));
            }
            if (o.has("miniMapX")) {
                miniMapX = o.get("miniMapX").getAsInt();
            }
            if (o.has("miniMapY")) {
                miniMapY = o.get("miniMapY").getAsInt();
            }
            if (o.has("miniMapW")) {
                miniMapW = o.get("miniMapW").getAsInt();
            }
            if (o.has("miniMapH")) {
                miniMapH = o.get("miniMapH").getAsInt();
            }
            if (o.has("miniMapOpacityPct")) {
                miniMapOpacityPct = o.get("miniMapOpacityPct").getAsInt();
            }
            if (o.has("heatX")) {
                heatX = o.get("heatX").getAsInt();
            }
            if (o.has("heatY")) {
                heatY = o.get("heatY").getAsInt();
            }
            if (o.has("heatW")) {
                heatW = o.get("heatW").getAsInt();
            }
            if (o.has("heatH")) {
                heatH = o.get("heatH").getAsInt();
            }
            if (o.has("heatOpacityPct")) {
                heatOpacityPct = o.get("heatOpacityPct").getAsInt();
            }
            if (o.has("mapIntegrationEnabled")) {
                mapIntegrationEnabled = o.get("mapIntegrationEnabled").getAsBoolean();
            }
            if (o.has("journeyMapEnabled")) {
                journeyMapEnabled = o.get("journeyMapEnabled").getAsBoolean();
            }
            if (o.has("clientEnableAdvancedEditor")) {
                clientEnableAdvancedEditor = o.get("clientEnableAdvancedEditor").getAsBoolean();
            }
            if (o.has("hudPosition")) {
                hudPosition = o.get("hudPosition").getAsString();
            }
            if (o.has("hudScale")) {
                hudScale = o.get("hudScale").getAsFloat();
            }
            if (o.has("hudOpacity")) {
                hudOpacity = o.get("hudOpacity").getAsInt();
            }
            if (o.has("hudCompactMode")) {
                hudCompactMode = o.get("hudCompactMode").getAsBoolean();
            }
            if (o.has("hudShowIcons")) {
                hudShowIcons = o.get("hudShowIcons").getAsBoolean();
            }
            if (o.has("hudShowProgressBars")) {
                hudShowProgressBars = o.get("hudShowProgressBars").getAsBoolean();
            }
            if (o.has("hudOffsetX")) {
                hudOffsetX = o.get("hudOffsetX").getAsInt();
            }
            if (o.has("hudOffsetY")) {
                hudOffsetY = o.get("hudOffsetY").getAsInt();
            }
            if (o.has("suppressUiScaleEditorWarning")) {
                suppressUiScaleEditorWarning = o.get("suppressUiScaleEditorWarning").getAsBoolean();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void save() {
        try {
            JsonObject o = new JsonObject();
            JsonArray arr = new JsonArray();
            for (String string : pinnedGroups) {
                arr.add(string);
            }
            o.add("pinnedGroups", (JsonElement)arr);
            o.addProperty("chapterPanelPinned", Boolean.valueOf(chapterPanelPinned));
            JsonArray arr2 = new JsonArray();
            for (String s : collapsedSections) {
                arr2.add(s);
            }
            o.add("collapsedSections", (JsonElement)arr2);
            JsonArray jsonArray = new JsonArray();
            for (String q : trackedQuests) {
                jsonArray.add(q);
            }
            o.add("trackedQuests", (JsonElement)jsonArray);
            o.addProperty("miniMapX", (Number)miniMapX);
            o.addProperty("miniMapY", (Number)miniMapY);
            o.addProperty("miniMapW", (Number)miniMapW);
            o.addProperty("miniMapH", (Number)miniMapH);
            o.addProperty("miniMapOpacityPct", (Number)miniMapOpacityPct);
            o.addProperty("heatX", (Number)heatX);
            o.addProperty("heatY", (Number)heatY);
            o.addProperty("heatW", (Number)heatW);
            o.addProperty("heatH", (Number)heatH);
            o.addProperty("heatOpacityPct", (Number)heatOpacityPct);
            o.addProperty("mapIntegrationEnabled", Boolean.valueOf(mapIntegrationEnabled));
            o.addProperty("journeyMapEnabled", Boolean.valueOf(journeyMapEnabled));
            o.addProperty("clientEnableAdvancedEditor", Boolean.valueOf(clientEnableAdvancedEditor));
            o.addProperty("hudPosition", hudPosition);
            o.addProperty("hudScale", (Number)Float.valueOf(hudScale));
            o.addProperty("hudOpacity", (Number)hudOpacity);
            o.addProperty("hudCompactMode", Boolean.valueOf(hudCompactMode));
            o.addProperty("hudShowIcons", Boolean.valueOf(hudShowIcons));
            o.addProperty("hudShowProgressBars", Boolean.valueOf(hudShowProgressBars));
            o.addProperty("hudOffsetX", (Number)hudOffsetX);
            o.addProperty("hudOffsetY", (Number)hudOffsetY);
            o.addProperty("suppressUiScaleEditorWarning", Boolean.valueOf(suppressUiScaleEditorWarning));
            Files.writeString(ClientConfig.getConfigFile().toPath(), (CharSequence)GSON.toJson((JsonElement)o), new OpenOption[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Set<String> getPinnedGroups() {
        ClientConfig.load();
        return new HashSet<String>(pinnedGroups);
    }

    public static void togglePinned(String group) {
        ClientConfig.load();
        if (pinnedGroups.contains(group)) {
            pinnedGroups.remove(group);
        } else {
            pinnedGroups.add(group);
        }
        ClientConfig.save();
    }

    public static boolean isChapterPanelPinned() {
        ClientConfig.load();
        return chapterPanelPinned;
    }

    public static void toggleChapterPanelPinned() {
        ClientConfig.load();
        chapterPanelPinned = !chapterPanelPinned;
        ClientConfig.save();
    }

    public static Set<String> getCollapsedSections() {
        ClientConfig.load();
        return new HashSet<String>(collapsedSections);
    }

    public static void toggleSectionCollapsed(String sectionId) {
        ClientConfig.load();
        if (collapsedSections.contains(sectionId)) {
            collapsedSections.remove(sectionId);
        } else {
            collapsedSections.add(sectionId);
        }
        ClientConfig.save();
    }

    public static int getMiniMapX() {
        ClientConfig.load();
        return miniMapX;
    }

    public static int getMiniMapY() {
        ClientConfig.load();
        return miniMapY;
    }

    public static int getMiniMapW() {
        ClientConfig.load();
        return miniMapW;
    }

    public static int getMiniMapH() {
        ClientConfig.load();
        return miniMapH;
    }

    public static void setMiniMapRect(int x, int y, int w, int h) {
        ClientConfig.load();
        miniMapX = x;
        miniMapY = y;
        miniMapW = w;
        miniMapH = h;
        ClientConfig.save();
    }

    public static int getMiniMapOpacityPct() {
        ClientConfig.load();
        return miniMapOpacityPct;
    }

    public static void setMiniMapOpacityPct(int pct) {
        ClientConfig.load();
        miniMapOpacityPct = Math.max(0, Math.min(100, pct));
        ClientConfig.save();
    }

    public static int getHeatX() {
        ClientConfig.load();
        return heatX;
    }

    public static int getHeatY() {
        ClientConfig.load();
        return heatY;
    }

    public static int getHeatW() {
        ClientConfig.load();
        return heatW;
    }

    public static int getHeatH() {
        ClientConfig.load();
        return heatH;
    }

    public static void setHeatRect(int x, int y, int w, int h) {
        ClientConfig.load();
        heatX = x;
        heatY = y;
        heatW = w;
        heatH = h;
        ClientConfig.save();
    }

    public static int getHeatOpacityPct() {
        ClientConfig.load();
        return heatOpacityPct;
    }

    public static void setHeatOpacityPct(int pct) {
        ClientConfig.load();
        heatOpacityPct = Math.max(0, Math.min(100, pct));
        ClientConfig.save();
    }

    public static boolean isMapIntegrationEnabled() {
        ClientConfig.load();
        return mapIntegrationEnabled;
    }

    public static void setMapIntegrationEnabled(boolean enabled) {
        ClientConfig.load();
        mapIntegrationEnabled = enabled;
        ClientConfig.save();
    }

    public static boolean isJourneyMapEnabled() {
        ClientConfig.load();
        return journeyMapEnabled;
    }

    public static void setJourneyMapEnabled(boolean enabled) {
        ClientConfig.load();
        journeyMapEnabled = enabled;
        ClientConfig.save();
    }

    public static boolean isClientEnableAdvancedEditor() {
        ClientConfig.load();
        return clientEnableAdvancedEditor;
    }

    public static void setClientEnableAdvancedEditor(boolean enabled) {
        ClientConfig.load();
        clientEnableAdvancedEditor = enabled;
        ClientConfig.save();
    }

    public static Set<String> getTrackedQuests() {
        ClientConfig.load();
        return new HashSet<String>(trackedQuests);
    }

    public static boolean isQuestTracked(String questId) {
        ClientConfig.load();
        return trackedQuests.contains(questId);
    }

    public static void setQuestTracked(String questId, boolean tracked) {
        ClientConfig.load();
        if (tracked) {
            trackedQuests.add(questId);
        } else {
            trackedQuests.remove(questId);
        }
        ClientConfig.save();
    }

    public static String getHudPosition() {
        ClientConfig.load();
        return hudPosition;
    }

    public static void setHudPosition(String pos) {
        ClientConfig.load();
        hudPosition = pos;
        ClientConfig.save();
    }

    public static float getHudScale() {
        ClientConfig.load();
        return hudScale;
    }

    public static void setHudScale(float scale) {
        ClientConfig.load();
        hudScale = Math.max(0.5f, Math.min(2.0f, scale));
        ClientConfig.save();
    }

    public static int getHudOpacity() {
        ClientConfig.load();
        return hudOpacity;
    }

    public static void setHudOpacity(int opacity) {
        ClientConfig.load();
        hudOpacity = Math.max(0, Math.min(100, opacity));
        ClientConfig.save();
    }

    public static boolean isHudCompactMode() {
        ClientConfig.load();
        return hudCompactMode;
    }

    public static void setHudCompactMode(boolean compact) {
        ClientConfig.load();
        hudCompactMode = compact;
        ClientConfig.save();
    }

    public static boolean isHudShowIcons() {
        ClientConfig.load();
        return hudShowIcons;
    }

    public static void setHudShowIcons(boolean show) {
        ClientConfig.load();
        hudShowIcons = show;
        ClientConfig.save();
    }

    public static boolean isHudShowProgressBars() {
        ClientConfig.load();
        return hudShowProgressBars;
    }

    public static void setHudShowProgressBars(boolean show) {
        ClientConfig.load();
        hudShowProgressBars = show;
        ClientConfig.save();
    }

    public static int getHudOffsetX() {
        ClientConfig.load();
        return hudOffsetX;
    }

    public static void setHudOffsetX(int offset) {
        ClientConfig.load();
        hudOffsetX = offset;
        ClientConfig.save();
    }

    public static int getHudOffsetY() {
        ClientConfig.load();
        return hudOffsetY;
    }

    public static void setHudOffsetY(int offset) {
        ClientConfig.load();
        hudOffsetY = offset;
        ClientConfig.save();
    }

    public static boolean isSuppressUiScaleEditorWarning() {
        ClientConfig.load();
        return suppressUiScaleEditorWarning;
    }

    public static void setSuppressUiScaleEditorWarning(boolean suppress) {
        ClientConfig.load();
        suppressUiScaleEditorWarning = suppress;
        ClientConfig.save();
    }
}

