/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.ChapterDefaultsTabPanel;
import org.texboobcat.questory.client.gui.ChapterGeneralTabPanel;
import org.texboobcat.questory.client.gui.ChapterImagesTabPanel;
import org.texboobcat.questory.client.gui.ChapterLinksTabPanel;
import org.texboobcat.questory.client.gui.ChapterPreviewTabPanel;
import org.texboobcat.questory.network.ChapterDataUpdateRequestPacket;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.quest.ChapterData;

public class ChapterArtEditorScreen
extends class_437 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final int SIDEBAR_W = 240;
    private static final int TAB_H = 24;
    private static final int HEADER_H = 32;
    private static final int FOOTER_H = 36;
    private static final int PAD = 8;
    private final class_437 parent;
    private ChapterData workingChapter;
    private String originalId;
    private Tab activeTab = Tab.GENERAL;
    private class_342 searchBox;
    private List<ChapterData> filtered = new ArrayList<ChapterData>();
    private int listScroll = 0;
    private ChapterGeneralTabPanel generalTab;
    private ChapterDefaultsTabPanel defaultsTab;
    private ChapterImagesTabPanel imagesTab;
    private ChapterLinksTabPanel linksTab;
    private ChapterPreviewTabPanel previewTab;
    private class_4185 tabGeneralBtn;
    private class_4185 tabDefaultsBtn;
    private class_4185 tabImagesBtn;
    private class_4185 tabLinksBtn;
    private class_4185 tabPreviewBtn;
    private class_4185 newBtn;
    private class_4185 saveBtn;
    private class_4185 closeBtn;

    public ChapterArtEditorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Chapter Art Editor"));
        this.parent = parent;
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }

    protected void method_25426() {
        super.method_25426();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "chapter_editor");
        this.searchBox = new class_342(this.field_22793, 8, 8, 224, 18, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search chapters..."));
        this.method_37063((class_364)this.searchBox);
        int tabX = 248;
        int tabY = 8;
        int tabW = 85;
        this.tabGeneralBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"General"), b -> this.switchTab(Tab.GENERAL)).method_46434(tabX, tabY, tabW, 22).method_46431());
        this.tabDefaultsBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Defaults"), b -> this.switchTab(Tab.DEFAULTS)).method_46434(tabX += tabW + 2, tabY, tabW, 22).method_46431());
        this.tabImagesBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Images"), b -> this.switchTab(Tab.IMAGES)).method_46434(tabX += tabW + 2, tabY, tabW, 22).method_46431());
        this.tabLinksBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Quest Links"), b -> this.switchTab(Tab.QUEST_LINKS)).method_46434(tabX += tabW + 2, tabY, tabW + 20, 22).method_46431());
        this.tabPreviewBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Preview"), b -> this.switchTab(Tab.PREVIEW)).method_46434(tabX += tabW + 22, tabY, tabW, 22).method_46431());
        int footerY = this.field_22790 - 36 + 8;
        int btnX = 248;
        this.newBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"New"), b -> this.createNew()).method_46434(btnX, footerY, 60, 20).method_46431());
        this.saveBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.save()).method_46434(btnX += 64, footerY, 60, 20).method_46431());
        int closeX = this.field_22789 - 8 - 60;
        this.closeBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.field_22787.method_1507(this.parent)).method_46434(closeX, footerY, 60, 20).method_46431());
        this.initTabPanels();
        this.reloadChapterList();
        if (!this.filtered.isEmpty()) {
            this.selectChapter(this.filtered.get(0));
        } else {
            this.createNew();
        }
    }

    private void initTabPanels() {
        int contentX = 248;
        int contentY = 40;
        int contentW = this.field_22789 - contentX - 8;
        int contentH = this.field_22790 - contentY - 36 - 8;
        this.generalTab = new ChapterGeneralTabPanel(this, contentX, contentY, contentW, contentH);
        this.defaultsTab = new ChapterDefaultsTabPanel(this, contentX, contentY, contentW, contentH);
        this.imagesTab = new ChapterImagesTabPanel(this, contentX, contentY, contentW, contentH);
        this.linksTab = new ChapterLinksTabPanel(this, contentX, contentY, contentW, contentH);
        this.previewTab = new ChapterPreviewTabPanel(this, contentX, contentY, contentW, contentH);
    }

    private void switchTab(Tab tab) {
        if (this.activeTab == tab) {
            return;
        }
        this.saveCurrentTabToChapter();
        this.activeTab = tab;
        this.loadTabFromChapter();
    }

    private void saveCurrentTabToChapter() {
        if (this.workingChapter == null) {
            return;
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.saveToChapter(this.workingChapter);
                break;
            }
            case 1: {
                this.defaultsTab.saveToChapter(this.workingChapter);
                break;
            }
            case 2: {
                this.imagesTab.saveToChapter(this.workingChapter);
                break;
            }
            case 3: {
                this.linksTab.saveToChapter(this.workingChapter);
            }
        }
    }

    private void loadTabFromChapter() {
        if (this.workingChapter == null) {
            return;
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 1: {
                this.defaultsTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 2: {
                this.imagesTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 3: {
                this.linksTab.loadFromChapter(this.workingChapter);
                break;
            }
            case 4: {
                this.previewTab.loadFromChapter(this.workingChapter);
            }
        }
    }

    private void reloadChapterList() {
        String query = this.searchBox.method_1882().trim().toLowerCase();
        ArrayList<ChapterData> all = new ArrayList<ChapterData>(ClientQuestManager.getInstance().getAllChapters());
        all.sort((a, b) -> a.getTitle().compareToIgnoreCase(b.getTitle()));
        this.filtered = query.isEmpty() ? all : all.stream().filter(ch -> ch.getId().toLowerCase().contains(query) || ch.getTitle().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    private void selectChapter(ChapterData chapter) {
        this.saveCurrentTabToChapter();
        this.workingChapter = chapter;
        this.originalId = chapter.getId();
        this.loadTabFromChapter();
    }

    private void createNew() {
        this.saveCurrentTabToChapter();
        this.workingChapter = new ChapterData("chapter_" + System.currentTimeMillis(), "New Chapter");
        this.originalId = null;
        this.activeTab = Tab.GENERAL;
        this.loadTabFromChapter();
    }

    private void save() {
        block4: {
            if (this.workingChapter == null) {
                return;
            }
            this.saveCurrentTabToChapter();
            try {
                JsonObject json = this.workingChapter.toJson();
                String payload = GSON.toJson((JsonElement)json);
                NetworkManager.sendToServer(new ChapterDataUpdateRequestPacket(payload));
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7aChapter saved successfully"));
                }
                this.originalId = this.workingChapter.getId();
            }
            catch (Exception e) {
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block4;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7cSave failed: " + e.getMessage())));
            }
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        g.method_25294(0, 0, 240, this.field_22790, -804253680);
        int listTop = 32;
        int listBottom = this.field_22790 - 8;
        g.method_25294(8, listTop, 232, listBottom, -534765536);
        this.renderChapterList(g, mouseX, mouseY);
        int contentX = 248;
        int contentY = 40;
        int contentW = this.field_22789 - contentX - 8;
        int contentH = this.field_22790 - contentY - 36 - 8;
        g.method_25294(contentX, contentY, contentX + contentW, contentY + contentH, -535291880);
        this.renderActiveTab(g, mouseX, mouseY, partialTick);
        super.method_25394(g, mouseX, mouseY, partialTick);
        g.method_27535(this.field_22793, this.field_22785, 248, -4, -1);
    }

    private void renderChapterList(class_332 g, int mouseX, int mouseY) {
        this.reloadChapterList();
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.field_22790 - 8;
        int lineH = 16;
        g.method_44379(listX, listTop, listX + listW, listBottom);
        int maxLines = Math.max(1, (listBottom - listTop) / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.filtered.size() - maxLines)));
        for (int i = 0; i < Math.min(maxLines, this.filtered.size() - this.listScroll); ++i) {
            boolean hover;
            ChapterData ch = this.filtered.get(this.listScroll + i);
            int y = listTop + 2 + i * lineH;
            boolean selected = this.workingChapter != null && this.workingChapter.getId().equals(ch.getId());
            boolean bl = hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= y && mouseY < y + lineH;
            if (selected) {
                g.method_25294(listX, y - 1, listX + listW, y + lineH - 1, -12952966);
            } else if (hover) {
                g.method_25294(listX, y - 1, listX + listW, y + lineH - 1, -14013910);
            }
            Object label = ch.getTitle();
            if (this.field_22793.method_1727((String)label) > listW - 4) {
                label = this.field_22793.method_27523((String)label, listW - 10) + "...";
            }
            g.method_25303(this.field_22793, (String)label, listX + 2, y, -1);
        }
        g.method_44380();
    }

    private void renderActiveTab(class_332 g, int mouseX, int mouseY, float partialTick) {
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 1: {
                this.defaultsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 2: {
                this.imagesTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 3: {
                this.linksTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 4: {
                this.previewTab.render(g, mouseX, mouseY, partialTick);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean tabHandled;
        int relY;
        int index;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.field_22790 - 8;
        int lineH = 16;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom && (index = this.listScroll + (relY = (int)mouseY - listTop - 2) / lineH) >= 0 && index < this.filtered.size()) {
            this.selectChapter(this.filtered.get(index));
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 1: {
                boolean bl = this.defaultsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 2: {
                boolean bl = this.imagesTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 3: {
                boolean bl = this.linksTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 4: {
                boolean bl = tabHandled = this.previewTab.mouseClicked(mouseX, mouseY, button);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        boolean tabHandled;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.field_22790 - 8;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta) * 3.0);
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 1: {
                boolean bl = this.defaultsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 2: {
                boolean bl = this.imagesTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 3: {
                boolean bl = this.linksTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 4: {
                boolean bl = tabHandled = this.previewTab.mouseScrolled(mouseX, mouseY, delta);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25421() {
        return false;
    }

    private static enum Tab {
        GENERAL,
        DEFAULTS,
        IMAGES,
        QUEST_LINKS,
        PREVIEW;

    }
}

