/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;

public class DependenciesTabPanel
extends TabPanel {
    private List<Quest> availableQuests = new ArrayList<Quest>();
    private Set<String> selectedDeps = new HashSet<String>();
    private int availableScroll = 0;
    private String searchQuery = "";
    private class_342 searchBox;
    private class_4185 addBtn;
    private class_4185 removeBtn;
    private class_4185 clearBtn;
    private class_4185 modeAllBtn;
    private class_4185 modeOneBtn;
    private class_4185 modeStartedBtn;
    private String depMode = "all_completed";
    private int minRequired = 0;
    private int maxCompletable = 0;
    private boolean hideLines = false;
    private String lineStyle = "solid";

    public DependenciesTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int searchW = this.w / 2 - 20 - 8;
        this.searchBox = new class_342(this.editor.getMinecraft().field_1772, this.x + 16, this.y + 32, searchW, 16, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search quests..."));
        this.searchBox.method_1863(text -> {
            this.searchQuery = text.toLowerCase();
        });
        this.fields.add(this.searchBox);
        int btnY = this.y + this.h - 32;
        this.addBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add Selected \u2192"), b -> this.addSelectedDeps()).method_46434(this.x + 12, btnY, 120, 20).method_46431();
        this.removeBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190 Remove"), b -> this.removeSelectedDeps()).method_46434(this.x + 140, btnY, 100, 20).method_46431();
        this.clearBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear All"), b -> this.clearAllDeps()).method_46434(this.x + 248, btnY, 80, 20).method_46431();
        int modeX = this.x + this.w - 400;
        int modeY = this.y + 12;
        this.modeAllBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"All Complete"), b -> this.setDepMode("all_completed")).method_46434(modeX, modeY, 100, 18).method_46431();
        this.modeOneBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"One Complete"), b -> this.setDepMode("one_completed")).method_46434(modeX + 104, modeY, 100, 18).method_46431();
        this.modeStartedBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"All Started"), b -> this.setDepMode("all_started")).method_46434(modeX + 208, modeY, 90, 18).method_46431();
    }

    private void setDepMode(String mode) {
        this.depMode = mode;
    }

    private void addSelectedDeps() {
    }

    private void removeSelectedDeps() {
    }

    private void clearAllDeps() {
        this.selectedDeps.clear();
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.availableQuests = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        this.availableQuests.removeIf(q -> q.getId().equals(quest.getId()));
        this.selectedDeps.clear();
        this.selectedDeps.addAll(quest.getDependencies());
        this.depMode = quest.getDependencyRequirement();
        this.minRequired = quest.getMinRequiredDependencies();
        this.maxCompletable = quest.getMaxCompletableDeps();
        this.hideLines = quest.isHideDependencyLines();
        this.lineStyle = quest.getLineStyle();
    }

    @Override
    public void saveToQuest(Quest quest) {
        quest.getDependencies().clear();
        quest.getDependencies().addAll(this.selectedDeps);
        quest.setDependencyRequirement(this.depMode);
        quest.setMinRequiredDependencies(this.minRequired);
        quest.setMaxCompletableDeps(this.maxCompletable);
        quest.setHideDependencyLines(this.hideLines);
        quest.setLineStyle(this.lineStyle);
    }

    @Override
    public void render(class_332 g, int mouseX, int mouseY, float partialTick) {
        int leftW = this.w / 2 - 20;
        int rightW = this.w / 2 - 20;
        int leftX = this.x + 12;
        int rightX = this.x + this.w / 2 + 8;
        int listY = this.y + 54;
        int listH = this.h - 104;
        g.method_25294(leftX, listY, leftX + leftW, listY + listH, -803200992);
        g.method_25303(this.getFont(), "\u00a7lAvailable Quests", leftX, this.y + 12, -86);
        int searchW = this.w / 2 - 20 - 8;
        this.searchBox.method_48229(this.x + 16, this.y + 32);
        this.searchBox.method_25394(g, mouseX, mouseY, partialTick);
        this.renderAvailableList(g, leftX, listY, leftW, listH, mouseX, mouseY);
        g.method_25294(rightX, listY, rightX + rightW, listY + listH, -803200992);
        g.method_25303(this.getFont(), "\u00a7lSelected Dependencies", rightX, this.y + 12, -86);
        this.renderSelectedList(g, rightX, listY, rightW, listH, mouseX, mouseY);
        int modeX = this.x + this.w - 400;
        int modeY = this.y + 12;
        g.method_25303(this.getFont(), "Dependency Mode:", modeX - 120, modeY + 5, -1);
        this.modeAllBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.modeOneBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.modeStartedBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.addBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.removeBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.clearBtn.method_25394(g, mouseX, mouseY, partialTick);
    }

    private void renderAvailableList(class_332 g, int lx, int ly, int lw, int lh, int mx, int my) {
        g.method_44379(lx, ly, lx + lw, ly + lh);
        int lineH = 16;
        int y = ly + 4;
        List<Quest> filteredQuests = this.availableQuests;
        if (!this.searchQuery.isEmpty()) {
            filteredQuests = this.availableQuests.stream().filter(q -> q.getTitle().toLowerCase().contains(this.searchQuery) || q.getId().toLowerCase().contains(this.searchQuery)).collect(Collectors.toList());
        }
        for (Quest q2 : filteredQuests) {
            if (y > ly + lh) break;
            boolean inDeps = this.selectedDeps.contains(q2.getId());
            String label = (inDeps ? "\u2713 " : "  ") + q2.getTitle();
            g.method_25303(this.getFont(), label, lx + 4, y, inDeps ? -7798904 : -1);
            y += lineH;
        }
        g.method_44380();
    }

    private void renderSelectedList(class_332 g, int rx, int ry, int rw, int rh, int mx, int my) {
        g.method_44379(rx, ry, rx + rw, ry + rh);
        int lineH = 16;
        int y = ry + 4;
        for (String depId : this.selectedDeps) {
            if (y > ry + rh) break;
            Quest dep = ClientQuestManager.getInstance().getQuest(depId);
            String label = dep != null ? dep.getTitle() : depId;
            g.method_25303(this.getFont(), "\u2192 " + label, rx + 4, y, -1);
            y += lineH;
        }
        g.method_44380();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int searchW = this.w / 2 - 20 - 8;
        this.searchBox.method_48229(this.x + 16, this.y + 32);
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.addBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.removeBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.clearBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.modeAllBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.modeOneBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.modeStartedBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int leftX = this.x + 12;
        int leftW = this.w / 2 - 20;
        int listY = this.y + 54;
        int listH = this.h - 104;
        if (mouseX >= (double)leftX && mouseX <= (double)(leftX + leftW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            int index;
            List<Quest> filteredQuests = this.availableQuests;
            if (!this.searchQuery.isEmpty()) {
                filteredQuests = this.availableQuests.stream().filter(q -> q.getTitle().toLowerCase().contains(this.searchQuery) || q.getId().toLowerCase().contains(this.searchQuery)).collect(Collectors.toList());
            }
            if ((index = ((int)mouseY - listY - 4) / 16) >= 0 && index < filteredQuests.size()) {
                Quest q2 = filteredQuests.get(index);
                if (this.selectedDeps.contains(q2.getId())) {
                    this.selectedDeps.remove(q2.getId());
                } else {
                    this.selectedDeps.add(q2.getId());
                }
                return true;
            }
        }
        return false;
    }
}

