/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.IconPickerScreen;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.QuestPositionPickerScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;

public class GeneralTabPanel
extends TabPanel {
    private class_342 idField;
    private class_342 titleField;
    private class_342 descField;
    private class_342 iconField;
    private class_4185 iconBrowseBtn;
    private class_342 groupField;
    private class_342 tagsField;
    private class_342 xField;
    private class_342 yField;
    private class_4185 positionBtn;
    private class_342 shapeField;
    private class_342 sizeField;
    private class_342 iconScaleField;
    private class_4185 hiddenBtn;
    private boolean hidden = false;

    public GeneralTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    public String getIdFieldValue() {
        return this.idField.method_1882();
    }

    private void initWidgets() {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int fieldW = Math.min(400, this.w - 24);
        int labelW = 120;
        int inputW = fieldW - labelW - 8;
        this.idField = this.createField(fieldX + labelW, fieldY, inputW, "quest_id");
        this.titleField = this.createField(fieldX + labelW, fieldY += 26, inputW, "Quest Title");
        this.descField = this.createField(fieldX + labelW, fieldY += 26, inputW, "Enter quest description...");
        this.descField.method_1880(500);
        int iconW = inputW - 80;
        this.iconField = this.createField(fieldX + labelW, fieldY += 70, iconW, "minecraft:writable_book");
        this.iconField.method_1880(200);
        this.iconBrowseBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Browse..."), b -> this.openIconPicker()).method_46434(fieldX + labelW + iconW + 4, fieldY, 76, 18).method_46431();
        fieldY += 30;
        this.groupField = this.createField(fieldX + labelW, fieldY += 12, inputW, "default");
        this.tagsField = this.createField(fieldX + labelW, fieldY += 26, inputW, "comma, separated, tags");
        int halfW = (inputW - 90) / 2;
        this.xField = this.createField(fieldX + labelW, fieldY += 26, halfW, "0");
        this.yField = this.createField(fieldX + labelW + halfW + 4, fieldY, halfW, "0");
        this.positionBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Position..."), b -> this.openPositionPicker()).method_46434(fieldX + labelW + halfW * 2 + 8, fieldY, 82, 18).method_46431();
        fieldY += 30;
        this.shapeField = this.createField(fieldX + labelW, fieldY += 12, inputW, "square (or circle, hexagon...)");
        this.sizeField = this.createField(fieldX + labelW, fieldY += 26, 80, "1.0");
        this.iconScaleField = this.createField(fieldX + labelW, fieldY += 26, 80, "1.0");
        this.hiddenBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hidden: No"), b -> this.toggleHidden()).method_46434(fieldX + labelW, fieldY += 26, 120, 20).method_46431();
    }

    private void toggleHidden() {
        this.hidden = !this.hidden;
        this.hiddenBtn.method_25355((class_2561)class_2561.method_43470((String)("Hidden: " + (this.hidden ? "Yes" : "No"))));
    }

    private void openIconPicker() {
        System.out.println("[GeneralTab] openIconPicker() - BEFORE save - ID field: " + this.idField.method_1882() + ", Title field: " + this.titleField.method_1882());
        this.editor.saveCurrentTabToQuest();
        System.out.println("[GeneralTab] openIconPicker() - AFTER save - WorkingQuest ID: " + this.editor.getWorkingQuest().getId() + ", Title: " + this.editor.getWorkingQuest().getTitle());
        this.getMinecraft().method_1507((class_437)new IconPickerScreen(this.editor, this.iconField.method_1882(), result -> {
            System.out.println("[GeneralTab] IconPicker callback - Selected icon: " + result);
            this.editor.getWorkingQuest().setIcon((String)result);
            System.out.println("[GeneralTab] IconPicker callback - Saved icon to quest: " + this.editor.getWorkingQuest().getIcon());
            this.getMinecraft().method_1507((class_437)this.editor);
        }));
    }

    private void openPositionPicker() {
        System.out.println("[GeneralTab] openPositionPicker() - Current position: X=" + this.xField.method_1882() + ", Y=" + this.yField.method_1882());
        this.editor.saveCurrentTabToQuest();
        this.getMinecraft().method_1507((class_437)new QuestPositionPickerScreen(this.editor, this.editor.getWorkingQuest(), (x, y) -> {
            System.out.println("[GeneralTab] PositionPicker callback - New position: X=" + x + ", Y=" + y);
            this.editor.getWorkingQuest().setX((int)x);
            this.editor.getWorkingQuest().setY((int)y);
            System.out.println("[GeneralTab] PositionPicker callback - Saved position to quest");
        }));
    }

    @Override
    public void loadFromQuest(Quest quest) {
        System.out.println("[GeneralTab] loadFromQuest() - Loading quest: " + quest.getId() + ", Title: " + quest.getTitle() + ", Icon: " + quest.getIcon());
        this.idField.method_1852(quest.getId());
        this.titleField.method_1852(quest.getTitle());
        this.descField.method_1852(quest.getDescription());
        this.iconField.method_1852(quest.getIcon());
        System.out.println("[GeneralTab] loadFromQuest() - Set iconField to: " + this.iconField.method_1882());
        this.groupField.method_1852(quest.getGroup());
        this.tagsField.method_1852(String.join((CharSequence)", ", quest.getTags()));
        this.xField.method_1852(String.valueOf(quest.getX()));
        this.yField.method_1852(String.valueOf(quest.getY()));
        this.shapeField.method_1852(quest.getShape().isEmpty() ? "" : quest.getShape());
        this.sizeField.method_1852(String.valueOf(quest.getSize()));
        this.iconScaleField.method_1852(String.valueOf(quest.getIconScale()));
        this.hidden = quest.isHidden();
        this.hiddenBtn.method_25355((class_2561)class_2561.method_43470((String)("Hidden: " + (this.hidden ? "Yes" : "No"))));
        System.out.println("[GeneralTab] loadFromQuest() - Loaded fields - ID: " + this.idField.method_1882() + ", Title: " + this.titleField.method_1882());
    }

    @Override
    public void saveToQuest(Quest quest) {
        String[] tags;
        System.out.println("[GeneralTab] saveToQuest() - BEFORE save - Quest ID: " + quest.getId() + ", Title: " + quest.getTitle());
        System.out.println("[GeneralTab] saveToQuest() - Field values - ID: " + this.idField.method_1882() + ", Title: " + this.titleField.method_1882());
        System.out.println("[GeneralTab] saveToQuest() - WARNING: Quest.setId() does not exist - ID field edits CANNOT be saved!");
        System.out.println("[GeneralTab] saveToQuest() - If user edited ID from '" + quest.getId() + "' to '" + this.idField.method_1882() + "', this change will be LOST!");
        quest.setTitle(this.titleField.method_1882().trim().isEmpty() ? quest.getId() : this.titleField.method_1882().trim());
        quest.setDescription(this.descField.method_1882());
        quest.setIcon(this.iconField.method_1882().trim().isEmpty() ? "minecraft:writable_book" : this.iconField.method_1882().trim());
        quest.setGroup(this.groupField.method_1882().trim().isEmpty() ? "default" : this.groupField.method_1882().trim());
        quest.getTags().clear();
        for (String tag : tags = this.tagsField.method_1882().split(",")) {
            String t = tag.trim();
            if (t.isEmpty()) continue;
            quest.addTag(t);
        }
        try {
            quest.setX(Integer.parseInt(this.xField.method_1882().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            quest.setY(Integer.parseInt(this.yField.method_1882().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setShape(this.shapeField.method_1882().trim());
        try {
            double size = Double.parseDouble(this.sizeField.method_1882().trim());
            quest.setSize(Math.max(0.1, Math.min(5.0, size)));
        }
        catch (Exception size) {
            // empty catch block
        }
        try {
            double scale = Double.parseDouble(this.iconScaleField.method_1882().trim());
            quest.setIconScale(Math.max(0.1, Math.min(3.0, scale)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setHidden(this.hidden);
        System.out.println("[GeneralTab] saveToQuest() - AFTER save - Quest ID: " + quest.getId() + ", Title: " + quest.getTitle());
    }

    @Override
    public void render(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.updateFieldPositions();
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int labelW = 120;
        g.method_44379(this.x, this.y, this.x + this.w, this.y + this.h);
        g.method_25303(this.getFont(), "\u00a7lIdentity", fieldX, fieldY - 8, -86);
        g.method_25303(this.getFont(), "ID:", fieldX, fieldY += 12, -1);
        this.idField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Title:", fieldX, fieldY += 26, -1);
        this.titleField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Description:", fieldX, fieldY += 26, -1);
        this.descField.method_25394(g, mouseX, mouseY, partialTick);
        int inputW = Math.min(400, this.w - 24) - labelW - 8;
        int iconW = inputW - 80;
        g.method_25303(this.getFont(), "Icon:", fieldX, fieldY += 70, -1);
        this.iconField.method_25394(g, mouseX, mouseY, partialTick);
        this.iconBrowseBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        g.method_25303(this.getFont(), "\u00a7lOrganization", fieldX, fieldY += 4, -86);
        g.method_25303(this.getFont(), "Group/Chapter:", fieldX, fieldY += 12, -1);
        this.groupField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Tags:", fieldX, fieldY += 26, -1);
        this.tagsField.method_25394(g, mouseX, mouseY, partialTick);
        int halfW = (inputW - 90) / 2;
        g.method_25303(this.getFont(), "Position:", fieldX, fieldY += 26, -1);
        g.method_25303(this.getFont(), "X:", fieldX + labelW, fieldY, -3355444);
        this.xField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Y:", fieldX + labelW + halfW + 4, fieldY, -3355444);
        this.yField.method_25394(g, mouseX, mouseY, partialTick);
        this.positionBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        g.method_25303(this.getFont(), "\u00a7lAppearance", fieldX, fieldY += 4, -86);
        g.method_25303(this.getFont(), "Shape:", fieldX, fieldY += 12, -1);
        this.shapeField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Size:", fieldX, fieldY += 26, -1);
        this.sizeField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "(0.5 - 3.0)", fieldX + labelW + 88, fieldY, -7829368);
        g.method_25303(this.getFont(), "Icon Scale:", fieldX, fieldY += 26, -1);
        this.iconScaleField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "(0.5 - 2.0)", fieldX + labelW + 88, fieldY, -7829368);
        g.method_25303(this.getFont(), "Visibility:", fieldX, fieldY += 26, -1);
        this.hiddenBtn.method_25394(g, mouseX, mouseY, partialTick);
        g.method_44380();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateFieldPositions();
        if (this.iconBrowseBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.positionBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hiddenBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void updateFieldPositions() {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int labelW = 120;
        int inputW = Math.min(400, this.w - 24) - labelW - 8;
        this.idField.method_46421(fieldX + labelW);
        this.idField.method_46419(fieldY);
        this.titleField.method_46421(fieldX + labelW);
        this.titleField.method_46419(fieldY += 26);
        this.descField.method_46421(fieldX + labelW);
        this.descField.method_46419(fieldY += 26);
        int iconW = inputW - 80;
        this.iconField.method_46421(fieldX + labelW);
        this.iconField.method_46419(fieldY += 70);
        this.iconBrowseBtn.method_46421(fieldX + labelW + iconW + 4);
        this.iconBrowseBtn.method_46419(fieldY);
        fieldY += 30;
        this.groupField.method_46421(fieldX + labelW);
        this.groupField.method_46419(fieldY += 12);
        this.tagsField.method_46421(fieldX + labelW);
        this.tagsField.method_46419(fieldY += 26);
        int halfW = (inputW - 90) / 2;
        this.xField.method_46421(fieldX + labelW);
        this.xField.method_46419(fieldY += 26);
        this.yField.method_46421(fieldX + labelW + halfW + 4);
        this.yField.method_46419(fieldY);
        this.positionBtn.method_46421(fieldX + labelW + halfW * 2 + 8);
        this.positionBtn.method_46419(fieldY);
        fieldY += 30;
        this.shapeField.method_46421(fieldX + labelW);
        this.shapeField.method_46419(fieldY += 12);
        this.sizeField.method_46421(fieldX + labelW);
        this.sizeField.method_46419(fieldY += 26);
        this.iconScaleField.method_46421(fieldX + labelW);
        this.iconScaleField.method_46419(fieldY += 26);
        this.hiddenBtn.method_46421(fieldX + labelW);
        this.hiddenBtn.method_46419(fieldY += 26);
    }
}

