/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.gui.QuestIconRenderer;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class QuestHudOverlay {
    private static final int MAX_TRACKED_QUESTS = 5;
    private static final int PANEL_WIDTH = 240;
    private static final int COMPACT_PANEL_WIDTH = 200;
    private static final int ICON_SIZE = 16;
    private static final int COMPACT_ICON_SIZE = 12;
    private static final Map<String, Long> questAddTimes = new HashMap<String, Long>();
    private static final long FADE_IN_DURATION = 300L;

    public static void render(class_332 graphics, float partialTick) {
        int startX;
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.showProgressPercentage && !config.useColoredMessages) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1866) {
            return;
        }
        ClientQuestManager manager = ClientQuestManager.getInstance();
        QuestProgress progress = manager.getProgress();
        if (progress == null) {
            return;
        }
        Set<String> pinnedQuests = ClientConfig.getTrackedQuests();
        if (pinnedQuests.isEmpty()) {
            return;
        }
        String position = ClientConfig.getHudPosition();
        float scale = ClientConfig.getHudScale();
        boolean compact = ClientConfig.isHudCompactMode();
        int offsetX = ClientConfig.getHudOffsetX();
        int offsetY = ClientConfig.getHudOffsetY();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        int panelWidth = compact ? 200 : 240;
        int startY = switch (position) {
            case "TOP_RIGHT" -> {
                startX = screenWidth - panelWidth - offsetX;
                yield offsetY;
            }
            case "BOTTOM_LEFT" -> {
                startX = offsetX;
                yield screenHeight - offsetY;
            }
            case "BOTTOM_RIGHT" -> {
                startX = screenWidth - panelWidth - offsetX;
                yield screenHeight - offsetY;
            }
            default -> {
                startX = offsetX;
                yield offsetY;
            }
        };
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        if (position.contains("RIGHT")) {
            pose.method_46416((float)(startX + panelWidth), (float)startY, 0.0f);
            pose.method_22905(scale, scale, 1.0f);
            pose.method_46416((float)(-(startX + panelWidth)), (float)(-startY), 0.0f);
        } else {
            pose.method_46416((float)startX, (float)startY, 0.0f);
            pose.method_22905(scale, scale, 1.0f);
            pose.method_46416((float)(-startX), (float)(-startY), 0.0f);
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        int rendered = 0;
        int currentY = startY;
        boolean bottomAnchored = position.contains("BOTTOM");
        ArrayList<Quest> questsToRender = new ArrayList<Quest>();
        for (String string : pinnedQuests) {
            if (rendered >= 5) break;
            Quest quest = manager.getQuest(string);
            if (quest == null || progress.isQuestCompleted(string)) {
                toRemove.add(string);
                continue;
            }
            questsToRender.add(quest);
            ++rendered;
        }
        if (bottomAnchored) {
            Collections.reverse(questsToRender);
            int totalHeight = 0;
            for (Quest q : questsToRender) {
                totalHeight += QuestHudOverlay.getQuestHeight(q, progress, compact) + 4;
            }
            currentY -= totalHeight;
        }
        for (Quest quest : questsToRender) {
            QuestHudOverlay.renderTrackedQuest(graphics, quest, progress, startX, currentY, panelWidth, compact);
            currentY += QuestHudOverlay.getQuestHeight(quest, progress, compact) + 4;
        }
        pose.method_22909();
        for (String string : toRemove) {
            ClientConfig.setQuestTracked(string, false);
            questAddTimes.remove(string);
        }
    }

    private static void renderTrackedQuest(class_332 graphics, Quest quest, QuestProgress progress, int x, int y, int width, boolean compact) {
        class_310 mc = class_310.method_1551();
        int height = QuestHudOverlay.getQuestHeight(quest, progress, compact);
        int opacity = ClientConfig.getHudOpacity();
        int alpha = (int)((float)opacity * 2.55f);
        float fadeAlpha = 1.0f;
        if (questAddTimes.containsKey(quest.getId())) {
            long elapsed = System.currentTimeMillis() - questAddTimes.get(quest.getId());
            if (elapsed < 300L) {
                fadeAlpha = (float)elapsed / 300.0f;
            }
        } else {
            questAddTimes.put(quest.getId(), System.currentTimeMillis());
        }
        int finalAlpha = (int)((float)alpha * fadeAlpha);
        int bgColor = finalAlpha << 24 | 0x1A1A1A;
        int borderColor = finalAlpha << 24 | 0x3A3A3A;
        graphics.method_25294(x - 1, y - 1, x + width + 1, y + height + 1, borderColor);
        graphics.method_25294(x, y, x + width, y + height, bgColor);
        int iconSize = compact ? 12 : 16;
        int padding = compact ? 4 : 6;
        int currentY = y + padding;
        if (ClientConfig.isHudShowIcons() && quest.getIcon() != null) {
            try {
                QuestIconRenderer.render(graphics, quest.getIcon(), x + padding, currentY, iconSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int titleX = ClientConfig.isHudShowIcons() ? x + padding + iconSize + 4 : x + padding;
        int titleColor = finalAlpha << 24 | 0xFFFFFF;
        Object title = quest.getTitle();
        if (compact && mc.field_1772.method_1727((String)title) > width - (titleX - x) - padding) {
            title = mc.field_1772.method_27523((String)title, width - (titleX - x) - padding - 10) + "...";
        }
        graphics.method_51433(mc.field_1772, (String)title, titleX, currentY + (compact ? 2 : 4), titleColor, true);
        currentY += iconSize + (compact ? 4 : 6);
        boolean showProgressBars = ClientConfig.isHudShowProgressBars();
        for (Requirement req : quest.getRequirements()) {
            int availableWidth;
            boolean isMet = req.isMet(progress, quest.getId());
            String displayText = req.getProgressDisplay(progress, quest.getId());
            if (compact) {
                String prefix = isMet ? "\u2713" : "\u25cb";
                int color = isMet ? finalAlpha << 24 | 0x55FF55 : finalAlpha << 24 | 0xCCCCCC;
                availableWidth = width - padding * 2 - 4 - mc.field_1772.method_1727(prefix + " ");
                String truncatedText = QuestHudOverlay.truncateText(mc, displayText, availableWidth);
                graphics.method_25303(mc.field_1772, prefix + " " + truncatedText, x + padding + 2, currentY, color);
                currentY += 10;
                continue;
            }
            int textColor = isMet ? finalAlpha << 24 | 0x55FF55 : finalAlpha << 24 | 0xFFFFFF;
            String prefix = isMet ? "\u2713 " : "";
            availableWidth = width - padding * 2 - 4;
            List<String> lines = QuestHudOverlay.wrapText(mc, prefix + displayText, availableWidth, 2);
            for (String line : lines) {
                graphics.method_25303(mc.field_1772, line, x + padding + 2, currentY, textColor);
                currentY += 10;
            }
            if (showProgressBars && !isMet) {
                int current = progress.getRequirementProgress(quest.getId(), req);
                int target = QuestHudOverlay.extractTargetFromDisplay(displayText);
                if (target > 0 && current < target) {
                    float progressPct = Math.min(1.0f, (float)current / (float)target);
                    int barWidth = width - padding * 2 - 4;
                    int barHeight = 3;
                    int barX = x + padding + 2;
                    int barY = currentY;
                    int barBg = finalAlpha << 24 | 0x333333;
                    graphics.method_25294(barX, barY, barX + barWidth, barY + barHeight, barBg);
                    int fillWidth = (int)((float)barWidth * progressPct);
                    int progressColor = isMet ? finalAlpha << 24 | 0x55FF55 : finalAlpha << 24 | 0xFFAA00;
                    graphics.method_25294(barX, barY, barX + fillWidth, barY + barHeight, progressColor);
                    currentY += barHeight + 2;
                }
            }
            currentY += 2;
        }
    }

    private static int getQuestHeight(Quest quest, QuestProgress progress, boolean compact) {
        int iconSize = compact ? 12 : 16;
        int padding = compact ? 4 : 6;
        int height = padding * 2 + iconSize + (compact ? 4 : 6);
        int panelWidth = compact ? 200 : 240;
        class_310 mc = class_310.method_1551();
        int reqCount = quest.getRequirements().size();
        if (compact) {
            height += reqCount * 10;
        } else {
            boolean showProgressBars = ClientConfig.isHudShowProgressBars();
            int availableWidth = panelWidth - padding * 2 - 4;
            for (Requirement req : quest.getRequirements()) {
                int target;
                String displayText = req.getProgressDisplay(progress, quest.getId());
                String prefix = req.isMet(progress, quest.getId()) ? "\u2713 " : "";
                List<String> lines = QuestHudOverlay.wrapText(mc, prefix + displayText, availableWidth, 2);
                height += lines.size() * 10;
                if (showProgressBars && !req.isMet(progress, quest.getId()) && (target = QuestHudOverlay.extractTargetFromDisplay(displayText)) > 0) {
                    height += 5;
                }
                height += 2;
            }
        }
        return height + 2;
    }

    private static String truncateText(class_310 mc, String text, int maxWidth) {
        int progressWidth;
        int ellipsisWidth;
        int availableForText;
        if (mc.field_1772.method_1727(text) <= maxWidth) {
            return text;
        }
        String progressPattern = "\\d+/\\d+";
        Pattern pattern = Pattern.compile(progressPattern);
        Matcher matcher = pattern.matcher(text);
        Object progressPart = "";
        if (matcher.find()) {
            progressPart = " " + matcher.group();
        }
        if ((availableForText = maxWidth - (ellipsisWidth = mc.field_1772.method_1727("...")) - (progressWidth = mc.field_1772.method_1727((String)progressPart))) <= 0) {
            return ((String)progressPart).isEmpty() ? "..." : progressPart;
        }
        String mainText = text;
        if (!((String)progressPart).isEmpty()) {
            mainText = text.replace(((String)progressPart).trim(), "").trim();
        }
        String truncated = mc.field_1772.method_27524(mainText, availableForText, false).trim();
        return truncated + "..." + (String)progressPart;
    }

    private static List<String> wrapText(class_310 mc, String text, int maxWidth, int maxLines) {
        ArrayList<String> lines = new ArrayList<String>();
        if (mc.field_1772.method_1727(text) <= maxWidth) {
            lines.add(text);
            return lines;
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (mc.field_1772.method_1727(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
            } else {
                String truncated = mc.field_1772.method_27524(word, maxWidth - mc.field_1772.method_1727("..."), false);
                lines.add(truncated + "...");
            }
            if (lines.size() < maxLines - 1 || currentLine.length() <= 0) continue;
            StringBuilder remaining = new StringBuilder(currentLine.toString());
            for (int i = words.length - 1; i >= 0; --i) {
                if (remaining.toString().contains(words[i])) continue;
                String test = String.valueOf(remaining) + " " + words[i];
                if (mc.field_1772.method_1727(test) <= maxWidth) {
                    remaining.append(" ").append(words[i]);
                    continue;
                }
                remaining.append("...");
                break;
            }
            lines.add(remaining.toString());
            return lines;
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private static int extractTargetFromDisplay(String displayText) {
        if (displayText == null) {
            return 0;
        }
        int slashIndex = displayText.indexOf(47);
        if (slashIndex > 0 && slashIndex < displayText.length() - 1) {
            int endIndex;
            for (endIndex = slashIndex + 1; endIndex < displayText.length() && Character.isDigit(displayText.charAt(endIndex)); ++endIndex) {
            }
            if (endIndex > slashIndex + 1) {
                try {
                    return Integer.parseInt(displayText.substring(slashIndex + 1, endIndex));
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        }
        return 0;
    }

    public static void trackQuest(String questId) {
        ClientConfig.setQuestTracked(questId, true);
    }

    public static void untrackQuest(String questId) {
        ClientConfig.setQuestTracked(questId, false);
    }

    public static void clearTracked() {
        for (String questId : ClientConfig.getTrackedQuests()) {
            ClientConfig.setQuestTracked(questId, false);
        }
    }

    public static List<String> getTrackedQuests() {
        return new ArrayList<String>(ClientConfig.getTrackedQuests());
    }
}

