/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.QuestoryKeybindings;
import org.texboobcat.questory.quest.Quest;

public class QuestPositionPickerScreen
extends class_437 {
    private final class_437 parent;
    private final Quest questBeingPositioned;
    private final BiConsumer<Integer, Integer> onPositionSelected;
    private int questX;
    private int questY;
    private double zoom = 1.0;
    private double scrollX = 0.0;
    private double scrollY = 0.0;
    private boolean draggingQuest = false;
    private boolean panning = false;
    private int prevMouseX = 0;
    private int prevMouseY = 0;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private static final int QUEST_SIZE = 32;
    private static final int GRID_SIZE = 100;

    public QuestPositionPickerScreen(class_437 parent, Quest quest, BiConsumer<Integer, Integer> onPositionSelected) {
        super((class_2561)class_2561.method_43470((String)("Position Quest: " + quest.getTitle())));
        this.parent = parent;
        this.questBeingPositioned = quest;
        this.questX = quest.getX();
        this.questY = quest.getY();
        this.onPositionSelected = onPositionSelected;
    }

    protected void method_25426() {
        super.method_25426();
        int btnY = this.field_22790 - 30;
        int btnX = this.field_22789 / 2 - 110;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply"), b -> {
            this.onPositionSelected.accept(this.questX, this.questY);
            this.field_22787.method_1507(this.parent);
        }).method_46434(btnX, btnY, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> {
            this.questX = this.questBeingPositioned.getX();
            this.questY = this.questBeingPositioned.getY();
        }).method_46434(btnX + 65, btnY, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46434(btnX + 130, btnY, 60, 20).method_46431());
        this.centerOnQuest();
    }

    private void centerOnQuest() {
        this.scrollX = (double)this.questX * this.zoom - (double)this.field_22789 / 2.0;
        this.scrollY = (double)this.questY * this.zoom - (double)this.field_22790 / 2.0;
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        this.renderGrid(g);
        ArrayList<Quest> allQuests = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        for (Quest q : allQuests) {
            if (q.getId().equals(this.questBeingPositioned.getId())) continue;
            this.renderQuestNode(g, q, q.getX(), q.getY(), false);
        }
        this.renderDependencyLines(g);
        this.renderQuestNode(g, this.questBeingPositioned, this.questX, this.questY, true);
        super.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.field_22793, "Drag the highlighted quest to position it", 10, 10, -1);
        g.method_25303(this.field_22793, "Pan (" + QuestoryKeybindings.getPanViewDisplayName() + ") to move view, scroll to zoom", 10, 22, -5592406);
        g.method_25303(this.field_22793, String.format("Position: X=%d, Y=%d", this.questX, this.questY), 10, 34, -256);
    }

    private void renderGrid(class_332 g) {
        int gridSpacing = (int)(100.0 * this.zoom);
        if (gridSpacing < 10) {
            return;
        }
        int startX = (int)(-this.scrollX % (double)gridSpacing);
        int startY = (int)(-this.scrollY % (double)gridSpacing);
        for (int x = startX; x < this.field_22789; x += gridSpacing) {
            g.method_25294(x, 0, x + 1, this.field_22790 - 40, 0x20FFFFFF);
        }
        for (int y = startY; y < this.field_22790 - 40; y += gridSpacing) {
            g.method_25294(0, y, this.field_22789, y + 1, 0x20FFFFFF);
        }
    }

    private void renderQuestNode(class_332 g, Quest quest, int qx, int qy, boolean highlighted) {
        int screenX = (int)((double)qx * this.zoom - this.scrollX);
        int screenY = (int)((double)qy * this.zoom - this.scrollY);
        int size = (int)(32.0 * this.zoom);
        if (screenX + size < 0 || screenX > this.field_22789 || screenY + size < 0 || screenY > this.field_22790 - 40) {
            return;
        }
        boolean completed = ClientQuestManager.getInstance().isQuestCompleted(quest.getId());
        int color = highlighted ? -256 : (completed ? -16711936 : -7829368);
        int alpha = highlighted ? 255 : 128;
        g.method_25294(screenX, screenY, screenX + size, screenY + size, alpha << 24 | color & 0xFFFFFF);
        int borderColor = highlighted ? -1 : -12303292;
        g.method_25294(screenX, screenY, screenX + size, screenY + 1, borderColor);
        g.method_25294(screenX, screenY + size - 1, screenX + size, screenY + size, borderColor);
        g.method_25294(screenX, screenY, screenX + 1, screenY + size, borderColor);
        g.method_25294(screenX + size - 1, screenY, screenX + size, screenY + size, borderColor);
        if (this.zoom > 0.5) {
            Object title = quest.getTitle();
            if (this.field_22793.method_1727((String)title) > size) {
                title = this.field_22793.method_27523((String)title, size - 4) + "...";
            }
            g.method_25303(this.field_22793, (String)title, screenX + 2, screenY + size + 2, highlighted ? -1 : -5592406);
        }
    }

    private void renderDependencyLines(class_332 g) {
        ArrayList<Quest> allQuests = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        for (String depId : this.questBeingPositioned.getDependencies()) {
            Quest dep = allQuests.stream().filter(q -> q.getId().equals(depId)).findFirst().orElse(null);
            if (dep == null) continue;
            this.renderLine(g, dep.getX(), dep.getY(), this.questX, this.questY, -16711681, "\u2192");
        }
        for (Quest q2 : allQuests) {
            if (!q2.getDependencies().contains(this.questBeingPositioned.getId())) continue;
            this.renderLine(g, this.questX, this.questY, q2.getX(), q2.getY(), -22016, "\u2192");
        }
    }

    private void renderLine(class_332 g, int x1, int y1, int x2, int y2, int color, String arrow) {
        int screenX1 = (int)((double)x1 * this.zoom - this.scrollX) + 16;
        int screenY1 = (int)((double)y1 * this.zoom - this.scrollY) + 16;
        int screenX2 = (int)((double)x2 * this.zoom - this.scrollX) + 16;
        int screenY2 = (int)((double)y2 * this.zoom - this.scrollY) + 16;
        this.drawLine(g, screenX1, screenY1, screenX2, screenY2, color);
    }

    private void drawLine(class_332 g, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            g.method_25294(x1, y1, x1 + 2, y1 + 2, color);
            if (x1 == x2 && y1 == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int screenX = (int)((double)this.questX * this.zoom - this.scrollX);
        int screenY = (int)((double)this.questY * this.zoom - this.scrollY);
        int size = (int)(32.0 * this.zoom);
        if (button == 0) {
            if (mouseX >= (double)screenX && mouseX <= (double)(screenX + size) && mouseY >= (double)screenY && mouseY <= (double)(screenY + size)) {
                this.draggingQuest = true;
                int questScreenCenterX = screenX + size / 2;
                int questScreenCenterY = screenY + size / 2;
                this.dragOffsetX = (int)(((double)questScreenCenterX - mouseX) / this.zoom);
                this.dragOffsetY = (int)(((double)questScreenCenterY - mouseY) / this.zoom);
                return true;
            }
        } else if (QuestoryKeybindings.isPanButton(button)) {
            this.panning = true;
            this.prevMouseX = (int)mouseX;
            this.prevMouseY = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingQuest) {
            int worldMouseX = (int)((mouseX + this.scrollX) / this.zoom);
            int worldMouseY = (int)((mouseY + this.scrollY) / this.zoom);
            this.questX = worldMouseX + this.dragOffsetX;
            this.questY = worldMouseY + this.dragOffsetY;
            this.questX = Math.round((float)this.questX / 10.0f) * 10;
            this.questY = Math.round((float)this.questY / 10.0f) * 10;
            return true;
        }
        if (this.panning) {
            this.scrollX -= mouseX - (double)this.prevMouseX;
            this.scrollY -= mouseY - (double)this.prevMouseY;
            this.prevMouseX = (int)mouseX;
            this.prevMouseY = (int)mouseY;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingQuest = false;
        this.panning = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        double oldZoom = this.zoom;
        this.zoom *= 1.0 + delta * 0.1;
        this.zoom = Math.max(0.1, Math.min(3.0, this.zoom));
        double zoomChange = this.zoom / oldZoom;
        this.scrollX = mouseX + (this.scrollX - mouseX) * zoomChange;
        this.scrollY = mouseY + (this.scrollY - mouseY) * zoomChange;
        return true;
    }

    public boolean method_25421() {
        return false;
    }
}

